/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.editor;

import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.Translation;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsFilterComponent;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTableCell;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTableController;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTableCursor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class NlsTable
extends Composite {
    private final NlsTableController m_controller;
    private final Table m_table;
    private final TableViewer m_viewer;
    private final NlsFilterComponent m_filterComp;
    private final NlsTableCursor m_cursorManager;
    private final MenuManager m_menuManger;
    private TableColumn m_sortColumn;

    public NlsTable(Composite parent, NlsTableController controller) {
        super(parent, 0);
        this.setBackground(parent.getBackground());
        this.m_controller = (NlsTableController)((Object)Ensure.notNull((Object)((Object)controller)));
        this.m_table = new Table((Composite)this, 65538);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        this.m_cursorManager = new NlsTableCursor(this.m_table, this.m_controller);
        this.m_cursorManager.addCursorListener(this::handleTextUpdate);
        this.m_viewer = new TableViewer(this.m_table);
        this.m_viewer.setUseHashlookup(false);
        this.m_viewer.addSelectionChangedListener(event -> this.m_cursorManager.setVisible(((IStructuredSelection)event.getSelection()).size() < 2));
        this.m_filterComp = new NlsFilterComponent(this, this.tableViewer(), this.m_controller);
        this.m_menuManger = new MenuManager();
        this.m_menuManger.setRemoveAllWhenShown(true);
        this.m_cursorManager.getCursor().setMenu(this.m_menuManger.createContextMenu((Control)this.m_cursorManager.getCursor()));
        this.m_table.setMenu(this.m_menuManger.createContextMenu((Control)this.m_table));
        this.setLayout((Layout)new FormLayout());
        FormData filterData = new FormData();
        filterData.top = new FormAttachment(0, 0);
        filterData.left = new FormAttachment(0, 0);
        filterData.right = new FormAttachment(100, 0);
        this.m_filterComp.setLayoutData(filterData);
        FormData tableData = new FormData();
        tableData.top = new FormAttachment((Control)this.m_filterComp, 0);
        tableData.left = new FormAttachment(0, 0);
        tableData.right = new FormAttachment(100, 0);
        tableData.bottom = new FormAttachment(100, 0);
        this.m_table.setLayoutData((Object)tableData);
    }

    protected TableViewer tableViewer() {
        return this.m_viewer;
    }

    protected NlsTableCursor tableCursor() {
        return this.m_cursorManager;
    }

    private void handleTextUpdate(NlsTableCell cell, String newText) {
        if (cell.column() == 1) {
            this.m_controller.stack().changeKey(cell.entry().key(), newText);
        } else {
            TranslationStoreStack stack = this.m_controller.stack();
            stack.setChanging(true);
            try {
                Translation updatedTranslation = new Translation((ITranslation)cell.entry());
                Language language = cell.language().get();
                if (cell.store().languages().noneMatch(Predicate.isEqual(language))) {
                    stack.addNewLanguage(language, cell.entry().store());
                }
                updatedTranslation.putText(language, newText);
                stack.updateTranslation((ITranslation)updatedTranslation);
            }
            finally {
                stack.setChanging(false);
            }
        }
    }

    protected void createColumns() {
        TableColumn[] cols;
        TableColumn[] tableColumnArray = cols = this.m_table.getColumns();
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.dispose();
            ++n2;
        }
        TableColumn colRefs = new TableColumn(this.m_table, 16384);
        colRefs.setResizable(false);
        colRefs.setMoveable(false);
        colRefs.setWidth(45);
        colRefs.addSelectionListener((SelectionListener)new P_SortSelectionAdapter(0));
        TableColumn keyColumn = new TableColumn(this.m_table, 16384);
        keyColumn.setText("Key");
        keyColumn.setMoveable(false);
        keyColumn.setWidth(200);
        keyColumn.addSelectionListener((SelectionListener)new P_SortSelectionAdapter(1));
        this.m_controller.allLanguages().forEach(this::createColumnForLanguage);
        this.m_filterComp.columnsChanged();
        this.updateSortIcon();
    }

    private void createColumnForLanguage(Language language) {
        TableColumn c = new TableColumn(this.m_table, 16384);
        c.setText(language.displayName());
        c.setMoveable(false);
        c.addSelectionListener((SelectionListener)new P_SortSelectionAdapter(this.m_table.indexOf(c)));
        c.setWidth(200);
    }

    private void updateSortIcon() {
        TableColumn col = this.m_table.getColumn(this.m_controller.getSortIndex());
        if (col == null) {
            return;
        }
        if (col.equals(this.m_sortColumn)) {
            int sortDir = 128;
            if (this.m_table.getSortDirection() == 128) {
                sortDir = 1024;
            }
            this.m_table.setSortDirection(sortDir);
        } else {
            this.m_sortColumn = col;
            this.m_table.setSortColumn(this.m_sortColumn);
            this.m_table.setSortDirection(128);
        }
    }

    public void addMenuListener(IMenuListener listener) {
        this.m_menuManger.addMenuListener(listener);
    }

    public void removeMenuListener(IMenuListener listener) {
        this.m_menuManger.removeMenuListener(listener);
    }

    public Optional<NlsTableCell> getCursorSelection() {
        return this.m_cursorManager.getSelection();
    }

    public void showEditor() {
        this.m_cursorManager.createEditableText();
    }

    private final class P_SortSelectionAdapter
    extends SelectionAdapter {
        private final int m_index;

        private P_SortSelectionAdapter(int index) {
            this.m_index = index;
        }

        public void widgetSelected(SelectionEvent e) {
            if (NlsTable.this.m_controller.getSortIndex() == this.m_index) {
                NlsTable.this.m_controller.setAscSorting(!NlsTable.this.m_controller.isAscSorting());
            } else {
                NlsTable.this.m_controller.setAscSorting(false);
                NlsTable.this.m_controller.setSortIndex(this.m_index);
            }
            NlsTable.this.updateSortIcon();
            NlsTable.this.m_controller.preservingSelectionDo(() -> ((TableViewer)NlsTable.this.m_viewer).refresh());
        }
    }
}

