/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibPackage;
import org.eclipse.ocl.pivot.utilities.UniqueList;
import org.eclipse.qvtd.runtime.evaluation.AbstractObjectManager;
import org.eclipse.qvtd.runtime.evaluation.AbstractSlotState;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractObjectState;
import org.eclipse.qvtd.runtime.internal.evaluation.EOppositeReferenceImpl;
import org.eclipse.qvtd.runtime.internal.evaluation.LazyInvocationManager;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public class LazyObjectManager
extends AbstractObjectManager<LazySlotState> {
    public LazyObjectManager(@NonNull LazyInvocationManager invocationManager) {
        super(invocationManager);
    }

    @Override
    public void assigned(@NonNull Invocation.Incremental invocation, @NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
        this.assigned(eObject, eFeature, ecoreValue, isPartial);
    }

    public @NonNull LazyObjectState createObjectState(@NonNull Object eObject) {
        return new LazyObjectState(this, eObject);
    }

    @Override
    public void created(@NonNull Invocation.Incremental invocation, @NonNull Object eObject) {
    }

    @Override
    public void destroyed(@NonNull Object eObject) {
    }

    @Override
    public void got( @NonNull Execution.Incremental computation, @NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue) {
    }

    public static class LazyObjectState
    extends AbstractObjectState<LazySlotState> {
        public LazyObjectState(@NonNull LazyObjectManager objectManager, @NonNull Object eObject) {
            super(objectManager, eObject);
        }

        @Override
        protected @NonNull ManyToManySlotState createManyToManySlotState(@NonNull EReference eReference) {
            return new ManyToManySlotState(this, eReference);
        }

        @Override
        protected @NonNull LazySlotState createOclContainerSlotState(@NonNull EReference eReference, @NonNull Object eContainer) {
            return new OclContainerSlotState((AbstractObjectState<LazySlotState>)this, eReference, eContainer);
        }

        @Override
        protected @NonNull LazySlotState createOneToManyAggregatorSlotState(@NonNull EReference eReference, @NonNull Object eContents) {
            return new OneToManyAggregatorSlotState(this, eReference, eContents);
        }

        @Override
        protected @NonNull OneToManyElementSlotState createOneToManyElementSlotState(@NonNull EReference eReference, @NonNull EReference eOppositeReference, @NonNull Object eAggregator) {
            return new OneToManyElementSlotState(this, eReference, eOppositeReference, eAggregator);
        }

        @Override
        protected @NonNull LazySlotState createOneToOneSlotState(@NonNull EReference eReference, @Nullable Object ecoreValue) {
            return new OneToOneSlotState(this, eReference, ecoreValue);
        }

        @Override
        protected @NonNull SimpleSlotState createSimpleSlotState(@NonNull EAttribute eFeature, @Nullable Object ecoreValue) {
            return new SimpleSlotState((AbstractObjectState<LazySlotState>)this, eFeature, ecoreValue);
        }

        @Override
        protected @NonNull SpeculatingSlotState createSpeculatableSlotState(@NonNull EAttribute eFeature, @Nullable Boolean speculationStatus) {
            return new SpeculatingSlotState((AbstractObjectState<LazySlotState>)this, eFeature, speculationStatus);
        }
    }

    public static abstract class LazySlotState
    extends AbstractSlotState {
        protected final @NonNull EStructuralFeature debug_eFeature;

        protected LazySlotState(@NonNull AbstractObjectState<@NonNull LazySlotState> objectState, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            super(objectState, ecoreValue != NOT_A_VALUE ? AbstractSlotState.SlotMode.ASSIGNED : AbstractSlotState.SlotMode.ASSIGNABLE);
            this.debug_eFeature = eFeature;
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
            if (this.isAssigned() && !(eFeature instanceof EOppositeReferenceImpl)) {
                QVTruntimeUtil.errPrintln("Re-assignment of \"" + LazyObjectManager.toDebugString(eObject) + "\"." + eFeature.getEContainingClass().getName() + "::" + eFeature.getName() + " with \"" + ecoreValue + "\"");
            }
            this.assignedSlot();
        }

        @Override
        public final void assignedSlot() {
            switch (this.mode) {
                case ASSIGNABLE: {
                    this.mode = AbstractSlotState.SlotMode.ASSIGNED;
                    this.unblock();
                    break;
                }
                case ASSIGNED: {
                    break;
                }
                case REASSIGNABLE: {
                    throw new IllegalStateException("Only the IncrementalObjectManager supports REASSIGNABLE slots.");
                }
            }
        }

        @Override
        public void debugUnblock() {
            Object object2 = this.objectState.getObject();
            if (object2 instanceof EObject) {
                Object eProxy = null;
                EObject eObject = (EObject)this.objectState.getObject();
                EClassifier eType = this.debug_eFeature.getEType();
                if (eType instanceof EClass) {
                    EClass eClass = (EClass)eType;
                    for (EClassifier eClassifier : eClass.getEPackage().getEClassifiers()) {
                        EClass eClass2;
                        if (!(eClassifier instanceof EClass) || (eClass2 = (EClass)eClassifier).isAbstract() || !eClass2.getEAllSuperTypes().contains((Object)eClass)) continue;
                        eClass = eClass2;
                    }
                    eProxy = eType.getEPackage().getEFactoryInstance().create(eClass);
                    if (eProxy instanceof InternalEObject) {
                        ((InternalEObject)eProxy).eSetProxyURI(URI.createURI((String)"blocked"));
                    }
                } else {
                    try {
                        eProxy = eType.getEPackage().getEFactoryInstance().createFromString((EDataType)eType, "");
                    }
                    catch (Throwable eClass) {
                        // empty catch block
                    }
                }
                if (this.debug_eFeature.isMany()) {
                    List list = (List)eObject.eGet(this.debug_eFeature);
                    list.add(eProxy);
                } else if (!(this.debug_eFeature instanceof EOppositeReferenceImpl)) {
                    eObject.eSet(this.debug_eFeature, eProxy);
                }
            }
        }

        protected @NonNull LazyObjectManager getObjectManager() {
            return (LazyObjectManager)this.objectState.getObjectManager();
        }

        @Override
        public synchronized void getting(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
            switch (this.mode) {
                case ASSIGNABLE: {
                    throw new InvocationFailedException(this, false);
                }
                case ASSIGNED: {
                    break;
                }
                case REASSIGNABLE: {
                    throw new IllegalStateException("Only the IncrementalObjectManager supports REASSIGNABLE slots.");
                }
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(LazyObjectManager.toDebugString(this.objectState.getObject()));
            s.append(".");
            s.append(this.debug_eFeature.getEContainingClass().getName());
            s.append("::");
            s.append(this.debug_eFeature.getName());
            s.append(" ");
            s.append(this.getClass().getSimpleName());
            s.append("@");
            s.append(Integer.toHexString(System.identityHashCode(this)));
            s.append(" ");
            s.append((Object)this.mode);
            return s.toString();
        }
    }

    static class ManyToManySlotState
    extends LazySlotState {
        public ManyToManySlotState(@NonNull AbstractObjectState<@NonNull LazySlotState> objectState, @NonNull EReference eReference) {
            super(objectState, (EStructuralFeature)eReference, NOT_A_VALUE);
            assert (eReference.isMany());
            assert (this.getObjectManager().getEOppositeReference(eReference).isMany());
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
            LazyObjectManager objectManager = this.getObjectManager();
            assert (ecoreValue != null);
            List ecoreValues = (List)ecoreValue;
            EReference eOppositeReference = objectManager.getEOppositeReference((EReference)eFeature);
            for (EObject element : ecoreValues) {
                if (element == null) continue;
                AbstractObjectState<@NonNull ManyToManySlotState> elementObjectState = objectManager.getObjectState(element);
                elementObjectState.putSlotState((EStructuralFeature)eOppositeReference, this);
            }
            this.assignedSlot();
        }
    }

    static class OclContainerSlotState
    extends LazySlotState {
        public OclContainerSlotState(@NonNull AbstractObjectState<@NonNull LazySlotState> objectState, @NonNull EReference eReference, @NonNull Object eContainer) {
            super(objectState, (EStructuralFeature)eReference, eContainer);
            assert (!eReference.isMany());
            assert (this.getObjectManager().getEOppositeReference(eReference).isMany());
            assert (eReference == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER);
            assert (eReference.getEOpposite() == null);
            assert (eContainer == NOT_A_VALUE || ((EObject)objectState.getObject()).eContainer() == eContainer);
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object eContainer, boolean isPartial) {
            if (!this.isAssigned() && eContainer != null) {
                LazyObjectManager objectManager = this.getObjectManager();
                EObject eOpposite = (EObject)eContainer;
                EReference eOppositeReference = objectManager.getEOppositeReference((EReference)eFeature);
                eOppositeReference = ((EObject)eObject).eContainmentFeature();
                assert (eOppositeReference != null);
                Object aggregatorSlotState = objectManager.updateSlotState(eOpposite, (EStructuralFeature)eOppositeReference, eContainer, isPartial);
                aggregatorSlotState.assigned(eOpposite, (EStructuralFeature)eOppositeReference, eObject, isPartial);
            }
            super.assigned(eObject, eFeature, eContainer, isPartial);
        }
    }

    static class OneToManyAggregatorSlotState
    extends LazySlotState {
        private OneToManyAggregatorSlotState(@NonNull AbstractObjectState<@NonNull LazySlotState> objectState, @NonNull EReference eReference, @Nullable Object eContents) {
            super(objectState, (EStructuralFeature)eReference, eContents);
            assert (eReference.isMany());
            assert (eContents == NOT_A_VALUE || ((EObject)objectState.getObject()).eGet((EStructuralFeature)eReference).equals(eContents));
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
            assert (ecoreValue != null);
            LazyObjectManager objectManager = this.getObjectManager();
            EReference eOppositeReference = objectManager.getEOppositeReference((EReference)eFeature);
            if (isPartial) {
                AbstractObjectState<@NonNull SS> elementObjectState = objectManager.getObjectState(ecoreValue);
                elementObjectState.gotSlotState((EStructuralFeature)eOppositeReference, eObject);
            } else {
                Iterable ecoreValues = (Iterable)ecoreValue;
                for (EObject element : ecoreValues) {
                    if (element == null) continue;
                    AbstractObjectState<@NonNull SS> elementObjectState = objectManager.getObjectState(element);
                    elementObjectState.gotSlotState((EStructuralFeature)eOppositeReference, eObject);
                }
            }
            this.assignedSlot();
        }

        @Override
        public synchronized void getting(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
            this.assignedSlot();
        }
    }

    static class OneToManyElementSlotState
    extends LazySlotState {
        public OneToManyElementSlotState(@NonNull AbstractObjectState<@NonNull LazySlotState> objectState, @NonNull EReference eReference, @NonNull EReference eOppositeReference, @NonNull Object eAggregator) {
            super(objectState, (EStructuralFeature)eReference, eAggregator);
            assert (!eReference.isMany());
            assert (eOppositeReference.isMany());
            assert (eReference != OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER);
            assert (eAggregator == NOT_A_VALUE || eReference instanceof EOppositeReferenceImpl || ((EObject)objectState.getObject()).eGet((EStructuralFeature)eReference) == eAggregator);
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue, boolean isPartial) {
            if (!this.isAssigned() && ecoreValue != null) {
                LazyObjectManager objectManager = this.getObjectManager();
                EObject eOpposite = (EObject)ecoreValue;
                EReference eOppositeReference = objectManager.getEOppositeReference((EReference)eFeature);
                assert (eOppositeReference != null);
                OneToManyAggregatorSlotState aggregatorSlotState = (OneToManyAggregatorSlotState)objectManager.updateSlotState(eOpposite, (EStructuralFeature)eOppositeReference, ecoreValue, isPartial);
                aggregatorSlotState.assignedSlot();
            }
            super.assigned(eObject, eFeature, ecoreValue, isPartial);
        }
    }

    static class OneToOneSlotState
    extends LazySlotState {
        private OneToOneSlotState(@NonNull AbstractObjectState<@NonNull LazySlotState> objectState, @NonNull EReference eFeature, @Nullable Object eOpposite) {
            super(objectState, (EStructuralFeature)eFeature, eOpposite);
            assert (eOpposite != null);
            assert (!eFeature.isMany());
            Object eObject = objectState.getObject();
            LazyObjectManager objectManager = this.getObjectManager();
            if (eFeature instanceof EOppositeReferenceImpl) {
                assert (!((EOppositeReferenceImpl)eFeature).getEOpposite().isMany());
            } else {
                assert (!eFeature.isMany());
                if (!eFeature.isContainer() && !eFeature.isContainment() && eFeature != OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER) assert (!objectManager.getEOppositeReference(eFeature).isMany());
            }
            if (eFeature.isContainer()) {
                assert (((EObject)eObject).eContainer() == eOpposite);
            } else if (eFeature.isContainment()) {
                assert (eOpposite == NOT_A_VALUE || eObject == ((EObject)eOpposite).eContainer());
            } else {
                assert (!objectManager.getEOppositeReference(eFeature).isMany());
                assert (eOpposite == NOT_A_VALUE || !(eFeature == this.debug_eFeature ? ((EObject)eObject).eGet((EStructuralFeature)eFeature) != eOpposite : eOpposite != null && ((EObject)eOpposite).eGet((EStructuralFeature)objectManager.getEOppositeReference(eFeature)) != eObject));
            }
        }
    }

    static class SimpleSlotState
    extends LazySlotState {
        public SimpleSlotState(@NonNull AbstractObjectState<@NonNull LazySlotState> objectState, @NonNull EAttribute eFeature, @Nullable Object ecoreValue) {
            super(objectState, (EStructuralFeature)eFeature, ecoreValue);
        }
    }

    static class SpeculatingSlotState
    extends LazySlotState
    implements SlotState.Speculating {
        private final @NonNull Set< @NonNull SlotState.Speculating> inputSpeculatables = new UniqueList();
        private @Nullable Boolean speculationStatus;

        public SpeculatingSlotState(@NonNull AbstractObjectState<@NonNull LazySlotState> objectState, @NonNull EAttribute eFeature, @Nullable Boolean speculationStatus) {
            super(objectState, (EStructuralFeature)eFeature, speculationStatus != null ? speculationStatus : AbstractObjectManager.NOT_A_VALUE);
            assert (speculationStatus != AbstractObjectManager.NOT_A_VALUE);
            this.speculationStatus = speculationStatus;
        }

        @Override
        public void addInput( @NonNull SlotState.Speculating inputSpeculatable) {
            assert (this.speculationStatus == null);
            this.inputSpeculatables.add(inputSpeculatable);
        }

        @Override
        public @NonNull Iterable< @NonNull SlotState.Speculating> getInputs() {
            assert (this.speculationStatus == null);
            return this.inputSpeculatables;
        }

        @Override
        public @Nullable Boolean getSpeculationStatus() {
            return this.speculationStatus;
        }

        @Override
        public void setSpeculated(boolean success) {
            assert (this.speculationStatus == null);
            this.speculationStatus = success;
            if (!success) {
                this.assignedSlot();
            } else {
                this.unblock();
            }
        }
    }
}

