/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTSeparatedListNode;
import org.eclipse.photran.internal.core.parser.ASTUseStmtNode;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class AddOnlyToUseStmtRefactoring
extends FortranEditorRefactoring {
    private String moduleName = null;
    private IProject projectInEditor = null;
    private ASTUseStmtNode useNode = null;
    private List<IFile> filesContainingModule = null;
    private List<String> entitiesInProgram = new ArrayList<String>();
    private List<String> entitiesInModule = new ArrayList<String>();
    private Map<String, Definition> moduleEntDefMap = new HashMap<String, Definition>();
    private List<Definition> existingOnlyList = new ArrayList<Definition>();
    private List<Definition> defsToAdd = new ArrayList<Definition>();
    private Set<String> entitiesToAdd = new HashSet<String>();
    private Set<PhotranTokenRef> allReferences = null;
    private boolean onlyListInitiatlized = false;

    public AddOnlyToUseStmtRefactoring() {
    }

    public AddOnlyToUseStmtRefactoring(IFile file, ITextSelection selection) {
        this.initialize(file, selection);
    }

    public List<String> getModuleEntityList() {
        return this.entitiesInModule;
    }

    public void addToOnlyList(String name) {
        String id = PhotranVPG.canonicalizeIdentifier(name);
        this.entitiesToAdd.add(id);
        if (!this.defsToAdd.contains(this.moduleEntDefMap.get(id))) {
            this.defsToAdd.add(this.moduleEntDefMap.get(id));
        }
    }

    public void removeFromOnlyList(String name) {
        this.entitiesToAdd.remove(name);
        this.defsToAdd.remove(this.moduleEntDefMap.get(name));
    }

    public Set<String> getNewOnlyList() {
        return this.entitiesToAdd;
    }

    @Override
    protected void preCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.moduleName = this.selectedRegionInEditor.getText();
        if (this.moduleName == null || this.moduleName.equals("")) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_NoModuleNameSelected);
        }
        this.findUseStmtNode();
        this.checkIfModuleExistsInProject();
        this.getModuleDeclaredEntities();
        this.getProgramDeclaredEntities();
        this.readExistingOnlyList();
    }

    private void findUseStmtNode() throws VPGRefactoring.PreconditionFailure {
        Token token = this.findEnclosingToken();
        if (token == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_SelectModuleName);
        }
        this.useNode = token.findNearestAncestor(ASTUseStmtNode.class);
        if (this.useNode == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_SelectModuleName);
        }
    }

    private void checkIfModuleExistsInProject() throws VPGRefactoring.PreconditionFailure {
        this.projectInEditor = this.fileInEditor.getProject();
        this.filesContainingModule = ((PhotranVPG)this.vpg).findFilesThatExportModule(this.moduleName);
        if (this.filesContainingModule.isEmpty() || this.filesContainingModule == null) {
            this.fail(Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_NoFilesContainModule, (Object)this.moduleName));
        } else if (this.filesContainingModule.size() > 1) {
            this.filterFileList();
        }
        if (this.filesContainingModule.isEmpty() || this.filesContainingModule == null) {
            this.fail(Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_NoFilesContainModule, (Object)this.moduleName));
        }
        if (this.filesContainingModule.size() > 1) {
            this.fail(Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_MultipleDefinitionsOfModule, (Object)this.moduleName));
        }
    }

    private void filterFileList() throws VPGRefactoring.PreconditionFailure {
        if (this.projectInEditor == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_ProjectDoesNotExist);
        }
        int i = 0;
        while (i < this.filesContainingModule.size()) {
            if (this.filesContainingModule.get(i) == null || this.filesContainingModule.get(i).getProject() != this.projectInEditor) {
                this.filesContainingModule.remove(i);
                continue;
            }
            ++i;
        }
    }

    private Token findEnclosingToken() throws VPGRefactoring.PreconditionFailure {
        Token selectedToken = AddOnlyToUseStmtRefactoring.findEnclosingToken(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (selectedToken == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_PleaseSelectModuleName);
        }
        return selectedToken;
    }

    private void getProgramDeclaredEntities() throws VPGRefactoring.PreconditionFailure {
        IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(this.fileInEditor);
        if (ast == null) {
            return;
        }
        DeclarationVisitor visitor = new DeclarationVisitor();
        ast.accept(visitor);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private void getModuleDeclaredEntities() throws VPGRefactoring.PreconditionFailure {
        List<Definition> moduleDefs;
        ASTModuleNode moduleNode;
        Token moduleToken;
        PhotranTokenRef moduleTokenRef = ((PhotranVPG)this.vpg).getModuleTokenRef(this.moduleName);
        if (moduleTokenRef == null) {
            this.fail(Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_NoModuleNamed, (Object)this.moduleName));
        }
        if ((moduleToken = moduleTokenRef.findTokenOrReturnNull()) == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_ModuleTokenNotFound);
        }
        if ((moduleNode = moduleToken.findNearestAncestor(ASTModuleNode.class)) == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_ModuleNodeNodeFound);
        }
        if ((moduleDefs = moduleNode.getAllPublicDefinitions()).isEmpty()) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_NoDeclarationsInModule);
        } else {
            for (Definition def : moduleDefs) {
                this.moduleEntDefMap.put(def.getCanonicalizedName(), def);
                this.entitiesInModule.add(def.getCanonicalizedName());
            }
        }
    }

    public void readExistingOnlyList() {
        ASTSeparatedListNode existingOnlys = (ASTSeparatedListNode)this.useNode.getOnlyList();
        if (existingOnlys != null) {
            for (Object existingOnly : existingOnlys) {
                String id = PhotranVPG.canonicalizeIdentifier(existingOnly.toString().trim());
                this.entitiesToAdd.add(id);
                this.existingOnlyList.add(this.moduleEntDefMap.get(id));
            }
        }
        if (!this.onlyListInitiatlized) {
            IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(this.fileInEditor);
            if (ast == null) {
                return;
            }
            TokenVisitor visitor = new TokenVisitor();
            ast.accept(visitor);
            ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
            this.onlyListInitiatlized = true;
        }
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(this.fileInEditor);
        if (ast == null) {
            return;
        }
        pm.subTask(Messages.AddOnlyToUseStmtRefactoring_InsertingUseStmt);
        this.createAndInsertUseStmt(ast);
        pm.subTask(Messages.AddOnlyToUseStmtRefactoring_CreatingChangeObject);
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
        pm.done();
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        pm.beginTask(Messages.AddOnlyToUseStmtRefactoring_Analyzing, -1);
        if (this.useNode == null) {
            this.fail(Messages.AddOnlyToUseStmtRefactoring_ModuleNameInUseStmtNotSelected);
        }
        pm.subTask(String.valueOf(Messages.AddOnlyToUseStmtRefactoring_Parsing) + this.fileInEditor.getName());
        IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(this.fileInEditor);
        if (ast == null) {
            return;
        }
        pm.subTask(Messages.AddOnlyToUseStmtRefactoring_CheckingForConflicts);
        this.checkConflictingBindings(ast, pm, status);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
        pm.done();
    }

    private void checkConflictingBindings(IFortranAST ast, IProgressMonitor pm, RefactoringStatus status) {
        pm.subTask(Messages.AddOnlyToUseStmtRefactoring_FindingReferences);
        for (String entityToAdd : this.entitiesToAdd) {
            Set<PhotranTokenRef> newRefs = this.findModuleEntityRefs(ast, Arrays.asList(entityToAdd));
            this.allReferences = newRefs;
            Definition def = this.moduleEntDefMap.get(entityToAdd);
            AddOnlyToUseStmtRefactoring.checkForConflictingBindings(pm, (FortranResourceRefactoring.IConflictingBindingCallback)new ConflictingBindingErrorHandler(status), def, (ScopingNode)ast.getRoot().getProgramUnitList().get(0), this.allReferences, def.getCanonicalizedName());
        }
    }

    private Set<PhotranTokenRef> findModuleEntityRefs(IFortranAST ast, final Collection<String> defNames) {
        final HashSet<PhotranTokenRef> result = new HashSet<PhotranTokenRef>();
        ast.accept(new GenericASTVisitor(){

            @Override
            public void visitToken(Token token) {
                if (token.getTerminal() == Terminal.T_IDENT) {
                    for (Definition def : token.resolveBinding()) {
                        if (!defNames.contains(def.getCanonicalizedName())) continue;
                        result.add(token.getTokenRef());
                    }
                }
            }
        });
        return result;
    }

    private void removeOriginalModuleRefs() {
        if (this.allReferences != null && this.allReferences.size() > 0) {
            HashSet<PhotranTokenRef> referencesToRemove = new HashSet<PhotranTokenRef>();
            for (PhotranTokenRef ref : this.allReferences) {
                IFile file = ref.getFile();
                IProject project = file.getProject();
                if (this.projectInEditor.equals((Object)project)) continue;
                referencesToRemove.add(ref);
            }
            this.allReferences.removeAll(referencesToRemove);
        }
    }

    private void createAndInsertUseStmt(IFortranAST ast) {
        Token useToken = ast.findTokenByStreamOffsetLength(this.useNode.getUseToken().getFileOffset(), this.useNode.getUseToken().getLength());
        ASTUseStmtNode useToModify = (ASTUseStmtNode)useToken.getParent();
        TreeSet<String> varNames = new TreeSet<String>(this.entitiesToAdd);
        String newOnlyAdditions = " ";
        Iterator iter = varNames.iterator();
        int counter = 0;
        while (iter.hasNext()) {
            newOnlyAdditions = String.valueOf(newOnlyAdditions) + (String)iter.next();
            if (counter < varNames.size() - 1) {
                newOnlyAdditions = String.valueOf(newOnlyAdditions) + ", ";
            }
            ++counter;
        }
        ASTUseStmtNode newStmtNode = this.entitiesToAdd.size() > 0 ? (ASTUseStmtNode)AddOnlyToUseStmtRefactoring.parseLiteralStatement(String.valueOf(useToken.getWhiteBefore()) + "use " + useToModify.getName().getText() + ", only:" + newOnlyAdditions + System.getProperty("line.separator")) : (ASTUseStmtNode)AddOnlyToUseStmtRefactoring.parseLiteralStatement(String.valueOf(useToken.getWhiteBefore()) + "use " + useToModify.getName().getText() + System.getProperty("line.separator"));
        useToModify.replaceWith(newStmtNode);
    }

    @Override
    public String getName() {
        return Messages.AddOnlyToUseStmtRefactoring_Name;
    }

    private final class ConflictingBindingErrorHandler
    implements FortranResourceRefactoring.IConflictingBindingCallback {
        private final RefactoringStatus status;

        private ConflictingBindingErrorHandler(RefactoringStatus status) {
            this.status = status;
        }

        @Override
        public void addConflictError(List<FortranResourceRefactoring.Conflict> conflictingDef) {
            PhotranVPG vpg = AddOnlyToUseStmtRefactoring.this.getVPG();
            for (FortranResourceRefactoring.Conflict conflict : conflictingDef) {
                IFile file = conflict.tokenRef.getFile();
                if (AddOnlyToUseStmtRefactoring.this.filesContainingModule.contains(file) || !file.getProject().equals((Object)AddOnlyToUseStmtRefactoring.this.projectInEditor)) continue;
                Definition def = vpg.getDefinitionFor(conflict.tokenRef);
                Token token = def.getTokenRef().findToken();
                String msg = Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_NameConflicts, (Object[])new Object[]{conflict.name, def.getCanonicalizedName(), def.getClassification(), token.getLine(), conflict.tokenRef.getFilename()});
                RefactoringStatusContext context = AddOnlyToUseStmtRefactoring.this.createContext(conflict.tokenRef);
                this.status.addError(msg, context);
            }
        }

        @Override
        public void addConflictWarning(List<FortranResourceRefactoring.Conflict> conflictingDef) {
            for (FortranResourceRefactoring.Conflict conflict : conflictingDef) {
                IFile file = conflict.tokenRef.getFile();
                if (AddOnlyToUseStmtRefactoring.this.filesContainingModule.contains(file) || !file.getProject().equals((Object)AddOnlyToUseStmtRefactoring.this.projectInEditor)) continue;
                String msg = Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_NameMightConflict, (Object)conflict.name);
                RefactoringStatusContext context = AddOnlyToUseStmtRefactoring.this.createContext(conflict.tokenRef);
                this.status.addWarning(msg, context);
            }
        }

        @Override
        public void addReferenceWillChangeError(String newName, Token reference) {
            if (AddOnlyToUseStmtRefactoring.this.entitiesInProgram.contains(newName)) {
                String msg = Messages.bind((String)Messages.AddOnlyToUseStmtRefactoring_AddingWouldChangeMeaningOf, (Object[])new Object[]{newName, reference.getText(), reference.getLine(), reference.getTokenRef().getFilename()});
                RefactoringStatusContext context = AddOnlyToUseStmtRefactoring.this.createContext(reference);
                this.status.addError(msg, context);
            }
        }
    }

    private final class DeclarationVisitor
    extends GenericASTVisitor {
        private DeclarationVisitor() {
        }

        @Override
        public void visitASTEntityDeclNode(ASTEntityDeclNode node) {
            String name = node.getObjectName().getObjectName().getText();
            if (!AddOnlyToUseStmtRefactoring.this.entitiesInProgram.contains(name)) {
                AddOnlyToUseStmtRefactoring.this.entitiesInProgram.add(name);
            }
        }
    }

    private final class TokenVisitor
    extends GenericASTVisitor {
        private TokenVisitor() {
        }

        @Override
        public void visitToken(Token node) {
            String name = node.getText();
            if (AddOnlyToUseStmtRefactoring.this.moduleEntDefMap.containsKey(name)) {
                AddOnlyToUseStmtRefactoring.this.addToOnlyList(name);
            }
        }
    }
}

