/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.infra.ui.util.EclipseCommandUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public abstract class AbstractCreateMenuFromCommandCategory
extends ExtensionContributionFactory {
    protected final String commandCateogyId;

    public AbstractCreateMenuFromCommandCategory(String commandCategoryId) {
        this.commandCateogyId = commandCategoryId;
    }

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        Expression visibleWhen = new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                return EvaluationResult.TRUE;
            }
        };
        for (CommandContributionItem item : this.addCreationItems(serviceLocator, additions, null)) {
            additions.addContributionItem((IContributionItem)item, visibleWhen);
        }
    }

    protected List<CommandContributionItem> addCreationItems(IServiceLocator serviceLocator, IContributionRoot additions, IContributionManager parent) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        ArrayList<CommandContributionItem> items = new ArrayList<CommandContributionItem>();
        Category category = commandService.getCategory(this.commandCateogyId);
        TreeSet<Command> commands = new TreeSet<Command>();
        commands.addAll(Arrays.asList(commandService.getDefinedCommands()));
        for (Command command : commands) {
            IHandler handler;
            Category currentCategory = null;
            try {
                currentCategory = command.getCategory();
            }
            catch (NotDefinedException e) {
                Activator.log.debug(e.getLocalizedMessage());
                continue;
            }
            if (!command.isDefined() || !category.equals((Object)currentCategory) || !((handler = command.getHandler()) instanceof AbstractHandler)) continue;
            ((AbstractHandler)handler).setEnabled(null);
            boolean isEnabled = handler.isEnabled();
            command.setEnabled(null);
            ((AbstractHandler)handler).setEnabled(null);
            isEnabled = handler.isEnabled();
            try {
                if (!isEnabled) continue;
                CommandContributionItemParameter p = new CommandContributionItemParameter(serviceLocator, "", command.getId(), 8);
                p.label = command.getDescription();
                p.icon = EclipseCommandUtils.getCommandIcon(command);
                CommandContributionItem item = new CommandContributionItem(p);
                items.add(item);
            }
            catch (NotDefinedException e) {
                Activator.log.debug(e.getLocalizedMessage());
            }
        }
        return items;
    }
}

