/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SWTUtil {
    private static FontMetrics fontMetrics;

    protected static void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected static int getButtonWidthHint(Button button) {
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void setButtonDimensionHint(Button button) {
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = SWTUtil.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    public static Button createButton(Composite comp, String label) {
        Button b = new Button(comp, 8);
        b.setText(label);
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        GridData data = new GridData(256);
        data.widthHint = SWTUtil.getButtonWidthHint(b);
        b.setLayoutData((Object)data);
        return b;
    }

    public static Button createCheckButton(Composite parent, String label, int hspan) {
        Button button = new Button(parent, 32);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        gd.horizontalSpan = hspan;
        button.setLayoutData((Object)gd);
        return button;
    }

    public static Text createText(Composite parent, int style, int hspan) {
        Text t = new Text(parent, style);
        t.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        t.setLayoutData((Object)gd);
        return t;
    }
}

