/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;

class VisibleLinesTracker
implements PaintListener {
    private static final String DATA_KEY = VisibleLinesTracker.class.getName();
    private final ITextViewer viewer;
    private int oldModelBottom = -1;
    private int oldWidgetBottom = -1;
    private int oldBottomPixel;
    private final LinkedHashSet<Consumer<StyledText>> handlers = new LinkedHashSet();

    private VisibleLinesTracker(ITextViewer viewer) {
        this.viewer = viewer;
    }

    public void paintControl(PaintEvent e) {
        StyledText textWidget = this.viewer.getTextWidget();
        if (this.oldModelBottom == -1) {
            this.oldWidgetBottom = JFaceTextUtil.getPartialBottomIndex(textWidget);
            this.oldModelBottom = JFaceTextUtil.widgetLine2ModelLine(this.viewer, this.oldWidgetBottom);
            this.oldBottomPixel = JFaceTextUtil.getLinePixel(textWidget, this.oldWidgetBottom);
            return;
        }
        int newWidgetBottom = JFaceTextUtil.getPartialBottomIndex(textWidget);
        int newModelBottom = JFaceTextUtil.widgetLine2ModelLine(this.viewer, newWidgetBottom);
        int newBottomPixel = JFaceTextUtil.getLinePixel(textWidget, newWidgetBottom);
        if (newWidgetBottom != this.oldWidgetBottom || newModelBottom != this.oldModelBottom || newBottomPixel != this.oldBottomPixel) {
            this.oldWidgetBottom = newWidgetBottom;
            this.oldModelBottom = newModelBottom;
            this.oldBottomPixel = newBottomPixel;
            this.handlers.forEach(handler -> handler.accept(textWidget));
        }
    }

    static void track(ITextViewer viewer, Consumer<StyledText> handler) {
        StyledText textWidget;
        StyledText styledText = textWidget = viewer != null ? viewer.getTextWidget() : null;
        if (textWidget == null) {
            return;
        }
        VisibleLinesTracker tracker = (VisibleLinesTracker)textWidget.getData(DATA_KEY);
        if (tracker == null) {
            tracker = new VisibleLinesTracker(viewer);
            textWidget.setData(DATA_KEY, (Object)tracker);
        }
        tracker.addHandler(handler);
    }

    static void untrack(ITextViewer viewer, Consumer<StyledText> handler) {
        StyledText textWidget;
        StyledText styledText = textWidget = viewer != null ? viewer.getTextWidget() : null;
        if (textWidget == null) {
            return;
        }
        VisibleLinesTracker tracker = (VisibleLinesTracker)textWidget.getData(DATA_KEY);
        if (tracker != null) {
            tracker.removeHandler(handler);
        }
    }

    private void addHandler(Consumer<StyledText> handler) {
        if (this.handlers.isEmpty()) {
            this.viewer.getTextWidget().addPaintListener((PaintListener)this);
        }
        this.handlers.add(handler);
    }

    private void removeHandler(Consumer<StyledText> handler) {
        this.handlers.remove(handler);
        if (this.handlers.isEmpty()) {
            this.viewer.getTextWidget().removePaintListener((PaintListener)this);
        }
    }
}

