/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.EGFCommonPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusHelper {
    private StatusHelper() {
    }

    public static IStatus newStatus(int severity, String message, Throwable exception) {
        String statusMessage = message;
        if (message == null || message.trim().length() == 0) {
            if (exception == null) {
                throw new IllegalArgumentException();
            }
            statusMessage = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        }
        return new Status(severity, EGFCommonPlugin.getDefault().getPluginID(), severity, statusMessage, exception);
    }

    protected static IStatus newStatus(String pluginID, IStatus[] stati, String message, Throwable exception) {
        if (message == null || message.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        return new MultiStatus(pluginID != null && pluginID.trim().length() > 0 ? pluginID : EGFCommonPlugin.getDefault().getPluginID(), 4, stati, message, exception);
    }

    public static IStatus newStatus(String pluginID, int severity, String message, Throwable exception) {
        String statusMessage = message;
        if (message == null || message.trim().length() == 0) {
            if (exception == null) {
                throw new IllegalArgumentException();
            }
            statusMessage = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        }
        return new Status(severity, pluginID != null && pluginID.trim().length() > 0 ? pluginID : EGFCommonPlugin.getDefault().getPluginID(), severity, statusMessage, exception);
    }

    public static IStatus newStatus(String pluginID, List<IStatus> children, String message, Throwable exception) {
        ArrayList<IStatus> flatStatusCollection = new ArrayList<IStatus>();
        for (IStatus currentStatus : children) {
            Iterator<IStatus> childrenIter = StatusHelper.flatten(currentStatus).iterator();
            while (childrenIter.hasNext()) {
                flatStatusCollection.add(childrenIter.next());
            }
        }
        IStatus[] stati = new IStatus[flatStatusCollection.size()];
        flatStatusCollection.toArray(stati);
        return StatusHelper.newStatus(pluginID, stati, message, exception);
    }

    protected static List<IStatus> flatten(IStatus aStatus) {
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        if (aStatus.isMultiStatus()) {
            IStatus[] children = aStatus.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus currentChild = children[i];
                if (currentChild.isMultiStatus()) {
                    Iterator<IStatus> childStatiiEnum = StatusHelper.flatten(currentChild).iterator();
                    while (childStatiiEnum.hasNext()) {
                        result.add(childStatiiEnum.next());
                    }
                } else {
                    result.add(currentChild);
                }
                ++i;
            }
        } else {
            result.add(aStatus);
        }
        return result;
    }
}

