/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.query.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;

public class SQLLogUtil {
    private static int MAX_TRACELINE_LEN = 200;
    private Plugin currentPlugin;

    public SQLLogUtil(Plugin plugin) {
        if (plugin != null) {
            this.setCurrentPlugin(plugin);
        }
    }

    public Plugin getCurrentPlugin() {
        return this.currentPlugin;
    }

    public void setCurrentPlugin(Plugin currentPlugin) {
        this.currentPlugin = currentPlugin;
    }

    public boolean isTracing() {
        boolean tracing = false;
        if (this.getCurrentPlugin() != null && this.getCurrentPlugin().isDebugging()) {
            tracing = true;
        }
        return tracing;
    }

    public void write(Throwable throwable) {
        if (this.getCurrentPlugin() != null && this.getCurrentPlugin().isDebugging()) {
            Status status = new Status(1, this.getCurrentPlugin().getBundle().getSymbolicName(), 0, throwable.toString(), throwable);
            this.getCurrentPlugin().getLog().log((IStatus)status);
        }
    }

    public void write(String text) {
        this.write(new Throwable(text));
    }

    public void write(Object obj) {
        this.write(obj.toString());
    }

    public void writeInfo(String text) {
        if (this.getCurrentPlugin() != null && this.getCurrentPlugin().isDebugging()) {
            Status status = new Status(1, this.getCurrentPlugin().getBundle().getSymbolicName(), 0, text, new Throwable(text));
            this.getCurrentPlugin().getLog().log((IStatus)status);
        }
    }

    public void writeLog(Throwable throwable) {
        if (this.getCurrentPlugin() != null) {
            Status status = new Status(4, this.getCurrentPlugin().getBundle().getSymbolicName(), 0, throwable.toString(), throwable);
            this.getCurrentPlugin().getLog().log((IStatus)status);
        }
    }

    public void writeLog(String text) {
        this.writeLog(new Throwable(text));
    }

    public void writeLog(Object obj) {
        this.writeLog(obj.toString());
    }

    public void writeTrace(String text) {
        if (this.getCurrentPlugin() != null && this.getCurrentPlugin().isDebugging()) {
            Status status = new Status(1, this.getCurrentPlugin().getBundle().getSymbolicName(), 0, "Trace: " + text, null);
            this.getCurrentPlugin().getLog().log((IStatus)status);
        }
    }

    public void writeTraceEntry(Object[] args) {
        if (this.getCurrentPlugin() != null && this.getCurrentPlugin().isDebugging()) {
            Throwable t = new Throwable();
            StackTraceElement caller = t.getStackTrace()[1];
            String className = caller.getClassName();
            String methodName = caller.getMethodName();
            int line = caller.getLineNumber();
            StringBuffer msg = new StringBuffer();
            msg.append("Trace: Entry ");
            msg.append(className);
            msg.append(".");
            msg.append(methodName);
            msg.append(" at line ");
            msg.append(line);
            if (args != null) {
                msg.append(" with args: ");
                int i = 0;
                while (i < args.length) {
                    String arg = null;
                    boolean truncate = false;
                    arg = args[i] != null ? (args[i] instanceof SQLQueryObject ? StatementHelper.getSQLSourceUnformatted((SQLQueryObject)args[i]) : args[i].toString()) : "null";
                    boolean bl = truncate = arg.length() > MAX_TRACELINE_LEN;
                    if (truncate) {
                        arg = String.valueOf(arg.substring(0, MAX_TRACELINE_LEN)) + "...";
                    }
                    msg.append(arg);
                    if (i < args.length - 1) {
                        msg.append(", ");
                    }
                    ++i;
                }
            }
            Status status = new Status(1, this.getCurrentPlugin().getBundle().getSymbolicName(), 0, msg.toString(), null);
            this.getCurrentPlugin().getLog().log((IStatus)status);
        }
    }

    public boolean writeTraceExit(boolean returnValue) {
        if (this.getCurrentPlugin() != null && this.getCurrentPlugin().isDebugging()) {
            this.writeTraceExit(new Boolean(returnValue));
        }
        return returnValue;
    }

    public int writeTraceExit(int returnValue) {
        if (this.getCurrentPlugin() != null && this.getCurrentPlugin().isDebugging()) {
            this.writeTraceExit(new Integer(returnValue));
        }
        return returnValue;
    }

    public Object writeTraceExit(Object returnValue) {
        if (this.getCurrentPlugin() != null && this.getCurrentPlugin().isDebugging()) {
            Throwable t = new Throwable();
            StackTraceElement caller = t.getStackTrace()[1];
            String className = caller.getClassName();
            String methodName = caller.getMethodName();
            if (methodName.equals("writeTraceExit")) {
                caller = t.getStackTrace()[2];
                className = caller.getClassName();
                methodName = caller.getMethodName();
            }
            int line = caller.getLineNumber();
            StringBuffer msg = new StringBuffer();
            msg.append("Trace: Exit ");
            msg.append(className);
            msg.append(".");
            msg.append(methodName);
            msg.append(" at line ");
            msg.append(line);
            String returnValueString = null;
            if (returnValue != null) {
                returnValueString = returnValue instanceof SQLQueryObject ? StatementHelper.getSQLSourceUnformatted((SQLQueryObject)returnValue) : returnValue.toString();
                if (returnValueString != null && returnValueString.length() > MAX_TRACELINE_LEN) {
                    returnValueString = String.valueOf(returnValueString.substring(0, MAX_TRACELINE_LEN)) + "...";
                }
                msg.append(" with return value: ");
                msg.append(returnValueString);
            }
            Status status = new Status(1, this.getCurrentPlugin().getBundle().getSymbolicName(), 0, msg.toString(), null);
            this.getCurrentPlugin().getLog().log((IStatus)status);
        }
        return returnValue;
    }
}

