/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IStorage;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.model.XpandResource;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.type.baseimpl.PolymorphicResolver;
import org.eclipse.internal.xtend.type.baseimpl.types.CollectionTypeImpl;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xpand.ui.core.IXpandResource;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.search.SearchMatch;
import org.eclipse.xtend.shared.ui.core.search.XtendXpandSearchEngine;
import org.eclipse.xtend.shared.ui.editor.navigation.AbstractHyperlinkDetector;
import org.eclipse.xtend.shared.ui.editor.navigation.ContextComputer;
import org.eclipse.xtend.shared.ui.editor.navigation.GenericHyperlink;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandHyperlinkDetector
extends AbstractHyperlinkDetector {
    public XpandHyperlinkDetector(IEditorPart editor) {
        super(editor);
    }

    protected List<GenericHyperlink> computeMatchesAndHyperlinks(IRegion hyperlinkRegion, String hyperlinkedWord, IXtendXpandProject project) {
        try {
            ArrayList<GenericHyperlink> links = super.computeMatchesAndHyperlinks(hyperlinkRegion, hyperlinkedWord, project);
            if (!links.isEmpty()) {
                return links;
            }
            links = new ArrayList<GenericHyperlink>();
            IXpandResource xpandResource = (IXpandResource)Activator.getExtXptModelManager().findExtXptResource((IStorage)this.getFile());
            ExpandStatement statement = XtendXpandSearchEngine.findDefinition((String)hyperlinkedWord, (IRegion)hyperlinkRegion, (Template)((Template)xpandResource.getExtXptResource()));
            if (statement == null) {
                return Collections.emptyList();
            }
            List defmatches = XtendXpandSearchEngine.findDefinitionsByNameInResourceAndImports((IXtendXpandProject)project, (String)statement.getDefinition().toString(), (XpandResource)xpandResource);
            ContextComputer helper = this.computeContext(xpandResource, statement.getTarget());
            if (helper == null || helper.getContext() == null) {
                return this.useGenericHyplerlinkDetector(hyperlinkRegion, hyperlinkedWord, project);
            }
            ExecutionContext ctx = helper.getContext();
            Type expandTargetType = null;
            expandTargetType = statement.getTarget() == null ? ctx.getTypeForName(statement.getContainingDefinition().getType().toString()) : (statement.getTarget().equals("this") ? ctx.getTypeForName(statement.getContainingDefinition().getType().toString()) : statement.getTarget().analyze(ctx, new HashSet()));
            if (expandTargetType == null) {
                expandTargetType = ctx.getTypeForName(statement.getContainingDefinition().getType().toString());
            }
            if (expandTargetType instanceof CollectionTypeImpl) {
                expandTargetType = ((CollectionTypeImpl)expandTargetType).getInnerType();
            }
            Type[] statementTypes = new Type[statement.getParameters().length];
            int i = 0;
            while (i < statementTypes.length) {
                statementTypes[i] = statement.getParameters()[i].analyze(ctx, new HashSet());
                if (statementTypes[i] == null) {
                    statementTypes[i] = ctx.getObjectType();
                }
                ++i;
            }
            for (AbstractDefinition definition : defmatches) {
                int compare = this.isDefinitionAssignableFromExpandStatement(definition, statementTypes, expandTargetType, ctx);
                if (compare == -1) continue;
                GenericHyperlink genericHyperlink = this.createGenericTemplateHyperlink(hyperlinkedWord, statement, definition);
                if (compare == 0) {
                    links.add(0, genericHyperlink);
                    continue;
                }
                links.add(genericHyperlink);
            }
            return links;
        }
        catch (Exception e) {
            return this.useGenericHyplerlinkDetector(hyperlinkRegion, hyperlinkedWord, project);
        }
    }

    protected GenericHyperlink createGenericTemplateHyperlink(String hyperlinkedWord, ExpandStatement statement, AbstractDefinition definition) {
        SearchMatch match = new SearchMatch(definition.getDefName().getStart(), definition.getDefName().getEnd() - definition.getDefName().getStart(), this.getXXResourceByName(definition.getFileName().replaceAll("::", "/"), "xpt").getUnderlyingStorage());
        GenericHyperlink genericHyperlink = new GenericHyperlink(this.getWorkbenchPage(), match, (IRegion)new Region(statement.getDefinition().getStart(), statement.getDefinition().getEnd() - statement.getDefinition().getStart()), this.computeHyperlinkLabel(hyperlinkedWord, definition.getTargetType(), definition.getParamsAsList(), this.getXXResourceByName(definition.getFileName().replaceAll("::", "/"), "xpt")));
        return genericHyperlink;
    }

    private int isDefinitionAssignableFromExpandStatement(AbstractDefinition definition, Type[] statementTypes, Type statementType, ExecutionContext ctx) {
        Type defineType = ctx.getTypeForName(definition.getType().toString());
        if (defineType == null) {
            defineType = ctx.getObjectType();
        }
        if (!defineType.isAssignableFrom(statementType)) {
            return -1;
        }
        ArrayList<Type> definitionTypes = new ArrayList<Type>();
        DeclaredParameter[] declaredParameterArray = definition.getParams();
        int n = declaredParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeclaredParameter param = declaredParameterArray[n2];
            Type paramType = ctx.getTypeForName(param.getType().toString());
            if (paramType != null) {
                definitionTypes.add(paramType);
            } else {
                definitionTypes.add(ctx.getObjectType());
            }
            ++n2;
        }
        return PolymorphicResolver.typesComparator.compare(definitionTypes, Arrays.asList(statementTypes));
    }
}

