/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.wsdl.xsd;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InlineSchemaGenerator {
    protected final String SOAP_ENCODING_URI = "http://schemas.xmlsoap.org/soap/encoding/";
    protected final String XMLNS = "xmlns";
    protected final String TARGETNAMESPACE = "targetNamespace";
    protected final String NAMESPACE = "namespace";
    protected final String IMPORT = "import";
    protected final String INCLUDE = "include";
    protected final String SCHEMA = "schema";
    protected final String SCHEMALOCATION = "schemaLocation";
    protected final String TYPE = "type";
    protected final String NAME = "name";
    protected final String[] ignoreNamespaces = new String[]{"http://www.w3.org/1999/XMLSchema", "http://www.w3.org/2000/10/XMLSchema", "http://www.w3.org/2001/XMLSchema"};
    protected static InlineSchemaGenerator instance = null;

    protected InlineSchemaGenerator() {
    }

    protected static InlineSchemaGenerator getInstance() {
        if (instance == null) {
            instance = new InlineSchemaGenerator();
        }
        return instance;
    }

    public static String createXSDString(Element element, List elements, String filelocation) {
        return InlineSchemaGenerator.createXSDString(element, elements, filelocation, new Hashtable());
    }

    public static String createXSDString(Element element, List elements, String filelocation, Hashtable parentNSs) {
        InlineSchemaGenerator schemaGenerator = InlineSchemaGenerator.getInstance();
        Hashtable nsResolver = schemaGenerator.getNSResolver(element);
        List reqns = schemaGenerator.getRequiredNamespaces(element);
        Hashtable reqNSDecl = schemaGenerator.resolveNamespaces(reqns, nsResolver, parentNSs);
        List importNS = schemaGenerator.getImportNamespaces(element);
        reqns = schemaGenerator.removeImports(reqns, importNS);
        reqns = schemaGenerator.removeLocalNamespaces(reqns, element);
        return schemaGenerator.createXSDStringRecursively(element, elements, reqns, reqNSDecl, filelocation);
    }

    public static boolean soapEncodingRequiredNotImported(Element element, String filelocation, Hashtable parentNSs) {
        InlineSchemaGenerator schemaGenerator = InlineSchemaGenerator.getInstance();
        Hashtable nsResolver = schemaGenerator.getNSResolver(element);
        List reqns = null;
        reqns = schemaGenerator.getRequiredNamespaces(element);
        schemaGenerator.resolveNamespaces(reqns, nsResolver, parentNSs);
        List importNS = schemaGenerator.getImportNamespaces(element);
        reqns = schemaGenerator.removeImports(reqns, importNS);
        reqns = schemaGenerator.removeLocalNamespaces(reqns, element);
        return schemaGenerator.checkSOAPEncodingRequired(reqns);
    }

    protected String createXSDStringRecursively(Element elem, List elements, List requiredNamespaces, Hashtable reqNSDecl, String filelocation) {
        if (elem == null) {
            return "";
        }
        elements.add(elem);
        StringBuffer xsdString = new StringBuffer();
        String elementName = elem.getTagName();
        xsdString.append("<").append(elementName);
        boolean foundSchemaLocation = false;
        String namespace = "";
        String namePrefix = "";
        NamedNodeMap atts = elem.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Node n = atts.item(i);
            xsdString.append(" ").append(n.getNodeName()).append("=\"");
            String nodeName = n.getNodeName();
            if (nodeName.equalsIgnoreCase("schemaLocation") && filelocation != null) {
                foundSchemaLocation = true;
                String relativePath = n.getNodeValue();
                xsdString.append(relativePath).append("\"");
            } else {
                String nodeValue = n.getNodeValue();
                if (nodeName.equalsIgnoreCase("namespace")) {
                    namespace = nodeValue;
                } else if (nodeName.indexOf("xmlns") != -1 && nodeValue.equalsIgnoreCase(elem.getNamespaceURI())) {
                    namePrefix = nodeName;
                    namePrefix = namePrefix.equalsIgnoreCase("xmlns") ? "" : String.valueOf(namePrefix.substring(6)) + ":";
                }
                if (nodeValue.equals("http://www.w3.org/1999/XMLSchema") || nodeValue.equals("http://www.w3.org/2000/10/XMLSchema")) {
                    nodeValue = "http://www.w3.org/2001/XMLSchema";
                }
                xsdString.append(nodeValue).append("\"");
            }
            ++i;
        }
        if (elementName.equalsIgnoreCase("import") && !foundSchemaLocation) {
            xsdString.append(" ").append("schemaLocation").append("=\"").append(namespace).append("\"");
        }
        if (reqNSDecl != null) {
            Enumeration keys = reqNSDecl.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String declNS = (String)reqNSDecl.get(key);
                if (declNS.equals("http://www.w3.org/1999/XMLSchema") || declNS.equals("http://www.w3.org/2000/10/XMLSchema")) {
                    declNS = "http://www.w3.org/2001/XMLSchema";
                }
                xsdString.append(" ").append(key).append("=\"").append(declNS).append("\"");
            }
        }
        xsdString.append(">");
        if (requiredNamespaces != null) {
            for (String ns : requiredNamespaces) {
                xsdString.append("<").append(namePrefix).append("import").append(" ").append("namespace").append("=\"").append(ns).append("\" ").append("schemaLocation").append("=\"").append(ns).append("\"/>");
            }
        }
        xsdString.append("\n");
        NodeList childNodes = elem.getChildNodes();
        int i2 = 0;
        while (i2 < childNodes.getLength() || i2 < 5) {
            Node n = childNodes.item(i2);
            if (n instanceof Element) {
                Element child = (Element)n;
                xsdString.append(this.createXSDStringRecursively(child, elements, null, null, filelocation));
            }
            ++i2;
        }
        xsdString.append("</").append(elem.getTagName()).append(">");
        return xsdString.toString();
    }

    protected List getRequiredNamespaces(Element elem) {
        String localname;
        Vector<String> namespace = new Vector<String>();
        NodeList childNodes = elem.getChildNodes();
        int numChildren = childNodes.getLength();
        int i = 0;
        while (i < numChildren) {
            Node n = childNodes.item(i);
            if (n instanceof Element) {
                Element child = (Element)n;
                List childns = this.getRequiredNamespaces(child);
                int j = childns.size() - 1;
                while (j >= 0) {
                    String ns = (String)childns.get(j);
                    if (!namespace.contains(ns)) {
                        namespace.add(ns);
                    }
                    --j;
                }
            }
            ++i;
        }
        String elemNS = elem.getPrefix();
        if (elemNS == null) {
            elemNS = "";
        }
        if (!namespace.contains(elemNS.intern())) {
            namespace.add(elemNS.intern());
        }
        if (!((localname = elem.getLocalName()).equals("import") || localname.equals("include") || localname.equals("schema"))) {
            NamedNodeMap atts = elem.getAttributes();
            int i2 = 0;
            while (i2 < atts.getLength()) {
                String nodeValue;
                int colonIndex;
                Node n = atts.item(i2);
                String nodeName = n.getNodeName();
                if (!(nodeName.indexOf("xmlns") != -1 || nodeName.equals("targetNamespace") || nodeName.equals("name") || (colonIndex = (nodeValue = n.getNodeValue()).indexOf(":")) == -1 || nodeValue.charAt(colonIndex + 1) == '/' || namespace.contains((nodeValue = nodeValue.substring(0, colonIndex)).intern()))) {
                    namespace.add(nodeValue.intern());
                }
                ++i2;
            }
        }
        return namespace;
    }

    protected List getImportNamespaces(Element elem) {
        Vector<String> namespace = new Vector<String>();
        NodeList childNodes = elem.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength() || i < 5) {
            Node n = childNodes.item(i);
            if (n instanceof Element) {
                Element child = (Element)n;
                List childns = this.getImportNamespaces(child);
                int j = childns.size() - 1;
                while (j >= 0) {
                    String ns = (String)childns.get(j);
                    if (!namespace.contains(ns)) {
                        namespace.add(ns);
                    }
                    --j;
                }
            }
            ++i;
        }
        if (elem.getLocalName().equalsIgnoreCase("import")) {
            NamedNodeMap atts = elem.getAttributes();
            int i2 = 0;
            while (i2 < atts.getLength()) {
                String nodeValue;
                Node n = atts.item(i2);
                String nodeName = n.getNodeName();
                if (nodeName.equalsIgnoreCase("namespace") && !namespace.contains((nodeValue = n.getNodeValue()).intern())) {
                    namespace.add(nodeValue.intern());
                }
                ++i2;
            }
        }
        return namespace;
    }

    protected Hashtable getNSResolver(Element elem) {
        Hashtable<String, String> nsResolver = new Hashtable<String, String>();
        NamedNodeMap atts = elem.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Node n = atts.item(i);
            String nodeName = n.getNodeName();
            if (nodeName.indexOf("xmlns") != -1) {
                String nodeValue = n.getNodeValue();
                String namePrefix = nodeName;
                namePrefix = namePrefix.equalsIgnoreCase("xmlns") ? "" : namePrefix.substring(6);
                nsResolver.put(namePrefix, nodeValue);
            }
            ++i;
        }
        return nsResolver;
    }

    protected Hashtable resolveNamespaces(List namespaces, Hashtable nsResolver, Hashtable parentNSResolver) {
        Hashtable reqNSDecl = new Hashtable();
        if (namespaces != null && !namespaces.isEmpty() && nsResolver != null) {
            int i = namespaces.size() - 1;
            while (i >= 0) {
                Object resolvedNS;
                String ns = (String)namespaces.get(i);
                namespaces.remove(i);
                if (nsResolver.containsKey(ns)) {
                    resolvedNS = nsResolver.get(ns);
                    if (!namespaces.contains(resolvedNS)) {
                        namespaces.add(i, nsResolver.get(ns));
                    }
                } else if (parentNSResolver.containsKey(ns = ns.equals("") ? "xmlns" : "xmlns:" + ns)) {
                    resolvedNS = parentNSResolver.get(ns);
                    if (!namespaces.contains(resolvedNS)) {
                        namespaces.add(i, resolvedNS);
                    }
                    reqNSDecl.put(ns, resolvedNS);
                }
                --i;
            }
        }
        return reqNSDecl;
    }

    protected List removeImports(List namespaces, List importedNamespaces) {
        if (namespaces != null && importedNamespaces != null && !importedNamespaces.isEmpty()) {
            for (String iNS : importedNamespaces) {
                namespaces.remove(iNS);
            }
        }
        return namespaces;
    }

    protected List removeLocalNamespaces(List namespaces, Element elem) {
        if (namespaces != null && elem != null) {
            String ns = elem.getAttribute("targetNamespace");
            namespaces.remove(ns);
            int i = this.ignoreNamespaces.length - 1;
            while (i >= 0) {
                if (namespaces.remove(this.ignoreNamespaces[i])) {
                    ++i;
                }
                --i;
            }
        }
        return namespaces;
    }

    protected boolean checkSOAPEncodingRequired(List reqns) {
        return reqns.contains("http://schemas.xmlsoap.org/soap/encoding/");
    }
}

