/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Element;

public class AP2940
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public AP2940(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            boolean swaRefFound = false;
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List ops = binding.getBindingOperations();
            int i = 0;
            while (i < ops.size()) {
                String unboundPart;
                List swaRefParts;
                BindingOperation bindingOperation = (BindingOperation)ops.get(i);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                Input portTypeInput = bindingOperation.getOperation().getInput();
                Output portTypeOutput = bindingOperation.getOperation().getOutput();
                if (portTypeInput != null && portTypeInput.getMessage() != null && !(swaRefParts = this.getSwaRefParts(portTypeInput.getMessage())).isEmpty()) {
                    swaRefFound = true;
                    unboundPart = this.getUnboundPart(swaRefParts, portTypeInput.getMessage().getQName(), bindingInput == null ? null : bindingInput.getExtensibilityElements());
                    if (unboundPart != null) {
                        throw new AssertionFailException("The part \"" + unboundPart + "\" is not bound properly to the wsdl:input of the \"" + bindingOperation.getName() + "\" binding operation.");
                    }
                }
                if (portTypeOutput != null && portTypeOutput.getMessage() != null && !(swaRefParts = this.getSwaRefParts(portTypeOutput.getMessage())).isEmpty()) {
                    swaRefFound = true;
                    unboundPart = this.getUnboundPart(swaRefParts, portTypeOutput.getMessage().getQName(), bindingOutput == null ? null : bindingOutput.getExtensibilityElements());
                    if (unboundPart != null) {
                        throw new AssertionFailException("The part \"" + unboundPart + "\" is not bound properly to the wsdl:input of the \"" + bindingOperation.getName() + "\" binding operation.");
                    }
                }
                ++i;
            }
            if (!swaRefFound) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "warning";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private String getUnboundPart(List swaRefParts, QName messageName, List extElems) {
        int i = 0;
        while (i < swaRefParts.size()) {
            String part = (String)swaRefParts.get(i);
            boolean boundProperly = false;
            if (extElems != null) {
                int j = 0;
                while (j < extElems.size() && !boundProperly) {
                    List mimeParts;
                    ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(j);
                    if (extElem.getElementType().equals(WSDL_MIME_MULTIPART) && (mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts()).size() > 0) {
                        List elems = ((MIMEPart)mimeParts.get(0)).getExtensibilityElements();
                        int k = 0;
                        while (k < elems.size()) {
                            ExtensibilityElement elem = (ExtensibilityElement)elems.get(k);
                            if (elem.getElementType().equals(WSDL_SOAP_BODY)) {
                                List pts = ((SOAPBody)elem).getParts();
                                if (pts == null || pts.contains(part)) {
                                    boundProperly = true;
                                    break;
                                }
                            } else if (elem.getElementType().equals(WSDL_SOAP_HEADER)) {
                                Object header;
                                if (elem instanceof SOAPHeader) {
                                    header = (SOAPHeader)elem;
                                    if (messageName.equals(header.getMessage()) && header.getPart() != null && header.getPart().equals(part)) {
                                        boundProperly = true;
                                        break;
                                    }
                                } else {
                                    header = ((UnknownExtensibilityElement)elem).getElement();
                                    if (this.referencesMessage((Element)header, messageName) && header.getAttribute("part").equals(part)) {
                                        boundProperly = true;
                                        break;
                                    }
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            if (!boundProperly) {
                return part;
            }
            ++i;
        }
        return null;
    }

    private boolean referencesMessage(Element elem, QName messageName) {
        String lp;
        String message = elem.getAttribute("message");
        int colonPos = message.indexOf(":");
        String ns = null;
        String string = lp = colonPos > -1 ? message.substring(colonPos + 1) : message;
        if (colonPos > -1) {
            ns = this.validator.wsdlDocument.getDefinitions().getNamespace(message.substring(0, colonPos));
        }
        return messageName.getLocalPart().equals(lp) && messageName.getNamespaceURI().equals(ns);
    }

    private List getSwaRefParts(Message message) {
        ArrayList<String> swaRefParts = new ArrayList<String>();
        for (Part part : message.getParts().values()) {
            int type;
            QName ref = part.getTypeName();
            if (ref != null) {
                type = 3;
            } else {
                ref = part.getElementName();
                if (ref == null) continue;
                type = 2;
            }
            Map schemas = this.validator.wsdlDocument.getSchemas();
            for (XSModel xsModel : schemas.values()) {
                XSTypeDefinition partType = null;
                if (type == 2) {
                    XSElementDeclaration elem = xsModel.getElementDeclaration(ref.getLocalPart(), ref.getNamespaceURI());
                    if (elem != null) {
                        partType = elem.getTypeDefinition();
                    }
                } else {
                    partType = xsModel.getTypeDefinition(ref.getLocalPart(), ref.getNamespaceURI());
                }
                if (!this.referencesSwaRef(partType, new ArrayList())) continue;
                swaRefParts.add(part.getName());
            }
        }
        return swaRefParts;
    }

    private boolean referencesSwaRef(XSTypeDefinition xsType, List types) {
        if (xsType != null && !types.contains(xsType)) {
            XSSimpleType xsSimpleType;
            types.add(xsType);
            if (xsType.getTypeCategory() == 15) {
                XSComplexTypeDefinition xsComplexType = (XSComplexTypeDefinition)xsType;
                if (xsComplexType.getParticle() != null && this.referencesSwaRef(xsComplexType.getParticle().getTerm(), types)) {
                    return true;
                }
                XSObjectList attrList = xsComplexType.getAttributeUses();
                int i = 0;
                while (i < attrList.getLength()) {
                    XSAttributeUse xsAttrUse = (XSAttributeUse)attrList.item(i);
                    if (this.referencesSwaRef((XSTypeDefinition)xsAttrUse.getAttrDeclaration().getTypeDefinition(), types)) {
                        return true;
                    }
                    ++i;
                }
            } else if (xsType.getTypeCategory() == 16 && (xsSimpleType = (XSSimpleType)xsType).getNamespace().equals("http://ws-i.org/profiles/basic/1.1/xsd") && xsSimpleType.getName().equals("swaRef")) {
                return true;
            }
        }
        return false;
    }

    private boolean referencesSwaRef(XSTerm term, List types) {
        if (term.getType() == 2) {
            if (this.referencesSwaRef(((XSElementDeclaration)term).getTypeDefinition(), types)) {
                return true;
            }
        } else if (term.getType() == 7) {
            XSObjectList list = ((XSModelGroup)term).getParticles();
            int i = 0;
            while (i < list.getLength()) {
                if (this.referencesSwaRef(((XSParticle)list.item(i)).getTerm(), types)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

