/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/language-service/src/types", ["require", "exports", "@angular/compiler", "@angular/compiler-cli/src/language_services"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var compiler_1 = require("@angular/compiler");
    exports.StaticSymbol = compiler_1.StaticSymbol;
    var language_services_1 = require("@angular/compiler-cli/src/language_services");
    exports.BuiltinType = language_services_1.BuiltinType;
    /**
     * The kind of diagnostic message.
     *
     * @publicApi
     */
    var DiagnosticKind;
    (function (DiagnosticKind) {
        DiagnosticKind[DiagnosticKind["Error"] = 0] = "Error";
        DiagnosticKind[DiagnosticKind["Warning"] = 1] = "Warning";
    })(DiagnosticKind = exports.DiagnosticKind || (exports.DiagnosticKind = {}));
    /**
     * The type of Angular directive. Used for QuickInfo in template.
     */
    var DirectiveKind;
    (function (DirectiveKind) {
        DirectiveKind["COMPONENT"] = "component";
        DirectiveKind["DIRECTIVE"] = "directive";
        DirectiveKind["EVENT"] = "event";
    })(DirectiveKind = exports.DirectiveKind || (exports.DirectiveKind = {}));
    /**
     * ScriptElementKind for completion.
     */
    var CompletionKind;
    (function (CompletionKind) {
        CompletionKind["ATTRIBUTE"] = "attribute";
        CompletionKind["COMPONENT"] = "component";
        CompletionKind["ELEMENT"] = "element";
        CompletionKind["ENTITY"] = "entity";
        CompletionKind["HTML_ATTRIBUTE"] = "html attribute";
        CompletionKind["KEY"] = "key";
        CompletionKind["METHOD"] = "method";
        CompletionKind["PIPE"] = "pipe";
        CompletionKind["PROPERTY"] = "property";
        CompletionKind["REFERENCE"] = "reference";
        CompletionKind["TYPE"] = "type";
        CompletionKind["VARIABLE"] = "variable";
    })(CompletionKind = exports.CompletionKind || (exports.CompletionKind = {}));
});
//# sourceMappingURL=data:application/json;base64,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