/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.aggregators;

import java.util.OptionalDouble;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.aggregators.AverageAccumulator;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;

public class DoubleAverageOperator
implements IMultisetAggregationOperator<Double, AverageAccumulator<Double>, Double> {
    public static final DoubleAverageOperator INSTANCE = new DoubleAverageOperator();

    private DoubleAverageOperator() {
    }

    @Override
    public String getShortDescription() {
        return "avg<Integer> incrementally computes the average of java.lang.Integer values";
    }

    @Override
    public String getName() {
        return "avg<Integer>";
    }

    @Override
    public AverageAccumulator<Double> createNeutral() {
        return new AverageAccumulator<Double>(0.0, 0L);
    }

    @Override
    public boolean isNeutral(AverageAccumulator<Double> result) {
        return result.count == 0L;
    }

    @Override
    public AverageAccumulator<Double> update(AverageAccumulator<Double> oldResult, Double updateValue, boolean isInsertion) {
        if (isInsertion) {
            oldResult.value = (Double)oldResult.value + updateValue;
            ++oldResult.count;
        } else {
            oldResult.value = (Double)oldResult.value - updateValue;
            --oldResult.count;
        }
        return oldResult;
    }

    @Override
    public Double getAggregate(AverageAccumulator<Double> result) {
        return result.count == 0L ? null : Double.valueOf((Double)result.value / (double)result.count);
    }

    @Override
    public Double aggregateStream(Stream<Double> stream) {
        OptionalDouble averageOpt = stream.mapToDouble(Double::doubleValue).average();
        return averageOpt.isPresent() ? Double.valueOf(averageOpt.getAsDouble()) : null;
    }
}

