/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.latency;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.SystemCallLatencyAnalysis;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfSourceLookup;

public final class SystemCall
implements INamedSegment,
ITmfSourceLookup {
    private static final long serialVersionUID = 1554494342105208730L;
    public static final IHTIntervalReader<ISegment> READER = buffer -> new SystemCall(buffer.getLong(), buffer.getLong(), buffer.getString(), buffer.getInt(), buffer.getInt());
    private final long fStartTime;
    private final long fEndTime;
    private final String fName;
    private final int fTid;
    private final int fRet;

    public SystemCall(InitialInfo info, long endTime, int ret) {
        this.fStartTime = info.fStartTime;
        this.fName = info.fName;
        this.fEndTime = endTime;
        this.fTid = info.fTid;
        this.fRet = ret;
    }

    private SystemCall(long startTime, long endTime, String name, int tid, int ret) {
        this.fStartTime = startTime;
        this.fEndTime = endTime;
        this.fName = name;
        this.fTid = tid;
        this.fRet = ret;
    }

    public long getStart() {
        return this.fStartTime;
    }

    public long getEnd() {
        return this.fEndTime;
    }

    public String getName() {
        return this.fName;
    }

    public int getTid() {
        return this.fTid;
    }

    public int getReturnValue() {
        return this.fRet;
    }

    public int getSizeOnDisk() {
        return 16 + SafeByteBufferFactory.getStringSizeInBuffer((String)this.fName) + 8;
    }

    public void writeSegment(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putLong(this.fStartTime);
        buffer.putLong(this.fEndTime);
        buffer.putString(this.fName);
        buffer.putInt(this.fTid);
        buffer.putInt(this.fRet);
    }

    public int compareTo(@NonNull ISegment o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return "Start Time = " + this.getStart() + "; End Time = " + this.getEnd() + "; Duration = " + this.getLength() + "; Name = " + this.getName();
    }

    public @Nullable ITmfCallsite getCallsite() {
        return (ITmfCallsite)SystemCallLatencyAnalysis.SyscallCallsiteAspect.INSTANCE.resolve((ISegment)this);
    }

    public static class InitialInfo {
        private long fStartTime;
        private String fName;
        private int fTid;

        public InitialInfo(long startTime, String name, int tid) {
            this.fStartTime = startTime;
            this.fName = name.intern();
            this.fTid = tid;
        }
    }
}

