/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.validation.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.metamodel.description.validation.operations.ValidationRuleOperations;
import org.eclipse.sirius.business.internal.metamodel.helper.ComponentizationHelper;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.tools.api.validation.constraint.RuleWrappingStatus;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.validation.ERROR_LEVEL;
import org.eclipse.sirius.viewpoint.description.validation.SemanticValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ValidationRule;
import org.eclipse.sirius.viewpoint.description.validation.ValidationSet;
import org.eclipse.sirius.viewpoint.description.validation.ViewValidationRule;

public abstract class AbstractDDiagramConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Collection<ValidationRule> failures;
        EObject objectToValidate = ctx.getTarget();
        EMFEventType typeEvenement = ctx.getEventType();
        if (typeEvenement == EMFEventType.NULL && (failures = this.getFailingRules(objectToValidate)).size() > 0) {
            MultiStatus parentStatus = new MultiStatus("org.eclipse.sirius", this.getHighestStatusCode(failures), Messages.AbstractDDiagramConstraint_validationErrorMessage, null);
            for (ValidationRule failedRule : failures) {
                EObject target = objectToValidate;
                if (failedRule instanceof SemanticValidationRule && objectToValidate instanceof DSemanticDecorator) {
                    target = ((DSemanticDecorator)objectToValidate).getTarget();
                }
                String message = ValidationRuleOperations.getMessage((ValidationRule)failedRule, (EObject)target);
                ConstraintStatus emfStatus = (ConstraintStatus)ctx.createFailureStatus(new Object[]{message});
                parentStatus.add((IStatus)new RuleWrappingStatus(emfStatus, failedRule));
            }
            return parentStatus;
        }
        return ctx.createSuccessStatus();
    }

    private int getHighestStatusCode(Collection<ValidationRule> rules) {
        int highestCode = 0;
        Iterator<ValidationRule> it = rules.iterator();
        while (it.hasNext() && highestCode < 4) {
            int currentCode = this.mapLevelToStatusCode(it.next().getLevel());
            if (currentCode <= highestCode) continue;
            highestCode = currentCode;
        }
        return highestCode;
    }

    private int mapLevelToStatusCode(ERROR_LEVEL level) {
        int code = 0;
        if (level == ERROR_LEVEL.ERROR_LITERAL) {
            code = 4;
        } else if (level == ERROR_LEVEL.WARNING_LITERAL) {
            code = 2;
        } else if (level == ERROR_LEVEL.INFO_LITERAL) {
            code = 1;
        }
        return code;
    }

    private Collection<ValidationRule> getFailingRules(EObject objectToValidate) {
        ArrayList<ValidationRule> failingRules = new ArrayList<ValidationRule>();
        DDiagram diagram = null;
        if (objectToValidate instanceof DDiagram) {
            diagram = (DDiagram)objectToValidate;
        } else if (objectToValidate instanceof DDiagramElement) {
            diagram = ((DDiagramElement)objectToValidate).getParentDiagram();
        }
        if (diagram != null && ((DSemanticDecorator)objectToValidate).getTarget() != null && ((DSemanticDecorator)objectToValidate).getTarget().eResource() != null) {
            Collection selectedVps = Session.of((EObject)objectToValidate).map(s -> s.getSelectedViewpoints(false)).orElseGet(() -> new ArrayList());
            if (diagram.getActivatedRules().size() > 0) {
                failingRules.addAll(this.getFailingRulesFromCollection(objectToValidate, diagram.getActivatedRules().iterator()));
            } else if (diagram.getDescription() != null) {
                DiagramDescription desc = diagram.getDescription();
                ValidationSet validationSet = desc.getValidationSet();
                if (validationSet != null) {
                    failingRules.addAll(this.getFailingRulesFromCollection(objectToValidate, validationSet.getAllRules().iterator()));
                }
                failingRules.addAll(this.getFailingRulesFromDiagramExtension(objectToValidate, desc, selectedVps));
            }
            failingRules.addAll(this.checkRulesFromActivatedViewpoints(objectToValidate, selectedVps));
        }
        return failingRules;
    }

    private Collection<ValidationRule> getFailingRulesFromDiagramExtension(EObject objectToValidate, DiagramDescription diagDescExtension, Collection<Viewpoint> viewpoints) {
        Collection failingRules = viewpoints.stream().flatMap(vp -> vp.getOwnedRepresentationExtensions().stream()).filter(DiagramExtensionDescription.class::isInstance).filter(ext -> ComponentizationHelper.match((RepresentationDescription)diagDescExtension, (RepresentationExtensionDescription)ext)).map(ext -> ((DiagramExtensionDescription)ext).getValidationSet()).filter(Objects::nonNull).flatMap(vs -> this.getFailingRulesFromCollection(objectToValidate, vs.getAllRules().iterator()).stream()).collect(Collectors.toList());
        return failingRules;
    }

    private Collection<ValidationRule> checkRulesFromActivatedViewpoints(EObject objectToValidate, Collection<Viewpoint> selectedVps) {
        return selectedVps.stream().map(vp -> vp.getValidationSet()).filter(Objects::nonNull).flatMap(vs -> this.getFailingRulesFromCollection(objectToValidate, vs.getAllRules().iterator()).stream()).collect(Collectors.toList());
    }

    private Collection<ValidationRule> getFailingRulesFromCollection(EObject objectToValidate, Iterator<ValidationRule> it) {
        ArrayList<ValidationRule> failingRules = new ArrayList<ValidationRule>();
        while (it.hasNext()) {
            DiagramElementMapping objMapping;
            boolean checkRule;
            ValidationRule rule = it.next();
            if (!this.isValid(rule)) continue;
            if (objectToValidate instanceof DSemanticDecorator && rule instanceof SemanticValidationRule && ((SemanticValidationRule)rule).getTargetClass() != null && !StringUtil.isEmpty((String)((SemanticValidationRule)rule).getTargetClass().trim())) {
                EObject semanticTargetElement = ((DSemanticDecorator)objectToValidate).getTarget();
                if (!this.isSemanticElementToValidate(objectToValidate, semanticTargetElement, ((SemanticValidationRule)rule).getTargetClass()) || (checkRule = ValidationRuleOperations.checkRule((ValidationRule)rule, (EObject)semanticTargetElement))) continue;
                failingRules.add(rule);
                continue;
            }
            if (!(objectToValidate instanceof DDiagramElement) || !(rule instanceof ViewValidationRule) || (objMapping = ((DDiagramElement)objectToValidate).getDiagramElementMapping()) == null || !((ViewValidationRule)rule).getTargets().contains((Object)objMapping) || (checkRule = ValidationRuleOperations.checkRule((ValidationRule)rule, (EObject)objectToValidate))) continue;
            failingRules.add(rule);
        }
        return failingRules;
    }

    private boolean isSemanticElementToValidate(EObject objectToValidate, EObject semanticElement, String expectedClass) {
        boolean result = false;
        if (SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semanticElement).eInstanceOf(semanticElement, expectedClass)) {
            if (objectToValidate instanceof DEdge) {
                if (((DEdge)objectToValidate).getSourceNode() instanceof DSemanticDecorator && !semanticElement.equals(((DSemanticDecorator)((DEdge)objectToValidate).getSourceNode()).getTarget())) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    protected abstract boolean isValid(ValidationRule var1);
}

