/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import java.util.ArrayList;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFormatException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeFunction;
import org.eclipse.ptp.internal.debug.core.pdi.aif.AIFType;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class AIFTypeFunction
extends AIFType
implements IAIFTypeFunction {
    private IAIFType[] fArgTypes;
    private IAIFType fReturnType;
    private int fSize = 0;

    @Override
    public IAIFType[] getArgumentTypes() {
        return this.fArgTypes;
    }

    @Override
    public IAIFType getReturnType() {
        return this.fReturnType;
    }

    @Override
    public String parse(String fmt) throws AIFFormatException {
        ArrayList<IAIFType> argTypes = new ArrayList<IAIFType>();
        int pos = fmt.indexOf(47);
        if (pos > 0) {
            String[] args;
            String argsStr = fmt.substring(0, pos);
            String[] stringArray = args = argsStr.split(String.valueOf(','));
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                AIFFactory.parseType(arg);
                argTypes.add(AIFFactory.getType());
                ++n2;
            }
        }
        this.fArgTypes = argTypes.toArray(new IAIFType[0]);
        String res = AIFFactory.parseType(fmt.substring(pos + 1));
        this.fReturnType = AIFFactory.getType();
        return res;
    }

    public void setSizeof(int size) {
        this.fSize = size;
    }

    @Override
    public int sizeof() {
        return this.fSize;
    }

    public String toString() {
        String content = String.valueOf('&');
        int i = 0;
        while (i < this.fArgTypes.length) {
            content = String.valueOf(content) + this.fArgTypes[i].toString();
            if (i < this.fArgTypes.length - 1) {
                content = String.valueOf(content) + ',';
            }
            ++i;
        }
        return String.valueOf(content) + '/' + this.getReturnType().toString();
    }
}

