/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.libfolders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.php.internal.core.libfolders.AutoDetectLibraryFolderJob;
import org.eclipse.php.internal.core.libfolders.OpenedAndChangedProjectsFinder;

public class AutoDetectLibraryFolderListener
implements IResourceChangeListener {
    private final Set<IProject> suspendedProjects = Collections.synchronizedSet(new HashSet());
    private boolean suspendDetection = false;

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.suspendDetection) {
            return;
        }
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        IProject[] projects = new OpenedAndChangedProjectsFinder(delta).getFoundProjects();
        if (projects.length == 0) {
            return;
        }
        if ((projects = this.filterSuspended(projects)).length == 0) {
            return;
        }
        new AutoDetectLibraryFolderJob(projects).schedule();
    }

    public void suspendDetection(IProject project, boolean suspend) {
        if (suspend) {
            this.suspendedProjects.add(project);
        } else {
            this.suspendedProjects.remove(project);
        }
    }

    public void suspendAllDetection(boolean suspend) {
        this.suspendDetection = suspend;
    }

    private IProject[] filterSuspended(IProject[] projects) {
        ArrayList<IProject> filtered = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (!this.suspendedProjects.contains(projects[i])) {
                filtered.add(projects[i]);
            }
            ++i;
        }
        return filtered.toArray(new IProject[filtered.size()]);
    }
}

