/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.codeassist.CompletionCompanion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionContextResolver;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.CompletionRequestorExtension;
import org.eclipse.php.internal.core.codeassist.contexts.ArrayKeyContext;
import org.eclipse.php.internal.core.codeassist.contexts.CatchTypeContext;
import org.eclipse.php.internal.core.codeassist.contexts.CatchVariableContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassDeclarationKeywordContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassExtendsContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassImplementsContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassInstantiationContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassObjMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassStaticMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.ExceptionClassInstantiationContext;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionParameterTypeContext;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionParameterValueContext;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionParameterVariableContext;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionReturnTypeContext;
import org.eclipse.php.internal.core.codeassist.contexts.GlobalMethodStatementContext;
import org.eclipse.php.internal.core.codeassist.contexts.GlobalStatementContext;
import org.eclipse.php.internal.core.codeassist.contexts.GotoStatementContext;
import org.eclipse.php.internal.core.codeassist.contexts.IncludeStatementContext;
import org.eclipse.php.internal.core.codeassist.contexts.InstanceOfContext;
import org.eclipse.php.internal.core.codeassist.contexts.InterfaceDeclarationKeywordContext;
import org.eclipse.php.internal.core.codeassist.contexts.InterfaceExtendsContext;
import org.eclipse.php.internal.core.codeassist.contexts.MethodNameContext;
import org.eclipse.php.internal.core.codeassist.contexts.NamespaceDeclContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocMagicTagsContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocParamTagContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocReturnTagContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocTagInnerContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocTagStartContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocThrowsStartContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocVarTagContext;
import org.eclipse.php.internal.core.codeassist.contexts.PHPVarCommentContext;
import org.eclipse.php.internal.core.codeassist.contexts.QuotesContext;
import org.eclipse.php.internal.core.codeassist.contexts.TypeCastingContext;
import org.eclipse.php.internal.core.codeassist.contexts.TypeStatementContext;
import org.eclipse.php.internal.core.codeassist.contexts.UseAliasContext;
import org.eclipse.php.internal.core.codeassist.contexts.UseConstNameContext;
import org.eclipse.php.internal.core.codeassist.contexts.UseFunctionNameContext;
import org.eclipse.php.internal.core.codeassist.contexts.UseNameContext;

public class CompletionContextResolver
implements ICompletionContextResolver {
    private static ICompletionContextResolver[] instances;

    public static ICompletionContextResolver[] getActive() {
        if (instances == null) {
            IConfigurationElement[] elements;
            LinkedList<ICompletionContextResolver> resolvers = new LinkedList<ICompletionContextResolver>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core.completionContextResolvers");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("resolver")) {
                    try {
                        resolvers.add((ICompletionContextResolver)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        PHPCorePlugin.log(e);
                    }
                }
                ++n2;
            }
            resolvers.add(new CompletionContextResolver());
            instances = resolvers.toArray(new ICompletionContextResolver[resolvers.size()]);
        }
        return instances;
    }

    @Override
    public ICompletionContext[] createContexts() {
        return new ICompletionContext[]{new PHPDocTagStartContext(), new PHPDocThrowsStartContext(), new PHPDocParamTagContext(), new PHPDocVarTagContext(), new PHPVarCommentContext(), new PHPDocReturnTagContext(), new PHPDocMagicTagsContext(), new PHPDocTagInnerContext(), new ArrayKeyContext(), new CatchTypeContext(), new CatchVariableContext(), new ClassDeclarationKeywordContext(), new ClassExtendsContext(), new ClassImplementsContext(), new ClassInstantiationContext(), new ClassObjMemberContext(), new TypeStatementContext(), new ClassStaticMemberContext(), new FunctionParameterTypeContext(), new FunctionReturnTypeContext(), new FunctionParameterValueContext(), new FunctionParameterVariableContext(), new MethodNameContext(), new GlobalStatementContext(), new GlobalMethodStatementContext(), new InstanceOfContext(), new InterfaceExtendsContext(), new InterfaceDeclarationKeywordContext(), new UseAliasContext(), new UseNameContext(), new UseConstNameContext(), new UseFunctionNameContext(), new GotoStatementContext(), new NamespaceDeclContext(), new IncludeStatementContext(), new ExceptionClassInstantiationContext(), new TypeCastingContext(), new QuotesContext()};
    }

    @Override
    public ICompletionContext[] resolve(ISourceModule sourceModule, int offset, CompletionRequestor requestor, CompletionCompanion companion) {
        LinkedList<ICompletionContext> result = new LinkedList<ICompletionContext>();
        ICompletionContext[] contexts = requestor instanceof CompletionRequestorExtension ? ((CompletionRequestorExtension)requestor).createContexts() : this.createContexts();
        ICompletionContext[] iCompletionContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionContext context = iCompletionContextArray[n2];
            context.init(companion);
            try {
                if (context.isValid(sourceModule, offset, requestor)) {
                    result.add(context);
                }
            }
            catch (Exception e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        if (result.size() > 1) {
            LinkedList<ICompletionContext> filteredResult = new LinkedList<ICompletionContext>();
            for (ICompletionContext context : result) {
                if (context.isExclusive()) continue;
                filteredResult.add(context);
            }
            result = filteredResult;
        }
        return result.toArray(new ICompletionContext[result.size()]);
    }
}

