/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.RegionEditPart;

public class CustomRegionResizableEditPolicy
extends ResizableEditPolicy {
    private ChangeBoundsRequest request;
    private boolean changeReferentFigure = false;

    protected List<?> createSelectionHandles() {
        ArrayList list = new ArrayList();
        int dirs = this.getResizeDirections();
        if (dirs > 0) {
            if ((dirs & 0x10) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)16);
            }
            if ((dirs & 4) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)4);
            }
            if ((dirs & 8) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)8);
            }
            if ((dirs & 1) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)1);
            }
        }
        return list;
    }

    protected Rectangle getInitialFeedbackBounds() {
        Dimension sizeDelta = this.request.getSizeDelta();
        this.changeReferentFigure = false;
        if (sizeDelta.width == 0 && sizeDelta.height == 0) {
            return super.getInitialFeedbackBounds();
        }
        int direction = this.request.getResizeDirection();
        RegionEditPart regionEP = (RegionEditPart)this.getHost();
        View region = (View)regionEP.getModel();
        List<Object> nodes = new ArrayList();
        if (direction == 1) {
            nodes = Zone.getRegionTopBorderInsideNeighbours(region);
        } else if (direction == 4) {
            nodes = Zone.getRegionBottomBorderInsideNeighbours(region);
        } else if (direction == 16) {
            nodes = Zone.getRegionRightBorderInsideNeighbours(region);
        } else if (direction == 8) {
            nodes = Zone.getRegionLeftBorderInsideNeighbours(region);
        }
        Rectangle rect = null;
        for (View view : nodes) {
            Rectangle currentBounds = Zone.getBounds(view);
            rect = rect == null ? currentBounds : rect.union(currentBounds);
        }
        return rect;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.request = request;
        IFigure feedback = this.getDragSourceFeedbackFigure();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        if (!this.changeReferentFigure) {
            this.getHostFigure().translateToAbsolute((Translatable)rect);
        }
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds((Rectangle)rect);
    }

    public void showSourceFeedback(Request request) {
        if ("resize".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }
}

