/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.drivers.emf4atl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.m2m.atl.common.ATL.ATLPackage;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.common.ATLResourceProvider;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModelElement;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.osgi.framework.Bundle;

public class EMFModelLoader
extends ModelLoader {
    protected static Bundle bundle = Platform.getBundle((String)"org.eclipse.m2m.atl.drivers.emf4atl");
    protected static URI mofURI = EcorePackage.eINSTANCE.eResource().getURI();
    protected static ASMModel atlmm;
    private static int instanceCount;
    protected ResourceSet resourceSet;
    protected Map bimm = new HashMap();
    protected boolean useIDs;
    protected boolean removeIDs;
    protected String encoding = "ISO-8859-1";
    protected Map saveOptions = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public EMFModelLoader() {
        IExtensionPoint point;
        IExtensionRegistry registry;
        this.resourceSet = new ResourceSetImpl();
        Map loadOptions = this.resourceSet.getLoadOptions();
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.m2m.atl.engine.injectors.xml.XMLInjector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addInjector("xml", clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.m2m.atl.drivers.emf4atl.tcs.injector.TCSInjector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addInjector("ebnf2", clazz2);
        if (Platform.isRunning() && (registry = Platform.getExtensionRegistry()) != null && (point = registry.getExtensionPoint("org.eclipse.m2m.atl.engine.vm.injector")) != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        this.addInjector(elements[j].getAttribute("name"), elements[j].createExecutableExtension("class").getClass());
                    }
                    catch (CoreException e) {
                        ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.saveOptions.put("ENCODING", this.encoding);
        ATLLogger.fine((String)((Object)((Object)this) + " created (" + ++instanceCount + ")"));
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public ASMModel getMOF() {
        return ASMEMFModel.getMOF();
    }

    public ASMModel getATL() {
        if (atlmm == null) {
            atlmm = this.createASMEMFModel("ATL", ATLPackage.eINSTANCE.eResource(), this.getMOF(), true);
        }
        return atlmm;
    }

    protected ASMEMFModel createASMEMFModel(String name, Resource extent, ASMModel metamodel, boolean isTarget) {
        return new ASMEMFModel(name, extent, (ASMEMFModel)metamodel, isTarget, this);
    }

    public ASMModel loadModel(String name, ASMModel metamodel, InputStream in) throws IOException {
        ASMEMFModel ret = null;
        Resource extent = this.resourceSet.createResource(URI.createURI((String)name));
        extent.load(in, this.resourceSet.getLoadOptions());
        ret = this.createASMEMFModel(name, extent, metamodel, true);
        this.adaptMetamodel(ret, (ASMEMFModel)metamodel);
        ret.setIsTarget(false);
        this.loadedModels.put(name, ret);
        return ret;
    }

    public ASMEMFModel loadModel(String name, ASMModel metamodel, URI uri) throws IOException {
        ASMEMFModel ret = null;
        if (mofURI.equals(uri)) {
            ret = (ASMEMFModel)this.getMOF();
        } else {
            Resource extent = this.resourceSet.getResource(uri, true);
            ret = this.createASMEMFModel(name, extent, metamodel, true);
            this.adaptMetamodel(ret, (ASMEMFModel)metamodel);
            ret.setIsTarget(false);
        }
        this.loadedModels.put(name, ret);
        return ret;
    }

    protected ASMModel realLoadModel(String name, ASMModel metamodel, String href) {
        ASMEMFModel ret = null;
        try {
            if (href.startsWith("uri:")) {
                String uri = href.substring(4);
                if (mofURI.toString().equals(uri)) {
                    ret = (ASMEMFModel)this.getMOF();
                } else {
                    ret = this.createASMEMFModel(name, null, metamodel, false);
                    ret.resolveURI = uri;
                }
            } else {
                ret = this.loadModel(name, metamodel, URI.createURI((String)href));
            }
        }
        catch (Exception e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return ret;
    }

    public ASMModel newModel(String name, ASMModel metamodel) {
        return this.newModel(name, name, metamodel);
    }

    public ASMModel newModel(String name, String uri, ASMModel metamodel) {
        ASMEMFModel ret = null;
        Resource extent = this.resourceSet.createResource(URI.createURI((String)uri));
        ret = this.createASMEMFModel(name, extent, metamodel, true);
        this.loadedModels.put(name, ret);
        return ret;
    }

    public ASMModel getBuiltInMetaModel(String name) {
        ASMModel ret = (ASMModel)this.bimm.get(name);
        if (ret == null) {
            URL resource = ATLResourceProvider.getURL((String)name);
            try {
                ret = this.loadModel(name, this.getMOF(), resource.openStream());
            }
            catch (IOException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            this.bimm.put(name, ret);
        }
        this.loadedModels.put(name, ret);
        return ret;
    }

    protected void setParameter(String name, Object value) {
        if ("useIDs".equals(name)) {
            if ("true".equals(value)) {
                this.useIDs = true;
            } else if ("false".equals(value)) {
                this.useIDs = false;
            }
        } else if ("removeIDs".equals(name)) {
            if ("true".equals(value)) {
                this.removeIDs = true;
            } else if ("false".equals(value)) {
                this.removeIDs = false;
            }
        } else if ("encoding".equals(name)) {
            this.encoding = (String)value;
        }
    }

    protected void realSave(ASMModel model, String href) throws IOException {
        Resource r = ((ASMEMFModel)model).getExtent();
        if (href != null) {
            r.setURI(URI.createURI((String)href));
        }
        if (this.useIDs || this.removeIDs) {
            XMIResource xr = (XMIResource)r;
            int id = 1;
            HashSet<EObject> alreadySet = new HashSet<EObject>();
            TreeIterator i = r.getAllContents();
            while (i.hasNext()) {
                EObject eo = (EObject)i.next();
                if (alreadySet.contains(eo)) continue;
                xr.setID(eo, this.removeIDs ? null : "a" + id++);
                alreadySet.add(eo);
            }
        }
        r.save(this.saveOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adaptMetamodel(ASMEMFModel model, ASMEMFModel metamodel) throws IOException {
        ASMModel mofmm = model.getModelLoader().getMOF();
        if (metamodel == mofmm) {
            ASMEMFModelElement ame;
            Iterator i = model.getAllElementsByType("EPackage").iterator();
            while (i.hasNext()) {
                ame = (ASMEMFModelElement)((Object)i.next());
                EPackage p = (EPackage)ame.getObject();
                String nsURI = p.getNsURI();
                if (nsURI == null) {
                    nsURI = p.getName();
                    p.setNsURI(nsURI);
                } else if (mofURI.toString().equals(nsURI) && !((ASMEMFModel)this.getMOF()).getExtent().equals(p.eResource())) {
                    ATLLogger.warning((String)"Cannot overload Ecore");
                }
                ResourceSet resourceSet = this.resourceSet;
                synchronized (resourceSet) {
                    this.resourceSet.getPackageRegistry().put((Object)nsURI, (Object)p);
                }
            }
            i = model.getAllElementsByType("EDataType").iterator();
            while (i.hasNext()) {
                ame = (ASMEMFModelElement)((Object)i.next());
                String tname = ((ASMString)ame.get(null, "name")).getSymbol();
                ASMOclAny icnObject = ame.get(null, "instanceClassName");
                if (icnObject instanceof ASMString) continue;
                String icn = null;
                if (tname.equals("Boolean")) {
                    icn = "boolean";
                } else if (tname.equals("Double") || tname.equals("Real")) {
                    icn = "java.lang.Double";
                } else if (tname.equals("Float")) {
                    icn = "java.lang.Float";
                } else if (tname.equals("Integer")) {
                    icn = "java.lang.Integer";
                } else if (tname.equals("String")) {
                    icn = "java.lang.String";
                }
                if (icn == null) continue;
                ame.set(null, "instanceClassName", (ASMOclAny)new ASMString(icn));
            }
        }
    }

    protected void finalize() throws Throwable {
        ATLLogger.fine((String)((Object)((Object)this) + " is being collected (" + --instanceCount + ") : " + EMFModelLoader.resourceSetToString(this.resourceSet)));
        Iterator it = this.resourceSet.getResources().iterator();
        while (it.hasNext()) {
            Resource r = (Resource)it.next();
            it.remove();
            this.finalizeResource(r);
            ATLLogger.fine((String)(r + " is removed"));
        }
        super.finalize();
    }

    protected void finalizeResource(Resource r) {
    }

    private static String resourceSetToString(ResourceSet rs) {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator i = rs.getResources().iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            ret.add(r.getURI().lastSegment());
        }
        return ((Object)ret).toString();
    }

    public void unload(ASMModel model) {
        if (model instanceof ASMEMFModel) {
            ASMEMFModel emfmodel = (ASMEMFModel)model;
            Resource r = emfmodel.getExtent();
            EList rs = this.getResourceSet().getResources();
            if (rs.contains((Object)r)) {
                this.loadedModels.remove(model.getName());
                rs.remove((Object)r);
                this.finalizeResource(r);
            }
        }
    }
}

