import { Position, SignatureHelp } from 'vscode-languageserver-types';
export declare class DockerSignatures {
    private documentation;
    computeSignatures(content: string, position: Position): SignatureHelp;
    private getInstructionSignatures(document, instructions, position);
    private getFromSignatureHelp(position, from);
    private getFromSignatures(fromSignatures, tag, digest, stagesOnly);
    private getFromActiveParameter(position, from, tag, digest, args);
    private getJSONInstructionSignatureHelp(document, instruction, position, jsonSignatures, shellSignature, hasFlags, jsonFirst, singleParameter, finalRepeats);
    private getJSONSignatureActiveParameter(document, instruction, position, hasFlags, singleParameter, finalRepeats);
    private getSignatureActiveParameter(instruction, position, hasFlags, max, finalRepeats);
    private getPropertySignatureHelp(document, position, signatures, properties);
    private getPropertySignatures(document, position, signatures, properties);
    private getPropertySignatureActiveParameter(document, position, properties);
    private static isInName(property, position);
    private static isNameBefore(property, position);
    private static isInValue(property, position);
    private static isValueBefore(property, position);
}
