/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.figures.core;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.figures.IImageFactory;
import org.eclipse.jwt.we.figures.core.ModelElementFigure;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.swt.graphics.Image;

public class NamedElementFigure
extends ModelElementFigure {
    private static final Logger logger = Logger.getLogger(NamedElementFigure.class);
    private Label label;
    private IImageFactory imageFactory;

    public NamedElementFigure() {
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.setLabel(this.createLabel());
    }

    public NamedElementFigure(Label label) {
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.setLabel(label);
    }

    public void setName(String name) {
        if (this.label != null) {
            this.label.setText(name);
        }
    }

    public IImageFactory getImageFactory() {
        return this.imageFactory;
    }

    public void setImageFactory(IImageFactory imageFactory) {
        this.imageFactory = imageFactory;
    }

    public Dimension getPreferredIconSize() {
        return PreferenceReader.appearanceFigureIconSize.get();
    }

    public void setIcon(ImageDescriptor icon) {
        if (icon == null) {
            this.setIcon((Image)null);
            return;
        }
        if (this.imageFactory != null) {
            this.setIcon(this.imageFactory.getImage(icon, this.getPreferredIconSize()));
        } else {
            logger.debugWarning("imageFactory is null, no image is created.");
        }
    }

    public void setIcon(Image icon) {
    }

    protected Label createLabel() {
        Label newLabel = new Label();
        newLabel.setLabelAlignment(2);
        newLabel.setForegroundColor(PreferenceReader.appearanceTextColor.get());
        return newLabel;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label newLabel) {
        if (this.label != null) {
            this.remove((IFigure)this.label);
        }
        this.label = newLabel;
        if (this.label != null) {
            this.add((IFigure)this.label);
        }
    }

    public Rectangle getCellEditorArea() {
        return this.getClientArea();
    }
}

