/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the TextInputComponentActionHandler component from the concrete toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2019-11-26T06:47:23.002Z")
public interface TextInputComponentActionHandler extends org.eclipse.jubula.toolkit.base.components.handler.TextInputComponentActionHandler {
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param index 
         *        the index
         * 
         */
        public Result insertTextAfterIndex(
            @Nullable String text,
            @Nullable Integer index
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param pattern 
         *        the pattern to use
         * @param operator 
         *        the operator used for comparison
         * @param insertAfterPattern 
         *        insert after pattern
         * 
         */
        public Result insertTextBeforeAfterPattern(
            @Nullable String text,
            @Nullable String pattern,
            @Nullable Operator operator,
            @Nullable Boolean insertAfterPattern
        ) ;
        
        /**
         * 
         * 
         */
        public Result selectAll(
        ) ;
        
        /**
         * 
         * @param pattern 
         *        the pattern to use
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result selectPattern(
            @Nullable String pattern,
            @Nullable Operator operator
        ) ;
        
} 