/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epp.internal.logging.aeri.ide.IIdeFactory;
import org.eclipse.epp.internal.logging.aeri.ide.IIdePackage;
import org.eclipse.epp.internal.logging.aeri.ide.IInternalInput;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.ProblemStatusDialog;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.ReportPreview;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.UI;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.UIUtils;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.processors.AnonymizeMessagesProcessor;
import org.eclipse.epp.internal.logging.aeri.ide.processors.AnonymizeStackTracesProcessor;
import org.eclipse.epp.internal.logging.aeri.ide.processors.Processors;
import org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper;
import org.eclipse.epp.internal.logging.aeri.ide.processors.StepsToReproduceProcessor;
import org.eclipse.epp.internal.logging.aeri.ide.util.IdeSwitch;
import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.Severity;
import org.eclipse.epp.logging.aeri.ide.processors.IEditableReportProcessor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class ReviewDialog
extends MessageDialog {
    public static final String CTX_STATE_REVIEW_IN_PROGRESS = "org.eclipse.epp.logging.aeri.ide.di.review-in-progress";
    private static final int DEFAULT_DIALOG_WIDTH = 600;
    private static final int DEFAULT_DIALOG_HEIGHT = 320;
    private SashForm reportsAndDetailsSash;
    private TableViewer reportsViewer;
    private SashForm commentAndPreviewSash;
    private ComboViewer severity;
    private StyledText comments;
    private Composite previewArea;
    private ReportPreview preview;
    private Composite detailsArea;
    private ExpandableComposite previewTwistie;
    private ToolBar processorsBar;
    private ExpandableComposite commentTwistie;
    private ShowPreviewListener showPreviewListener;
    private IEclipseContext context;
    private IEventBroker broker;
    private ImageRegistry registry;
    @Nullable
    private ILogEventGroup active;
    private ILogEventsQueue queue;
    private DataBindingContext dbContext;
    private IViewerObservableValue selectedLogEvent;
    private IObservableList<ILogEvent> events;
    private IncomingEventsCopier incomingEventsCopier;
    private UISynchronize uiSynchronize;
    private List<IProcessorDescriptor> reportProcessorDescriptors;
    private Map<String, String> directivesToReadable;

    @Inject
    public ReviewDialog(@Active @Optional ILogEventGroup active, ILogEventsQueue queue, ImageRegistry registry, @Named(value="activeShell") @Optional Shell parentShell, UISynchronize uiSynchronize, IEclipseContext context, IEventBroker broker, @Named(value="org.eclipse.epp.logging.aeri.ide.processors") List<IProcessorDescriptor> descriptors) {
        super(parentShell, Messages.DIALOG_TITLE_REVIEW, null, MessageFormat.format("Eclipse encountered {0,choice,1#an error|1<{0,number,integer} errors}. Errors may reveal severe issues in the code and thus we kindly ask you to send them to the affected projects.", queue.getGroups().size()), 4, new String[]{Messages.BUTTON_TEXT_SEND, Messages.BUTTON_TEXT_DONT_SEND}, 0);
        this.active = active;
        this.queue = queue;
        this.uiSynchronize = uiSynchronize;
        this.reportProcessorDescriptors = Lists.newArrayList(descriptors);
        this.sortProcessorDescriptors();
        this.directivesToReadable = descriptors.stream().collect(Collectors.toMap(IProcessorDescriptor::getDirective, IProcessorDescriptor::getName));
        this.registry = (ImageRegistry)Preconditions.checkNotNull((Object)registry);
        this.context = context;
        this.broker = broker;
        this.setShellStyle(3184);
        this.setBlockOnOpen(false);
        this.setupObservableList();
        context.modify(CTX_STATE_REVIEW_IN_PROGRESS, (Object)true);
    }

    protected void sortProcessorDescriptors() {
        Comparator<IProcessorDescriptor> comparator = Comparator.comparing(IProcessorDescriptor::getProcessor, (a, b) -> a.getWrapped() instanceof AnonymizeStackTracesProcessor ? 1 : (b.getWrapped() instanceof AnonymizeStackTracesProcessor ? -1 : 0)).thenComparing(IProcessorDescriptor::getProcessor, (a, b) -> a.getWrapped() instanceof AnonymizeMessagesProcessor ? 1 : (b.getWrapped() instanceof AnonymizeMessagesProcessor ? -1 : 0)).thenComparing(IProcessorDescriptor::getProcessor, (a, b) -> a.getWrapped() instanceof StepsToReproduceProcessor ? 1 : (b.getWrapped() instanceof StepsToReproduceProcessor ? -1 : 0)).thenComparing(IProcessorDescriptor::getName, Comparator.naturalOrder());
        Collections.sort(this.reportProcessorDescriptors, comparator);
    }

    private void setupObservableList() {
        IInternalInput input = IIdeFactory.eINSTANCE.createInternalInput();
        this.events = EMFProperties.list((EStructuralFeature)IIdePackage.Literals.INTERNAL_INPUT__INPUT).observe((Object)input);
        for (ILogEventGroup group : this.queue.getGroups()) {
            input.getInput().addAll(group.getEvents());
        }
        this.incomingEventsCopier = new IncomingEventsCopier(input);
        this.queue.eAdapters().add((Object)this.incomingEventsCopier);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(600, 320);
    }

    public void create() {
        super.create();
    }

    protected boolean customShouldTakeFocus() {
        return false;
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        Composite messageLink = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)messageLink);
        messageLink.setLayout((Layout)new GridLayout());
        Control processLink = this.createMessage(messageLink);
        if (processLink != null) {
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo(processLink);
        }
        return composite;
    }

    public Composite createCustomArea(Composite parent) {
        EList<ILogEvent> events;
        this.createReportsAndDetailsSash(parent);
        this.createReportsViewer((Composite)this.reportsAndDetailsSash);
        this.createDetailsArea((Composite)this.reportsAndDetailsSash);
        this.reportsAndDetailsSash.setWeights(new int[]{1, 3});
        this.createPreferencesLink(parent);
        this.createDatabindings();
        if (this.active != null && !(events = this.active.getEvents()).isEmpty()) {
            ILogEvent event = (ILogEvent)events.get(0);
            this.selectedLogEvent.setValue((Object)event);
        }
        return this.reportsAndDetailsSash;
    }

    @Nullable
    private Control createMessage(Composite parent) {
        ArrayListMultimap eventsByRequestedProcessors = ArrayListMultimap.create();
        HashSet interestedServers = Sets.newHashSet();
        for (ILogEventGroup group : this.queue.getGroups()) {
            for (ILogEvent event : group.getEvents()) {
                this.reportProcessorDescriptors.stream().filter(descriptor -> Processors.shouldProcess(descriptor, event)).forEach(arg_0 -> ReviewDialog.lambda$10((Multimap)eventsByRequestedProcessors, event, interestedServers, arg_0));
            }
        }
        Label additionalInformationRequestedMessage = new Label(parent, 64);
        if (!eventsByRequestedProcessors.isEmpty()) {
            int countEvents = Sets.newHashSet((Iterable)eventsByRequestedProcessors.values()).size();
            this.message = String.valueOf(this.message) + MessageFormat.format(" {0,choice,1#One project|1<{0,number,integer} projects} requested additional information for {1,choice,1#this error|1<{1,number,integer} errors}. Please provide the requested information to {1,choice,1#this report|1<the highlighted reports}.", interestedServers.size(), countEvents);
        }
        additionalInformationRequestedMessage.setText(this.message);
        return additionalInformationRequestedMessage;
    }

    private void createDetailsArea(Composite parent) {
        this.detailsArea = new Composite((Composite)this.reportsAndDetailsSash, 0);
        this.commentTwistie = new ExpandableComposite(this.detailsArea, 0);
        this.commentTwistie.setText(Messages.TWISTIE_TEXT_COMMENT);
        this.commentTwistie.setExpanded(true);
        this.commentTwistie.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    ReviewDialog.this.commentAndPreviewSash.setMaximizedControl(null);
                } else {
                    ReviewDialog.this.commentAndPreviewSash.setMaximizedControl((Control)ReviewDialog.this.previewArea);
                    if (!ReviewDialog.this.previewTwistie.isExpanded()) {
                        ReviewDialog.this.previewTwistie.setExpanded(true);
                        ReviewDialog.this.showPreviewListener.showPreview();
                    }
                }
            }
        });
        this.severity = new ComboViewer(this.detailsArea);
        this.severity.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.severity.setInput((Object)Severity.VALUES);
        this.severity.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element == Severity.UNKNOWN ? Messages.COMBO_TEXT_SEVERITY_UNKNOWN : StringUtils.capitalize((String)StringUtils.lowerCase((String)StringUtils.replaceChars((String)element.toString(), (char)'_', (char)' ')));
            }
        });
        this.commentAndPreviewSash = new SashForm(this.detailsArea, 512);
        this.commentAndPreviewSash.setSashWidth(10);
        this.createCommentArea((Composite)this.commentAndPreviewSash);
        this.createPreviewArea((Composite)this.commentAndPreviewSash);
        final int lineHeight = Math.max(19, parent.getFont().getFontData()[0].getHeight());
        this.commentAndPreviewSash.addControlListener((ControlListener)new ControlAdapter(){
            private int preferredCommentHeight = -1;
            private int autoExpandPoint;

            public void controlResized(ControlEvent e) {
                int preferredPreviewHeight;
                int sashHeight = ((ReviewDialog)ReviewDialog.this).commentAndPreviewSash.getClientArea().height;
                if (this.preferredCommentHeight < 0) {
                    this.preferredCommentHeight = sashHeight - lineHeight - ReviewDialog.this.commentAndPreviewSash.getSashWidth();
                    this.autoExpandPoint = (int)((double)sashHeight * 1.35);
                }
                if (ReviewDialog.this.preview.getStyledText().isVisible()) {
                    if (sashHeight < this.autoExpandPoint && ReviewDialog.this.commentTwistie.isExpanded()) {
                        ReviewDialog.this.previewTwistie.setExpanded(false);
                        ReviewDialog.this.preview.getStyledText().setVisible(false);
                    }
                } else if (sashHeight >= this.autoExpandPoint) {
                    ReviewDialog.this.previewTwistie.setExpanded(true);
                    ReviewDialog.this.preview.getStyledText().setVisible(true);
                }
                if ((preferredPreviewHeight = sashHeight - this.preferredCommentHeight) < lineHeight || preferredPreviewHeight < 0 || this.preferredCommentHeight < 0) {
                    ReviewDialog.this.commentAndPreviewSash.setWeights(new int[]{3, 1});
                } else {
                    ReviewDialog.this.commentAndPreviewSash.setWeights(new int[]{this.preferredCommentHeight, preferredPreviewHeight});
                }
            }
        });
        UI.gl().margins(0, 0).spacing(0, 0).numColumns(2).applyTo(this.detailsArea);
        UI.gdGrabHV().span(2, 1).applyTo((Control)this.commentAndPreviewSash);
        GridDataFactory.fillDefaults().align(0x1000008, 128).applyTo((Control)this.commentTwistie);
        GridDataFactory.fillDefaults().align(0x1000008, 128).applyTo(this.severity.getControl());
    }

    private void createReportsAndDetailsSash(Composite parent) {
        this.reportsAndDetailsSash = new SashForm(parent, 256);
        this.reportsAndDetailsSash.setSashWidth(10);
        UI.gdGrabHV().indent(0, 10).applyTo((Control)this.reportsAndDetailsSash);
    }

    private void createReportsViewer(Composite parent) {
        Composite container = new Composite(parent, 0);
        Label label = new Label(container, 0);
        label.setText(Messages.LABEL_TEXT_EVENTS);
        this.reportsViewer = new TableViewer(container);
        this.reportsViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.reportsViewer.setLabelProvider((IBaseLabelProvider)new ReportsViewerLabelProvider((ColumnViewer)this.reportsViewer));
        this.reportsViewer.getControl().addKeyListener((KeyListener)new ReportsViewerDeleteListener());
        UI.gl().applyTo(container);
        UI.gdGrabH().align(1, 128).applyTo((Control)label);
        UI.gdGrabHV().applyTo((Control)container);
        UI.gdGrabHV().applyTo(this.reportsViewer.getControl());
        this.reportsViewer.setInput(this.events);
    }

    private void createCommentArea(Composite parent) {
        this.comments = new StyledText(parent, 2626);
        this.comments.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.comments.setToolTipText(Messages.TOOLTIP_COMMENTS);
        this.comments.setAlwaysShowScrollBars(false);
        UI.gdGrabHV().applyTo((Control)this.comments);
    }

    private void createPreviewArea(Composite parent) {
        this.previewArea = new Composite(parent, 0);
        this.previewTwistie = new ExpandableComposite(this.previewArea, 0);
        this.previewTwistie.setText(Messages.TWISTIE_TEXT_PREVIEW);
        this.showPreviewListener = new ShowPreviewListener();
        this.previewTwistie.addExpansionListener((IExpansionListener)this.showPreviewListener);
        this.processorsBar = new ToolBar(this.previewArea, 0x800000);
        ToolItem showResponseToolItem = new ToolItem(this.processorsBar, 8);
        showResponseToolItem.setImage(this.registry.get("icons/elcl16/message_info.png"));
        showResponseToolItem.setToolTipText("Show problem state");
        showResponseToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ILogEvent event = (ILogEvent)ReviewDialog.this.selectedLogEvent.getValue();
                if (event == null) {
                    return;
                }
                new ProblemStatusDialog(event, ReviewDialog.this.reportProcessorDescriptors, ReviewDialog.this.getShell()).open();
            }
        });
        new ToolItem(this.processorsBar, 2);
        for (IProcessorDescriptor descriptor : this.reportProcessorDescriptors) {
            ToolItem processorToolItem = new ToolItem(this.processorsBar, 32);
            processorToolItem.setData((Object)descriptor);
            processorToolItem.setImage(descriptor.getImage16());
        }
        this.preview = new ReportPreview(this.previewArea);
        this.preview.setEditListener(isReset -> this.previewReport());
        UI.gl().numColumns(2).applyTo(this.previewArea);
        UI.gdGrabH().align(0x1000008, 0x1000000).applyTo((Control)this.processorsBar);
        UI.gdGrabHV().span(2, 1).hint(-1, 320).applyTo((Control)this.preview.getStyledText());
    }

    protected void createPreferencesLink(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(Messages.LINK_TEXT_SENDING_PREFERENCES);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewDialog.this.uiSynchronize.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.epp.logging.aeri.ide.preferencePages.root", null, null);
                        dialog.open();
                    }
                });
            }
        });
        UI.gdGrabH().indent(0, 10).minSize(-1, 20).applyTo((Control)link);
    }

    private void createDatabindings() {
        this.dbContext = new DataBindingContext();
        this.selectedLogEvent = ViewerProperties.singlePostSelection().observe((Viewer)this.reportsViewer);
        this.selectedLogEvent.addChangeListener(x -> {
            ILogEvent logEvent = (ILogEvent)this.selectedLogEvent.getValue();
            if (logEvent != null) {
                ToolItem[] toolItemArray = this.processorsBar.getItems();
                int n = toolItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolItem processorToolItem = toolItemArray[n2];
                    IProcessorDescriptor descriptor = (IProcessorDescriptor)processorToolItem.getData();
                    if (descriptor != null) {
                        ReportProcessorSafeWrapper processor = descriptor.getProcessor();
                        boolean canContribute = processor.canContribute(logEvent.getStatus(), logEvent.getContext());
                        processorToolItem.setEnabled(canContribute);
                        String tooltipText = MessageFormat.format("{0}:\n{1}", descriptor.getName(), descriptor.getDescription());
                        if (!canContribute) {
                            tooltipText = MessageFormat.format("The processor ''{0}'' cannot contribute to the report.\n\n{1}", descriptor.getName(), tooltipText);
                        }
                        processorToolItem.setToolTipText(tooltipText);
                    }
                    ++n2;
                }
            }
        });
        IObservableList enabledProcessors = EMFProperties.list((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{IIdePackage.Literals.LOG_EVENT__OPTIONS, IModelPackage.Literals.SEND_OPTIONS__ENABLED_PROCESSORS})).observeDetail((IObservableValue)this.selectedLogEvent);
        enabledProcessors.addListChangeListener(event -> event.diff.accept((ListDiffVisitor)new ActivatedProcessorsChangeVisitor()));
        ToolItem[] toolItemArray = this.processorsBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            final ToolItem processorToolItem = toolItemArray[n2];
            IProcessorDescriptor descriptor = (IProcessorDescriptor)processorToolItem.getData();
            if (descriptor != null) {
                final ReportProcessorSafeWrapper processor = descriptor.getProcessor();
                processorToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ILogEvent event = (ILogEvent)ReviewDialog.this.selectedLogEvent.getValue();
                        if (event == null) {
                            return;
                        }
                        EList activeProcessors = event.getOptions().getEnabledProcessors();
                        if (processorToolItem.getSelection()) {
                            if (!activeProcessors.contains((Object)processor)) {
                                activeProcessors.add((Object)processor);
                            }
                        } else {
                            activeProcessors.remove((Object)processor);
                        }
                        ReviewDialog.this.reportsViewer.refresh(true, false);
                    }
                });
            }
            ++n2;
        }
        IObservableValue emf = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{IIdePackage.Literals.LOG_EVENT__OPTIONS, IModelPackage.Literals.SEND_OPTIONS__COMMENT})).observeDetail((IObservableValue)this.selectedLogEvent);
        ISWTObservableValue swt = WidgetProperties.text((int)24).observeDelayed(300, (Widget)this.comments);
        this.dbContext.bindValue((IObservableValue)swt, emf);
        emf = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{IIdePackage.Literals.LOG_EVENT__OPTIONS, IModelPackage.Literals.SEND_OPTIONS__SEVERITY})).observeDetail((IObservableValue)this.selectedLogEvent);
        IViewerObservableValue jface = ViewerProperties.singleSelection().observe((Viewer)this.severity);
        this.dbContext.bindValue((IObservableValue)jface, emf);
        this.addChangeListenerToBindings(this.dbContext);
        this.selectedLogEvent.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent e) {
                ILogEvent event = (ILogEvent)ReviewDialog.this.selectedLogEvent.getValue();
                if (event != null) {
                    ToolItem[] toolItemArray = ReviewDialog.this.processorsBar.getItems();
                    int n = toolItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ToolItem processorToolItem = toolItemArray[n2];
                        IProcessorDescriptor descriptor = (IProcessorDescriptor)processorToolItem.getData();
                        if (descriptor != null) {
                            if (descriptor.getProcessor().getWrapped() instanceof AnonymizeStackTracesProcessor && event.getOptions().isAnonymizeStackTraces() || descriptor.getProcessor().getWrapped() instanceof AnonymizeMessagesProcessor && event.getOptions().isAnonymizeMessages()) {
                                event.getOptions().getEnabledProcessors().add((Object)descriptor.getProcessor());
                            }
                            boolean shouldProcess = Processors.shouldProcess(descriptor, event);
                            processorToolItem.setSelection(event.getOptions().getEnabledProcessors().contains((Object)descriptor.getProcessor()));
                            processorToolItem.setImage(UIUtils.decorate(descriptor, ReviewDialog.this.registry, shouldProcess));
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private void editAndPreviewReport(IEditableReportProcessor processor) {
        ILogEvent logEvent = (ILogEvent)this.selectedLogEvent.getValue();
        if (logEvent != null) {
            IServerDescriptor server = logEvent.getServer();
            IReport report = server.getConnection().transform(logEvent.getStatus(), logEvent.getContext());
            IProcessorDescriptor descriptor = null;
            for (IProcessorDescriptor availableDescriptor : this.reportProcessorDescriptors) {
                if (availableDescriptor.getProcessor() != processor) continue;
                descriptor = availableDescriptor;
                break;
            }
            if (descriptor == null) {
                return;
            }
            processor.process(report, logEvent.getStatus(), logEvent.getContext());
            IEditableReportProcessor.EditResult editResult = processor.edit(logEvent.getStatus(), logEvent.getContext(), this.getShell());
            block0 : switch (editResult) {
                case MODIFIED: {
                    this.preview.getEditedDescriptors().add(descriptor);
                }
                case UNMODIFIED: {
                    processor.process(report, logEvent.getStatus(), logEvent.getContext());
                    break;
                }
                default: {
                    EList activeProcessors = logEvent.getOptions().getEnabledProcessors();
                    activeProcessors.remove((Object)processor);
                    report = server.getConnection().transform(logEvent.getStatus(), logEvent.getContext());
                    ToolItem[] toolItemArray = this.processorsBar.getItems();
                    int n = toolItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ToolItem processorToolItem = toolItemArray[n2];
                        IProcessorDescriptor toolItemDescriptor = (IProcessorDescriptor)processorToolItem.getData();
                        if (toolItemDescriptor == descriptor) {
                            processorToolItem.setSelection(false);
                            break block0;
                        }
                        ++n2;
                    }
                    break block0;
                }
            }
            this.preview.preview(report, logEvent.getStatus(), server.getName(), this.reportProcessorDescriptors, logEvent.getContext(), this.getShell());
            this.reportsViewer.refresh(true, false);
        }
    }

    private void previewReport() {
        ILogEvent logEvent = (ILogEvent)this.selectedLogEvent.getValue();
        if (logEvent != null) {
            IServerDescriptor server = logEvent.getServer();
            IReport report = server.getConnection().transform(logEvent.getStatus(), logEvent.getContext());
            this.preview.preview(report, logEvent.getStatus(), server.getName(), this.reportProcessorDescriptors, logEvent.getContext(), this.getShell());
        }
    }

    private void addChangeListenerToBindings(DataBindingContext context) {
        for (Object o : context.getBindings()) {
            Binding b = (Binding)o;
            b.getModel().addChangeListener((IChangeListener)new UpdatePreviewChangeListener());
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        }
    }

    public boolean close() {
        this.context.modify(CTX_STATE_REVIEW_IN_PROGRESS, (Object)false);
        this.dbContext.dispose();
        this.queue.eAdapters().remove((Object)this.incomingEventsCopier);
        return super.close();
    }

    protected void okPressed() {
        super.okPressed();
        this.broker.post("org/eclipse/epp/internal/logging/aeri/ui/event/send/groups", (Object)this.queue);
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this.broker.post("org/eclipse/epp/internal/logging/aeri/ui/events/clear", (Object)this.queue);
    }

    private static /* synthetic */ void lambda$10(Multimap multimap, ILogEvent iLogEvent, Set set, IProcessorDescriptor descriptor) {
        multimap.put((Object)descriptor, (Object)iLogEvent);
        set.add(iLogEvent.getServer());
    }

    private final class ActivatedProcessorsChangeVisitor
    extends ListDiffVisitor {
        private ActivatedProcessorsChangeVisitor() {
        }

        public void handleAdd(int index, Object processor) {
            if (processor instanceof IEditableReportProcessor) {
                ReviewDialog.this.editAndPreviewReport((IEditableReportProcessor)processor);
            } else {
                ReviewDialog.this.previewReport();
            }
        }

        public void handleRemove(int index, Object processor) {
            ReviewDialog.this.previewReport();
        }
    }

    private final class IncomingEventsCopier
    extends AdapterImpl {
        private final IInternalInput input;

        private IncomingEventsCopier(IInternalInput input) {
            this.input = input;
        }

        public void notifyChanged(Notification msg) {
            EList<ILogEvent> input2 = this.input.getInput();
            switch (msg.getEventType()) {
                case 3: {
                    ILogEventGroup group = (ILogEventGroup)msg.getNewValue();
                    for (ILogEvent event : group.getEvents()) {
                        IServerDescriptor server = event.getServer();
                        if (!server.isConfigured()) continue;
                        input2.add((Object)event);
                    }
                    break;
                }
                case 4: {
                    ILogEventGroup group = (ILogEventGroup)msg.getOldValue();
                    input2.removeAll(group.getEvents());
                }
            }
        }
    }

    private final class ReportsViewerDeleteListener
    extends KeyAdapter {
        private ReportsViewerDeleteListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 127 || e.keyCode == 8) {
                this.deleteSelection();
            }
        }

        private void deleteSelection() {
            IStructuredSelection selection = (IStructuredSelection)ReviewDialog.this.reportsViewer.getSelection();
            List elements = selection.toList();
            ReviewDialog.this.events.removeAll((Collection)elements);
            for (ILogEvent event : elements) {
                ILogEventGroup group = (ILogEventGroup)event.eContainer();
                EcoreUtil.delete((EObject)event);
                if (!group.getEvents().isEmpty()) continue;
                EcoreUtil.remove((EObject)group);
            }
        }
    }

    private final class ReportsViewerLabelProvider
    extends ColumnLabelProvider
    implements ITableFontProvider {
        private Font defaultFont;
        private Font boldFont;

        ReportsViewerLabelProvider(ColumnViewer viewer) {
            this.defaultFont = viewer.getControl().getFont();
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)this.defaultFont).setStyle(1);
            this.boldFont = boldDescriptor.createFont((Device)viewer.getControl().getDisplay());
        }

        public String getText(Object element) {
            return (String)new IdeSwitch<String>(){

                @Override
                public String caseLogEvent(ILogEvent event) {
                    if (ReportsViewerLabelProvider.this.isActivationConfirmRequired(event)) {
                        return "* " + event.getLabel();
                    }
                    return event.getLabel();
                }
            }.doSwitch((EObject)element);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 100;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }

        public Image getImage(Object element) {
            return (Image)new IdeSwitch<Image>(){

                @Override
                public Image caseLogEvent(ILogEvent event) {
                    boolean shouldProcess = Processors.shouldProcess(ReviewDialog.this.reportProcessorDescriptors, event);
                    Image image = UIUtils.decorate(event.getServer(), event.getStatus(), ReviewDialog.this.registry, shouldProcess);
                    return image;
                }
            }.doSwitch((EObject)element);
        }

        public Font getFont(Object element, int columnIndex) {
            return (Font)new IdeSwitch<Font>(){

                @Override
                public Font caseLogEvent(ILogEvent event) {
                    return ReportsViewerLabelProvider.this.isActivationConfirmRequired(event) ? ReportsViewerLabelProvider.this.boldFont : ReportsViewerLabelProvider.this.defaultFont;
                }
            }.doSwitch((EObject)element);
        }

        private boolean isActivationConfirmRequired(ILogEvent event) {
            return ReviewDialog.this.reportProcessorDescriptors.stream().filter(descriptor -> Processors.shouldProcess(descriptor, event) && !event.getOptions().getEnabledProcessors().contains((Object)descriptor.getProcessor())).findFirst().isPresent();
        }
    }

    private final class ShowPreviewListener
    extends ExpansionAdapter {
        private Point collapsedShellSize;

        private ShowPreviewListener() {
        }

        public void expansionStateChanged(ExpansionEvent e) {
            if (e.getState()) {
                this.showPreview();
            } else {
                this.hidePreview();
            }
        }

        public void hidePreview() {
            Shell shell = ReviewDialog.this.getShell();
            Point current = shell.getSize();
            ReviewDialog.this.preview.getStyledText().setVisible(false);
            shell.setSize(current.x, 320);
        }

        public void showPreview() {
            Shell shell = ReviewDialog.this.getShell();
            ReviewDialog.this.preview.getStyledText().setVisible(true);
            this.collapsedShellSize = shell.getSize();
            shell.setSize(this.collapsedShellSize.x, this.collapsedShellSize.y + 300);
        }
    }

    private final class UpdatePreviewChangeListener
    implements IChangeListener {
        private UpdatePreviewChangeListener() {
        }

        public void handleChange(ChangeEvent event) {
            ReviewDialog.this.previewReport();
        }
    }
}

