/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.emfstore.internal.common.model.IdentifiableElement;
import org.eclipse.emf.emfstore.server.ESServerURIUtil;

public final class ESClientURIUtil {
    public static final String SCHEME = "emfstore";
    public static final String CLIENT_SEGMENT = "workspaces";
    public static final String PROJECTSPACES_SEGMENT = "projectspaces";
    public static final String WORKSPACE_SEGMENT = "workspace";
    public static final String PROJECT_SEGMENT = "project";
    public static final String PROJECTSPACE_SEGMENT = "projectspace";
    public static final String OPERATIONS_SEGMENT = "operations";

    private ESClientURIUtil() {
    }

    public static URI createWorkspaceURI() {
        return URI.createURI((String)(String.valueOf(ESClientURIUtil.getClientPrefix()) + WORKSPACE_SEGMENT));
    }

    public static URI createProjectURI(IdentifiableElement projectSpace) {
        return URI.createURI((String)(String.valueOf(ESClientURIUtil.getProjectspacesPrefix(projectSpace)) + PROJECT_SEGMENT));
    }

    public static URI createOperationsURI(IdentifiableElement projectSpace) {
        return URI.createURI((String)(String.valueOf(ESClientURIUtil.getProjectspacesPrefix(projectSpace)) + OPERATIONS_SEGMENT));
    }

    public static URI createProjectSpaceURI(IdentifiableElement projectSpace) {
        return URI.createURI((String)(String.valueOf(ESClientURIUtil.getProjectspacesPrefix(projectSpace)) + PROJECTSPACE_SEGMENT));
    }

    private static String getClientPrefix() {
        return "emfstore://workspaces/" + ESServerURIUtil.getProfile() + "/";
    }

    private static String getProjectspacesPrefix(IdentifiableElement projectSpace) {
        return String.valueOf(ESClientURIUtil.getClientPrefix()) + PROJECTSPACES_SEGMENT + "/" + projectSpace.getIdentifier() + "/";
    }
}

