/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.Messages;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMapping;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IAttributeValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.api.diff.IMergeableDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.impl.helpers.AbstractExpensiveOperation;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DiffOperation
extends AbstractExpensiveOperation {
    private final IDiffPolicy _diffPolicy;
    private final IMergePolicy _mergePolicy;
    private final IComparison.Editable _comparison;
    protected final boolean _isReferenceScopeReadOnly;
    protected final boolean _isTargetScopeReadOnly;

    public DiffOperation(IComparison.Editable comparison_p, IDiffPolicy diffPolicy_p, IMergePolicy mergePolicy_p) {
        this._comparison = comparison_p;
        this._diffPolicy = diffPolicy_p;
        this._mergePolicy = mergePolicy_p;
        this._isReferenceScopeReadOnly = this.getComparison().getScope(Role.REFERENCE).isReadOnly();
        this._isTargetScopeReadOnly = this.getComparison().getScope(Role.TARGET).isReadOnly();
    }

    protected void createAttributeOrderDifference(IMatch elementMatch_p, EAttribute attribute_p, Object value1_p, Object value2_p, Role role1_p, Role role2_p) {
        this.createAttributeValueDifference(elementMatch_p, attribute_p, value1_p, role1_p, true);
        this.createAttributeValueDifference(elementMatch_p, attribute_p, value2_p, role2_p, true);
    }

    protected IAttributeValuePresence createAttributeValueDifference(IMatch elementMatch_p, EAttribute attribute_p, Object value_p, Role role_p, boolean isOrder_p) {
        IAttributeValuePresence result = this.getComparison().newAttributeValuePresence(elementMatch_p, attribute_p, value_p, role_p, isOrder_p);
        IAttributeValuePresence symmetrical = result.getSymmetrical();
        if (symmetrical != null) {
            this.setSymmetricalValuePresenceDependencies(result, symmetrical);
        }
        if (this.getComparison().isThreeWay()) {
            this.setThreeWayProperties(result);
        }
        return result;
    }

    protected void createDifferences() {
        for (IMatch match : this.getMapping().getContents()) {
            this.checkProgress();
            if (this.getDiffPolicy().coverMatch(match)) {
                this.createTechnicalDifferences(match);
            }
            this.getMonitor().worked(1);
        }
    }

    protected void createReferenceOrderDifference(IMatch elementMatch_p, EReference reference_p, EObject value_p, IMatch valueMatch_p) {
        this.createReferenceValueDifference(elementMatch_p, reference_p, value_p, valueMatch_p, Role.TARGET, true);
        this.createReferenceValueDifference(elementMatch_p, reference_p, value_p, valueMatch_p, Role.REFERENCE, true);
    }

    protected IReferenceValuePresence createReferenceValueDifference(IMatch elementMatch_p, EReference reference_p, EObject value_p, IMatch valueMatch_p, Role role_p, boolean isOrder_p) {
        IReferenceValuePresence result = this.getComparison().newReferenceValuePresence(elementMatch_p, reference_p, value_p, valueMatch_p, role_p, isOrder_p);
        this.setReferencedValueDependencies(result);
        if (this.getComparison().isThreeWay()) {
            this.setThreeWayProperties(result);
        }
        return result;
    }

    protected void createTechnicalDifferences(IMatch match_p) {
        assert (match_p != null);
        if (match_p.isPartial()) {
            this.getOrCreateElementPresence(match_p);
        } else {
            this.detectContentDifferences(match_p, Role.TARGET, Role.REFERENCE, true);
        }
    }

    protected boolean detectAllAttributeDifferences(IMatch match_p, Role role1_p, Role role2_p, boolean create_p) {
        assert (match_p != null && !match_p.isPartial(role1_p, role2_p));
        EClass eClass = match_p.get(role1_p).eClass();
        boolean result = false;
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            if (!this.getDiffPolicy().coverFeature((EStructuralFeature)attribute)) continue;
            boolean bl = result = this.detectAttributeDifferences(match_p, attribute, role1_p, role2_p, create_p) || result;
        }
        return result;
    }

    protected boolean detectAllReferenceDifferences(IMatch match_p, Role role1_p, Role role2_p, boolean create_p) {
        assert (match_p != null && !match_p.isPartial(role1_p, role2_p));
        EClass eClass = match_p.get(role1_p).eClass();
        boolean result = false;
        for (EReference reference : eClass.getEAllReferences()) {
            if (reference.isContainer() || !this.getDiffPolicy().coverFeature((EStructuralFeature)reference)) continue;
            boolean bl = result = this.detectReferenceDifferences(match_p, reference, role1_p, role2_p, create_p) || result;
        }
        return result;
    }

    protected boolean detectAttributeDifferences(IMatch match_p, EAttribute attribute_p, Role role1_p, Role role2_p, boolean create_p) {
        assert (match_p != null && !match_p.isPartial(role1_p, role2_p) && attribute_p != null);
        boolean result = false;
        IEditableModelScope scope1 = this.getComparison().getScope(role1_p);
        IEditableModelScope scope2 = this.getComparison().getScope(role2_p);
        EObject element1 = match_p.get(role1_p);
        EObject element2 = match_p.get(role2_p);
        List<Object> values1 = scope1.get(element1, attribute_p);
        List<Object> values2 = scope2.get(element2, attribute_p);
        ArrayList<Object> remainingValues1 = new ArrayList<Object>(values1);
        ArrayList<Object> remainingValues2 = new ArrayList<Object>(values2);
        boolean checkOrder = attribute_p.isMany() && this.getDiffPolicy().considerOrdered((EStructuralFeature)attribute_p);
        int maxIndex = -1;
        for (Object value1 : values1) {
            ObjectAndIndex matchingValue2 = this.findEqualAttributeValue(attribute_p, value1, remainingValues2);
            if (matchingValue2.getObject() == null) continue;
            if (checkOrder) {
                if (matchingValue2.getIndex() < maxIndex) {
                    if (!create_p) {
                        return true;
                    }
                    this.createAttributeOrderDifference(match_p, attribute_p, value1, matchingValue2.getObject(), role1_p, role2_p);
                    result = true;
                    checkOrder = false;
                } else {
                    maxIndex = matchingValue2.getIndex();
                }
            }
            remainingValues1.remove(value1);
            remainingValues2.remove(matchingValue2.getObject());
        }
        for (Object remainingValue1 : remainingValues1) {
            if (!this.getDiffPolicy().coverValue(remainingValue1, attribute_p)) continue;
            if (!create_p) {
                return true;
            }
            this.createAttributeValueDifference(match_p, attribute_p, remainingValue1, role1_p, false);
            result = true;
        }
        for (Object remainingValue2 : remainingValues2) {
            if (!this.getDiffPolicy().coverValue(remainingValue2, attribute_p)) continue;
            if (!create_p) {
                return true;
            }
            this.createAttributeValueDifference(match_p, attribute_p, remainingValue2, role2_p, false);
            result = true;
        }
        return result;
    }

    protected boolean detectContentDifferences(IMatch match_p, Role role1_p, Role role2_p, boolean create_p) {
        assert (match_p != null && !match_p.isPartial(role1_p, role2_p));
        boolean result = this.detectAllAttributeDifferences(match_p, role1_p, role2_p, create_p);
        result = this.detectAllReferenceDifferences(match_p, role1_p, role2_p, create_p) || result;
        result = this.detectOwnershipDifferences(match_p, role1_p, role2_p, create_p) || result;
        return result;
    }

    protected boolean detectOwnershipDifferences(IMatch match_p, Role role1_p, Role role2_p, boolean create_p) {
        assert (match_p != null && !match_p.isPartial(role1_p, role2_p));
        boolean result = false;
        for (Role role : Arrays.asList(role1_p, role2_p)) {
            IMatch parentMatch = this.getComparison().getContainerOf(match_p, role);
            if (parentMatch == null || !parentMatch.isPartial(role1_p, role2_p)) continue;
            if (!create_p) {
                return true;
            }
            EObject element = match_p.get(role);
            EReference containment = this.getComparison().getScope(role).getContainment(element);
            this.createReferenceValueDifference(parentMatch, containment, element, match_p, role, false);
            result = true;
        }
        return result;
    }

    protected boolean detectReferenceDifferences(IMatch match_p, EReference reference_p, Role role1_p, Role role2_p, boolean create_p) {
        assert (match_p != null && !match_p.isPartial(role1_p, role2_p) && reference_p != null);
        assert (!reference_p.isContainer());
        boolean result = false;
        IDiffPolicy diffPolicy = this.getDiffPolicy();
        IEditableModelScope scope1 = this.getComparison().getScope(role1_p);
        IEditableModelScope scope2 = this.getComparison().getScope(role2_p);
        EObject element1 = match_p.get(role1_p);
        EObject element2 = match_p.get(role2_p);
        List<EObject> values1 = scope1.get(element1, reference_p);
        List<EObject> values2 = scope2.get(element2, reference_p);
        FArrayList remainingValues2 = new FArrayList(values2, IEqualityTester.BY_REFERENCE);
        boolean checkOrder = reference_p.isMany() && diffPolicy.considerOrdered((EStructuralFeature)reference_p);
        int maxIndex = -1;
        for (EObject value1 : values1) {
            boolean coverValue1;
            IMatch valueMatch1 = this.getMapping().getMatchFor(value1, role1_p);
            boolean outsideScope1 = valueMatch1 == null;
            boolean bl = coverValue1 = !outsideScope1 && diffPolicy.coverMatch(valueMatch1) || outsideScope1 && diffPolicy.coverOutOfScopeValue(value1, reference_p);
            if (!coverValue1) continue;
            EObject matchValue2 = outsideScope1 ? value1 : valueMatch1.get(role2_p);
            boolean isIsolated = matchValue2 == null;
            int index = -1;
            if (!isIsolated) {
                index = this.detectReferenceValueAmong(reference_p, matchValue2, (List<EObject>)remainingValues2, outsideScope1);
                boolean bl2 = isIsolated = index < 0;
                if (checkOrder && !isIsolated) {
                    if (index < maxIndex) {
                        if (!create_p) {
                            return true;
                        }
                        this.createReferenceOrderDifference(match_p, reference_p, value1, valueMatch1);
                        result = true;
                        checkOrder = false;
                    } else {
                        maxIndex = index;
                    }
                }
            }
            if (isIsolated) {
                if (!create_p) {
                    return true;
                }
                this.createReferenceValueDifference(match_p, reference_p, value1, valueMatch1, role1_p, false);
                result = true;
                continue;
            }
            if (index > -1) {
                remainingValues2.remove(index);
                continue;
            }
            remainingValues2.remove(matchValue2);
        }
        for (EObject remainingValue2 : remainingValues2) {
            boolean coverReferenceValue;
            IMatch valueMatch2 = this.getMapping().getMatchFor(remainingValue2, role2_p);
            boolean outsideReferenceScope = valueMatch2 == null;
            boolean bl = coverReferenceValue = !outsideReferenceScope && diffPolicy.coverMatch(valueMatch2) || outsideReferenceScope && diffPolicy.coverOutOfScopeValue(remainingValue2, reference_p);
            if (!coverReferenceValue) continue;
            if (!create_p) {
                return true;
            }
            this.createReferenceValueDifference(match_p, reference_p, remainingValue2, valueMatch2, role2_p, false);
            result = true;
        }
        return result;
    }

    protected int detectReferenceValueAmong(EReference reference_p, EObject value_p, List<EObject> values_p, boolean outsideScope_p) {
        int result = values_p.indexOf(value_p);
        if (result == -1 && outsideScope_p) {
            IDiffPolicy diffPolicy = this.getDiffPolicy();
            int i = -1;
            for (EObject candidateValue : values_p) {
                ++i;
                if (!diffPolicy.considerEqualOutOfScope(value_p, candidateValue, reference_p)) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    protected ObjectAndIndex findEqualAttributeValue(EAttribute attribute_p, Object value_p, Collection<? extends Object> candidates_p) {
        int i = 0;
        for (Object object : candidates_p) {
            if (this.getDiffPolicy().considerEqual(value_p, object, attribute_p)) {
                return new ObjectAndIndex(object, i);
            }
            ++i;
        }
        return new ObjectAndIndex();
    }

    public IComparison.Editable getComparison() {
        return this._comparison;
    }

    protected IDiffPolicy getDiffPolicy() {
        return this._diffPolicy;
    }

    protected IMergePolicy getMergePolicy() {
        return this._mergePolicy;
    }

    protected IMapping getMapping() {
        return this.getComparison().getMapping();
    }

    @Override
    public String getOperationName() {
        return Messages.DiffBuilder_Task_Main;
    }

    protected IElementPresence getOrCreateElementPresence(IMatch match_p) {
        assert (match_p != null && match_p.isPartial());
        IElementPresence result = match_p.getElementPresenceDifference();
        if (result == null && this.getDiffPolicy().coverMatch(match_p)) {
            Role presenceRole = match_p.getUncoveredRole().opposite();
            IMatch ownerMatch = this.getComparison().getContainerOf(match_p, presenceRole);
            result = this.getComparison().newElementPresence(match_p, ownerMatch);
            this.setElementPresenceDependencies(result);
            if (this.getComparison().isThreeWay()) {
                this.setThreeWayProperties(result);
            }
        }
        return result;
    }

    @Override
    protected int getWorkAmount() {
        return 1 + this.getMapping().size();
    }

    protected boolean isReadOnly(Role role_p) {
        boolean result;
        switch (role_p) {
            case REFERENCE: {
                result = this._isReferenceScopeReadOnly;
                break;
            }
            case TARGET: {
                result = this._isTargetScopeReadOnly;
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    protected void markImplies(IMergeableDifference source_p, IMergeableDifference target_p, Role role_p) {
        if (!this.isReadOnly(role_p)) {
            ((IMergeableDifference.Editable)source_p).markImplies(target_p, role_p);
        }
    }

    protected void markRequires(IMergeableDifference source_p, IMergeableDifference target_p, Role role_p) {
        if (!this.isReadOnly(role_p)) {
            ((IMergeableDifference.Editable)source_p).markRequires(target_p, role_p);
        }
    }

    @Override
    public IStatus run() {
        this.getMonitor().worked(1);
        this.createDifferences();
        return Status.OK_STATUS;
    }

    protected void setCyclicOwnershipDependencies(IReferenceValuePresence presence_p) {
        assert (presence_p.getValueMatch() != null);
        assert (!presence_p.isOrder());
        assert (presence_p.getValueMatch().isAMove());
        assert (presence_p.isOwnership());
        assert (!presence_p.getValueMatch().isPartial());
        Role orderingRole = this.getComparison().getMapping().getOrderingRole();
        Role oppositeRole = orderingRole.opposite();
        if (presence_p.getPresenceRole() == oppositeRole) {
            IMatch valueMatch;
            IComparison.Editable comparison = this.getComparison();
            IMatch oppositeAncestorMatch = valueMatch = presence_p.getValueMatch();
            do {
                if ((oppositeAncestorMatch = comparison.getContainerOf(oppositeAncestorMatch, oppositeRole)) == null || !oppositeAncestorMatch.isAMove()) continue;
                IReferenceValuePresence cycleEnd = null;
                IMatch orderingAncestorMatch = oppositeAncestorMatch;
                do {
                    if ((orderingAncestorMatch = comparison.getContainerOf(orderingAncestorMatch, orderingRole)) != valueMatch) continue;
                    cycleEnd = oppositeAncestorMatch.getOwnershipDifference(orderingRole);
                } while (orderingAncestorMatch != null && cycleEnd == null);
                if (cycleEnd == null) continue;
                this.markRequires(cycleEnd, presence_p, oppositeRole);
                this.markRequires(presence_p, cycleEnd, orderingRole);
            } while (oppositeAncestorMatch != null);
        }
    }

    protected void setElementPresenceDependencies(IElementPresence presence_p) {
        Role presenceRole = presence_p.getPresenceRole();
        if (!presence_p.isRoot()) {
            IElementPresence ownerPresence;
            IMatch ownerMatch = presence_p.getOwnerMatch();
            if (this.getMergePolicy().bindPresenceToOwnership(this._comparison.getScope(presenceRole.opposite())) && ownerMatch != null && ownerMatch.isPartial() && (ownerPresence = this.getOrCreateElementPresence(ownerMatch)) != null) {
                this.markRequires(presence_p, ownerPresence, presenceRole.opposite());
                this.markRequires(ownerPresence, presence_p, presenceRole);
            }
        }
        Collection<EObject> additionPeers = this.getMergePolicy().getAdditionGroup(presence_p.getElement(), this.getComparison().getScope(presenceRole));
        for (EObject peer : additionPeers) {
            IElementPresence peerPresence;
            IMatch peerMatch = this.getMapping().getMatchFor(peer, presenceRole);
            if (peerMatch == null || !peerMatch.isPartial() || (peerPresence = this.getOrCreateElementPresence(peerMatch)) == null) continue;
            this.markRequires(presence_p, peerPresence, presenceRole.opposite());
            this.markRequires(peerPresence, presence_p, presenceRole);
        }
        Collection<EObject> deletionPeers = this.getMergePolicy().getDeletionGroup(presence_p.getElement(), this.getComparison().getScope(presenceRole));
        for (EObject peer : deletionPeers) {
            IElementPresence peerPresence;
            IMatch peerMatch = this.getMapping().getMatchFor(peer, presenceRole);
            if (peerMatch == null || !peerMatch.isPartial() || (peerPresence = this.getOrCreateElementPresence(peerMatch)) == null) continue;
            this.markRequires(presence_p, peerPresence, presenceRole);
        }
    }

    protected void setOppositeReferenceDependencies(IReferenceValuePresence first_p, IReferenceValuePresence second_p) {
        assert (first_p.isOppositeOf(second_p));
        Role presenceRole = first_p.getPresenceRole();
        if (second_p.getFeature().isMany()) {
            this.markImplies(first_p, second_p, presenceRole);
            this.markImplies(first_p, second_p, presenceRole.opposite());
        } else {
            this.markRequires(first_p, second_p, presenceRole);
            this.markRequires(first_p, second_p, presenceRole.opposite());
        }
        if (first_p.getFeature().isMany()) {
            this.markImplies(second_p, first_p, presenceRole);
            this.markImplies(second_p, first_p, presenceRole.opposite());
        } else {
            this.markRequires(second_p, first_p, presenceRole);
            this.markRequires(second_p, first_p, presenceRole.opposite());
        }
    }

    protected void setOwnershipDependencies(IReferenceValuePresence presence_p) {
        assert (presence_p.isOwnership());
        IMatch valueMatch = presence_p.getValueMatch();
        if (valueMatch == null || !valueMatch.isPartial()) {
            IReferenceValuePresence symmetricalOwnership = presence_p.getSymmetricalOwnership();
            if (symmetricalOwnership != null) {
                this.setSymmetricalOwnershipDependencies(presence_p, symmetricalOwnership);
            }
            if (valueMatch != null && !presence_p.isOrder()) {
                this.setCyclicOwnershipDependencies(presence_p);
            }
        }
    }

    protected void setPartialReferencedValueDependencies(IReferenceValuePresence referenceDiff_p) {
        assert (referenceDiff_p.getValueMatch() != null);
        assert (referenceDiff_p.getValueMatch().isPartial());
        IElementPresence presence = this.getOrCreateElementPresence(referenceDiff_p.getValueMatch());
        if (presence != null) {
            Role presenceRole = referenceDiff_p.getPresenceRole();
            this.markRequires(referenceDiff_p, presence, presenceRole.opposite());
            this.markRequires(presence, referenceDiff_p, presenceRole);
            if (referenceDiff_p.getFeature() != null) {
                if (referenceDiff_p.isOwnership() && this.getMergePolicy().bindPresenceToOwnership(this._comparison.getScope(presenceRole.opposite()))) {
                    this.markImplies(presence, referenceDiff_p, presenceRole.opposite());
                    this.markImplies(referenceDiff_p, presence, presenceRole);
                } else {
                    EReference opposite = referenceDiff_p.getFeature().getEOpposite();
                    if (opposite != null && this.getMergePolicy().isMandatoryForAddition(opposite)) {
                        this.markRequires(presence, referenceDiff_p, presenceRole.opposite());
                        this.markRequires(referenceDiff_p, presence, presenceRole);
                    }
                }
            }
        }
    }

    protected void setPartialReferencingElementDependencies(IReferenceValuePresence referenceDiff_p) {
        assert (referenceDiff_p.getElementMatch().isPartial());
        IElementPresence presence = this.getOrCreateElementPresence(referenceDiff_p.getElementMatch());
        if (presence != null) {
            Role presenceRole = referenceDiff_p.getPresenceRole();
            this.markRequires(referenceDiff_p, presence, presenceRole.opposite());
            this.markRequires(presence, referenceDiff_p, presenceRole);
        }
    }

    protected void setReferencedValueDependencies(IReferenceValuePresence presence_p) {
        IReferenceValuePresence symmetrical;
        IReferenceValuePresence oppositeDiff;
        IMatch valueMatch = presence_p.getValueMatch();
        if (!presence_p.isOwnership() && (oppositeDiff = presence_p.getOpposite()) != null) {
            this.setOppositeReferenceDependencies(presence_p, oppositeDiff);
        }
        if ((symmetrical = presence_p.getSymmetrical()) != null) {
            this.setSymmetricalValuePresenceDependencies(presence_p, symmetrical);
        }
        if (presence_p.getElementMatch().isPartial()) {
            this.setPartialReferencingElementDependencies(presence_p);
        }
        if (valueMatch != null && valueMatch.isPartial()) {
            this.setPartialReferencedValueDependencies(presence_p);
        }
        if (presence_p.isOwnership()) {
            this.setOwnershipDependencies(presence_p);
        }
    }

    protected void setSymmetricalOwnershipDependencies(IReferenceValuePresence first_p, IReferenceValuePresence second_p) {
        assert (first_p.isSymmetricalOwnershipTo(second_p));
        this.markImplies(first_p, second_p, second_p.getPresenceRole());
        this.markImplies(second_p, first_p, first_p.getPresenceRole());
        this.markRequires(first_p, second_p, first_p.getPresenceRole());
        this.markRequires(second_p, first_p, second_p.getPresenceRole());
    }

    protected void setSymmetricalValuePresenceDependencies(IValuePresence first_p, IValuePresence second_p) {
        assert (first_p.isSymmetricalTo(second_p));
        this.markImplies(first_p, second_p, second_p.getPresenceRole());
        this.markImplies(second_p, first_p, first_p.getPresenceRole());
        this.markRequires(first_p, second_p, first_p.getPresenceRole());
        this.markRequires(second_p, first_p, second_p.getPresenceRole());
    }

    protected void setThreeWayProperties(IElementPresence presence_p) {
        IMatch elementMatch = presence_p.getElementMatch();
        EObject ancestorElement = elementMatch.get(Role.ANCESTOR);
        if (ancestorElement != null) {
            boolean diffWithAncestor = this.detectContentDifferences(elementMatch, presence_p.getPresenceRole(), Role.ANCESTOR, false);
            if (diffWithAncestor) {
                ((IDifference.Editable)((Object)presence_p)).markAsConflicting();
            }
        } else {
            ((IDifference.Editable)((Object)presence_p)).markAsDifferentFromAncestor();
        }
    }

    protected void setThreeWayProperties(IAttributeValuePresence presence_p) {
        boolean aligned;
        EObject ancestorHolder = presence_p.getElementMatch().get(Role.ANCESTOR);
        if (ancestorHolder == null) {
            aligned = false;
        } else {
            EAttribute attribute = presence_p.getFeature();
            IEditableModelScope ancestorScope = this._comparison.getScope(Role.ANCESTOR);
            assert (ancestorScope != null);
            List<Object> valuesInAncestor = ancestorScope.get(ancestorHolder, attribute);
            if (presence_p.isOrder()) {
                Role presenceRole = presence_p.getPresenceRole();
                List<Object> values = this._comparison.getScope(presenceRole).get(presence_p.getElementMatch().get(presenceRole), presence_p.getFeature());
                int maxIndex = -1;
                aligned = true;
                for (Object value : values) {
                    ObjectAndIndex matchingAncestorValue = this.findEqualAttributeValue(attribute, value, valuesInAncestor);
                    if (matchingAncestorValue.getObject() == null) continue;
                    if (matchingAncestorValue.getIndex() < maxIndex) {
                        aligned = false;
                        break;
                    }
                    maxIndex = matchingAncestorValue.getIndex();
                }
            } else {
                ObjectAndIndex equalInAncestor = this.findEqualAttributeValue(attribute, presence_p.getValue(), valuesInAncestor);
                boolean bl = aligned = equalInAncestor.getObject() != null;
            }
        }
        if (!aligned) {
            IAttributeValuePresence symmetrical = presence_p.getSymmetrical();
            if (symmetrical != null && !symmetrical.isAlignedWithAncestor()) {
                ((IDifference.Editable)((Object)presence_p)).markAsConflicting();
                ((IDifference.Editable)((Object)symmetrical)).markAsConflicting();
            } else {
                ((IDifference.Editable)((Object)presence_p)).markAsDifferentFromAncestor();
            }
        }
    }

    protected void setThreeWayProperties(IReferenceValuePresence presence_p) {
        boolean aligned;
        EObject ancestorHolder = presence_p.getElementMatch().get(Role.ANCESTOR);
        if (ancestorHolder == null) {
            aligned = false;
        } else {
            IMatch valueMatch = presence_p.getValueMatch();
            EObject ancestorValue = valueMatch == null ? null : valueMatch.get(Role.ANCESTOR);
            IEditableModelScope ancestorScope = this._comparison.getScope(Role.ANCESTOR);
            assert (ancestorScope != null);
            FArrayList ancestorValues = new FArrayList(ancestorScope.get(ancestorHolder, presence_p.getFeature()), IEqualityTester.BY_REFERENCE);
            if (presence_p.isOrder()) {
                EReference reference = presence_p.getFeature();
                Role presenceRole = presence_p.getPresenceRole();
                List<EObject> values = this._comparison.getScope(presenceRole).get(presence_p.getElementMatch().get(presenceRole), reference);
                int maxIndex = -1;
                aligned = true;
                for (EObject value : values) {
                    int index;
                    EObject matchAncestor;
                    IMatch currentValueMatch = this.getMapping().getMatchFor(value, presenceRole);
                    if (currentValueMatch == null || (matchAncestor = currentValueMatch.get(Role.ANCESTOR)) == null || (index = this.detectReferenceValueAmong(reference, matchAncestor, (List<EObject>)ancestorValues, false)) < 0) continue;
                    if (index < maxIndex) {
                        aligned = false;
                        break;
                    }
                    maxIndex = index;
                }
            } else {
                aligned = ancestorValues.contains(ancestorValue);
            }
        }
        if (!aligned) {
            IReferenceValuePresence symmetrical = presence_p.getSymmetrical();
            if (symmetrical != null && !symmetrical.isAlignedWithAncestor()) {
                ((IDifference.Editable)((Object)presence_p)).markAsConflicting();
                ((IDifference.Editable)((Object)symmetrical)).markAsConflicting();
            } else {
                ((IDifference.Editable)((Object)presence_p)).markAsDifferentFromAncestor();
            }
        }
    }

    protected static class ObjectAndIndex {
        private Object _object;
        private int _index;

        public ObjectAndIndex(Object object_p, int index_p) {
            assert (object_p != null && index_p >= 0);
            this._object = object_p;
            this._index = index_p;
        }

        public ObjectAndIndex() {
            this._object = null;
            this._index = -1;
        }

        public boolean equals(Object peer_p) {
            boolean result = false;
            if (peer_p instanceof ObjectAndIndex) {
                ObjectAndIndex peer = (ObjectAndIndex)peer_p;
                result = this._object == null && peer.getObject() == null || this._object != null && this._object.equals(peer.getObject());
                result = result && this._index == peer.getIndex();
            }
            return result;
        }

        public Object getObject() {
            return this._object;
        }

        public int getIndex() {
            return this._index;
        }

        public int hashCode() {
            return (this._object != null ? this._object.hashCode() : 0) + Integer.valueOf(this._index).hashCode();
        }
    }
}

