/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.internal.ui.editor;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSectionPart<T extends EObject>
extends AbstractFormPart {
    private final EditingDomain domain;
    private final AdapterFactory adapterFactory;
    private final Class<T> inputType;
    private final EClass inputEClass;
    private T input;
    private DataBindingContext context;
    private WritableValue<Object> value;
    private IActionBars editorActionBars;

    public AbstractSectionPart(Class<T> inputType, EClass inputEClass, EditingDomain domain, AdapterFactory adapterFactory) {
        this.inputType = inputType;
        this.inputEClass = inputEClass;
        this.domain = domain;
        this.adapterFactory = adapterFactory;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.initDatabindings();
    }

    public void setEditorActionBars(IActionBars actionBars) {
        this.editorActionBars = actionBars;
    }

    protected IActionBars getEditorActionBars() {
        return this.editorActionBars;
    }

    protected void initDatabindings() {
        this.context = new EMFDataBindingContext();
        this.value = new WritableValue(this.context.getValidationRealm());
    }

    public void dispose() {
        if (this.context != null) {
            this.context.dispose();
        }
        super.dispose();
    }

    public boolean setFormInput(Object input) {
        boolean result = false;
        this.input = null;
        if (this.inputType.isInstance(input)) {
            this.input = (EObject)this.inputType.cast(input);
            result = true;
        }
        this.value.setValue(this.input);
        return result;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection sel;
        if (selection instanceof IStructuredSelection && !(sel = (IStructuredSelection)selection).isEmpty()) {
            this.setFormInput(sel.getFirstElement());
        }
    }

    public final Class<T> getInputType() {
        return this.inputType;
    }

    public final EClass getInputEClass() {
        return this.inputEClass;
    }

    protected T getInput() {
        return this.input;
    }

    protected EditingDomain getEditingDomain() {
        return this.domain;
    }

    protected AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    protected Realm getRealm() {
        return this.getContext().getValidationRealm();
    }

    protected DataBindingContext getContext() {
        return this.context;
    }

    protected IObservableValue<Object> getValue() {
        return this.value;
    }

    protected ISWTObservableValue<?> observeText(Text text) {
        return WidgetProperties.text((int[])new int[]{14, 16}).observe((Widget)text);
    }

    public void createContents(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(parent, 512);
        section.setText(this.getTitle());
        if (parent.getLayout() instanceof TableWrapLayout) {
            section.setLayoutData((Object)new TableWrapData(256, 256));
        } else if (parent.getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        Composite body = toolkit.createComposite((Composite)section);
        section.setClient((Control)body);
        this.createContents(body, toolkit);
        this.createActionToolbar(section, toolkit);
    }

    protected abstract String getTitle();

    protected abstract void createContents(Composite var1, FormToolkit var2);

    protected void createActionToolbar(Section section, FormToolkit toolkit) {
    }
}

