/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.workingsets;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;

public class EditWorkingSetAction
extends Action {
    private IWorkbenchPartSite fSite;
    private Shell fShell;
    private WorkingSetFilterActionGroup fActionGroup;

    public EditWorkingSetAction(WorkingSetFilterActionGroup actionGroup, IWorkbenchPartSite site) {
        this(actionGroup);
        this.fSite = site;
    }

    public EditWorkingSetAction(WorkingSetFilterActionGroup actionGroup, Shell shell) {
        this(actionGroup);
        this.fShell = shell;
    }

    private EditWorkingSetAction(WorkingSetFilterActionGroup actionGroup) {
        super(WorkingSetMessages.EditWorkingSetAction_text);
        this.setToolTipText(WorkingSetMessages.EditWorkingSetAction_toolTip);
        this.setEnabled(actionGroup.getWorkingSet() != null);
        this.fActionGroup = actionGroup;
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public void run() {
        Shell shell = this.getShell();
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = this.fActionGroup.getWorkingSet();
        if (workingSet == null || workingSet.isAggregateWorkingSet()) {
            this.setEnabled(false);
            return;
        }
        IWorkingSetEditWizard wizard = manager.createWorkingSetEditWizard(workingSet);
        if (wizard == null) {
            String title = WorkingSetMessages.EditWorkingSetAction_error_nowizard_title;
            String message = WorkingSetMessages.EditWorkingSetAction_error_nowizard_message;
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
            return;
        }
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            this.fActionGroup.setWorkingSet(wizard.getSelection(), true);
        }
    }

    private Shell getShell() {
        if (this.fSite != null) {
            return this.fSite.getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }
}

