/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.launchConfigurations;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.ant.internal.launching.AntLaunch;
import org.eclipse.ant.internal.launching.AntLaunching;
import org.eclipse.ant.internal.launching.AntLaunchingUtil;
import org.eclipse.ant.internal.launching.launchConfigurations.AntStreamMonitor;
import org.eclipse.ant.internal.launching.launchConfigurations.AntStreamsProxy;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IProcess;

public class RemoteAntBuildListener
implements ILaunchesListener {
    private ServerSocket fServerSocket;
    private Socket fSocket;
    private BufferedReader fBufferedReader;
    private IProcess fProcess;
    private String fProcessId;
    private List<String> fMessageQueue;
    protected ILaunch fLaunch;
    private String fLastFileName = null;
    private String fLastTaskName = null;
    private boolean fBuildFailed = false;
    private String fEncoding;

    public RemoteAntBuildListener(ILaunch launch, String encoding) {
        this.fLaunch = launch;
        this.fEncoding = encoding;
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    protected String getEncoding() {
        return this.fEncoding;
    }

    public synchronized void startListening(int eventPort) {
        ServerConnection connection = new ServerConnection(eventPort);
        connection.start();
    }

    protected synchronized void shutDown() {
        this.fLaunch = null;
        if (DebugPlugin.getDefault() != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        }
        try {
            if (this.fBufferedReader != null) {
                this.fBufferedReader.close();
                this.fBufferedReader = null;
            }
        }
        catch (IOException e) {
            AntLaunching.log(e);
        }
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
                this.fSocket = null;
            }
        }
        catch (IOException e) {
            AntLaunching.log(e);
        }
        try {
            if (this.fServerSocket != null) {
                this.fServerSocket.close();
                this.fServerSocket = null;
            }
        }
        catch (IOException e) {
            AntLaunching.log(e);
        }
    }

    protected void receiveMessage(String message) {
        if (message.startsWith("6")) {
            this.receiveTaskMessage(message);
        } else if (message.startsWith("7")) {
            this.receiveTargetMessage(message);
        } else if (message.startsWith("processID")) {
            this.fProcessId = message.substring("processID".length());
        } else {
            int index = message.indexOf(44);
            if (index > 0) {
                int priority = Integer.parseInt(message.substring(0, index));
                String msg = message.substring(index + 1);
                this.writeMessage(String.valueOf(msg) + System.getProperty("line.separator"), priority);
                if (msg.startsWith("BUILD FAILED")) {
                    this.fBuildFailed = true;
                } else if (this.fBuildFailed) {
                    if (msg.startsWith("Total time:")) {
                        this.fBuildFailed = false;
                    } else {
                        AntLaunchingUtil.linkBuildFailedMessage(msg, this.getProcess());
                    }
                }
            }
        }
    }

    private void receiveTargetMessage(String message) {
        String msg = message.substring("7".length());
        StringTokenizer tokenizer = new StringTokenizer(msg, ",");
        msg = tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            int locationLength = Integer.parseInt(tokenizer.nextToken());
            String location = tokenizer.nextToken();
            while (location.length() < locationLength) {
                location = String.valueOf(location) + ",";
                location = String.valueOf(location) + tokenizer.nextToken();
            }
            int lineNumber = Integer.parseInt(tokenizer.nextToken());
            this.generateLink(msg, location, lineNumber, 0, msg.length() - 1);
        }
        this.writeMessage(String.valueOf(msg) + System.getProperty("line.separator"), 2);
    }

    private void receiveTaskMessage(String message) {
        String msg = message.substring("6".length());
        int index = msg.indexOf(44);
        int priority = Integer.parseInt(msg.substring(0, index));
        int index2 = msg.indexOf(44, index + 1);
        String taskName = msg.substring(index + 1, index2);
        if (taskName.length() == 0) {
            taskName = this.fLastTaskName;
        }
        int index3 = msg.indexOf(44, index2 + 1);
        int lineLength = Integer.parseInt(msg.substring(index2 + 1, index3));
        int index4 = index3 + 1 + lineLength;
        String line = msg.substring(index3 + 1, index4);
        StringBuilder labelBuff = new StringBuilder();
        labelBuff.append('[');
        labelBuff.append(taskName);
        labelBuff.append("] ");
        labelBuff.append(line);
        line = labelBuff.toString();
        this.fLastTaskName = taskName;
        int locationIndex = msg.indexOf(44, index4 + 1);
        int finalIndex = locationIndex + 1;
        String fileName = msg.substring(index4 + 1, locationIndex);
        int locationLength = 0;
        if (fileName.length() == 0) {
            fileName = this.fLastFileName;
        } else {
            finalIndex = msg.indexOf(44, locationIndex) + 1;
            locationLength = Integer.parseInt(fileName);
            fileName = msg.substring(finalIndex, finalIndex + locationLength);
            ++locationLength;
        }
        this.fLastFileName = fileName;
        int lineNumber = Integer.parseInt(msg.substring(finalIndex + locationLength));
        int size = 15 - (taskName.length() + 3);
        int offset = Math.max(size - 2, 1);
        int length = 15 - size - 3;
        if (fileName != null) {
            this.generateLink(line, fileName, lineNumber, offset, length);
        }
        StringBuffer fullMessage = new StringBuffer();
        this.adornMessage(taskName, line, fullMessage);
        this.writeMessage(fullMessage.append(System.getProperty("line.separator")).toString(), priority);
    }

    private void generateLink(String line, String fileName, int lineNumber, int offset, int length) {
        if (this.fLaunch != null) {
            ((AntLaunch)this.fLaunch).addLinkDescriptor(line, fileName, lineNumber, offset, length);
        }
    }

    protected IProcess getProcess() {
        if (this.fProcess == null && this.fProcessId != null) {
            IProcess[] all = DebugPlugin.getDefault().getLaunchManager().getProcesses();
            int i = 0;
            while (i < all.length) {
                IProcess process = all[i];
                if (this.fProcessId.equals(process.getAttribute("org.eclipse.ant.core.ANT_PROCESS_ID"))) {
                    this.fProcess = process;
                    break;
                }
                ++i;
            }
        }
        return this.fProcess;
    }

    private AntStreamMonitor getMonitor(int priority) {
        IProcess process = this.getProcess();
        if (process == null) {
            return null;
        }
        AntStreamsProxy proxy = (AntStreamsProxy)process.getStreamsProxy();
        if (proxy == null) {
            return null;
        }
        AntStreamMonitor monitor = null;
        switch (priority) {
            case 2: {
                monitor = (AntStreamMonitor)proxy.getOutputStreamMonitor();
                break;
            }
            case 0: {
                monitor = (AntStreamMonitor)proxy.getErrorStreamMonitor();
                break;
            }
            case 4: {
                monitor = (AntStreamMonitor)proxy.getDebugStreamMonitor();
                break;
            }
            case 1: {
                monitor = (AntStreamMonitor)proxy.getWarningStreamMonitor();
                break;
            }
            case 3: {
                monitor = (AntStreamMonitor)proxy.getVerboseStreamMonitor();
                break;
            }
        }
        return monitor;
    }

    private void adornMessage(String taskName, String line, StringBuffer fullMessage) {
        String tname = taskName;
        if (tname == null) {
            tname = "null";
        }
        int size = 15 - (tname.length() + 6);
        int i = 0;
        while (i < size) {
            fullMessage.append(' ');
            ++i;
        }
        fullMessage.append(line);
    }

    protected void writeMessage(String message, int priority) {
        AntStreamMonitor monitor = this.getMonitor(priority);
        if (monitor == null) {
            if (this.fMessageQueue == null) {
                this.fMessageQueue = new ArrayList<String>();
            }
            this.fMessageQueue.add(message);
            return;
        }
        if (this.fMessageQueue != null) {
            for (String oldMessage : this.fMessageQueue) {
                monitor.append(oldMessage);
            }
            this.fMessageQueue = null;
        }
        monitor.append(message);
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch.equals(this.fLaunch)) {
                this.shutDown();
                return;
            }
            ++i;
        }
    }

    public abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        public void handleException(Throwable exception) {
            AntLaunching.log(exception);
        }
    }

    private class ServerConnection
    extends Thread {
        private int fServerPort;

        public ServerConnection(int port) {
            super("Ant Build Server Connection");
            this.setDaemon(true);
            this.fServerPort = port;
        }

        @Override
        public void run() {
            try {
                String message;
                RemoteAntBuildListener.this.fServerSocket = new ServerSocket(this.fServerPort);
                int socketTimeout = Platform.getPreferencesService().getInt(AntLaunching.getUniqueIdentifier(), "timeout", 20000, null);
                RemoteAntBuildListener.this.fServerSocket.setSoTimeout(socketTimeout);
                RemoteAntBuildListener.this.fSocket = RemoteAntBuildListener.this.fServerSocket.accept();
                RemoteAntBuildListener.this.fBufferedReader = new BufferedReader(new InputStreamReader(RemoteAntBuildListener.this.fSocket.getInputStream(), RemoteAntBuildListener.this.fEncoding));
                while (RemoteAntBuildListener.this.fLaunch != null && !RemoteAntBuildListener.this.fLaunch.isTerminated() && RemoteAntBuildListener.this.fBufferedReader != null && (message = RemoteAntBuildListener.this.fBufferedReader.readLine()) != null) {
                    RemoteAntBuildListener.this.receiveMessage(message);
                }
            }
            catch (SocketException e) {
                AntLaunching.log(e);
            }
            catch (SocketTimeoutException e) {
                AntLaunching.log(e);
            }
            catch (IOException e) {
                AntLaunching.log(e);
            }
            RemoteAntBuildListener.this.shutDown();
        }
    }
}

