/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.image.plugin;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentHandler;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.utils.xml.FileDocumentEditContext;
import org.eclipse.wb.internal.core.utils.xml.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkspacePluginInfo {
    public static final IPath MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");
    public static final IPath PLUGIN_PATH = new Path("plugin.xml");

    public static String getBundleSymbolicName(IProject project) {
        String bundleSymbolicName;
        try {
            Map<String, String> manifest;
            IFile manifestFile = project.getFile(MANIFEST_PATH);
            if (manifestFile.exists() && !StringUtils.isEmpty((String)(bundleSymbolicName = (manifest = WorkspacePluginInfo.parseBundleManifest(manifestFile)).get("Bundle-SymbolicName"))) && !StringUtils.isEmpty((String)(bundleSymbolicName = StringUtils.substringBefore((String)bundleSymbolicName, (String)";").trim()))) {
                return bundleSymbolicName;
            }
        }
        catch (Exception manifestFile) {
            // empty catch block
        }
        try {
            DocumentElement pluginNode;
            IFile pluginFile = project.getFile(MANIFEST_PATH);
            if (pluginFile.exists() && "plugin".equalsIgnoreCase((pluginNode = WorkspacePluginInfo.parsePluginXml(pluginFile)).getTag()) && !StringUtils.isEmpty((String)(bundleSymbolicName = pluginNode.getAttribute("id")))) {
                return bundleSymbolicName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getBundleActivator(IProject project) {
        String bundleActivator;
        try {
            Map<String, String> manifest;
            IFile manifestFile = project.getFile(MANIFEST_PATH);
            if (manifestFile.exists() && !StringUtils.isEmpty((String)(bundleActivator = (manifest = WorkspacePluginInfo.parseBundleManifest(manifestFile)).get("Bundle-Activator")))) {
                return bundleActivator;
            }
        }
        catch (Exception manifestFile) {
            // empty catch block
        }
        try {
            DocumentElement pluginNode;
            IFile pluginFile = project.getFile(MANIFEST_PATH);
            if (pluginFile.exists() && "plugin".equalsIgnoreCase((pluginNode = WorkspacePluginInfo.parsePluginXml(pluginFile)).getTag()) && !StringUtils.isEmpty((String)(bundleActivator = pluginNode.getAttribute("class")))) {
                return bundleActivator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static List<String> getRequiredPlugins(IProject project) {
        try {
            Map<String, String> manifest;
            String requireBundle;
            IFile manifestFile = project.getFile(MANIFEST_PATH);
            if (manifestFile.exists() && !StringUtils.isEmpty((String)(requireBundle = (manifest = WorkspacePluginInfo.parseBundleManifest(manifestFile)).get("Require-Bundle")))) {
                String[] requireBundles = StringUtils.split((String)requireBundle.trim(), (String)",");
                ArrayList<String> result = new ArrayList<String>();
                String[] stringArray = requireBundles;
                int n = requireBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    String bundle = stringArray[n2];
                    if (!StringUtils.isEmpty((String)bundle)) {
                        result.add(bundle);
                    }
                    ++n2;
                }
                return result;
            }
        }
        catch (Exception manifestFile) {
            // empty catch block
        }
        try {
            DocumentElement pluginNode;
            IFile pluginFile = project.getFile(MANIFEST_PATH);
            if (pluginFile.exists() && "plugin".equalsIgnoreCase((pluginNode = WorkspacePluginInfo.parsePluginXml(pluginFile)).getTag())) {
                for (DocumentElement child : pluginNode.getChildren()) {
                    String bundle;
                    if (!"requires".equalsIgnoreCase(child.getTag())) continue;
                    ArrayList<String> result = new ArrayList<String>();
                    Iterator iterator = child.getChildren().iterator();
                    if (!iterator.hasNext()) continue;
                    DocumentElement importNode = (DocumentElement)iterator.next();
                    if ("import".equalsIgnoreCase(importNode.getTag()) && !StringUtils.isEmpty((String)(bundle = importNode.getAttribute("plugin")))) {
                        result.add(bundle);
                    }
                    return result;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static Map<String, String> parseBundleManifest(IFile manifestFile) throws Exception {
        BufferedReader reader;
        HashMap headers = Maps.newHashMap();
        try {
            reader = new BufferedReader(new InputStreamReader(manifestFile.getContents(true), "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            reader = new BufferedReader(new InputStreamReader(manifestFile.getContents(true)));
        }
        try {
            String header = null;
            StringBuffer value = new StringBuffer(256);
            boolean firstLine = true;
            while (true) {
                int colon;
                String line;
                if ((line = reader.readLine()) == null || line.length() == 0) {
                    if (!firstLine) {
                        headers.put(header, value.toString().trim());
                    }
                    break;
                }
                if (line.charAt(0) == ' ') {
                    if (firstLine) {
                        throw new Exception();
                    }
                    value.append(line.substring(1));
                    continue;
                }
                if (!firstLine) {
                    headers.put(header, value.toString().trim());
                    value.setLength(0);
                }
                if ((colon = line.indexOf(58)) == -1) {
                    throw new Exception();
                }
                header = line.substring(0, colon).trim();
                value.append(line.substring(colon + 1));
                firstLine = false;
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return headers;
    }

    private static DocumentElement parsePluginXml(IFile pluginFile) throws Exception {
        FileDocumentEditContext context = new FileDocumentEditContext(pluginFile){

            protected AbstractDocumentHandler createDocumentHandler() {
                return new AbstractDocumentHandler(){

                    protected DocumentElement getDocumentNode(String name, DocumentElement parent) {
                        DocumentElement documentNode = new DocumentElement();
                        if (parent == null) {
                            documentNode.setModel(new Model());
                        }
                        return documentNode;
                    }
                };
            }
        };
        context.disconnect();
        return context.getRoot();
    }
}

