/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.SingleValueExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileMaskedTuple;

public class ExtendToEStructuralFeatureSource
implements IIteratingSearchOperation {
    private final int sourcePosition;
    private final int targetPosition;
    private final EStructuralFeature feature;
    private final IInputKey type;
    private static final TupleMask indexerMask = TupleMask.fromSelectedIndices((int)2, (int[])new int[]{1});
    private final TupleMask mask;

    public ExtendToEStructuralFeatureSource(int sourcePosition, int targetPosition, EStructuralFeature feature, TupleMask mask) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.feature = feature;
        this.mask = mask;
        this.type = new EStructuralFeatureInstancesKey(feature);
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor(this.sourcePosition);
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    " + this.feature.getContainerClass().getSimpleName() + "." + this.feature.getName() + "(-" + variableMapping.apply(this.sourcePosition) + ", +" + variableMapping.apply(this.targetPosition) + ") indexed";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.sourcePosition, this.targetPosition);
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return this.type;
    }

    private class Executor
    extends SingleValueExtendOperationExecutor<EObject> {
        private VolatileMaskedTuple maskedTuple;

        public Executor(int position) {
            super(position);
            this.maskedTuple = new VolatileMaskedTuple(ExtendToEStructuralFeatureSource.this.mask);
        }

        @Override
        public Iterator<EObject> getIterator(MatchingFrame frame, ISearchContext context) {
            this.maskedTuple.updateTuple((ITuple)frame);
            Iterable values = context.getRuntimeContext().enumerateValues(ExtendToEStructuralFeatureSource.this.type, indexerMask, (ITuple)this.maskedTuple);
            return Iterables.filter((Iterable)values, EObject.class).iterator();
        }

        @Override
        public ISearchOperation getOperation() {
            return ExtendToEStructuralFeatureSource.this;
        }
    }
}

