/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.statesystem;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.views.statesystem.Messages;
import org.eclipse.tracecompass.tmf.ui.views.statesystem.StateSystemEvent;
import org.eclipse.tracecompass.tmf.ui.views.statesystem.TmfStateSystemExplorer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

class StateSystemPresentationProvider
extends TimeGraphPresentationProvider {
    public static final int NUM_COLORS = 9;
    private static final StateItem[] STATE_TABLE = new StateItem[10];
    private IPaletteProvider fPalette = new RotatingPaletteProvider.Builder().setNbColors(9).build();

    static {
        StateSystemPresentationProvider.STATE_TABLE[9] = new StateItem(new RGB(192, 192, 192), "UNKNOWN");
    }

    StateSystemPresentationProvider() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public StateItem[] getStateTable() {
        if (STATE_TABLE[0] == null) {
            @NonNull List colors = this.fPalette.get();
            int i = 0;
            while (i < colors.size()) {
                RGBAColor rgbaColor = (RGBAColor)colors.get(i);
                StateSystemPresentationProvider.STATE_TABLE[i] = new StateItem(RGBAUtil.fromInt((int)rgbaColor.toInt()).rgb, rgbaColor.toString());
                ++i;
            }
        }
        return STATE_TABLE;
    }

    @Override
    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof StateSystemEvent) {
            StateSystemEvent stateSystemEvent = (StateSystemEvent)event;
            Object value = stateSystemEvent.getInterval().getValue();
            if (value != null) {
                return Math.floorMod(value.hashCode(), 9);
            }
            return 9;
        }
        if (event.getEntry() instanceof TmfStateSystemExplorer.AttributeEntry) {
            return -2;
        }
        return -1;
    }

    @Override
    public String getEventName(ITimeEvent event) {
        if (event instanceof StateSystemEvent) {
            Object object = ((StateSystemEvent)event).getInterval().getValue();
            return object != null ? object.getClass().getSimpleName() : Messages.TypeNull;
        }
        return null;
    }

    @Override
    public String getStateTypeName(ITimeGraphEntry entry) {
        if (entry instanceof TmfStateSystemExplorer.TraceEntry) {
            return Messages.TraceEntry_StateTypeName;
        }
        if (entry instanceof TmfStateSystemExplorer.ModuleEntry) {
            return Messages.ModuleEntry_StateTypeName;
        }
        if (entry instanceof TmfStateSystemExplorer.StateSystemEntry) {
            return Messages.StateSystemEntry_StateTypeName;
        }
        return Messages.AttributeEntry_StateTypeName;
    }

    @Override
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (event instanceof StateSystemEvent) {
            StateSystemEvent ssEvent = (StateSystemEvent)event;
            TmfStateSystemExplorer.AttributeEntry entry = (TmfStateSystemExplorer.AttributeEntry)event.getEntry();
            Object value = ssEvent.getInterval().getValue();
            if (value != null) {
                retMap.put(Messages.ValueColumnLabel, value.toString());
            }
            int quark = ssEvent.getInterval().getAttribute();
            retMap.put(Messages.QuarkColumnLabel, Integer.toString(quark));
            ITmfStateSystem ss = TmfStateSystemExplorer.getStateSystem(entry);
            if (ss != null) {
                retMap.put(Messages.AttributePathColumnLabel, ss.getFullAttributePath(entry.getQuark()));
            }
        } else if (event instanceof TimeEvent) {
            ITimeGraphEntry entry = event.getEntry();
            if (entry instanceof TmfStateSystemExplorer.StateSystemEntry) {
                TmfStateSystemExplorer.ModuleEntry moduleEntry = (TmfStateSystemExplorer.ModuleEntry)entry.getParent();
                ITmfAnalysisModuleWithStateSystems module = moduleEntry.getModule();
                if (module instanceof TmfAbstractAnalysisModule) {
                    retMap.putAll(((TmfAbstractAnalysisModule)module).getProperties());
                }
            } else if (entry instanceof TmfStateSystemExplorer.ModuleEntry) {
                ITmfAnalysisModuleWithStateSystems module = ((TmfStateSystemExplorer.ModuleEntry)entry).getModule();
                retMap.put(Messages.ModuleHelpText, module.getHelpText());
                retMap.put(Messages.ModuleIsAutomatic, Boolean.toString(module.isAutomatic()));
            }
        }
        return retMap;
    }
}

