/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelTidAspect;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadStatusDataProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.FollowThreadAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowCheckActiveProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowColumnComparators;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowPresentationProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.NaiveOptimizationAlgorithm;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.PackageMessages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.filters.ActiveThreadsFilter;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.filters.DynamicFilterDialog;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.ITimeGraphEntryActiveProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.PlatformUI;

public class ControlFlowView
extends BaseDataProviderTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.views.controlflow";
    private static final String ICONS_PATH = "icons/";
    private static final String OPTIMIZE_ICON = "icons/elcl16/Optimization.png";
    private static final String PROCESS_COLUMN = Messages.ControlFlowView_processColumn;
    private static final String TID_COLUMN = Messages.ControlFlowView_tidColumn;
    private static final String PTID_COLUMN = Messages.ControlFlowView_ptidColumn;
    private static final String BIRTH_TIME_COLUMN = Messages.ControlFlowView_birthTimeColumn;
    private static final String INVISIBLE_COLUMN = Messages.ControlFlowView_invisibleColumn;
    private Action fOptimizationAction;
    private static final String NEXT_EVENT_ICON_PATH = "icons/elcl16/shift_r_edit.gif";
    private static final String PREV_EVENT_ICON_PATH = "icons/elcl16/shift_l_edit.gif";
    private static final String[] COLUMN_NAMES = new String[]{PROCESS_COLUMN, TID_COLUMN, PTID_COLUMN, BIRTH_TIME_COLUMN};
    private static final String[] FILTER_COLUMN_NAMES = new String[]{PROCESS_COLUMN, TID_COLUMN};
    private static final Comparator<ITimeGraphEntry>[] COLUMN_COMPARATORS;
    private static final Function<Collection<ILinkEvent>, Map<Integer, Long>> UPDATE_SCHEDULING_COLUMN_ALGO;
    private static final int INITIAL_SORT_COLUMN_INDEX = 3;
    private final ISchedulingRule fSearchActionMutexRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private final Set<ITmfTrace> fFlatTraces = new HashSet<ITmfTrace>();
    private IAction fFlatAction;
    private IAction fHierarchicalAction;
    private @NonNull ActiveThreadsFilter fActiveThreadsFilter = new ActiveThreadsFilter(null, false, null);
    private final ActiveThreadsFilterAction fActiveThreadsRapidToggle = new ActiveThreadsFilterAction();

    static {
        UPDATE_SCHEDULING_COLUMN_ALGO = new NaiveOptimizationAlgorithm();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)ControlFlowColumnComparators.PROCESS_NAME_COLUMN_COMPARATOR).add((Object)ControlFlowColumnComparators.TID_COLUMN_COMPARATOR).add((Object)ControlFlowColumnComparators.PTID_COLUMN_COMPARATOR).add((Object)ControlFlowColumnComparators.BIRTH_TIME_COLUMN_COMPARATOR);
        ImmutableList l = builder.build();
        COLUMN_COMPARATORS = l.toArray(new Comparator[l.size()]);
    }

    public ControlFlowView() {
        super(ID, (TimeGraphPresentationProvider)new ControlFlowPresentationProvider(), "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadStatusDataProvider");
        this.setTreeColumns(COLUMN_NAMES, COLUMN_COMPARATORS, 3);
        this.setTreeLabelProvider(new ControlFlowTreeLabelProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new ControlFlowFilterLabelProvider());
        this.setEntryComparator((Comparator)ControlFlowColumnComparators.BIRTH_TIME_COLUMN_COMPARATOR);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getTimeGraphViewer().getShowFilterDialogAction().getFilterDialog().addTimeGraphFilterCheckActiveButton((ITimeGraphEntryActiveProvider)new ControlFlowCheckActiveProvider(Messages.ControlFlowView_checkActiveLabel, Messages.ControlFlowView_checkActiveToolTip));
        this.getTimeGraphViewer().getShowFilterDialogAction().getFilterDialog().addTimeGraphFilterUncheckInactiveButton((ITimeGraphEntryActiveProvider)new ControlFlowCheckActiveProvider(Messages.ControlFlowView_uncheckInactiveLabel, Messages.ControlFlowView_uncheckInactiveToolTip));
    }

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
        StructuredSelection sSel;
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof StructuredSelection && (sSel = (StructuredSelection)selection).getFirstElement() instanceof ControlFlowEntry) {
            ControlFlowEntry entry = (ControlFlowEntry)((Object)sSel.getFirstElement());
            menuManager.add((IAction)new FollowThreadAction((TmfView)this, entry.getName(), entry.getThreadId(), ControlFlowView.getTrace((TimeGraphEntry)entry)));
        }
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        IAction optimizationAction = this.getOptimizationAction();
        manager.appendToGroup("additions", optimizationAction);
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        Action hideArrowsAction = this.getTimeGraphViewer().getHideArrowsAction(section);
        manager.appendToGroup("additions", (IAction)hideArrowsAction);
        Action followArrowBwdAction = this.getTimeGraphViewer().getFollowArrowBwdAction();
        followArrowBwdAction.setText(Messages.ControlFlowView_followCPUBwdText);
        followArrowBwdAction.setToolTipText(Messages.ControlFlowView_followCPUBwdText);
        manager.appendToGroup("additions", (IAction)followArrowBwdAction);
        Action followArrowFwdAction = this.getTimeGraphViewer().getFollowArrowFwdAction();
        followArrowFwdAction.setText(Messages.ControlFlowView_followCPUFwdText);
        followArrowFwdAction.setToolTipText(Messages.ControlFlowView_followCPUFwdText);
        manager.appendToGroup("additions", (IAction)followArrowFwdAction);
        SearchEventAction previousEventAction = new SearchEventAction(false, PackageMessages.ControlFlowView_PreviousEventJobName);
        previousEventAction.setText(PackageMessages.ControlFlowView_PreviousEventActionName);
        previousEventAction.setToolTipText(PackageMessages.ControlFlowView_PreviousEventActionTooltip);
        previousEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(PREV_EVENT_ICON_PATH));
        manager.appendToGroup("additions", (IAction)previousEventAction);
        SearchEventAction nextEventAction = new SearchEventAction(true, PackageMessages.ControlFlowView_NextEventJobName);
        nextEventAction.setText(PackageMessages.ControlFlowView_NextEventActionName);
        nextEventAction.setToolTipText(PackageMessages.ControlFlowView_NextEventActionTooltip);
        nextEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(NEXT_EVENT_ICON_PATH));
        manager.appendToGroup("additions", (IAction)nextEventAction);
    }

    private IAction getOptimizationAction() {
        if (this.fOptimizationAction == null) {
            this.fOptimizationAction = new OptimizationAction();
            this.fOptimizationAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(OPTIMIZE_ICON));
            this.fOptimizationAction.setText(Messages.ControlFlowView_optimizeLabel);
            this.fOptimizationAction.setToolTipText(Messages.ControlFlowView_optimizeToolTip);
        }
        return this.fOptimizationAction;
    }

    protected void fillLocalMenu(IMenuManager manager) {
        super.fillLocalMenu(manager);
        MenuManager item = new MenuManager(Messages.ControlFlowView_threadPresentation);
        this.fFlatAction = this.createFlatAction();
        item.add(this.fFlatAction);
        this.fHierarchicalAction = this.createHierarchicalAction();
        item.add(this.fHierarchicalAction);
        manager.add((IContributionItem)item);
        item = new MenuManager(PackageMessages.ControlFlowView_DynamicFiltersMenuLabel);
        item.add((IAction)this.fActiveThreadsRapidToggle);
        item.add((IContributionItem)new Separator());
        IAction dynamicFiltersConfigureAction = this.createDynamicFilterConfigureAction();
        item.add(dynamicFiltersConfigureAction);
        manager.add((IContributionItem)item);
    }

    private IAction createDynamicFilterConfigureAction() {
        return new Action(PackageMessages.ControlFlowView_DynamicFiltersConfigureLabel, 1){

            public void run() {
                DynamicFilterDialog dialog = new DynamicFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ControlFlowView.this.fActiveThreadsFilter, ControlFlowView.this.getTrace());
                if (dialog.open() == 0) {
                    ((TimeGraphViewer)NonNullUtils.checkNotNull((Object)ControlFlowView.this.getTimeGraphViewer())).removeFilter((ViewerFilter)ControlFlowView.this.fActiveThreadsFilter);
                    ActiveThreadsFilter newFilter = dialog.getActiveThreadsResult();
                    ActiveThreadsFilter previousFilter = ControlFlowView.this.fActiveThreadsFilter;
                    ControlFlowView.this.fActiveThreadsFilter = newFilter;
                    boolean enabled = ControlFlowView.this.fActiveThreadsFilter.isEnabled();
                    if (enabled) {
                        ((TimeGraphViewer)NonNullUtils.checkNotNull((Object)ControlFlowView.this.getTimeGraphViewer())).addFilter((ViewerFilter)newFilter);
                    }
                    if (previousFilter.isEnabled() && newFilter.isEnabled()) {
                        boolean changed;
                        boolean bl = changed = !Objects.equals(previousFilter.getCpuRanges(), newFilter.getCpuRanges()) || previousFilter.isCpuRangesBased() != newFilter.isCpuRangesBased();
                        if (changed) {
                            ControlFlowView.this.refresh();
                        }
                    } else {
                        ControlFlowView.this.fActiveThreadsRapidToggle.setChecked(enabled);
                    }
                }
            }
        };
    }

    private IAction createHierarchicalAction() {
        Action action = new Action(Messages.ControlFlowView_hierarchicalViewLabel, 8){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Issues handling annotations - annotations may be inaccurate
             */
            public void run() {
                ITmfTrace parentTrace = ControlFlowView.this.getTrace();
                Set set = ControlFlowView.this.fFlatTraces;
                synchronized (set) {
                    ControlFlowView.this.fFlatTraces.remove(parentTrace);
                    @NonNull List entryList = ControlFlowView.this.getEntryList(parentTrace);
                    if (entryList != null) {
                        for (TimeGraphEntry traceEntry : entryList) {
                            Collection controlFlowEntries = ControlFlowView.this.fEntries.row((Object)ControlFlowView.getProvider((TimeGraphEntry)traceEntry)).values();
                            controlFlowEntries.forEach(e -> e.setParent(null));
                            ControlFlowView.addEntriesToHierarchicalTree(controlFlowEntries, traceEntry);
                        }
                    }
                }
                ControlFlowView.this.refresh();
            }
        };
        action.setChecked(true);
        action.setToolTipText(Messages.ControlFlowView_hierarchicalViewToolTip);
        return action;
    }

    private IAction createFlatAction() {
        Action action = new Action(Messages.ControlFlowView_flatViewLabel, 8){

            public void run() {
                ControlFlowView.this.applyFlatPresentation();
                ControlFlowView.this.refresh();
            }
        };
        action.setChecked(true);
        action.setToolTipText(Messages.ControlFlowView_flatViewToolTip);
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    private void applyFlatPresentation() {
        ITmfTrace parentTrace = this.getTrace();
        Set<ITmfTrace> set = this.fFlatTraces;
        synchronized (set) {
            this.fFlatTraces.add(parentTrace);
            @NonNull List entryList = this.getEntryList(parentTrace);
            if (entryList != null) {
                for (TimeGraphEntry traceEntry : entryList) {
                    Collection<TimeGraphEntry> entries = this.fEntries.row((Object)ControlFlowView.getProvider((TimeGraphEntry)traceEntry)).values();
                    ControlFlowView.addEntriesToFlatTree(entries, traceEntry);
                }
            }
        }
    }

    protected String getNextText() {
        return Messages.ControlFlowView_nextProcessActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ControlFlowView_nextProcessActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ControlFlowView_previousProcessActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ControlFlowView_previousProcessActionToolTipText;
    }

    public Function<Collection<ILinkEvent>, Map<Integer, Long>> getUpdatedSchedulingColumn() {
        return UPDATE_SCHEDULING_COLUMN_ALGO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        ITmfTrace parentTrace = signal.getTrace();
        super.traceClosed(signal);
        Set<ITmfTrace> set = this.fFlatTraces;
        synchronized (set) {
            this.fFlatTraces.remove(parentTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        Set<ITmfTrace> set = this.fFlatTraces;
        synchronized (set) {
            if (this.fFlatTraces.contains(signal.getTrace())) {
                this.fHierarchicalAction.setChecked(false);
                this.fFlatAction.setChecked(true);
            } else {
                this.fFlatAction.setChecked(false);
                this.fHierarchicalAction.setChecked(true);
            }
        }
        ActiveThreadsFilter activeThreadFilter = null;
        ViewerFilter[] traceFilters = (ViewerFilter[])this.getFiltersMap().get(signal.getTrace());
        if (traceFilters != null) {
            activeThreadFilter = ControlFlowView.getActiveThreadsFilter(traceFilters);
        }
        this.fActiveThreadsFilter = activeThreadFilter instanceof ActiveThreadsFilter ? activeThreadFilter : new ActiveThreadsFilter(null, false, this.getTrace());
        this.fActiveThreadsRapidToggle.setChecked(this.fActiveThreadsFilter.isEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void buildEntryList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        ThreadStatusDataProvider dataProvider = (ThreadStatusDataProvider)DataProviderManager.getInstance().getDataProvider(trace, "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadStatusDataProvider", ThreadStatusDataProvider.class);
        if (dataProvider == null) {
            return;
        }
        boolean complete = false;
        BaseDataProviderTimeGraphView.TraceEntry traceEntry = null;
        while (!complete && !monitor.isCanceled()) {
            @NonNull TmfModelResponse response = dataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, Long.MAX_VALUE, 2)), monitor);
            if (response.getStatus() == ITmfResponse.Status.FAILED) {
                Activator.getDefault().logError("Thread Status Data Provider failed: " + response.getStatusMessage());
                return;
            }
            if (response.getStatus() == ITmfResponse.Status.CANCELLED) {
                return;
            }
            complete = response.getStatus() == ITmfResponse.Status.COMPLETED;
            @NonNull TmfTreeModel model = (TmfTreeModel)response.getModel();
            if (model != null && !model.getEntries().isEmpty()) {
                Object entry2;
                Table table = this.fEntries;
                synchronized (table) {
                    for (Object entry2 : model.getEntries()) {
                        if (entry2.getThreadId() != Integer.MIN_VALUE) {
                            if (traceEntry == null) break;
                            TimeGraphEntry e = (TimeGraphEntry)this.fEntries.get((Object)traceEntry.getProvider(), (Object)entry2.getId());
                            if (e != null) {
                                e.updateModel((TimeGraphEntryModel)entry2);
                                continue;
                            }
                            this.fEntries.put((Object)traceEntry.getProvider(), (Object)entry2.getId(), (Object)new ControlFlowEntry((ThreadEntryModel)entry2));
                            continue;
                        }
                        this.setStartTime(Long.min(this.getStartTime(), entry2.getStartTime()));
                        this.setEndTime(Long.max(this.getEndTime(), entry2.getEndTime() + 1L));
                        if (traceEntry != null) {
                            traceEntry.updateModel((TimeGraphEntryModel)entry2);
                            continue;
                        }
                        traceEntry = new BaseDataProviderTimeGraphView.TraceEntry((TimeGraphEntryModel)entry2, trace, (ITimeGraphDataProvider)dataProvider);
                        this.addToEntryList(parentTrace, Collections.singletonList(traceEntry));
                    }
                }
                Objects.requireNonNull(traceEntry, "ControlFlow tree model should have a trace entry with PID=Integer.MIN_VALUE");
                Collection<TimeGraphEntry> controlFlowEntries = this.fEntries.row((Object)ControlFlowView.getProvider(traceEntry)).values();
                entry2 = this.fFlatTraces;
                synchronized (entry2) {
                    if (this.fFlatTraces.contains(parentTrace)) {
                        ControlFlowView.addEntriesToFlatTree(controlFlowEntries, traceEntry);
                    } else {
                        ControlFlowView.addEntriesToHierarchicalTree(controlFlowEntries, traceEntry);
                    }
                }
                Iterable entries = Iterables.filter(controlFlowEntries, TimeGraphEntry.class);
                long resolution = Long.max(1L, (traceEntry.getEndTime() - traceEntry.getStartTime()) / (long)this.getDisplayWidth());
                this.zoomEntries(entries, traceEntry.getStartTime(), traceEntry.getEndTime(), resolution, monitor);
            }
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            if (complete) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError("Failed to wait for analysis to finish", e);
            }
        }
    }

    private static void addEntriesToFlatTree(Collection<@NonNull TimeGraphEntry> entries, TimeGraphEntry traceEntry) {
        traceEntry.clearChildren();
        for (TimeGraphEntry e : entries) {
            e.setParent(null);
            e.clearChildren();
            traceEntry.addChild(e);
        }
    }

    private static void addEntriesToHierarchicalTree(Iterable<TimeGraphEntry> entryList, TimeGraphEntry traceEntry) {
        traceEntry.clearChildren();
        ImmutableMap map = Maps.uniqueIndex(entryList, entry -> entry.getEntryModel().getId());
        for (TimeGraphEntry e : entryList) {
            e.clearChildren();
            e.setParent(null);
        }
        for (TimeGraphEntry entry2 : entryList) {
            TimeGraphEntry parent = (TimeGraphEntry)map.get(entry2.getEntryModel().getParentId());
            if (parent != null) {
                parent.addChild(entry2);
                continue;
            }
            traceEntry.addChild(entry2);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void synchingToTime(long time) {
        List traceEntries = this.getEntryList(this.getTrace());
        if (traceEntries == null) {
            return;
        }
        for (BaseDataProviderTimeGraphView.TraceEntry traceEntry : Iterables.filter((Iterable)traceEntries, BaseDataProviderTimeGraphView.TraceEntry.class)) {
            Iterable unfiltered = Utils.flatten((TimeGraphEntry)traceEntry);
            ImmutableMap map = Maps.uniqueIndex((Iterable)unfiltered, e -> e.getEntryModel().getId());
            SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(time - 1L, time, 2, map.keySet());
            @NonNull TmfModelResponse response = traceEntry.getProvider().fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter), null);
            TimeGraphModel model = (TimeGraphModel)response.getModel();
            if (model == null) continue;
            for (ITimeGraphRowModel row : model.getRows()) {
                if (!this.syncToRow(row, time, (Map<Long, TimeGraphEntry>)map)) continue;
                return;
            }
        }
    }

    protected void zoomEntries(@NonNull Iterable<@NonNull TimeGraphEntry> entries, long zoomStartTime, long zoomEndTime, long resolution, @NonNull IProgressMonitor monitor) {
        super.zoomEntries(entries, zoomStartTime, zoomEndTime, resolution, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        Map<ITmfTrace, Set<Long>> data = this.fActiveThreadsFilter.computeData(zoomStartTime, zoomEndTime);
        if (data != null) {
            this.applyResults(() -> this.fActiveThreadsFilter.updateData(zoomStartTime, zoomEndTime, data));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean syncToRow(ITimeGraphRowModel rowModel, long time, Map<Long, TimeGraphEntry> entryMap) {
        TimeGraphEntry entry;
        long id = rowModel.getEntryID();
        @NonNull List list = rowModel.getStates();
        if (list.isEmpty()) {
            return false;
        }
        ITimeGraphState event = (ITimeGraphState)list.get(0);
        if (event.getStartTime() + event.getDuration() <= time && list.size() > 1) {
            event = (ITimeGraphState)list.get(1);
        }
        if (time == event.getStartTime() && (entry = entryMap.get(id)) != null) {
            this.getTimeGraphViewer().setSelection((ISelection)entry, true);
            return true;
        }
        return false;
    }

    private static ActiveThreadsFilter getActiveThreadsFilter(ViewerFilter[] filters) {
        ViewerFilter[] viewerFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter viewerFilter = viewerFilterArray[n2];
            if (viewerFilter instanceof ActiveThreadsFilter) {
                return (ActiveThreadsFilter)viewerFilter;
            }
            ++n2;
        }
        return null;
    }

    class ActiveThreadsFilterAction
    extends Action {
        public ActiveThreadsFilterAction() {
            super(PackageMessages.ControlFlowView_DynamicFiltersActiveThreadToggleLabel, 2);
            this.setToolTipText(PackageMessages.ControlFlowView_DynamicFiltersActiveThreadToggleToolTip);
            this.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (!(event.getNewValue() instanceof Boolean)) {
                        return;
                    }
                    Boolean enabled = (Boolean)event.getNewValue();
                    ControlFlowView.this.getTimeGraphViewer().removeFilter((ViewerFilter)ControlFlowView.this.fActiveThreadsFilter);
                    if (enabled.booleanValue()) {
                        ControlFlowView.this.fActiveThreadsFilter.setEnabled(true);
                        ControlFlowView.this.getTimeGraphViewer().addFilter((ViewerFilter)ControlFlowView.this.fActiveThreadsFilter);
                        if (ControlFlowView.this.fFlatAction != null) {
                            ControlFlowView.this.applyFlatPresentation();
                            ControlFlowView.this.fFlatAction.setChecked(true);
                            ControlFlowView.this.fHierarchicalAction.setChecked(false);
                        }
                    } else {
                        ControlFlowView.this.fActiveThreadsFilter.setEnabled(false);
                    }
                    ControlFlowView.this.startZoomThread(ControlFlowView.this.getTimeGraphViewer().getTime0(), ControlFlowView.this.getTimeGraphViewer().getTime1());
                }
            });
        }
    }

    private static class ControlFlowFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private ControlFlowFilterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof TimeGraphEntry) {
                return ((TimeGraphEntry)element).getName();
            }
            if (columnIndex == 1 && element instanceof ControlFlowEntry) {
                return Integer.toString(((ControlFlowEntry)((Object)element)).getThreadId());
            }
            return "";
        }
    }

    protected static class ControlFlowTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        protected ControlFlowTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof TimeGraphEntry) {
                return ((TimeGraphEntry)element).getName();
            }
            if (element instanceof ControlFlowEntry) {
                ControlFlowEntry entry = (ControlFlowEntry)((Object)element);
                if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_tidColumn)) {
                    return Integer.toString(entry.getThreadId());
                }
                if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_ptidColumn)) {
                    if (entry.getParentThreadId() > 0) {
                        return Integer.toString(entry.getParentThreadId());
                    }
                } else {
                    if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_birthTimeColumn)) {
                        return FormatTimeUtils.formatTime((long)entry.getStartTime(), (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.CALENDAR, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC);
                    }
                    if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_traceColumn)) {
                        return ControlFlowView.getTrace((TimeGraphEntry)entry).getName();
                    }
                    if (COLUMN_NAMES[columnIndex].equals(INVISIBLE_COLUMN)) {
                        return Long.toString(entry.getSchedulingPosition());
                    }
                }
            }
            return "";
        }
    }

    private final class OptimizationAction
    extends Action {
        private OptimizationAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runWithEvent(Event event) {
            ITmfTrace parentTrace = ControlFlowView.this.getTrace();
            if (parentTrace == null) {
                return;
            }
            ControlFlowView.this.createFlatAction().run();
            List arrows = ControlFlowView.this.getTimeGraphViewer().getTimeGraphControl().getArrows();
            List currentList = ControlFlowView.this.getEntryList(parentTrace);
            if (currentList == null) {
                return;
            }
            Map<Integer, Long> orderedTidMap = ControlFlowView.this.getUpdatedSchedulingColumn().apply(arrows);
            Table table = ControlFlowView.this.fEntries;
            synchronized (table) {
                for (TimeGraphEntry entry : currentList) {
                    Collection controlFlowEntries = ControlFlowView.this.fEntries.row((Object)ControlFlowView.getProvider((TimeGraphEntry)entry)).values();
                    for (TimeGraphEntry child : controlFlowEntries) {
                        ControlFlowEntry controlFlowEntry = (ControlFlowEntry)child;
                        controlFlowEntry.setSchedulingPosition(orderedTidMap.getOrDefault(controlFlowEntry.getThreadId(), Long.MAX_VALUE));
                    }
                }
            }
            ControlFlowView.this.setEntryComparator((Comparator)ControlFlowColumnComparators.SCHEDULING_COLUMN_COMPARATOR);
            ControlFlowView.this.refresh();
        }
    }

    private class SearchEventAction
    extends Action {
        private final boolean ifDirection;
        private final String ifJobName;

        public SearchEventAction(boolean direction, String jobName) {
            this.ifDirection = direction;
            this.ifJobName = jobName;
        }

        public void run() {
            Job job = new Job(this.ifJobName){

                protected IStatus run(IProgressMonitor monitor) {
                    ITmfEvent event2;
                    long ts;
                    TimeGraphControl ctrl = ControlFlowView.this.getTimeGraphViewer().getTimeGraphControl();
                    ITimeGraphEntry traceEntry = ctrl.getSelectedTrace();
                    ITimeEvent selectedState = Utils.findEvent((ITimeGraphEntry)traceEntry, (long)(ts = ControlFlowView.this.getTimeGraphViewer().getSelectionBegin()), (int)0);
                    if (selectedState == null) {
                        return Status.OK_STATUS;
                    }
                    ITimeGraphEntry entry = selectedState.getEntry();
                    if (!(entry instanceof ControlFlowEntry)) {
                        return Status.OK_STATUS;
                    }
                    ControlFlowEntry cfEntry = (ControlFlowEntry)entry;
                    int tid = cfEntry.getThreadId();
                    ITmfTrace trace = ControlFlowView.getTrace((TimeGraphEntry)cfEntry);
                    ITmfContext ctx = trace.seekEvent(TmfTimestamp.fromNanos((long)ts));
                    long rank = ctx.getRank();
                    ctx.dispose();
                    Predicate<@NonNull ITmfEvent> predicate = event -> Objects.equals(tid, KernelTidAspect.INSTANCE.resolve(event));
                    ITmfEvent iTmfEvent = event2 = SearchEventAction.this.ifDirection ? TmfTraceUtils.getNextEventMatching((ITmfTrace)trace, (long)rank, predicate, (IProgressMonitor)monitor) : TmfTraceUtils.getPreviousEventMatching((ITmfTrace)trace, (long)rank, predicate, (IProgressMonitor)monitor);
                    if (event2 != null) {
                        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, event2.getTimestamp(), event2.getTimestamp(), ControlFlowView.this.getTrace()));
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule(ControlFlowView.this.fSearchActionMutexRule);
            job.schedule();
        }
    }
}

