/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.model.RemoteContentProvider;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteLogOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteOperation;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoriesView;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.IWorkbenchPart;

public class FetchAllMembersOperation
extends RemoteOperation {
    static final String DEAD_STATE = "dead";
    ICVSRepositoryLocation repoLocation;

    public FetchAllMembersOperation(IWorkbenchPart part, ICVSRemoteResource[] folders, ICVSRepositoryLocation repoLocation) {
        super(part, folders);
        this.repoLocation = repoLocation;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        ICVSRemoteResource[] restest = this.getRemoteResources();
        ICVSRemoteFolder testfolder = (ICVSRemoteFolder)restest[0];
        CVSTag tag = testfolder.getTag();
        if (tag == null) {
            tag = CVSTag.DEFAULT;
        }
        RemoteLogOperation.LogEntryCache cache = new RemoteLogOperation.LogEntryCache();
        RemoteLogOperation operation = new RemoteLogOperation(this.getPart(), this.getRemoteResources(), tag, null, cache);
        try {
            operation.run(monitor);
            ICVSRemoteResource[] remoteRes = this.getRemoteResources();
            ICVSRemoteFolder project = (ICVSRemoteFolder)remoteRes[0];
            String[] entry = cache.getCachedFilePaths();
            RLogTreeBuilder treeBuilder = new RLogTreeBuilder(project.getRepository(), tag);
            int i = 0;
            while (i < entry.length) {
                ILogEntry[] logEntry = cache.getLogEntries(entry[i]);
                if (logEntry[0].getState() == null || !logEntry[0].getState().equals(DEAD_STATE)) {
                    Path logPath;
                    ICVSRemoteFile remoteFile = logEntry[0].getRemoteFile();
                    if (tag.getType() == 1 && remoteFile.getRevision().equals("branchRevision")) {
                        this.verifyRevision(tag, logEntry[0], remoteFile);
                    }
                    if ((logPath = new Path(null, remoteFile.getRepositoryRelativePath())).segmentCount() > 0) {
                        logPath = logPath.removeFirstSegments(1);
                    }
                    treeBuilder.newFile((IPath)logPath, remoteFile);
                }
                ++i;
            }
            RemoteFolderTree remoteTree = treeBuilder.getTree();
            IWorkbenchPart part = this.getPart();
            if (part instanceof RepositoriesView) {
                RepositoriesView repView = (RepositoriesView)part;
                RemoteContentProvider prov = repView.getContentProvider();
                prov.addCachedTree(project, remoteTree);
                TreeViewer tree = repView.getViewer();
                Utils.asyncExec(() -> tree.expandToLevel((Object)project, -1), (StructuredViewer)repView.getViewer());
            }
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
    }

    private void verifyRevision(CVSTag tag, ILogEntry entry, ICVSRemoteFile remoteFile) throws CVSException {
        if (entry instanceof LogEntry) {
            LogEntry logEntry = (LogEntry)entry;
            String[] allBranchRevisions = logEntry.getBranchRevisions();
            CVSTag[] allCVSTags = entry.getTags();
            int i = 0;
            while (i < allCVSTags.length) {
                if (allCVSTags[i].equals((Object)tag)) {
                    ((RemoteFile)remoteFile).setRevision(allBranchRevisions[i]);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    protected String getTaskName() {
        return CVSUIMessages.FetchAllMembersOperation_0;
    }

    class RLogTreeBuilder {
        private ICVSRepositoryLocation location;
        private RemoteFolderTree tree;
        private CVSTag tag;

        public RLogTreeBuilder(ICVSRepositoryLocation location, CVSTag tag) {
            this.tag = tag;
            this.location = location;
            this.reset();
        }

        public RemoteFolderTree getTree() {
            return this.tree;
        }

        public void reset() {
            this.tree = new RemoteFolderTree(null, this.location, "", this.tag);
            this.tree.setChildren(new ICVSRemoteResource[0]);
        }

        public void newFile(IPath remoteFilePath, ICVSRemoteFile remoteFile) {
            try {
                this.addFile(this.tree, this.tag, remoteFile, remoteFilePath);
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }

        private void addFile(RemoteFolderTree tree, CVSTag tag, ICVSRemoteFile file, IPath filePath) throws CVSException {
            RemoteFolderTree parent = (RemoteFolderTree)this.getFolder(tree, tag, filePath.removeLastSegments(1), (IPath)Path.EMPTY);
            this.addChild(parent, (ICVSRemoteResource)file);
        }

        private void addChild(RemoteFolderTree tree, ICVSRemoteResource resource) {
            ICVSRemoteResource[] newChildren;
            ICVSRemoteResource[] children = tree.getChildren();
            if (children == null) {
                newChildren = new ICVSRemoteResource[]{resource};
            } else {
                newChildren = new ICVSRemoteResource[children.length + 1];
                System.arraycopy(children, 0, newChildren, 0, children.length);
                newChildren[children.length] = resource;
            }
            tree.setChildren(newChildren);
        }

        private ICVSRemoteFolder getFolder(RemoteFolderTree tree, CVSTag tag, IPath remoteFolderPath, IPath parentPath) throws CVSException {
            ICVSResource child;
            if (remoteFolderPath.segmentCount() == 0) {
                return tree;
            }
            String name = remoteFolderPath.segment(0);
            IPath childPath = parentPath.append(name);
            if (tree.childExists(name)) {
                child = tree.getChild(name);
            } else {
                child = new RemoteFolderTree((RemoteFolder)tree, tree.getRepository(), childPath.toString(), tag);
                ((RemoteFolderTree)child).setChildren(new ICVSRemoteResource[0]);
                this.addChild(tree, (ICVSRemoteResource)child);
            }
            return this.getFolder((RemoteFolderTree)child, tag, remoteFolderPath.removeFirstSegments(1), childPath);
        }
    }
}

