/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.helper.layers.LayerService;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.tool.ToolGroup;
import org.eclipse.sirius.diagram.description.tool.ToolGroupExtension;
import org.eclipse.sirius.diagram.description.tool.ToolSection;
import org.eclipse.sirius.diagram.tools.api.management.ToolChangeListener;
import org.eclipse.sirius.diagram.tools.api.management.ToolFilter;
import org.eclipse.sirius.diagram.tools.api.management.ToolFilterFromDescription;
import org.eclipse.sirius.diagram.tools.internal.management.ToolFilterDescriptionListenersManager;
import org.eclipse.sirius.viewpoint.ToolGroupInstance;
import org.eclipse.sirius.viewpoint.ToolInstance;
import org.eclipse.sirius.viewpoint.ToolSectionInstance;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.description.Environment;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolEntry;
import org.eclipse.sirius.viewpoint.description.tool.ToolFilterDescription;

public class ToolManagement {
    private Set<ToolFilter> filters = new LinkedHashSet<ToolFilter>();
    private List<Layer> activatedLayersOfSelectedViewpoints;
    private List<Layer> deactivatedLayersAndAllLayersOfDeselectedViewpoints;
    private DDiagram dDiagram;
    private ToolFilterDescriptionListenersManager listenersManager;
    private Set<ToolChangeListener> toolChangeListeners;

    public ToolManagement(DDiagram dDiagram) {
        this.dDiagram = dDiagram;
        this.listenersManager = new ToolFilterDescriptionListenersManager();
        this.listenersManager.init(dDiagram);
        this.toolChangeListeners = new HashSet<ToolChangeListener>();
    }

    public void addToolChangeListener(ToolChangeListener toolChangeListener) {
        this.toolChangeListeners.add(toolChangeListener);
    }

    public Set<ToolChangeListener> getToolListeners() {
        return this.toolChangeListeners;
    }

    public boolean removeToolChangeListener(ToolChangeListener toolChangeListener) {
        return this.toolChangeListeners.remove(toolChangeListener);
    }

    public List<Layer> getActivatedLayersOfSelectedViewpoints() {
        return this.activatedLayersOfSelectedViewpoints;
    }

    public void notifyToolChangeAfterVSMReload() {
        Set<ToolChangeListener> toolListeners = this.getToolListeners();
        for (ToolChangeListener toolChangeListener : toolListeners) {
            toolChangeListener.notifyToolChange(ToolChangeListener.ChangeKind.VSM_UPDATE);
        }
    }

    public void notifyToolChange() {
        Set<ToolChangeListener> toolListeners = this.getToolListeners();
        for (ToolChangeListener toolChangeListener : toolListeners) {
            toolChangeListener.notifyToolChange(ToolChangeListener.ChangeKind.OTHER_UPDATE);
        }
    }

    public List<Layer> getDeactivatedLayersAndAllLayersOfDeselectedViewpoints() {
        return this.deactivatedLayersAndAllLayersOfDeselectedViewpoints;
    }

    public List<ToolSectionInstance> updateTools(boolean updateFilters) {
        Session session = null;
        if (updateFilters) {
            this.clearFilters();
        }
        if (this.dDiagram instanceof DSemanticDiagram) {
            session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)this.dDiagram).getTarget());
        }
        return this.computeAvailableTools(session, updateFilters);
    }

    public void clearFilters() {
        this.listenersManager.init(this.dDiagram);
        ArrayList filtersCopy = Lists.newArrayList(this.filters);
        for (ToolFilter filter : filtersCopy) {
            if (!(filter instanceof ToolFilterFromDescription)) continue;
            this.removeToolFilter(filter);
        }
    }

    public void removeToolFilter(ToolFilter toolFilter) {
        this.filters.remove(toolFilter);
    }

    private List<ToolSectionInstance> computeAvailableTools(Session session, boolean updateFilters) {
        this.dDiagram.getUiState().getToolSections().clear();
        ToolSectionInstance defaultToolSection = ViewpointFactory.eINSTANCE.createToolSectionInstance();
        this.dDiagram.getUiState().getToolSections().add((Object)defaultToolSection);
        defaultToolSection.setId("defaultSectionId");
        this.addToolById("selectionTool", defaultToolSection);
        this.addToolById("zoomInTool", defaultToolSection);
        this.addToolById("zoomOutTool", defaultToolSection);
        this.addToolById("noteTool", defaultToolSection);
        this.addToolById("textTool", defaultToolSection);
        this.addToolById("noteattachmentTool", defaultToolSection);
        this.addToolById("GenericConnectionCreationTool", defaultToolSection);
        List<ToolEntry> defaultTools = this.getDefaultTools(TransactionUtil.getEditingDomain((EObject)this.dDiagram).getResourceSet());
        for (ToolEntry toolEntry : defaultTools) {
            this.addNewTool(defaultToolSection, toolEntry, true);
        }
        this.addVSMTools(session, updateFilters);
        return this.dDiagram.getUiState().getToolSections();
    }

    private void addToolById(String id, ToolSectionInstance defaultToolSection) {
        ToolInstance tool = ViewpointFactory.eINSTANCE.createToolInstance();
        tool.setId(id);
        tool.setVisible(true);
        tool.setEnabled(true);
        defaultToolSection.getTools().add((Object)tool);
    }

    private ToolInstance addNewTool(ToolSectionInstance toolSectionParent, ToolEntry toolEntry, boolean useNameAsId) {
        ToolInstance newToolInstance = this.createNewTool(toolEntry, useNameAsId);
        toolSectionParent.getTools().add((Object)newToolInstance);
        return newToolInstance;
    }

    private ToolInstance createNewTool(ToolEntry toolEntry, boolean useNameAsId) {
        ToolInstance newToolInstance = ViewpointFactory.eINSTANCE.createToolInstance();
        if (useNameAsId) {
            newToolInstance.setId(toolEntry.getName());
        } else {
            newToolInstance.setId(ToolManagement.getId((EObject)toolEntry));
        }
        newToolInstance.setVisible(true);
        newToolInstance.setEnabled(true);
        newToolInstance.setToolEntry(toolEntry);
        if (toolEntry instanceof AbstractToolDescription && this.isFiltered((AbstractToolDescription)toolEntry)) {
            newToolInstance.setFiltered(true);
        }
        return newToolInstance;
    }

    public void addToolFilter(ToolFilter toolFilter) {
        this.filters.add(toolFilter);
    }

    public static String getId(EObject entry) {
        return EcoreUtil.getURI((EObject)entry).toString();
    }

    private void addVSMToolsForDiagramWithoutLayer(Session session, boolean updateFilters) {
        ToolSection toolSection;
        DiagramDescription diagramDescription = this.dDiagram.getDescription();
        if (updateFilters) {
            this.updateFilters(session, (List<? extends ToolEntry>)diagramDescription.getAllTools());
        }
        if ((toolSection = diagramDescription.getToolSection()) != null) {
            this.initToolSection(toolSection);
        }
    }

    private void initToolSection(ToolSection toolSection) {
        ToolSectionInstance newToolSectionInstance = ViewpointFactory.eINSTANCE.createToolSectionInstance();
        newToolSectionInstance.setId(ToolManagement.getId((EObject)toolSection));
        newToolSectionInstance.setSection((EObject)newToolSectionInstance);
        this.dDiagram.getUiState().getToolSections().add((Object)newToolSectionInstance);
        newToolSectionInstance.getTools().addAll((Collection)toolSection.getOwnedTools().stream().map(ts -> this.createNewTool((ToolEntry)ts, false)).collect(Collectors.toSet()));
        newToolSectionInstance.getTools().addAll((Collection)toolSection.getReusedTools().stream().map(ts -> this.createNewTool((ToolEntry)ts, false)).collect(Collectors.toSet()));
        EList<ToolGroupExtension> groupExtensions = toolSection.getGroupExtensions();
        for (ToolGroupExtension toolGroupExtension : groupExtensions) {
            ToolGroup group = toolGroupExtension.getGroup();
            ToolGroupInstance newToolGroupInstance = ViewpointFactory.eINSTANCE.createToolGroupInstance();
            newToolGroupInstance.setId(group.getName());
            newToolGroupInstance.setGroup((EObject)newToolGroupInstance);
            newToolGroupInstance.getTools().addAll((Collection)group.getTools().stream().map(ts -> this.createNewTool((ToolEntry)ts, false)).collect(Collectors.toSet()));
            newToolSectionInstance.getTools().add((Object)newToolGroupInstance);
        }
        EList<ToolSection> subSections = toolSection.getSubSections();
        for (ToolSection subToolSection : subSections) {
            this.initToolSection(subToolSection);
        }
    }

    private void addVSMToolsForDiagramWithLayer(Session session, boolean updateFilters) {
        HashMap<String, ArrayList<ToolInstance>> idToTool = new HashMap<String, ArrayList<ToolInstance>>();
        HashSet<Layer> layersInActivatedViewpoints = new HashSet<Layer>((Collection<Layer>)new DiagramComponentizationManager().getAllLayers(session.getSelectedViewpoints(false), this.dDiagram.getDescription()));
        HashSet<Layer> activatedLayers = new HashSet<Layer>(new DDiagramQuery(this.dDiagram).getAllActivatedLayers());
        this.activatedLayersOfSelectedViewpoints = Lists.newArrayList((Iterable)Sets.intersection(layersInActivatedViewpoints, activatedLayers));
        this.deactivatedLayersAndAllLayersOfDeselectedViewpoints = Lists.newArrayList((Iterable)Sets.symmetricDifference(layersInActivatedViewpoints, activatedLayers));
        HashMap<String, ToolSectionInstance> idToToolSection = new HashMap<String, ToolSectionInstance>();
        for (ToolSection section : new DiagramComponentizationManager().getRootPaletteSections(session.getSelectedViewpoints(false), this.dDiagram.getDescription())) {
            if (updateFilters) {
                this.updateFilters(session, (List<? extends ToolEntry>)new DiagramComponentizationManager().getAllToolEntries(session.getSelectedViewpoints(false), section));
            }
            ToolSectionInstance newToolSectionInstance = ViewpointFactory.eINSTANCE.createToolSectionInstance();
            String id = ToolManagement.getId((EObject)section);
            newToolSectionInstance.setId(id);
            idToToolSection.put(id, newToolSectionInstance);
            newToolSectionInstance.setSection((EObject)section);
            this.dDiagram.getUiState().getToolSections().add((Object)newToolSectionInstance);
            EList<ToolEntry> allToolEntries = new DiagramComponentizationManager().getAllToolEntries(session.getSelectedViewpoints(false), section);
            for (ToolEntry toolEntry : allToolEntries) {
                if (toolEntry instanceof ToolGroup) {
                    ToolGroupInstance newToolGroupInstance = ViewpointFactory.eINSTANCE.createToolGroupInstance();
                    newToolGroupInstance.setId(ToolManagement.getId((EObject)toolEntry));
                    newToolGroupInstance.setGroup((EObject)newToolGroupInstance);
                    newToolGroupInstance.setToolEntry(toolEntry);
                    newToolGroupInstance.getTools().addAll((Collection)new DiagramComponentizationManager().getTools(session.getSelectedViewpoints(false), (ToolGroup)toolEntry).stream().map(ts -> {
                        ToolInstance tool = this.createNewTool((ToolEntry)ts, false);
                        return tool;
                    }).collect(Collectors.toCollection(LinkedHashSet::new)));
                    newToolSectionInstance.getTools().add((Object)newToolGroupInstance);
                    continue;
                }
                ToolInstance newToolInstance = this.createNewTool(toolEntry, false);
                newToolSectionInstance.getTools().add((Object)newToolInstance);
                ArrayList<ToolInstance> tools = (ArrayList<ToolInstance>)idToTool.get(newToolInstance.getId());
                if (tools == null) {
                    tools = new ArrayList<ToolInstance>();
                    idToTool.put(newToolInstance.getId(), tools);
                }
                tools.add(newToolInstance);
            }
        }
        for (Layer layer : Lists.newArrayList(this.deactivatedLayersAndAllLayersOfDeselectedViewpoints)) {
            EList<ToolSection> toolSections = layer.getToolSections();
            for (ToolSection toolSection : toolSections) {
                ToolSectionInstance toolSectionInstance = (ToolSectionInstance)idToToolSection.get(ToolManagement.getId((EObject)toolSection));
                if (toolSectionInstance == null) continue;
                toolSectionInstance.setVisible(false);
            }
        }
    }

    private void addVSMTools(Session session, boolean updateFilters) {
        if (LayerService.withoutLayersMode(this.dDiagram.getDescription())) {
            this.addVSMToolsForDiagramWithoutLayer(session, updateFilters);
        } else {
            this.addVSMToolsForDiagramWithLayer(session, updateFilters);
        }
    }

    private boolean isFiltered(AbstractToolDescription toolDescription) {
        for (ToolFilter filter : this.filters) {
            if (!filter.filter(this.dDiagram, toolDescription)) continue;
            return true;
        }
        return false;
    }

    private void updateFilters(Session session, List<? extends ToolEntry> toolEntries) {
        IInterpreter interpreter;
        if (session != null && (interpreter = session.getInterpreter()) != null) {
            for (ToolEntry toolEntry : toolEntries) {
                if (toolEntry instanceof AbstractToolDescription) {
                    for (ToolFilterDescription filterDescription : ((AbstractToolDescription)toolEntry).getFilters()) {
                        ToolFilterFromDescription filter = new ToolFilterFromDescription(interpreter, filterDescription);
                        this.filters.add(filter);
                    }
                    this.listenersManager.addListenersForFilters(interpreter, (Collection<ToolFilterDescription>)((AbstractToolDescription)toolEntry).getFilters());
                    continue;
                }
                if (!(toolEntry instanceof ToolGroup)) continue;
                this.updateFilters(session, (List<? extends ToolEntry>)new DiagramComponentizationManager().getTools(session.getSelectedViewpoints(false), (ToolGroup)toolEntry));
            }
        }
    }

    private List<ToolEntry> getDefaultTools(ResourceSet context) {
        Resource coreEnvResource = context.getResource(URI.createURI((String)"environment:/viewpoint", (boolean)true), true);
        Environment coreEnv = (Environment)coreEnvResource.getContents().get(0);
        Resource diagramEnvResource = context.getResource(URI.createURI((String)"environment:/diagram", (boolean)true), true);
        Environment diagramEnv = (Environment)diagramEnvResource.getContents().get(0);
        ArrayList<ToolEntry> defaultTools = new ArrayList<ToolEntry>();
        defaultTools.addAll((Collection<ToolEntry>)coreEnv.getDefaultTools());
        defaultTools.addAll((Collection<ToolEntry>)diagramEnv.getDefaultTools());
        return defaultTools;
    }
}

