/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.sync;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.collect.MultipleCollection;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public abstract class AbstractSynchronizerHelper {
    protected final DSemanticDiagram diagram;
    protected ModelAccessor accessor;
    protected final IInterpreter interpreter;
    protected Session session;
    protected DDiagramSynchronizer sync;
    protected boolean tool;
    private Multimap<String, EObject> candidatesMap = LinkedHashMultimap.create();

    public AbstractSynchronizerHelper(DDiagramSynchronizer sync, DSemanticDiagram diagram, ModelAccessor accessor) {
        this.diagram = diagram;
        this.accessor = accessor;
        this.session = new EObjectQuery(diagram.getTarget()).getSession();
        if (this.session == null) {
            this.session = new EObjectQuery((EObject)diagram).getSession();
        }
        this.interpreter = this.session != null ? this.session.getInterpreter() : InterpreterUtil.getInterpreter((EObject)diagram.getTarget());
        this.sync = sync;
        this.tool = false;
    }

    protected Collection<EObject> evaluateCandidateExpression(DragAndDropTarget container, DiagramElementMapping mapping) {
        return new DiagramElementMappingQuery(mapping).evaluateCandidateExpression(this.diagram, this.interpreter, container);
    }

    protected Collection<EObject> getAllCandidates(DiagramElementMapping mapping) {
        MultipleCollection semantics = new MultipleCollection();
        Option<String> domainClass = new DiagramElementMappingQuery(mapping).getDomainClass();
        if (domainClass.some()) {
            if (this.candidatesMap.containsKey(domainClass.get())) {
                semantics.addAll(this.candidatesMap.get((Object)((String)domainClass.get())));
            } else {
                for (Resource resource : this.session.getSemanticResources()) {
                    for (EObject root : resource.getContents()) {
                        semantics.addAll(this.accessor.eAllContents(root, (String)domainClass.get()));
                    }
                }
                this.candidatesMap.putAll((Object)((String)domainClass.get()), (Iterable)semantics);
            }
        }
        return semantics;
    }

    protected Collection<EObject> getPreviousSemanticsElements(DragAndDropTarget container, DiagramElementMapping mapping) {
        return ImmutableSet.copyOf((Collection)this.sync.getPreviousDiagramElements(container, mapping).stream().map(DSemanticDecorator::getTarget).filter(input -> input != null && (input.eContainer() != null && input.eContainer().eResource() != null || input.eResource() != null)).collect(Collectors.toSet()));
    }

    protected Iterable<EObject> getSemanticCandidates(DragAndDropTarget container, DiagramElementMapping mapping) {
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.GET_NODE_CANDIDATES_KEY);
        Iterable semantics = new ArrayList();
        boolean synchronizedAndCreateElement = new DiagramElementMappingQuery(mapping).isSynchronizedAndCreateElement(this.diagram);
        boolean bl = synchronizedAndCreateElement = this.tool || synchronizedAndCreateElement;
        if (new DiagramElementMappingQuery(mapping).hasCandidatesExpression()) {
            Collection<EObject> allCandidates = this.evaluateCandidateExpression(container, mapping);
            if (synchronizedAndCreateElement) {
                Option<String> domainClassOption = new DiagramElementMappingQuery(mapping).getDomainClass();
                if (domainClassOption.some()) {
                    semantics = Iterables.concat(semantics, (Iterable)Iterables.filter(allCandidates, input -> this.accessor.eInstanceOf(input, (String)domainClassOption.get())));
                }
            } else {
                this.sync.forceRetrieve();
                Collection<EObject> previousSemanticsElements = this.getPreviousSemanticsElements(container, mapping);
                this.sync.resetforceRetrieve();
                ImmutableSet keeped = ImmutableSet.copyOf((Collection)Collections2.filter(previousSemanticsElements, allCandidates::contains));
                semantics = Iterables.concat(semantics, (Iterable)keeped);
            }
        } else if (synchronizedAndCreateElement) {
            semantics = Iterables.concat(semantics, this.getAllCandidates(mapping));
        } else {
            this.sync.forceRetrieve();
            semantics = Iterables.concat(semantics, this.getPreviousSemanticsElements(container, mapping));
            this.sync.resetforceRetrieve();
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.GET_NODE_CANDIDATES_KEY);
        return semantics;
    }

    public void setTool(boolean b) {
        this.tool = b;
    }
}

