/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractSimplePartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.BasicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class LocalPredicatePartitionFactory
extends AbstractSimplePartitionFactory {
    protected final boolean useActivators;
    private final @NonNull Iterable<@NonNull Node> executionNodes;
    private final @NonNull Iterable<@NonNull Node> realizedWhenNodes;
    private final @Nullable Node dispatchNode;

    public LocalPredicatePartitionFactory(@NonNull MappingPartitioner mappingPartitioner, boolean useActivators) {
        super(mappingPartitioner);
        this.executionNodes = mappingPartitioner.getExecutionNodes();
        this.useActivators = useActivators;
        this.realizedWhenNodes = mappingPartitioner.getRealizedWhenNodes();
        this.dispatchNode = mappingPartitioner.basicGetDispatchNode();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull BasicPartitionAnalysis createPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        ReachabilityForest reachabilityForest = this.createReachabilityForest();
        String name = this.computeName("local");
        @NonNull Iterable headNodes = this.useActivators ? this.executionNodes : QVTscheduleUtil.getHeadNodes((Region)this.mappingPartitioner.getRegion());
        BasicPartition partition = this.createBasicPartition(name, headNodes);
        int partitionNumber = ((RuleRegion)this.region).getNextPartitionNumber();
        BasicPartitionAnalysis basicPartitionAnalysis = new BasicPartitionAnalysis(partitionedTransformationAnalysis, partition, reachabilityForest, "\u00ablocal\u00bb", "_p" + partitionNumber);
        this.initializePartition(basicPartitionAnalysis);
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.scheduleManager.writeDebugGraphs((Graphable)partition, null);
        }
        return basicPartitionAnalysis;
    }

    protected void gatherReachableOldAcyclicNodes(@NonNull BasicPartition partition, @NonNull Set<@NonNull Node> checkableOldNodes, @NonNull Node node) {
        if (partition.hasNode(node) || checkableOldNodes.contains(node) || this.mappingPartitioner.isCyclic(node)) {
            return;
        }
        if (node.isHead() || node.isOld()) {
            checkableOldNodes.add(node);
            for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                if (!edge.isNavigation() || !edge.isOld()) continue;
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
                this.gatherReachableOldAcyclicNodes(partition, checkableOldNodes, targetNode);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull Iterable<@NonNull Node> getReachabilityRootNodes() {
        @NonNull Iterable headNodes = QVTscheduleUtil.getHeadNodes((Region)this.mappingPartitioner.getRegion());
        List<@NonNull Node> traceNodes = this.mappingPartitioner.getTraceNodes();
        ArrayList<@NonNull Node> rootNodes = new ArrayList<Node>();
        for (Node node : this.useActivators ? traceNodes : headNodes) {
            if (node.isDependency()) continue;
            rootNodes.add(node);
        }
        for (Node node : this.mappingPartitioner.getConstantInputNodes()) {
            rootNodes.add(node);
        }
        return rootNodes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void initializePartition(@NonNull BasicPartitionAnalysis partitionAnalysis) {
        BasicPartition partition = (BasicPartition)partitionAnalysis.getPartition();
        @NonNull HashSet originalHeadNodes = Sets.newHashSet((Iterable)QVTscheduleUtil.getHeadNodes((Region)this.mappingPartitioner.getRegion()));
        Node dispatchNode = this.mappingPartitioner.basicGetDispatchNode();
        if (!this.hasSynthesizedTrace) {
            for (Node traceNode : this.mappingPartitioner.getTraceNodes()) {
                this.addNode(partition, traceNode, Role.SPECULATION);
            }
        }
        for (Node traceNode : this.executionNodes) {
            this.addNode(partition, traceNode, Role.PREDICATED);
        }
        Node dispatchNode2 = dispatchNode;
        if (dispatchNode2 != null) {
            assert (dispatchNode2.isPredicated());
            this.addNode(partition, dispatchNode2);
        }
        for (Node realizedWhenNode : this.realizedWhenNodes) {
            this.addNode(partition, realizedWhenNode, Role.PREDICATED);
            for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)realizedWhenNode)) {
                Node argumentNode = QVTscheduleUtil.getSourceNode((Edge)incomingEdge);
                if (!this.scheduleManager.isOutput(argumentNode)) continue;
                this.addNode(partition, argumentNode);
            }
        }
        HashSet<@NonNull Node> checkableOldNodes = new HashSet<Node>();
        for (Node node : originalHeadNodes) {
            this.gatherReachableOldAcyclicNodes(partition, checkableOldNodes, node);
        }
        if (dispatchNode != null) {
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)dispatchNode)) {
                assert (!edge.isCast());
                if (!edge.isNavigation() || !edge.isOld()) continue;
                Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
                this.gatherReachableOldAcyclicNodes(partition, checkableOldNodes, sourceNode);
            }
        }
        for (Node node : checkableOldNodes) {
            if (this.hasSynthesizedTrace) {
                boolean isCyclicCorollary = this.transformationAnalysis.isCorollary(node) && this.mappingPartitioner.isCyclic(node);
                Node.Utility utility = node.getUtility();
                boolean isWeaklyMatched = utility == Node.Utility.WEAKLY_MATCHED;
                boolean isTraced = this.isTraced(node, this.executionNodes);
                if (isCyclicCorollary || !isTraced && !isWeaklyMatched) continue;
                this.addNode(partition, node);
                continue;
            }
            this.addNode(partition, node);
        }
        if (this.hasSynthesizedTrace) {
            this.resolveSuccessNodes(partition);
        }
        this.resolvePrecedingNodes(partitionAnalysis);
        this.resolveDisambiguations(partition);
        this.resolveEdges(partitionAnalysis);
    }

    @Override
    protected boolean isAvailable(@NonNull BasicPartition partition, @NonNull Node node) {
        return node.isConstant() || node.isLoaded();
    }

    protected boolean isTraced(@NonNull Node node, @NonNull Iterable<@NonNull Node> executionNodes) {
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            Node sourceNode;
            assert (!edge.isCast());
            if (!edge.isNavigation() || !Iterables.contains(executionNodes, (Object)(sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge)))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED) {
            if (this.mappingPartitioner.hasRealizedEdge(edge)) {
                edgeRole = Role.PREDICATED;
            } else if (this.dispatchNode == edge.getSourceNode()) {
                edgeRole = null;
            }
        }
        return edgeRole;
    }

    protected void resolveSuccessNodes(@NonNull BasicPartition partition) {
        for (Node traceNode : this.executionNodes) {
            Node localSuccessNode = this.mappingPartitioner.getLocalSuccessNode(traceNode);
            this.addNode(partition, localSuccessNode, Role.REALIZED);
        }
    }
}

