/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.debug.core.zend.debugger.CodeCoverageData;
import org.eclipse.php.profile.core.data.ProfilerClassData;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;

public class ProfilerFileData {
    private String fName;
    private String fLocalName;
    private int fFunctionsCount;
    private double fTotalOwnTime = 0.0;
    private List<ProfilerFunctionData> fFunctions = new ArrayList<ProfilerFunctionData>();
    private Map<String, ProfilerClassData> fClasses = new HashMap<String, ProfilerClassData>();
    private CodeCoverageData fCodeCoverageData;

    public ProfilerFileData() {
    }

    public ProfilerFileData(String name) {
        this.fName = name;
    }

    public ProfilerFileData(String fileName, String localFileName, int functionsCount, double totalOwnTime, List<ProfilerFunctionData> functions) {
        this.fName = fileName;
        this.fLocalName = localFileName;
        this.fFunctionsCount = functionsCount;
        this.fTotalOwnTime = totalOwnTime;
        this.fFunctions = functions;
        int i = 0;
        while (i < functions.size()) {
            this.addClass(functions.get(i));
            ++i;
        }
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void setLocalName(String name) {
        this.fLocalName = name;
    }

    public String getLocalName() {
        return this.fLocalName;
    }

    public void setFunctionsCount(int functionsCount) {
        this.fFunctionsCount = functionsCount;
    }

    public int getFunctionsCount() {
        return this.fFunctionsCount;
    }

    public void addFunction(ProfilerFunctionData function) {
        this.fFunctions.add(function);
        this.fTotalOwnTime += function.getOwnTime();
        this.addClass(function);
    }

    public ProfilerFunctionData[] getFunctions() {
        ProfilerFunctionData[] pfd = new ProfilerFunctionData[this.fFunctions.size()];
        this.fFunctions.toArray(pfd);
        return pfd;
    }

    public ProfilerClassData[] getClasses() {
        ProfilerClassData[] pcd = new ProfilerClassData[this.fClasses.size()];
        this.fClasses.values().toArray(pcd);
        return pcd;
    }

    public double getTotalOwnTime() {
        return this.fTotalOwnTime;
    }

    public double getTotalOwnTimeInMilli() {
        return this.fTotalOwnTime * 1000.0;
    }

    public String toString() {
        return this.fName;
    }

    public void setCodeCoverageData(CodeCoverageData codeCoverageData) {
        this.fCodeCoverageData = codeCoverageData;
    }

    public CodeCoverageData getCodeCoverageData() {
        return this.fCodeCoverageData;
    }

    private void addClass(ProfilerFunctionData function) {
        String className = function.getClassName();
        if (className != null) {
            if (this.fClasses.containsKey(className)) {
                ProfilerClassData classData = this.fClasses.get(className);
                classData.addMethod(function);
            } else {
                ProfilerClassData classData = new ProfilerClassData(className);
                classData.addMethod(function);
                this.fClasses.put(className, classData);
            }
        }
    }
}

