/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class LabelWithScalableIcons
extends Label {
    public void paintFigure(Graphics graphics) {
        this.isOpaque();
        Rectangle bounds = this.getBounds();
        graphics.translate(bounds.x, bounds.y);
        if (this.getIcon() != null) {
            this.paintScaledIcon(graphics);
        }
        if (!this.isEnabled()) {
            graphics.translate(1, 1);
            graphics.setForegroundColor(ColorConstants.buttonLightest);
            graphics.drawText(this.getSubStringText(), this.getTextLocation());
            graphics.translate(-1, -1);
            graphics.setForegroundColor(ColorConstants.buttonDarker);
        }
        graphics.drawText(this.getSubStringText(), this.getTextLocation());
        graphics.translate(-bounds.x, -bounds.y);
    }

    protected Dimension getIconSize() {
        int width = 0;
        if (this.getFont() == null) {
            return new Dimension(0, 16);
        }
        int height = this.getTextSize().height;
        Image icon = this.getIcon();
        if (icon != null) {
            org.eclipse.swt.graphics.Rectangle bounds = icon.getBounds();
            double scale = (double)(height - 2) / (double)bounds.height;
            if (scale > 1.0) {
                scale = 1.0;
            }
            width = (int)((double)bounds.width * scale);
        }
        return new Dimension(width, height);
    }

    private void paintScaledIcon(Graphics graphics) {
        Point p = this.getIconLocation();
        if (p != null) {
            int height = this.getTextSize().height;
            Image icon = this.getIcon();
            if (icon != null) {
                org.eclipse.swt.graphics.Rectangle bounds = icon.getBounds();
                double scale = (double)(height - 2) / (double)bounds.height;
                if (scale > 1.0) {
                    scale = 1.0;
                }
                graphics.drawImage(icon, 0, 0, bounds.width, bounds.height, p.x, p.y, (int)((double)bounds.width * scale), (int)((double)bounds.height * scale));
            }
        }
    }
}

