/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.providers;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.tools.util.CoreExecutors;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class PropertiesHeaderLabelProvider
extends LabelProvider {
    private final ILabelProvider delegate;
    private final ILabelProviderListener forwardingListener;
    public static final String PROPERTIES_HEADER_CONTEXT = "org.eclipse.papyrus.infra.properties.ui.header.labelProvider.context";

    public PropertiesHeaderLabelProvider() {
        LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
        this.delegate = labelProviderService.getLabelProvider(PROPERTIES_HEADER_CONTEXT);
        this.forwardingListener = this::forwardLabelChange;
        this.delegate.addListener(this.forwardingListener);
    }

    public String getText(Object element) {
        return this.delegate.getText(element);
    }

    public Image getImage(Object element) {
        return this.delegate.getImage(element);
    }

    private void forwardLabelChange(LabelProviderChangedEvent event) {
        LabelProviderChangedEvent forward = new LabelProviderChangedEvent((IBaseLabelProvider)this, event.getElements());
        if (Display.getCurrent() != null) {
            this.fireLabelProviderChanged(forward);
        } else {
            CoreExecutors.getUIExecutorService().execute(() -> this.fireLabelProviderChanged(forward));
        }
    }

    public void dispose() {
        this.delegate.removeListener(this.forwardingListener);
        this.delegate.dispose();
    }
}

