/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.driver;

import java.awt.AWTException;
import java.awt.Robot;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class SwtRobot {
    private static AutServerLogger log = new AutServerLogger(SwtRobot.class);
    private static final int MODIFIER_COUNT = 7;
    private static final int BUTTON_MASK = 0x380000;
    private static int[][] mappings;
    private static Map<Character, CharCode> keycodes;
    private Display m_displayProperty;
    private Robot m_robot;

    static {
        int[][] nArrayArray = new int[39][];
        int[] nArray = new int[3];
        nArray[0] = 27;
        nArray[1] = 27;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 127;
        nArray2[1] = 127;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 32;
        nArray3[1] = 32;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 9;
        nArray4[1] = 9;
        nArrayArray[3] = nArray4;
        nArrayArray[4] = new int[]{126, 192, 1};
        int[] nArray5 = new int[3];
        nArray5[0] = 96;
        nArray5[1] = 192;
        nArrayArray[5] = nArray5;
        nArrayArray[6] = new int[]{33, 49, 1};
        nArrayArray[7] = new int[]{64, 50, 1};
        nArrayArray[8] = new int[]{35, 51, 1};
        nArrayArray[9] = new int[]{36, 52, 1};
        nArrayArray[10] = new int[]{37, 53, 1};
        nArrayArray[11] = new int[]{94, 54, 1};
        nArrayArray[12] = new int[]{38, 55, 1};
        nArrayArray[13] = new int[]{42, 56, 1};
        nArrayArray[14] = new int[]{40, 57, 1};
        nArrayArray[15] = new int[]{41, 48, 1};
        int[] nArray6 = new int[3];
        nArray6[0] = 45;
        nArray6[1] = SWT.getPlatform().equals("gtk") ? 523 : 45;
        nArrayArray[16] = nArray6;
        nArrayArray[17] = new int[]{95, SWT.getPlatform().equals("gtk") ? 523 : 45, 1};
        int[] nArray7 = new int[3];
        nArray7[0] = 61;
        nArray7[1] = 61;
        nArrayArray[18] = nArray7;
        nArrayArray[19] = new int[]{43, 61, 1};
        int[] nArray8 = new int[3];
        nArray8[0] = 91;
        nArray8[1] = 91;
        nArrayArray[20] = nArray8;
        nArrayArray[21] = new int[]{123, 91, 1};
        int[] nArray9 = new int[3];
        nArray9[0] = 93;
        nArray9[1] = 93;
        nArrayArray[22] = nArray9;
        nArrayArray[23] = new int[]{125, 93, 1};
        nArrayArray[24] = new int[]{124, 92, 1};
        int[] nArray10 = new int[3];
        nArray10[0] = 59;
        nArray10[1] = 59;
        nArrayArray[25] = nArray10;
        nArrayArray[26] = new int[]{58, 59, 1};
        int[] nArray11 = new int[3];
        nArray11[0] = 44;
        nArray11[1] = 44;
        nArrayArray[27] = nArray11;
        nArrayArray[28] = new int[]{60, 44, 1};
        int[] nArray12 = new int[3];
        nArray12[0] = 46;
        nArray12[1] = 46;
        nArrayArray[29] = nArray12;
        nArrayArray[30] = new int[]{62, SWT.getPlatform().equals("gtk") ? 160 : 46, 1};
        int[] nArray13 = new int[3];
        nArray13[0] = 47;
        nArray13[1] = 47;
        nArrayArray[31] = nArray13;
        nArrayArray[32] = new int[]{63, 47, 1};
        int[] nArray14 = new int[3];
        nArray14[0] = 92;
        nArray14[1] = 92;
        nArrayArray[33] = nArray14;
        nArrayArray[34] = new int[]{124, 92, 1};
        int[] nArray15 = new int[3];
        nArray15[0] = 39;
        nArray15[1] = 222;
        nArrayArray[35] = nArray15;
        nArrayArray[36] = new int[]{34, 222, 1};
        int[] nArray16 = new int[3];
        nArray16[0] = 13;
        nArray16[1] = 10;
        nArrayArray[37] = nArray16;
        int[] nArray17 = new int[3];
        nArray17[0] = 9;
        nArray17[1] = 9;
        nArrayArray[38] = nArray17;
        mappings = nArrayArray;
        keycodes = new HashMap<Character, CharCode>();
    }

    public SwtRobot() throws SWTException {
        try {
            this.m_robot = new Robot();
            keycodes = new HashMap<Character, CharCode>();
            int i = 0;
            while (i < mappings.length) {
                keycodes.put(new Character((char)mappings[i][0]), new CharCode(mappings[i][1], mappings[i][2]));
                ++i;
            }
        }
        catch (AWTException awte) {
            throw new SWTException("(Translated AWTException) " + awte.getMessage());
        }
    }

    public SwtRobot(Display display) throws SWTException {
        this();
        this.m_displayProperty = display;
    }

    public synchronized Image createScreenCapture(Rectangle rect) {
        PaletteData pData = new PaletteData(0xFF0000, 65280, 255);
        ImageData iData = new ImageData(rect.width, rect.height, 24, pData);
        int x = 0;
        while (x < rect.width) {
            int y = 0;
            while (y < rect.height) {
                Color color = this.getPixelColor(rect.x + x, rect.y + y);
                iData.setPixel(x, y, color.getRed() << 16 | color.getGreen() << 8 | color.getBlue());
                ++y;
            }
            ++x;
        }
        Image image = new Image((Device)Display.getDefault(), iData);
        return image;
    }

    public synchronized Color getPixelColor(int x, int y) {
        java.awt.Color awtColor = this.m_robot.getPixelColor(x, y);
        return new Color((Device)Display.getDefault(), awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
    }

    public static void delay(int ms) {
        final Display display = Display.getCurrent();
        if (display == null) {
            TimeUtil.delay((long)ms);
            return;
        }
        final boolean[] continueWait = new boolean[]{true};
        display.timerExec(ms, new Runnable(){

            public void run() {
                continueWait[0] = false;
                display.asyncExec(null);
            }
        });
        while (continueWait[0]) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public synchronized int getAutoDelay() {
        return this.m_robot.getAutoDelay();
    }

    public synchronized boolean isAutoWaitForIdle() {
        return this.m_robot.isAutoWaitForIdle();
    }

    public synchronized void setAutoDelay(int ms) {
        this.m_robot.setAutoDelay(ms);
    }

    public synchronized void setAutoWaitForIdle(boolean isOn) {
        this.m_robot.setAutoWaitForIdle(isOn);
    }

    public synchronized String toString() {
        String params = "autoDelay = " + this.getAutoDelay() + ", " + "autoWaitForIdle = " + this.isAutoWaitForIdle();
        return String.valueOf(this.getClass().getName()) + "[ " + params + " ]";
    }

    public synchronized void waitForIdle() {
        final Display d = this.m_displayProperty;
        if (d.getThread() == Thread.currentThread()) {
            boolean continueWaiting = d.readAndDispatch();
            while (continueWaiting) {
                continueWaiting = d.readAndDispatch();
            }
        } else {
            d.syncExec(new Runnable(){

                public void run() {
                    boolean continueWaiting = d.readAndDispatch();
                    while (continueWaiting) {
                        continueWaiting = d.readAndDispatch();
                    }
                }
            });
        }
    }

    public synchronized void keyPress(int accelerator) {
        int[] keys = this.getVirtualKeycode(accelerator);
        boolean shift = false;
        int i = 0;
        while (i < keys.length) {
            if (!(keys[i] == 0 || keys[i] == 0 || keys[i] == 16 && shift)) {
                try {
                    this.m_robot.keyPress(keys[i]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error((Object)("IllegalArgumentException: keystroke :" + keys[i] + "\nAccelerator:" + accelerator + "\nCast as a char: " + (char)accelerator));
                }
            }
            if (keys[i] == 16) {
                shift = true;
            }
            ++i;
        }
    }

    public synchronized void keyRelease(int accelerator) {
        int[] keys = this.getVirtualKeycode(accelerator);
        boolean shift = false;
        int i = 0;
        while (i < keys.length) {
            if (keys[i] != 0) {
                if (keys[i] != 16 || !shift) {
                    this.m_robot.keyRelease(keys[i]);
                }
                if (keys[i] == 16) {
                    shift = true;
                }
            }
            ++i;
        }
    }

    public synchronized void mouseMove(int x, int y) {
        this.m_robot.mouseMove(x, y);
    }

    public synchronized void mousePress(int accelerator) {
        int acc = accelerator;
        if (((acc &= 0x380000) & 0x80000) == 524288) {
            this.m_robot.mousePress(16);
        }
        if ((acc & 0x100000) == 0x100000) {
            this.m_robot.mousePress(8);
        }
        if ((acc & 0x200000) == 0x200000) {
            this.m_robot.mousePress(4);
        }
    }

    public synchronized void mouseRelease(int accelerator) {
        int acc = accelerator;
        if (((acc &= 0x380000) & 0x80000) == 524288) {
            this.m_robot.mouseRelease(16);
        }
        if ((acc & 0x100000) == 0x100000) {
            this.m_robot.mouseRelease(8);
        }
        if ((acc & 0x200000) == 0x200000) {
            this.m_robot.mouseRelease(4);
        }
    }

    private int[] getVirtualKeycode(int code) {
        int keyCode;
        int[] res = new int[9];
        Arrays.fill(res, 0);
        int idx = 0;
        if ((SWT.MODIFIER_MASK & code) != 0) {
            if ((code & 0x10000) == 65536) {
                res[idx++] = 18;
            }
            if ((code & 0x20000) == 131072) {
                res[idx++] = 16;
            }
            if ((code & 0x40000) == 262144) {
                res[idx++] = 17;
            }
            if ((code & 0x400000) == 0x400000) {
                res[idx++] = 157;
            }
        }
        if ((0x1000000 & (keyCode = code & 0x100FFFF)) != 0) {
            res = this.convResult(keyCode, res);
        } else {
            if (keyCode == 127) {
                res[8] = 127;
            } else if (keyCode == 27) {
                res[8] = 27;
            }
            if (Character.isDigit((char)keyCode)) {
                res[8] = keyCode - Character.getNumericValue('0') + 48;
            } else if (keyCode >= 97 && keyCode <= 122 || keyCode >= 65 && keyCode <= 90) {
                if (Character.isUpperCase((char)keyCode)) {
                    res[7] = 16;
                    keyCode = Character.getNumericValue(Character.toLowerCase((char)keyCode));
                }
                res[8] = Character.getNumericValue(Character.toLowerCase((char)keyCode));
            } else {
                CharCode cc = keycodes.get(new Character((char)keyCode));
                if (cc == null) {
                    res[8] = 0;
                } else {
                    if (cc.m_shift) {
                        res[7] = 16;
                    }
                    res[8] = cc.m_keycode;
                }
            }
        }
        return res;
    }

    private int[] convResult(int keyCode, int[] res) {
        switch (keyCode) {
            case 0x1000001: {
                res[8] = 38;
                break;
            }
            case 0x1000002: {
                res[8] = 40;
                break;
            }
            case 0x1000003: {
                res[8] = 37;
                break;
            }
            case 0x1000004: {
                res[8] = 39;
                break;
            }
            case 0x1000005: {
                res[8] = 33;
                break;
            }
            case 0x1000006: {
                res[8] = 34;
                break;
            }
            case 0x1000007: {
                res[8] = 36;
                break;
            }
            case 0x1000008: {
                res[8] = 35;
                break;
            }
            case 0x1000009: {
                res[8] = 155;
                break;
            }
            case 0x100000A: {
                res[8] = 112;
                break;
            }
            case 0x100000B: {
                res[8] = 113;
                break;
            }
            case 0x100000C: {
                res[8] = 114;
                break;
            }
            case 0x100000D: {
                res[8] = 115;
                break;
            }
            case 0x100000E: {
                res[8] = 116;
                break;
            }
            case 0x100000F: {
                res[8] = 117;
                break;
            }
            case 0x1000010: {
                res[8] = 118;
                break;
            }
            case 0x1000011: {
                res[8] = 119;
                break;
            }
            case 0x1000012: {
                res[8] = 120;
                break;
            }
            case 0x1000013: {
                res[8] = 121;
                break;
            }
            case 0x1000014: {
                res[8] = 122;
                break;
            }
            case 0x1000015: {
                res[8] = 123;
                break;
            }
            default: {
                res[8] = 0;
            }
        }
        return res;
    }

    public Display getDisplay() {
        return this.m_displayProperty;
    }

    private static class CharCode {
        private int m_keycode;
        private boolean m_shift;

        private CharCode(int keycode, int shift) {
            this.m_keycode = keycode;
            this.m_shift = shift == 1;
        }
    }
}

