/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal;

import com.google.common.base.Objects;
import com.google.inject.Injector;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyMapProperty;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.common.reflect.ReflectionUtils;
import org.eclipse.gef.dot.internal.language.DotArrowTypeStandaloneSetup;
import org.eclipse.gef.dot.internal.language.DotColorListStandaloneSetup;
import org.eclipse.gef.dot.internal.language.DotColorStandaloneSetup;
import org.eclipse.gef.dot.internal.language.DotEscStringStandaloneSetup;
import org.eclipse.gef.dot.internal.language.DotFontNameStandaloneSetup;
import org.eclipse.gef.dot.internal.language.DotHtmlLabelStandaloneSetup;
import org.eclipse.gef.dot.internal.language.DotPointStandaloneSetup;
import org.eclipse.gef.dot.internal.language.DotPortPosStandaloneSetup;
import org.eclipse.gef.dot.internal.language.DotRectStandaloneSetup;
import org.eclipse.gef.dot.internal.language.DotShapeStandaloneSetup;
import org.eclipse.gef.dot.internal.language.DotSplineTypeStandaloneSetup;
import org.eclipse.gef.dot.internal.language.DotStyleStandaloneSetup;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowType;
import org.eclipse.gef.dot.internal.language.clustermode.ClusterMode;
import org.eclipse.gef.dot.internal.language.color.Color;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.colorlist.ColorList;
import org.eclipse.gef.dot.internal.language.dir.DirType;
import org.eclipse.gef.dot.internal.language.dot.AttrStmt;
import org.eclipse.gef.dot.internal.language.dot.AttributeType;
import org.eclipse.gef.dot.internal.language.dot.EdgeOp;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtSubgraph;
import org.eclipse.gef.dot.internal.language.dot.GraphType;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.dot.Subgraph;
import org.eclipse.gef.dot.internal.language.escstring.EscString;
import org.eclipse.gef.dot.internal.language.fontname.FontName;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlLabel;
import org.eclipse.gef.dot.internal.language.layout.Layout;
import org.eclipse.gef.dot.internal.language.outputmode.OutputMode;
import org.eclipse.gef.dot.internal.language.pagedir.Pagedir;
import org.eclipse.gef.dot.internal.language.point.Point;
import org.eclipse.gef.dot.internal.language.portpos.PortPos;
import org.eclipse.gef.dot.internal.language.rankdir.Rankdir;
import org.eclipse.gef.dot.internal.language.ranktype.RankType;
import org.eclipse.gef.dot.internal.language.rect.Rect;
import org.eclipse.gef.dot.internal.language.shape.Shape;
import org.eclipse.gef.dot.internal.language.splines.Splines;
import org.eclipse.gef.dot.internal.language.splinetype.SplineType;
import org.eclipse.gef.dot.internal.language.style.Style;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.language.validation.DotArrowTypeJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotColorJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotColorListJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotEscStringJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotHtmlLabelJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotPointJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotPortPosJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotRectJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotShapeJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotSplineTypeJavaValidator;
import org.eclipse.gef.dot.internal.language.validation.DotStyleJavaValidator;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.RangeBasedDiagnostic;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class DotAttributes {
    private static final EnumParser<DirType> DIRTYPE_PARSER = new EnumParser<DirType>(DirType.class);
    private static final EnumSerializer<DirType> DIRTYPE_SERIALIZER = new EnumSerializer<DirType>(DirType.class);
    private static final EnumParser<Layout> LAYOUT_PARSER = new EnumParser<Layout>(Layout.class);
    private static final EnumSerializer<Layout> LAYOUT_SERIALIZER = new EnumSerializer<Layout>(Layout.class);
    private static final EnumParser<ClusterMode> CLUSTERMODE_PARSER = new EnumParser<ClusterMode>(ClusterMode.class);
    private static final EnumSerializer<ClusterMode> CLUSTERMODE_SERIALIZER = new EnumSerializer<ClusterMode>(ClusterMode.class);
    private static final EnumParser<OutputMode> OUTPUTMODE_PARSER = new EnumParser<OutputMode>(OutputMode.class);
    private static final EnumSerializer<OutputMode> OUTPUTMODE_SERIALIZER = new EnumSerializer<OutputMode>(OutputMode.class);
    private static final EnumParser<Pagedir> PAGEDIR_PARSER = new EnumParser<Pagedir>(Pagedir.class);
    private static final EnumSerializer<Pagedir> PAGEDIR_SERIALIZER = new EnumSerializer<Pagedir>(Pagedir.class);
    private static final EnumParser<Rankdir> RANKDIR_PARSER = new EnumParser<Rankdir>(Rankdir.class);
    private static final EnumSerializer<Rankdir> RANKDIR_SERIALIZER = new EnumSerializer<Rankdir>(Rankdir.class);
    private static final EnumParser<RankType> RANKTYPE_PARSER = new EnumParser<RankType>(RankType.class);
    private static final EnumSerializer<RankType> RANKTYPE_SERIALIZER = new EnumSerializer<RankType>(RankType.class);
    private static final IAttributeValueParser<Splines> SPLINES_PARSER = new Functions.Function0<IAttributeValueParser<Splines>>(){

        public IAttributeValueParser<Splines> apply() {
            abstract class __DotAttributes_1
            implements IAttributeValueParser<Splines> {
                EnumParser<Splines> enumParser;

                __DotAttributes_1() {
                }
            }
            __DotAttributes_1 ___DotAttributes_1 = new __DotAttributes_1(this){
                {
                    this.enumParser = new EnumParser<Splines>(Splines.class);
                }

                @Override
                public IAttributeValueParser.ParseResult<Splines> parse(String attributeValue) {
                    boolean _not_1;
                    boolean _not;
                    IAttributeValueParser.ParseResult boolResult = BOOL_PARSER.parse(attributeValue);
                    boolean _hasSyntaxErrors = boolResult.hasSyntaxErrors();
                    boolean bl = _not = !_hasSyntaxErrors;
                    if (_not) {
                        Splines _xifexpression = null;
                        Boolean _parsedValue = (Boolean)boolResult.getParsedValue();
                        _xifexpression = _parsedValue != false ? Splines.TRUE : Splines.FALSE;
                        return new IAttributeValueParser.ParseResult<Splines>((Object)_xifexpression);
                    }
                    IAttributeValueParser.ParseResult enumResult = this.enumParser.parse(attributeValue);
                    boolean _hasSyntaxErrors_1 = enumResult.hasSyntaxErrors();
                    boolean bl2 = _not_1 = !_hasSyntaxErrors_1;
                    if (_not_1) {
                        Splines _parsedValue_1 = (Splines)((Object)enumResult.getParsedValue());
                        return new IAttributeValueParser.ParseResult<Splines>((Object)_parsedValue_1);
                    }
                    ArrayList combinedFindings = CollectionLiterals.newArrayList((Object[])new Diagnostic[0]);
                    combinedFindings.addAll(boolResult.syntaxErrors);
                    combinedFindings.addAll(enumResult.syntaxErrors);
                    return new IAttributeValueParser.ParseResult<Splines>(combinedFindings);
                }

                @Override
                public Class<Splines> getParsedType() {
                    return Splines.class;
                }
            };
            return ___DotAttributes_1;
        }
    }.apply();
    private static final EnumSerializer<Splines> SPLINES_SERIALIZER = new EnumSerializer<Splines>(Splines.class);
    private static final IAttributeValueParser<Boolean> BOOL_PARSER = new IAttributeValueParser<Boolean>(){

        @Override
        public IAttributeValueParser.ParseResult<Boolean> parse(String rawValue) {
            boolean _equalsIgnoreCase_3;
            boolean _equalsIgnoreCase_1;
            boolean _tripleEquals;
            boolean bl = _tripleEquals = rawValue == null;
            if (_tripleEquals) {
                return null;
            }
            boolean _or = false;
            String _string = Boolean.TRUE.toString();
            boolean _equalsIgnoreCase = _string.equalsIgnoreCase(rawValue);
            _or = _equalsIgnoreCase ? true : (_equalsIgnoreCase_1 = "yes".equalsIgnoreCase(rawValue));
            if (_or) {
                return new IAttributeValueParser.ParseResult<Boolean>((Object)Boolean.TRUE);
            }
            boolean _or_1 = false;
            String _string_1 = Boolean.FALSE.toString();
            boolean _equalsIgnoreCase_2 = _string_1.equalsIgnoreCase(rawValue);
            _or_1 = _equalsIgnoreCase_2 ? true : (_equalsIgnoreCase_3 = "no".equalsIgnoreCase(rawValue));
            if (_or_1) {
                return new IAttributeValueParser.ParseResult<Boolean>((Object)Boolean.FALSE);
            }
            try {
                int parsedValue = Integer.parseInt(rawValue);
                Boolean _xifexpression = null;
                _xifexpression = parsedValue > 0 ? Boolean.TRUE : Boolean.FALSE;
                return new IAttributeValueParser.ParseResult<Boolean>((Object)_xifexpression);
            }
            catch (Throwable _t) {
                if (_t instanceof NumberFormatException) {
                    NumberFormatException cfr_ignored_0 = (NumberFormatException)_t;
                    BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, rawValue, -1, "The given value '" + rawValue + "' does not (case-insensitively) equal 'true', 'yes', 'false', or 'no' and is also not parsable as an integer value", new Object[0]);
                    List<BasicDiagnostic> _singletonList = Collections.singletonList(_basicDiagnostic);
                    return new IAttributeValueParser.ParseResult<Boolean>(_singletonList);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }

        @Override
        public Class<Boolean> getParsedType() {
            return Boolean.class;
        }
    };
    private static final IAttributeValueSerializer<Boolean> BOOL_SERIALIZER = new IAttributeValueSerializer<Boolean>(){

        @Override
        public String serialize(Boolean value) {
            return Boolean.toString(value);
        }
    };
    private static final IAttributeValueParser<Double> DOUBLE_PARSER = new IAttributeValueParser<Double>(){

        @Override
        public IAttributeValueParser.ParseResult<Double> parse(String rawValue) {
            boolean _tripleEquals;
            boolean bl = _tripleEquals = rawValue == null;
            if (_tripleEquals) {
                return null;
            }
            try {
                double parsedValue = Double.parseDouble(rawValue);
                Double _double = new Double(parsedValue);
                return new IAttributeValueParser.ParseResult<Double>((Object)_double);
            }
            catch (Throwable _t) {
                if (_t instanceof NumberFormatException) {
                    NumberFormatException exception = (NumberFormatException)_t;
                    String _message = exception.getMessage();
                    BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, rawValue, -1, _message, new Object[0]);
                    List<BasicDiagnostic> _singletonList = Collections.singletonList(_basicDiagnostic);
                    return new IAttributeValueParser.ParseResult<Double>(_singletonList);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }

        @Override
        public Class<Double> getParsedType() {
            return Double.class;
        }
    };
    private static final IAttributeValueSerializer<Double> DOUBLE_SERIALIZER = new IAttributeValueSerializer<Double>(){

        @Override
        public String serialize(Double value) {
            return Double.toString(value);
        }
    };
    private static final IAttributeValueParser<Integer> INT_PARSER = new IAttributeValueParser<Integer>(){

        @Override
        public IAttributeValueParser.ParseResult<Integer> parse(String rawValue) {
            boolean _tripleEquals;
            boolean bl = _tripleEquals = rawValue == null;
            if (_tripleEquals) {
                return null;
            }
            try {
                int parsedValue = Integer.parseInt(rawValue);
                Integer _integer = new Integer(parsedValue);
                return new IAttributeValueParser.ParseResult<Integer>((Object)_integer);
            }
            catch (Throwable _t) {
                if (_t instanceof NumberFormatException) {
                    NumberFormatException exception = (NumberFormatException)_t;
                    String _message = exception.getMessage();
                    BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, rawValue, -1, _message, new Object[0]);
                    List<BasicDiagnostic> _singletonList = Collections.singletonList(_basicDiagnostic);
                    return new IAttributeValueParser.ParseResult<Integer>(_singletonList);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }

        @Override
        public Class<Integer> getParsedType() {
            return Integer.class;
        }
    };
    private static final IAttributeValueSerializer<Integer> INT_SERIALIZER = new IAttributeValueSerializer<Integer>(){

        @Override
        public String serialize(Integer value) {
            return Integer.toString(value);
        }
    };
    private static final StringValidator COLORSCHEME_VALIDATOR = new StringValidator(DotColors.getColorSchemes().toArray());
    private static final IntValidator SIDES_VALIDATOR = new IntValidator(0);
    private static final DoubleValidator ARROWSIZE_VALIDATOR = new DoubleValidator(0.0);
    private static final DoubleValidator SKEW_VALIDATOR = new DoubleValidator(-100.0);
    private static final DoubleValidator DISTORTION_VALIDATOR = new DoubleValidator(-100.0);
    private static final DoubleValidator WIDTH_VALIDATOR = new DoubleValidator(0.0);
    private static final DoubleValidator HEIGHT_VALIDATOR = new DoubleValidator(0.0);
    private static final DoubleValidator NODESEP_VALIDATOR = new DoubleValidator(0.0);
    private static final DoubleValidator FONTSIZE_VALIDATOR = new DoubleValidator(1.0);
    private static final DoubleValidator PENWIDTH_VALIDATOR = new DoubleValidator(0.0);
    private static final Injector arrowTypeInjector = new DotArrowTypeStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final EObjectValidator<ArrowType> ARROWTYPE_VALIDATOR = new EObjectValidator(arrowTypeInjector, DotArrowTypeJavaValidator.class);
    private static final EObjectParser<ArrowType> ARROWTYPE_PARSER = new EObjectParser(arrowTypeInjector);
    private static final EObjectSerializer<ArrowType> ARROWTYPE_SERIALIZER = new EObjectSerializer(arrowTypeInjector);
    private static final Injector colorInjector = new DotColorStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final EObjectParser<Color> COLOR_PARSER = new EObjectParser(colorInjector);
    private static final EObjectSerializer<Color> COLOR_SERIALIZER = new EObjectSerializer(colorInjector);
    private static final Injector colorListInjector = new DotColorListStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final EObjectParser<ColorList> COLORLIST_PARSER = new EObjectParser(colorListInjector);
    private static final EObjectSerializer<ColorList> COLORLIST_SERIALIZER = new EObjectSerializer(colorListInjector);
    private static final EObjectValidator<ColorList> COLORLIST_VALIDATOR = new EObjectValidator(colorListInjector, DotColorListJavaValidator.class);
    private static final Injector htmlLabelInjector = new DotHtmlLabelStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final EObjectParser<HtmlLabel> HTML_LABEL_PARSER = new EObjectParser(htmlLabelInjector);
    private static final EObjectValidator<HtmlLabel> HTML_LABEL_VALIDATOR = new EObjectValidator(htmlLabelInjector, DotHtmlLabelJavaValidator.class);
    private static final Injector escStringInjector = new DotEscStringStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final EObjectParser<EscString> ESCSTRING_PARSER = new EObjectParser(escStringInjector);
    private static final EObjectSerializer<EscString> ESCSTRING_SERIALIZER = new EObjectSerializer(escStringInjector);
    private static final EObjectValidator<EscString> ESCSTRING_VALIDATOR = new EObjectValidator(escStringInjector, DotEscStringJavaValidator.class);
    private static final Injector fontNameInjector = new DotFontNameStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final EObjectParser<FontName> FONTNAME_PARSER = new EObjectParser(fontNameInjector);
    private static final EObjectSerializer<FontName> FONTNAME_SERIALIZER = new EObjectSerializer(fontNameInjector);
    private static final Injector rectInjector = new DotRectStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final EObjectParser<Rect> RECT_PARSER = new EObjectParser(rectInjector);
    private static final EObjectSerializer<Rect> RECT_SERIALIZER = new EObjectSerializer(rectInjector);
    private static final Injector pointInjector = new DotPointStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final EObjectParser<Point> POINT_PARSER = new EObjectParser(pointInjector);
    private static final EObjectSerializer<Point> POINT_SERIALIZER = new EObjectSerializer(pointInjector);
    private static final Injector shapeInjector = new DotShapeStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final EObjectParser<Shape> SHAPE_PARSER = new EObjectParser(shapeInjector);
    private static final EObjectSerializer<Shape> SHAPE_SERIALIZER = new EObjectSerializer(shapeInjector);
    private static final Injector splineTypeInjector = new DotSplineTypeStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final EObjectParser<SplineType> SPLINETYPE_PARSER = new EObjectParser(splineTypeInjector);
    private static final EObjectSerializer<SplineType> SPLINETYPE_SERIALIZER = new EObjectSerializer(splineTypeInjector);
    private static final Injector styleInjector = new DotStyleStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final EObjectSerializer<Style> STYLE_SERIALIZER = new EObjectSerializer(styleInjector);
    private static final EObjectParser<Style> STYLE_PARSER = new EObjectParser(styleInjector);
    private static final EObjectValidator<Color> COLOR_VALIDATOR = new EObjectValidator(colorInjector, DotColorJavaValidator.class);
    private static final EObjectValidator<SplineType> SPLINETYPE_VALIDATOR = new EObjectValidator(splineTypeInjector, DotSplineTypeJavaValidator.class);
    private static final EObjectValidator<Point> POINT_VALIDATOR = new EObjectValidator(pointInjector, DotPointJavaValidator.class);
    private static final EObjectValidator<Rect> RECT_VALIDATOR = new EObjectValidator(rectInjector, DotRectJavaValidator.class);
    private static final EObjectValidator<Shape> SHAPE_VALIDATOR = new EObjectValidator(shapeInjector, DotShapeJavaValidator.class);
    private static final EObjectValidator<Style> STYLE_VALIDATOR = new EObjectValidator(styleInjector, DotStyleJavaValidator.class);
    private static final Injector portPosInjector = new DotPortPosStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final EObjectValidator<PortPos> PORTPOS_VALIDATOR = new EObjectValidator(portPosInjector, DotPortPosJavaValidator.class);
    private static final EObjectParser<PortPos> PORTPOS_PARSER = new EObjectParser(portPosInjector);
    private static final EObjectSerializer<PortPos> PORTPOS_SERIALIZER = new EObjectSerializer(portPosInjector);
    public static final String _NAME__GNE = "_name";
    public static final String _TYPE__G = "_type";
    public static final String ARROWHEAD__E = "arrowhead";
    public static final String ARROWSIZE__E = "arrowsize";
    public static final String ARROWTAIL__E = "arrowtail";
    public static final String BB__GC = "bb";
    public static final String BGCOLOR__GC = "bgcolor";
    public static final String CLUSTERRANK__G = "clusterrank";
    public static final String COLOR__CNE = "color";
    public static final String COLORSCHEME__GCNE = "colorscheme";
    public static final String DIR__E = "dir";
    public static final String DISTORTION__N = "distortion";
    public static final String EDGETOOLTIP__E = "edgetooltip";
    public static final String FILLCOLOR__CNE = "fillcolor";
    public static final String FIXEDSIZE__N = "fixedsize";
    public static final String FONTCOLOR__GCNE = "fontcolor";
    public static final String FONTNAME__GCNE = "fontname";
    public static final String FONTSIZE__GCNE = "fontsize";
    public static final String FORCELABELS__G = "forcelabels";
    public static final String HEAD_LP__E = "head_lp";
    public static final String HEADLABEL__E = "headlabel";
    public static final String HEADPORT__E = "headport";
    public static final String HEADTOOLTIP__E = "headtooltip";
    public static final String HEIGHT__N = "height";
    public static final String ID__GCNE = "id";
    public static final String LABEL__GCNE = "label";
    public static final String LABELFONTCOLOR__E = "labelfontcolor";
    public static final String LABELFONTNAME__E = "labelfontname";
    public static final String LABELFONTSIZE__E = "labelfontsize";
    public static final String LABELTOOLTIP__E = "labeltooltip";
    public static final String LAYOUT__G = "layout";
    public static final String LP__GCE = "lp";
    public static final String NODESEP__G = "nodesep";
    public static final String OUTPUTORDER__G = "outputorder";
    public static final String PAGEDIR__G = "pagedir";
    public static final String PENWIDTH__CNE = "penwidth";
    public static final String POS__NE = "pos";
    public static final String RANK__S = "rank";
    public static final String RANKDIR__G = "rankdir";
    public static final String SHAPE__N = "shape";
    public static final String SIDES__N = "sides";
    public static final String SKEW__N = "skew";
    public static final String SPLINES__G = "splines";
    public static final String STYLE__GCNE = "style";
    public static final String TAIL_LP__E = "tail_lp";
    public static final String TAILLABEL__E = "taillabel";
    public static final String TAILPORT__E = "tailport";
    public static final String TAILTOOLTIP__E = "tailtooltip";
    public static final String TOOLTIP__CNE = "tooltip";
    public static final String WIDTH__N = "width";
    public static final String XLABEL__NE = "xlabel";
    public static final String XLP__NE = "xlp";

    public static boolean isCluster(Node node) {
        boolean _startsWith;
        boolean _tripleEquals;
        Graph _nestedGraph = node.getNestedGraph();
        boolean bl = _tripleEquals = _nestedGraph == null;
        if (_tripleEquals) {
            return false;
        }
        Graph _nestedGraph_1 = node.getNestedGraph();
        String name = DotAttributes._getName(_nestedGraph_1);
        boolean _and = false;
        boolean _tripleNotEquals = name != null;
        _and = !_tripleNotEquals ? false : (_startsWith = name.startsWith("cluster"));
        return _and;
    }

    public static Context getContext(EObject eObject) {
        boolean _tripleNotEquals_5;
        boolean _tripleNotEquals_4;
        boolean _tripleNotEquals_3;
        boolean _tripleNotEquals_2;
        EdgeStmtSubgraph _containerOfType_1;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        Context _xblockexpression = null;
        boolean _or = false;
        EdgeStmtNode _containerOfType = (EdgeStmtNode)EcoreUtil2.getContainerOfType((EObject)eObject, EdgeStmtNode.class);
        boolean bl = _tripleNotEquals = _containerOfType != null;
        _or = _tripleNotEquals ? true : (_tripleNotEquals_1 = (_containerOfType_1 = (EdgeStmtSubgraph)EcoreUtil2.getContainerOfType((EObject)eObject, EdgeStmtSubgraph.class)) != null);
        if (_or) {
            return Context.EDGE;
        }
        AttrStmt attrStmt = (AttrStmt)EcoreUtil2.getContainerOfType((EObject)eObject, AttrStmt.class);
        boolean _and = false;
        boolean bl2 = _tripleNotEquals_2 = attrStmt != null;
        if (!_tripleNotEquals_2) {
            _and = false;
        } else {
            boolean _equals;
            AttributeType _type = attrStmt.getType();
            _and = _equals = AttributeType.EDGE.equals((Object)_type);
        }
        if (_and) {
            return Context.EDGE;
        }
        NodeStmt _containerOfType_2 = (NodeStmt)EcoreUtil2.getContainerOfType((EObject)eObject, NodeStmt.class);
        boolean bl3 = _tripleNotEquals_3 = _containerOfType_2 != null;
        if (_tripleNotEquals_3) {
            return Context.NODE;
        }
        boolean _and_1 = false;
        boolean bl4 = _tripleNotEquals_4 = attrStmt != null;
        if (!_tripleNotEquals_4) {
            _and_1 = false;
        } else {
            boolean _equals_1;
            AttributeType _type_1 = attrStmt.getType();
            _and_1 = _equals_1 = AttributeType.NODE.equals((Object)_type_1);
        }
        if (_and_1) {
            return Context.NODE;
        }
        Subgraph subgraph = (Subgraph)EcoreUtil2.getContainerOfType((EObject)eObject, Subgraph.class);
        boolean bl5 = _tripleNotEquals_5 = subgraph != null;
        if (_tripleNotEquals_5) {
            boolean _tripleNotEquals_6;
            boolean _and_2 = false;
            ID _name = subgraph.getName();
            boolean bl6 = _tripleNotEquals_6 = _name != null;
            if (!_tripleNotEquals_6) {
                _and_2 = false;
            } else {
                boolean _startsWith;
                ID _name_1 = subgraph.getName();
                String _value = _name_1.toValue();
                _and_2 = _startsWith = _value.startsWith("cluster");
            }
            if (_and_2) {
                return Context.CLUSTER;
            }
            return Context.SUBGRAPH;
        }
        _xblockexpression = Context.GRAPH;
        return _xblockexpression;
    }

    private static <T> String serializeAttributeValue(IAttributeValueSerializer<T> serializer, T attributeValue) {
        String _xifexpression = null;
        boolean _tripleEquals = attributeValue == null;
        _xifexpression = _tripleEquals ? null : serializer.serialize(attributeValue);
        return _xifexpression;
    }

    private static <T> T parseAttributeValue(IAttributeValueParser<T> parser, String attributeValue) {
        boolean _tripleEquals;
        Object _xifexpression = null;
        boolean bl = _tripleEquals = attributeValue == null;
        if (_tripleEquals) {
            _xifexpression = null;
        } else {
            IAttributeValueParser.ParseResult<T> _parse = parser.parse(attributeValue);
            _xifexpression = ((IAttributeValueParser.ParseResult)_parse).parsedValue;
        }
        return (T)_xifexpression;
    }

    private static <T> List<Diagnostic> validateAttributeRawValue(IAttributeValueParser<T> parser, IAttributeValueValidator<T> validator, Context attributeContext, String attributeName, ID attributeValue) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        ArrayList _xblockexpression = null;
        Class _xifexpression = null;
        boolean _tripleEquals = parser == null;
        _xifexpression = _tripleEquals ? String.class : parser.getParsedType();
        Class attributeType = _xifexpression;
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal(attributeType, Integer.class)) {
            _matched = true;
            _switchResult = "int";
        }
        if (!_matched && Objects.equal(attributeType, Boolean.class)) {
            _matched = true;
            _switchResult = "bool";
        }
        if (!_matched) {
            String _simpleName = attributeType.getSimpleName();
            _switchResult = StringExtensions.toFirstLower((String)_simpleName);
        }
        String attributeTypeName = _switchResult;
        String _xifexpression_1 = null;
        boolean bl = _tripleNotEquals = parser != null;
        if (_tripleNotEquals) {
            Object _xblockexpression_1 = null;
            String _value = attributeValue.toValue();
            IAttributeValueParser.ParseResult<T> parseResult = parser.parse(_value);
            boolean _hasSyntaxErrors = parseResult.hasSyntaxErrors();
            if (_hasSyntaxErrors) {
                String _value_1 = attributeValue.toValue();
                String _plus = "The value '" + _value_1;
                String _plus_1 = String.valueOf(_plus) + "' is not a syntactically correct ";
                String _plus_2 = String.valueOf(_plus_1) + attributeTypeName;
                String _plus_3 = String.valueOf(_plus_2) + ": ";
                Functions.Function1<Diagnostic, String> _function = new Functions.Function1<Diagnostic, String>(){

                    public String apply(Diagnostic it) {
                        String _message = it.getMessage();
                        String _firstUpper = StringExtensions.toFirstUpper((String)_message);
                        return _firstUpper.replaceAll("\\.$", "");
                    }
                };
                List _map = ListExtensions.map((List)((IAttributeValueParser.ParseResult)parseResult).syntaxErrors, (Functions.Function1)_function);
                String _join = IterableExtensions.join((Iterable)_map, (CharSequence)". ");
                String _plus_4 = String.valueOf(_plus_3) + _join;
                String _plus_5 = String.valueOf(_plus_4) + ".";
                BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, null, -1, _plus_5, new Object[0]);
                return Collections.singletonList(_basicDiagnostic);
            }
            _xblockexpression_1 = parseResult.getParsedValue();
            _xifexpression_1 = _xblockexpression_1;
        } else {
            String _value;
            _xifexpression_1 = _value = attributeValue.toValue();
        }
        String parsedValue = _xifexpression_1;
        ArrayList diagnostics = CollectionLiterals.newArrayList((Object[])new Diagnostic[0]);
        boolean bl2 = _tripleNotEquals_1 = validator != null;
        if (_tripleNotEquals_1) {
            List<Diagnostic> validationResults = validator.validate(attributeContext, parsedValue);
            String _value_1 = attributeValue.toValue();
            String _plus = "The " + attributeTypeName + " value '" + _value_1;
            String newMessagePrefix = String.valueOf(_plus) + "' is not semantically correct: ";
            for (Diagnostic result : validationResults) {
                String _message = result.getMessage();
                String newMessage = String.valueOf(newMessagePrefix) + _message;
                Object _xifexpression_2 = null;
                if (result instanceof RangeBasedDiagnostic) {
                    int _severity = ((RangeBasedDiagnostic)result).getSeverity();
                    int _offset = ((RangeBasedDiagnostic)result).getOffset();
                    int _length = ((RangeBasedDiagnostic)result).getLength();
                    CheckType _checkType = ((RangeBasedDiagnostic)result).getCheckType();
                    String[] _issueData = ((RangeBasedDiagnostic)result).getIssueData();
                    _xifexpression_2 = new RangeBasedDiagnosticEx(_severity, newMessage, null, _offset, _length, _checkType, attributeName, _issueData);
                } else {
                    int _severity_1 = result.getSeverity();
                    _xifexpression_2 = new BasicDiagnostic(_severity_1, null, -1, newMessage, new Object[0]);
                }
                diagnostics.add(_xifexpression_2);
            }
        }
        _xblockexpression = diagnostics;
        return _xblockexpression;
    }

    private static void checkAttributeRawValue(Context context, String attributeName, ID attributeValue) {
        boolean _not;
        Functions.Function1<Diagnostic, Boolean> _function;
        List<Diagnostic> _validateAttributeRawValue = DotAttributes.validateAttributeRawValue(context, attributeName, attributeValue);
        Iterable diagnostics = IterableExtensions.filter(_validateAttributeRawValue, (Functions.Function1)(_function = new Functions.Function1<Diagnostic, Boolean>(){

            public Boolean apply(Diagnostic it) {
                int _severity = it.getSeverity();
                return _severity >= 4;
            }
        }));
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)diagnostics);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _name = context.name();
            String _lowerCase = _name.toLowerCase();
            String _plus = "Cannot set " + _lowerCase;
            String _plus_1 = String.valueOf(_plus) + " attribute '";
            String _plus_2 = String.valueOf(_plus_1) + attributeName;
            String _plus_3 = String.valueOf(_plus_2) + "' to '";
            String _value = attributeValue.toValue();
            String _plus_4 = String.valueOf(_plus_3) + _value;
            String _plus_5 = String.valueOf(_plus_4) + "'. ";
            Functions.Function1<Diagnostic, Boolean> _function_1 = new Functions.Function1<Diagnostic, Boolean>(){

                public Boolean apply(Diagnostic it) {
                    String _message = it.getMessage();
                    boolean _isEmpty = _message.isEmpty();
                    return !_isEmpty;
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)diagnostics, (Functions.Function1)_function_1);
            Functions.Function1<Diagnostic, String> _function_2 = new Functions.Function1<Diagnostic, String>(){

                public String apply(Diagnostic it) {
                    return it.getMessage();
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_2);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)" ");
            String _plus_6 = String.valueOf(_plus_5) + _join;
            throw new IllegalArgumentException(_plus_6);
        }
    }

    public static List<Diagnostic> validateAttributeRawValue(Context attributeContext, String attributeName, ID attributeValue) {
        List<Object> _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)attributeName, (Object)ARROWHEAD__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(ARROWTYPE_PARSER, ARROWTYPE_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)ARROWSIZE__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(DOUBLE_PARSER, ARROWSIZE_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)ARROWTAIL__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(ARROWTYPE_PARSER, ARROWTYPE_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)BB__GC)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(RECT_PARSER, RECT_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)BGCOLOR__GC)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(COLORLIST_PARSER, COLORLIST_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)CLUSTERRANK__G)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(CLUSTERMODE_PARSER, null, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)COLORSCHEME__GCNE)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(null, COLORSCHEME_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)COLOR__CNE)) {
            String _value;
            boolean _isEmpty;
            boolean _not;
            boolean _tripleNotEquals;
            _matched = true;
            List<Object> _xifexpression = null;
            boolean _and = false;
            boolean bl = _tripleNotEquals = attributeValue != null;
            _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = (_value = attributeValue.toValue()).isEmpty()));
            if (_and) {
                boolean _equals_2;
                boolean _equals_1;
                List<Object> _xifexpression_1 = null;
                boolean _or = false;
                boolean _or_1 = false;
                boolean _equals = Objects.equal((Object)((Object)attributeContext), (Object)((Object)Context.GRAPH));
                _or_1 = _equals ? true : (_equals_1 = Objects.equal((Object)((Object)attributeContext), (Object)((Object)Context.CLUSTER)));
                _or = _or_1 ? true : (_equals_2 = Objects.equal((Object)((Object)attributeContext), (Object)((Object)Context.NODE)));
                if (_or) {
                    _xifexpression_1 = DotAttributes.validateAttributeRawValue(COLOR_PARSER, COLOR_VALIDATOR, attributeContext, attributeName, attributeValue);
                } else {
                    List<Object> _xifexpression_2 = null;
                    boolean _equals_3 = Objects.equal((Object)((Object)attributeContext), (Object)((Object)Context.EDGE));
                    _xifexpression_2 = _equals_3 ? DotAttributes.validateAttributeRawValue(COLORLIST_PARSER, COLORLIST_VALIDATOR, attributeContext, attributeName, attributeValue) : Collections.emptyList();
                    _xifexpression_1 = _xifexpression_2;
                }
                _xifexpression = _xifexpression_1;
            } else {
                _xifexpression = Collections.emptyList();
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)DIR__E)) {
            String _value_1;
            boolean _isEmpty_1;
            boolean _not_1;
            boolean _tripleNotEquals_1;
            _matched = true;
            List<Object> _xifexpression_3 = null;
            boolean _and_1 = false;
            boolean bl = _tripleNotEquals_1 = attributeValue != null;
            _and_1 = !_tripleNotEquals_1 ? false : (_not_1 = !(_isEmpty_1 = (_value_1 = attributeValue.toValue()).isEmpty()));
            _xifexpression_3 = _and_1 ? DotAttributes.validateAttributeRawValue(DIRTYPE_PARSER, null, attributeContext, attributeName, attributeValue) : Collections.emptyList();
            _switchResult = _xifexpression_3;
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)DISTORTION__N)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(DOUBLE_PARSER, DISTORTION_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)EDGETOOLTIP__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(ESCSTRING_PARSER, ESCSTRING_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)FILLCOLOR__CNE)) {
            boolean _equals_6;
            boolean _equals_5;
            _matched = true;
            List<Object> _xifexpression_4 = null;
            boolean _or_2 = false;
            boolean _or_3 = false;
            boolean _equals_4 = Objects.equal((Object)((Object)attributeContext), (Object)((Object)Context.GRAPH));
            _or_3 = _equals_4 ? true : (_equals_5 = Objects.equal((Object)((Object)attributeContext), (Object)((Object)Context.CLUSTER)));
            _or_2 = _or_3 ? true : (_equals_6 = Objects.equal((Object)((Object)attributeContext), (Object)((Object)Context.NODE)));
            if (_or_2) {
                _xifexpression_4 = DotAttributes.validateAttributeRawValue(COLORLIST_PARSER, COLORLIST_VALIDATOR, attributeContext, attributeName, attributeValue);
            } else {
                List<Object> _xifexpression_5 = null;
                boolean _equals_7 = Objects.equal((Object)((Object)attributeContext), (Object)((Object)Context.EDGE));
                _xifexpression_5 = _equals_7 ? DotAttributes.validateAttributeRawValue(COLOR_PARSER, COLOR_VALIDATOR, attributeContext, attributeName, attributeValue) : Collections.emptyList();
                _xifexpression_4 = _xifexpression_5;
            }
            _switchResult = _xifexpression_4;
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)FIXEDSIZE__N)) {
            String _value_2;
            boolean _isEmpty_2;
            boolean _not_2;
            boolean _tripleNotEquals_2;
            _matched = true;
            List<Object> _xifexpression_6 = null;
            boolean _and_2 = false;
            boolean bl = _tripleNotEquals_2 = attributeValue != null;
            _and_2 = !_tripleNotEquals_2 ? false : (_not_2 = !(_isEmpty_2 = (_value_2 = attributeValue.toValue()).isEmpty()));
            _xifexpression_6 = _and_2 ? DotAttributes.validateAttributeRawValue(BOOL_PARSER, null, attributeContext, FIXEDSIZE__N, attributeValue) : Collections.emptyList();
            _switchResult = _xifexpression_6;
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)FONTCOLOR__GCNE)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(COLOR_PARSER, COLOR_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)FONTNAME__GCNE)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(FONTNAME_PARSER, null, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)FONTSIZE__GCNE)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(DOUBLE_PARSER, FONTSIZE_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)FORCELABELS__G)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(BOOL_PARSER, null, attributeContext, FORCELABELS__G, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)HEAD_LP__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(POINT_PARSER, POINT_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)HEADPORT__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(PORTPOS_PARSER, PORTPOS_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)HEADTOOLTIP__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(ESCSTRING_PARSER, ESCSTRING_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)HEIGHT__N)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(DOUBLE_PARSER, HEIGHT_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)LABEL__GCNE)) {
            _matched = true;
            List<Object> _xifexpression_7 = null;
            ID.Type _type = attributeValue.getType();
            boolean _equals_8 = Objects.equal((Object)((Object)_type), (Object)((Object)ID.Type.HTML_STRING));
            if (_equals_8) {
                _xifexpression_7 = DotAttributes.validateAttributeRawValue(HTML_LABEL_PARSER, HTML_LABEL_VALIDATOR, attributeContext, attributeName, attributeValue);
            } else {
                List<Object> _xifexpression_8 = null;
                ID.Type _type_1 = attributeValue.getType();
                boolean _equals_9 = Objects.equal((Object)((Object)_type_1), (Object)((Object)ID.Type.QUOTED_STRING));
                _xifexpression_8 = _equals_9 ? DotAttributes.validateAttributeRawValue(ESCSTRING_PARSER, ESCSTRING_VALIDATOR, attributeContext, attributeName, attributeValue) : Collections.emptyList();
                _xifexpression_7 = _xifexpression_8;
            }
            _switchResult = _xifexpression_7;
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)LABELFONTCOLOR__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(COLOR_PARSER, COLOR_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)LABELFONTNAME__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(FONTNAME_PARSER, null, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)LABELFONTSIZE__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(DOUBLE_PARSER, FONTSIZE_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)LABELTOOLTIP__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(ESCSTRING_PARSER, ESCSTRING_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)LAYOUT__G)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(LAYOUT_PARSER, null, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)LP__GCE)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(POINT_PARSER, POINT_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)NODESEP__G)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(DOUBLE_PARSER, NODESEP_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)OUTPUTORDER__G)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(OUTPUTMODE_PARSER, null, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)PAGEDIR__G)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(PAGEDIR_PARSER, null, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)PENWIDTH__CNE)) {
            String _value_3;
            boolean _isEmpty_3;
            boolean _not_3;
            boolean _tripleNotEquals_3;
            _matched = true;
            List<Object> _xifexpression_9 = null;
            boolean _and_3 = false;
            boolean bl = _tripleNotEquals_3 = attributeValue != null;
            _and_3 = !_tripleNotEquals_3 ? false : (_not_3 = !(_isEmpty_3 = (_value_3 = attributeValue.toValue()).isEmpty()));
            _xifexpression_9 = _and_3 ? DotAttributes.validateAttributeRawValue(DOUBLE_PARSER, PENWIDTH_VALIDATOR, attributeContext, attributeName, attributeValue) : Collections.emptyList();
            _switchResult = _xifexpression_9;
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)POS__NE)) {
            _matched = true;
            List<Object> _xifexpression_10 = null;
            boolean _equals_10 = Objects.equal((Object)((Object)attributeContext), (Object)((Object)Context.NODE));
            if (_equals_10) {
                _xifexpression_10 = DotAttributes.validateAttributeRawValue(POINT_PARSER, POINT_VALIDATOR, attributeContext, attributeName, attributeValue);
            } else {
                List<Object> _xifexpression_11 = null;
                boolean _equals_11 = Objects.equal((Object)((Object)attributeContext), (Object)((Object)Context.EDGE));
                _xifexpression_11 = _equals_11 ? DotAttributes.validateAttributeRawValue(SPLINETYPE_PARSER, SPLINETYPE_VALIDATOR, attributeContext, attributeName, attributeValue) : Collections.emptyList();
                _xifexpression_10 = _xifexpression_11;
            }
            _switchResult = _xifexpression_10;
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)RANKDIR__G)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(RANKDIR_PARSER, null, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)RANK__S)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(RANKTYPE_PARSER, null, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)SHAPE__N)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(SHAPE_PARSER, SHAPE_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)SIDES__N)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(INT_PARSER, SIDES_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)SKEW__N)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(DOUBLE_PARSER, SKEW_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)SPLINES__G)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(SPLINES_PARSER, null, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)STYLE__GCNE)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(STYLE_PARSER, STYLE_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)TAIL_LP__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(POINT_PARSER, POINT_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)TAILPORT__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(PORTPOS_PARSER, PORTPOS_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)TAILTOOLTIP__E)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(ESCSTRING_PARSER, ESCSTRING_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)TOOLTIP__CNE)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(ESCSTRING_PARSER, ESCSTRING_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)WIDTH__N)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(DOUBLE_PARSER, WIDTH_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched && Objects.equal((Object)attributeName, (Object)XLP__NE)) {
            _matched = true;
            _switchResult = DotAttributes.validateAttributeRawValue(POINT_PARSER, POINT_VALIDATOR, attributeContext, attributeName, attributeValue);
        }
        if (!_matched) {
            _switchResult = Collections.emptyList();
        }
        return _switchResult;
    }

    public static ID _getNameRaw(Graph graph) {
        ReadOnlyMapProperty _attributesProperty = graph.attributesProperty();
        Object _get = _attributesProperty.get((Object)_NAME__GNE);
        return (ID)_get;
    }

    public static String _getName(Graph graph) {
        String _xblockexpression = null;
        ID _nameRaw = DotAttributes._getNameRaw(graph);
        String _xifexpression = null;
        boolean _tripleNotEquals = _nameRaw != null;
        _xifexpression = _tripleNotEquals ? _nameRaw.toValue() : null;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static ID _getNameRaw(Node node) {
        ReadOnlyMapProperty _attributesProperty = node.attributesProperty();
        Object _get = _attributesProperty.get((Object)_NAME__GNE);
        return (ID)_get;
    }

    public static String _getName(Node node) {
        String _xblockexpression = null;
        ID _nameRaw = DotAttributes._getNameRaw(node);
        String _xifexpression = null;
        boolean _tripleNotEquals = _nameRaw != null;
        _xifexpression = _tripleNotEquals ? _nameRaw.toValue() : null;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static GraphType _getType(Graph graph) {
        ReadOnlyMapProperty _attributesProperty = graph.attributesProperty();
        Object _get = _attributesProperty.get((Object)_TYPE__G);
        return (GraphType)((Object)_get);
    }

    public static void _setNameRaw(Graph graph, ID name) {
        ReadOnlyMapProperty _attributesProperty = graph.attributesProperty();
        _attributesProperty.put((Object)_NAME__GNE, (Object)name);
    }

    public static void _setName(Graph graph, String name) {
        ID _fromValue = ID.fromValue(name);
        DotAttributes._setNameRaw(graph, _fromValue);
    }

    public static void _setNameRaw(Node node, ID name) {
        ReadOnlyMapProperty _attributesProperty = node.attributesProperty();
        _attributesProperty.put((Object)_NAME__GNE, (Object)name);
    }

    public static void _setName(Node node, String name) {
        ID _fromValue = ID.fromValue(name);
        DotAttributes._setNameRaw(node, _fromValue);
    }

    public static String _getName(Edge edge) {
        Node _source = edge.getSource();
        String __getName = DotAttributes._getName(_source);
        String _switchResult = null;
        Graph _graph = edge.getGraph();
        Graph _rootGraph = null;
        if (_graph != null) {
            _rootGraph = _graph.getRootGraph();
        }
        GraphType __getType = null;
        if (_rootGraph != null) {
            __getType = DotAttributes._getType(_rootGraph);
        }
        if (__getType != null) {
            switch (__getType) {
                case GRAPH: {
                    _switchResult = EdgeOp.UNDIRECTED.getLiteral();
                    break;
                }
                case DIGRAPH: {
                    _switchResult = EdgeOp.DIRECTED.getLiteral();
                    break;
                }
            }
        }
        String _plus = String.valueOf(__getName) + _switchResult;
        Node _target = edge.getTarget();
        String __getName_1 = DotAttributes._getName(_target);
        return String.valueOf(_plus) + __getName_1;
    }

    public static void _setType(Graph graph, GraphType type) {
        ReadOnlyMapProperty _attributesProperty = graph.attributesProperty();
        _attributesProperty.put((Object)_TYPE__G, (Object)type);
    }

    public static ID getArrowheadRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)ARROWHEAD__E);
    }

    public static void setArrowheadRaw(Edge edge, ID arrowhead) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, ARROWHEAD__E, arrowhead);
        edge.attributesProperty().put((Object)ARROWHEAD__E, (Object)arrowhead);
    }

    public static String getArrowhead(Edge edge) {
        ID arrowheadRaw = DotAttributes.getArrowheadRaw(edge);
        return arrowheadRaw != null ? arrowheadRaw.toValue() : null;
    }

    public static void setArrowhead(Edge edge, String arrowhead) {
        DotAttributes.setArrowheadRaw(edge, ID.fromValue(arrowhead, ID.Type.STRING));
    }

    public static ArrowType getArrowheadParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(ARROWTYPE_PARSER, DotAttributes.getArrowhead(edge));
    }

    public static void setArrowheadParsed(Edge edge, ArrowType arrowhead) {
        DotAttributes.setArrowhead(edge, DotAttributes.serializeAttributeValue(ARROWTYPE_SERIALIZER, arrowhead));
    }

    public static ID getArrowsizeRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)ARROWSIZE__E);
    }

    public static void setArrowsizeRaw(Edge edge, ID arrowsize) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, ARROWSIZE__E, arrowsize);
        edge.attributesProperty().put((Object)ARROWSIZE__E, (Object)arrowsize);
    }

    public static String getArrowsize(Edge edge) {
        ID arrowsizeRaw = DotAttributes.getArrowsizeRaw(edge);
        return arrowsizeRaw != null ? arrowsizeRaw.toValue() : null;
    }

    public static void setArrowsize(Edge edge, String arrowsize) {
        DotAttributes.setArrowsizeRaw(edge, ID.fromValue(arrowsize, ID.Type.NUMERAL));
    }

    public static Double getArrowsizeParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getArrowsize(edge));
    }

    public static void setArrowsizeParsed(Edge edge, Double arrowsize) {
        DotAttributes.setArrowsize(edge, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, arrowsize));
    }

    public static ID getArrowtailRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)ARROWTAIL__E);
    }

    public static void setArrowtailRaw(Edge edge, ID arrowtail) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, ARROWTAIL__E, arrowtail);
        edge.attributesProperty().put((Object)ARROWTAIL__E, (Object)arrowtail);
    }

    public static String getArrowtail(Edge edge) {
        ID arrowtailRaw = DotAttributes.getArrowtailRaw(edge);
        return arrowtailRaw != null ? arrowtailRaw.toValue() : null;
    }

    public static void setArrowtail(Edge edge, String arrowtail) {
        DotAttributes.setArrowtailRaw(edge, ID.fromValue(arrowtail, ID.Type.STRING));
    }

    public static ArrowType getArrowtailParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(ARROWTYPE_PARSER, DotAttributes.getArrowtail(edge));
    }

    public static void setArrowtailParsed(Edge edge, ArrowType arrowtail) {
        DotAttributes.setArrowtail(edge, DotAttributes.serializeAttributeValue(ARROWTYPE_SERIALIZER, arrowtail));
    }

    public static ID getBbRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)BB__GC);
    }

    public static void setBbRaw(Graph graph, ID bb) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, BB__GC, bb);
        graph.attributesProperty().put((Object)BB__GC, (Object)bb);
    }

    public static String getBb(Graph graph) {
        ID bbRaw = DotAttributes.getBbRaw(graph);
        return bbRaw != null ? bbRaw.toValue() : null;
    }

    public static void setBb(Graph graph, String bb) {
        DotAttributes.setBbRaw(graph, ID.fromValue(bb));
    }

    public static Rect getBbParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(RECT_PARSER, DotAttributes.getBb(graph));
    }

    public static void setBbParsed(Graph graph, Rect bb) {
        DotAttributes.setBb(graph, DotAttributes.serializeAttributeValue(RECT_SERIALIZER, bb));
    }

    public static ID getBgcolorRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)BGCOLOR__GC);
    }

    public static void setBgcolorRaw(Graph graph, ID bgcolor) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, BGCOLOR__GC, bgcolor);
        graph.attributesProperty().put((Object)BGCOLOR__GC, (Object)bgcolor);
    }

    public static String getBgcolor(Graph graph) {
        ID bgcolorRaw = DotAttributes.getBgcolorRaw(graph);
        return bgcolorRaw != null ? bgcolorRaw.toValue() : null;
    }

    public static void setBgcolor(Graph graph, String bgcolor) {
        DotAttributes.setBgcolorRaw(graph, ID.fromValue(bgcolor));
    }

    public static ColorList getBgcolorParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(COLORLIST_PARSER, DotAttributes.getBgcolor(graph));
    }

    public static void setBgcolorParsed(Graph graph, ColorList bgcolor) {
        DotAttributes.setBgcolor(graph, DotAttributes.serializeAttributeValue(COLORLIST_SERIALIZER, bgcolor));
    }

    public static ID getClusterrankRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)CLUSTERRANK__G);
    }

    public static void setClusterrankRaw(Graph graph, ID clusterrank) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, CLUSTERRANK__G, clusterrank);
        graph.attributesProperty().put((Object)CLUSTERRANK__G, (Object)clusterrank);
    }

    public static String getClusterrank(Graph graph) {
        ID clusterrankRaw = DotAttributes.getClusterrankRaw(graph);
        return clusterrankRaw != null ? clusterrankRaw.toValue() : null;
    }

    public static void setClusterrank(Graph graph, String clusterrank) {
        DotAttributes.setClusterrankRaw(graph, ID.fromValue(clusterrank, ID.Type.STRING));
    }

    public static ClusterMode getClusterrankParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(CLUSTERMODE_PARSER, DotAttributes.getClusterrank(graph));
    }

    public static void setClusterrankParsed(Graph graph, ClusterMode clusterrank) {
        DotAttributes.setClusterrank(graph, DotAttributes.serializeAttributeValue(CLUSTERMODE_SERIALIZER, clusterrank));
    }

    public static ID getColorRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)COLOR__CNE);
    }

    public static void setColorRaw(Graph graph, ID color) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, COLOR__CNE, color);
        graph.attributesProperty().put((Object)COLOR__CNE, (Object)color);
    }

    public static String getColor(Graph graph) {
        ID colorRaw = DotAttributes.getColorRaw(graph);
        return colorRaw != null ? colorRaw.toValue() : null;
    }

    public static void setColor(Graph graph, String color) {
        DotAttributes.setColorRaw(graph, ID.fromValue(color));
    }

    public static Color getColorParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(COLOR_PARSER, DotAttributes.getColor(graph));
    }

    public static void setColorParsed(Graph graph, Color color) {
        DotAttributes.setColor(graph, DotAttributes.serializeAttributeValue(COLOR_SERIALIZER, color));
    }

    public static ID getColorRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)COLOR__CNE);
    }

    public static void setColorRaw(Node node, ID color) {
        DotAttributes.checkAttributeRawValue(Context.NODE, COLOR__CNE, color);
        node.attributesProperty().put((Object)COLOR__CNE, (Object)color);
    }

    public static String getColor(Node node) {
        ID colorRaw = DotAttributes.getColorRaw(node);
        return colorRaw != null ? colorRaw.toValue() : null;
    }

    public static void setColor(Node node, String color) {
        DotAttributes.setColorRaw(node, ID.fromValue(color));
    }

    public static Color getColorParsed(Node node) {
        return DotAttributes.parseAttributeValue(COLOR_PARSER, DotAttributes.getColor(node));
    }

    public static void setColorParsed(Node node, Color color) {
        DotAttributes.setColor(node, DotAttributes.serializeAttributeValue(COLOR_SERIALIZER, color));
    }

    public static ID getColorRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)COLOR__CNE);
    }

    public static void setColorRaw(Edge edge, ID color) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, COLOR__CNE, color);
        edge.attributesProperty().put((Object)COLOR__CNE, (Object)color);
    }

    public static String getColor(Edge edge) {
        ID colorRaw = DotAttributes.getColorRaw(edge);
        return colorRaw != null ? colorRaw.toValue() : null;
    }

    public static void setColor(Edge edge, String color) {
        DotAttributes.setColorRaw(edge, ID.fromValue(color));
    }

    public static ColorList getColorParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(COLORLIST_PARSER, DotAttributes.getColor(edge));
    }

    public static void setColorParsed(Edge edge, ColorList color) {
        DotAttributes.setColor(edge, DotAttributes.serializeAttributeValue(COLORLIST_SERIALIZER, color));
    }

    public static ID getColorschemeRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)COLORSCHEME__GCNE);
    }

    public static void setColorschemeRaw(Graph graph, ID colorscheme) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, COLORSCHEME__GCNE, colorscheme);
        graph.attributesProperty().put((Object)COLORSCHEME__GCNE, (Object)colorscheme);
    }

    public static String getColorscheme(Graph graph) {
        ID colorschemeRaw = DotAttributes.getColorschemeRaw(graph);
        return colorschemeRaw != null ? colorschemeRaw.toValue() : null;
    }

    public static void setColorscheme(Graph graph, String colorscheme) {
        DotAttributes.setColorschemeRaw(graph, ID.fromValue(colorscheme));
    }

    public static ID getColorschemeRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)COLORSCHEME__GCNE);
    }

    public static void setColorschemeRaw(Node node, ID colorscheme) {
        DotAttributes.checkAttributeRawValue(Context.NODE, COLORSCHEME__GCNE, colorscheme);
        node.attributesProperty().put((Object)COLORSCHEME__GCNE, (Object)colorscheme);
    }

    public static String getColorscheme(Node node) {
        ID colorschemeRaw = DotAttributes.getColorschemeRaw(node);
        return colorschemeRaw != null ? colorschemeRaw.toValue() : null;
    }

    public static void setColorscheme(Node node, String colorscheme) {
        DotAttributes.setColorschemeRaw(node, ID.fromValue(colorscheme));
    }

    public static ID getColorschemeRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)COLORSCHEME__GCNE);
    }

    public static void setColorschemeRaw(Edge edge, ID colorscheme) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, COLORSCHEME__GCNE, colorscheme);
        edge.attributesProperty().put((Object)COLORSCHEME__GCNE, (Object)colorscheme);
    }

    public static String getColorscheme(Edge edge) {
        ID colorschemeRaw = DotAttributes.getColorschemeRaw(edge);
        return colorschemeRaw != null ? colorschemeRaw.toValue() : null;
    }

    public static void setColorscheme(Edge edge, String colorscheme) {
        DotAttributes.setColorschemeRaw(edge, ID.fromValue(colorscheme));
    }

    public static ID getDirRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)DIR__E);
    }

    public static void setDirRaw(Edge edge, ID dir) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, DIR__E, dir);
        edge.attributesProperty().put((Object)DIR__E, (Object)dir);
    }

    public static String getDir(Edge edge) {
        ID dirRaw = DotAttributes.getDirRaw(edge);
        return dirRaw != null ? dirRaw.toValue() : null;
    }

    public static void setDir(Edge edge, String dir) {
        DotAttributes.setDirRaw(edge, ID.fromValue(dir, ID.Type.STRING));
    }

    public static DirType getDirParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(DIRTYPE_PARSER, DotAttributes.getDir(edge));
    }

    public static void setDirParsed(Edge edge, DirType dir) {
        DotAttributes.setDir(edge, DotAttributes.serializeAttributeValue(DIRTYPE_SERIALIZER, dir));
    }

    public static ID getDistortionRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)DISTORTION__N);
    }

    public static void setDistortionRaw(Node node, ID distortion) {
        DotAttributes.checkAttributeRawValue(Context.NODE, DISTORTION__N, distortion);
        node.attributesProperty().put((Object)DISTORTION__N, (Object)distortion);
    }

    public static String getDistortion(Node node) {
        ID distortionRaw = DotAttributes.getDistortionRaw(node);
        return distortionRaw != null ? distortionRaw.toValue() : null;
    }

    public static void setDistortion(Node node, String distortion) {
        DotAttributes.setDistortionRaw(node, ID.fromValue(distortion, ID.Type.NUMERAL));
    }

    public static Double getDistortionParsed(Node node) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getDistortion(node));
    }

    public static void setDistortionParsed(Node node, Double distortion) {
        DotAttributes.setDistortion(node, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, distortion));
    }

    public static ID getEdgetooltipRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)EDGETOOLTIP__E);
    }

    public static void setEdgetooltipRaw(Edge edge, ID edgetooltip) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, EDGETOOLTIP__E, edgetooltip);
        edge.attributesProperty().put((Object)EDGETOOLTIP__E, (Object)edgetooltip);
    }

    public static String getEdgetooltip(Edge edge) {
        ID edgetooltipRaw = DotAttributes.getEdgetooltipRaw(edge);
        return edgetooltipRaw != null ? edgetooltipRaw.toValue() : null;
    }

    public static void setEdgetooltip(Edge edge, String edgetooltip) {
        DotAttributes.setEdgetooltipRaw(edge, ID.fromValue(edgetooltip));
    }

    public static EscString getEdgetooltipParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(ESCSTRING_PARSER, DotAttributes.getEdgetooltip(edge));
    }

    public static void setEdgetooltipParsed(Edge edge, EscString edgetooltip) {
        DotAttributes.setEdgetooltip(edge, DotAttributes.serializeAttributeValue(ESCSTRING_SERIALIZER, edgetooltip));
    }

    public static ID getFillcolorRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)FILLCOLOR__CNE);
    }

    public static void setFillcolorRaw(Graph graph, ID fillcolor) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, FILLCOLOR__CNE, fillcolor);
        graph.attributesProperty().put((Object)FILLCOLOR__CNE, (Object)fillcolor);
    }

    public static String getFillcolor(Graph graph) {
        ID fillcolorRaw = DotAttributes.getFillcolorRaw(graph);
        return fillcolorRaw != null ? fillcolorRaw.toValue() : null;
    }

    public static void setFillcolor(Graph graph, String fillcolor) {
        DotAttributes.setFillcolorRaw(graph, ID.fromValue(fillcolor));
    }

    public static ColorList getFillcolorParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(COLORLIST_PARSER, DotAttributes.getFillcolor(graph));
    }

    public static void setFillcolorParsed(Graph graph, ColorList fillcolor) {
        DotAttributes.setFillcolor(graph, DotAttributes.serializeAttributeValue(COLORLIST_SERIALIZER, fillcolor));
    }

    public static ID getFillcolorRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)FILLCOLOR__CNE);
    }

    public static void setFillcolorRaw(Node node, ID fillcolor) {
        DotAttributes.checkAttributeRawValue(Context.NODE, FILLCOLOR__CNE, fillcolor);
        node.attributesProperty().put((Object)FILLCOLOR__CNE, (Object)fillcolor);
    }

    public static String getFillcolor(Node node) {
        ID fillcolorRaw = DotAttributes.getFillcolorRaw(node);
        return fillcolorRaw != null ? fillcolorRaw.toValue() : null;
    }

    public static void setFillcolor(Node node, String fillcolor) {
        DotAttributes.setFillcolorRaw(node, ID.fromValue(fillcolor));
    }

    public static ColorList getFillcolorParsed(Node node) {
        return DotAttributes.parseAttributeValue(COLORLIST_PARSER, DotAttributes.getFillcolor(node));
    }

    public static void setFillcolorParsed(Node node, ColorList fillcolor) {
        DotAttributes.setFillcolor(node, DotAttributes.serializeAttributeValue(COLORLIST_SERIALIZER, fillcolor));
    }

    public static ID getFillcolorRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)FILLCOLOR__CNE);
    }

    public static void setFillcolorRaw(Edge edge, ID fillcolor) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, FILLCOLOR__CNE, fillcolor);
        edge.attributesProperty().put((Object)FILLCOLOR__CNE, (Object)fillcolor);
    }

    public static String getFillcolor(Edge edge) {
        ID fillcolorRaw = DotAttributes.getFillcolorRaw(edge);
        return fillcolorRaw != null ? fillcolorRaw.toValue() : null;
    }

    public static void setFillcolor(Edge edge, String fillcolor) {
        DotAttributes.setFillcolorRaw(edge, ID.fromValue(fillcolor));
    }

    public static Color getFillcolorParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(COLOR_PARSER, DotAttributes.getFillcolor(edge));
    }

    public static void setFillcolorParsed(Edge edge, Color fillcolor) {
        DotAttributes.setFillcolor(edge, DotAttributes.serializeAttributeValue(COLOR_SERIALIZER, fillcolor));
    }

    public static ID getFixedsizeRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)FIXEDSIZE__N);
    }

    public static void setFixedsizeRaw(Node node, ID fixedsize) {
        DotAttributes.checkAttributeRawValue(Context.NODE, FIXEDSIZE__N, fixedsize);
        node.attributesProperty().put((Object)FIXEDSIZE__N, (Object)fixedsize);
    }

    public static String getFixedsize(Node node) {
        ID fixedsizeRaw = DotAttributes.getFixedsizeRaw(node);
        return fixedsizeRaw != null ? fixedsizeRaw.toValue() : null;
    }

    public static void setFixedsize(Node node, String fixedsize) {
        DotAttributes.setFixedsizeRaw(node, ID.fromValue(fixedsize, ID.Type.STRING));
    }

    public static Boolean getFixedsizeParsed(Node node) {
        return DotAttributes.parseAttributeValue(BOOL_PARSER, DotAttributes.getFixedsize(node));
    }

    public static void setFixedsizeParsed(Node node, Boolean fixedsize) {
        DotAttributes.setFixedsize(node, DotAttributes.serializeAttributeValue(BOOL_SERIALIZER, fixedsize));
    }

    public static ID getFontcolorRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)FONTCOLOR__GCNE);
    }

    public static void setFontcolorRaw(Graph graph, ID fontcolor) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, FONTCOLOR__GCNE, fontcolor);
        graph.attributesProperty().put((Object)FONTCOLOR__GCNE, (Object)fontcolor);
    }

    public static String getFontcolor(Graph graph) {
        ID fontcolorRaw = DotAttributes.getFontcolorRaw(graph);
        return fontcolorRaw != null ? fontcolorRaw.toValue() : null;
    }

    public static void setFontcolor(Graph graph, String fontcolor) {
        DotAttributes.setFontcolorRaw(graph, ID.fromValue(fontcolor));
    }

    public static Color getFontcolorParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(COLOR_PARSER, DotAttributes.getFontcolor(graph));
    }

    public static void setFontcolorParsed(Graph graph, Color fontcolor) {
        DotAttributes.setFontcolor(graph, DotAttributes.serializeAttributeValue(COLOR_SERIALIZER, fontcolor));
    }

    public static ID getFontcolorRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)FONTCOLOR__GCNE);
    }

    public static void setFontcolorRaw(Node node, ID fontcolor) {
        DotAttributes.checkAttributeRawValue(Context.NODE, FONTCOLOR__GCNE, fontcolor);
        node.attributesProperty().put((Object)FONTCOLOR__GCNE, (Object)fontcolor);
    }

    public static String getFontcolor(Node node) {
        ID fontcolorRaw = DotAttributes.getFontcolorRaw(node);
        return fontcolorRaw != null ? fontcolorRaw.toValue() : null;
    }

    public static void setFontcolor(Node node, String fontcolor) {
        DotAttributes.setFontcolorRaw(node, ID.fromValue(fontcolor));
    }

    public static Color getFontcolorParsed(Node node) {
        return DotAttributes.parseAttributeValue(COLOR_PARSER, DotAttributes.getFontcolor(node));
    }

    public static void setFontcolorParsed(Node node, Color fontcolor) {
        DotAttributes.setFontcolor(node, DotAttributes.serializeAttributeValue(COLOR_SERIALIZER, fontcolor));
    }

    public static ID getFontcolorRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)FONTCOLOR__GCNE);
    }

    public static void setFontcolorRaw(Edge edge, ID fontcolor) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, FONTCOLOR__GCNE, fontcolor);
        edge.attributesProperty().put((Object)FONTCOLOR__GCNE, (Object)fontcolor);
    }

    public static String getFontcolor(Edge edge) {
        ID fontcolorRaw = DotAttributes.getFontcolorRaw(edge);
        return fontcolorRaw != null ? fontcolorRaw.toValue() : null;
    }

    public static void setFontcolor(Edge edge, String fontcolor) {
        DotAttributes.setFontcolorRaw(edge, ID.fromValue(fontcolor));
    }

    public static Color getFontcolorParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(COLOR_PARSER, DotAttributes.getFontcolor(edge));
    }

    public static void setFontcolorParsed(Edge edge, Color fontcolor) {
        DotAttributes.setFontcolor(edge, DotAttributes.serializeAttributeValue(COLOR_SERIALIZER, fontcolor));
    }

    public static ID getFontnameRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)FONTNAME__GCNE);
    }

    public static void setFontnameRaw(Graph graph, ID fontname) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, FONTNAME__GCNE, fontname);
        graph.attributesProperty().put((Object)FONTNAME__GCNE, (Object)fontname);
    }

    public static String getFontname(Graph graph) {
        ID fontnameRaw = DotAttributes.getFontnameRaw(graph);
        return fontnameRaw != null ? fontnameRaw.toValue() : null;
    }

    public static void setFontname(Graph graph, String fontname) {
        DotAttributes.setFontnameRaw(graph, ID.fromValue(fontname));
    }

    public static FontName getFontnameParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(FONTNAME_PARSER, DotAttributes.getFontname(graph));
    }

    public static void setFontnameParsed(Graph graph, FontName fontname) {
        DotAttributes.setFontname(graph, DotAttributes.serializeAttributeValue(FONTNAME_SERIALIZER, fontname));
    }

    public static ID getFontnameRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)FONTNAME__GCNE);
    }

    public static void setFontnameRaw(Node node, ID fontname) {
        DotAttributes.checkAttributeRawValue(Context.NODE, FONTNAME__GCNE, fontname);
        node.attributesProperty().put((Object)FONTNAME__GCNE, (Object)fontname);
    }

    public static String getFontname(Node node) {
        ID fontnameRaw = DotAttributes.getFontnameRaw(node);
        return fontnameRaw != null ? fontnameRaw.toValue() : null;
    }

    public static void setFontname(Node node, String fontname) {
        DotAttributes.setFontnameRaw(node, ID.fromValue(fontname));
    }

    public static FontName getFontnameParsed(Node node) {
        return DotAttributes.parseAttributeValue(FONTNAME_PARSER, DotAttributes.getFontname(node));
    }

    public static void setFontnameParsed(Node node, FontName fontname) {
        DotAttributes.setFontname(node, DotAttributes.serializeAttributeValue(FONTNAME_SERIALIZER, fontname));
    }

    public static ID getFontnameRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)FONTNAME__GCNE);
    }

    public static void setFontnameRaw(Edge edge, ID fontname) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, FONTNAME__GCNE, fontname);
        edge.attributesProperty().put((Object)FONTNAME__GCNE, (Object)fontname);
    }

    public static String getFontname(Edge edge) {
        ID fontnameRaw = DotAttributes.getFontnameRaw(edge);
        return fontnameRaw != null ? fontnameRaw.toValue() : null;
    }

    public static void setFontname(Edge edge, String fontname) {
        DotAttributes.setFontnameRaw(edge, ID.fromValue(fontname));
    }

    public static FontName getFontnameParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(FONTNAME_PARSER, DotAttributes.getFontname(edge));
    }

    public static void setFontnameParsed(Edge edge, FontName fontname) {
        DotAttributes.setFontname(edge, DotAttributes.serializeAttributeValue(FONTNAME_SERIALIZER, fontname));
    }

    public static ID getFontsizeRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)FONTSIZE__GCNE);
    }

    public static void setFontsizeRaw(Graph graph, ID fontsize) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, FONTSIZE__GCNE, fontsize);
        graph.attributesProperty().put((Object)FONTSIZE__GCNE, (Object)fontsize);
    }

    public static String getFontsize(Graph graph) {
        ID fontsizeRaw = DotAttributes.getFontsizeRaw(graph);
        return fontsizeRaw != null ? fontsizeRaw.toValue() : null;
    }

    public static void setFontsize(Graph graph, String fontsize) {
        DotAttributes.setFontsizeRaw(graph, ID.fromValue(fontsize, ID.Type.NUMERAL));
    }

    public static Double getFontsizeParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getFontsize(graph));
    }

    public static void setFontsizeParsed(Graph graph, Double fontsize) {
        DotAttributes.setFontsize(graph, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, fontsize));
    }

    public static ID getFontsizeRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)FONTSIZE__GCNE);
    }

    public static void setFontsizeRaw(Node node, ID fontsize) {
        DotAttributes.checkAttributeRawValue(Context.NODE, FONTSIZE__GCNE, fontsize);
        node.attributesProperty().put((Object)FONTSIZE__GCNE, (Object)fontsize);
    }

    public static String getFontsize(Node node) {
        ID fontsizeRaw = DotAttributes.getFontsizeRaw(node);
        return fontsizeRaw != null ? fontsizeRaw.toValue() : null;
    }

    public static void setFontsize(Node node, String fontsize) {
        DotAttributes.setFontsizeRaw(node, ID.fromValue(fontsize, ID.Type.NUMERAL));
    }

    public static Double getFontsizeParsed(Node node) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getFontsize(node));
    }

    public static void setFontsizeParsed(Node node, Double fontsize) {
        DotAttributes.setFontsize(node, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, fontsize));
    }

    public static ID getFontsizeRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)FONTSIZE__GCNE);
    }

    public static void setFontsizeRaw(Edge edge, ID fontsize) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, FONTSIZE__GCNE, fontsize);
        edge.attributesProperty().put((Object)FONTSIZE__GCNE, (Object)fontsize);
    }

    public static String getFontsize(Edge edge) {
        ID fontsizeRaw = DotAttributes.getFontsizeRaw(edge);
        return fontsizeRaw != null ? fontsizeRaw.toValue() : null;
    }

    public static void setFontsize(Edge edge, String fontsize) {
        DotAttributes.setFontsizeRaw(edge, ID.fromValue(fontsize, ID.Type.NUMERAL));
    }

    public static Double getFontsizeParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getFontsize(edge));
    }

    public static void setFontsizeParsed(Edge edge, Double fontsize) {
        DotAttributes.setFontsize(edge, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, fontsize));
    }

    public static ID getForcelabelsRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)FORCELABELS__G);
    }

    public static void setForcelabelsRaw(Graph graph, ID forcelabels) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, FORCELABELS__G, forcelabels);
        graph.attributesProperty().put((Object)FORCELABELS__G, (Object)forcelabels);
    }

    public static String getForcelabels(Graph graph) {
        ID forcelabelsRaw = DotAttributes.getForcelabelsRaw(graph);
        return forcelabelsRaw != null ? forcelabelsRaw.toValue() : null;
    }

    public static void setForcelabels(Graph graph, String forcelabels) {
        DotAttributes.setForcelabelsRaw(graph, ID.fromValue(forcelabels, ID.Type.STRING));
    }

    public static Boolean getForcelabelsParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(BOOL_PARSER, DotAttributes.getForcelabels(graph));
    }

    public static void setForcelabelsParsed(Graph graph, Boolean forcelabels) {
        DotAttributes.setForcelabels(graph, DotAttributes.serializeAttributeValue(BOOL_SERIALIZER, forcelabels));
    }

    public static ID getHeadLpRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)HEAD_LP__E);
    }

    public static void setHeadLpRaw(Edge edge, ID headLp) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, HEAD_LP__E, headLp);
        edge.attributesProperty().put((Object)HEAD_LP__E, (Object)headLp);
    }

    public static String getHeadLp(Edge edge) {
        ID headLpRaw = DotAttributes.getHeadLpRaw(edge);
        return headLpRaw != null ? headLpRaw.toValue() : null;
    }

    public static void setHeadLp(Edge edge, String headLp) {
        DotAttributes.setHeadLpRaw(edge, ID.fromValue(headLp, ID.Type.QUOTED_STRING));
    }

    public static Point getHeadLpParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(POINT_PARSER, DotAttributes.getHeadLp(edge));
    }

    public static void setHeadLpParsed(Edge edge, Point headLp) {
        DotAttributes.setHeadLp(edge, DotAttributes.serializeAttributeValue(POINT_SERIALIZER, headLp));
    }

    public static ID getHeadlabelRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)HEADLABEL__E);
    }

    public static void setHeadlabelRaw(Edge edge, ID headlabel) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, HEADLABEL__E, headlabel);
        edge.attributesProperty().put((Object)HEADLABEL__E, (Object)headlabel);
    }

    public static String getHeadlabel(Edge edge) {
        ID headlabelRaw = DotAttributes.getHeadlabelRaw(edge);
        return headlabelRaw != null ? headlabelRaw.toValue() : null;
    }

    public static void setHeadlabel(Edge edge, String headlabel) {
        DotAttributes.setHeadlabelRaw(edge, ID.fromValue(headlabel));
    }

    public static ID getHeadportRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)HEADPORT__E);
    }

    public static void setHeadportRaw(Edge edge, ID headport) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, HEADPORT__E, headport);
        edge.attributesProperty().put((Object)HEADPORT__E, (Object)headport);
    }

    public static String getHeadport(Edge edge) {
        ID headportRaw = DotAttributes.getHeadportRaw(edge);
        return headportRaw != null ? headportRaw.toValue() : null;
    }

    public static void setHeadport(Edge edge, String headport) {
        DotAttributes.setHeadportRaw(edge, ID.fromValue(headport));
    }

    public static PortPos getHeadportParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(PORTPOS_PARSER, DotAttributes.getHeadport(edge));
    }

    public static void setHeadportParsed(Edge edge, PortPos headport) {
        DotAttributes.setHeadport(edge, DotAttributes.serializeAttributeValue(PORTPOS_SERIALIZER, headport));
    }

    public static ID getHeadtooltipRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)HEADTOOLTIP__E);
    }

    public static void setHeadtooltipRaw(Edge edge, ID headtooltip) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, HEADTOOLTIP__E, headtooltip);
        edge.attributesProperty().put((Object)HEADTOOLTIP__E, (Object)headtooltip);
    }

    public static String getHeadtooltip(Edge edge) {
        ID headtooltipRaw = DotAttributes.getHeadtooltipRaw(edge);
        return headtooltipRaw != null ? headtooltipRaw.toValue() : null;
    }

    public static void setHeadtooltip(Edge edge, String headtooltip) {
        DotAttributes.setHeadtooltipRaw(edge, ID.fromValue(headtooltip));
    }

    public static EscString getHeadtooltipParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(ESCSTRING_PARSER, DotAttributes.getHeadtooltip(edge));
    }

    public static void setHeadtooltipParsed(Edge edge, EscString headtooltip) {
        DotAttributes.setHeadtooltip(edge, DotAttributes.serializeAttributeValue(ESCSTRING_SERIALIZER, headtooltip));
    }

    public static ID getHeightRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)HEIGHT__N);
    }

    public static void setHeightRaw(Node node, ID height) {
        DotAttributes.checkAttributeRawValue(Context.NODE, HEIGHT__N, height);
        node.attributesProperty().put((Object)HEIGHT__N, (Object)height);
    }

    public static String getHeight(Node node) {
        ID heightRaw = DotAttributes.getHeightRaw(node);
        return heightRaw != null ? heightRaw.toValue() : null;
    }

    public static void setHeight(Node node, String height) {
        DotAttributes.setHeightRaw(node, ID.fromValue(height, ID.Type.NUMERAL));
    }

    public static Double getHeightParsed(Node node) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getHeight(node));
    }

    public static void setHeightParsed(Node node, Double height) {
        DotAttributes.setHeight(node, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, height));
    }

    public static ID getIdRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)ID__GCNE);
    }

    public static void setIdRaw(Graph graph, ID id) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, ID__GCNE, id);
        graph.attributesProperty().put((Object)ID__GCNE, (Object)id);
    }

    public static String getId(Graph graph) {
        ID idRaw = DotAttributes.getIdRaw(graph);
        return idRaw != null ? idRaw.toValue() : null;
    }

    public static void setId(Graph graph, String id) {
        DotAttributes.setIdRaw(graph, ID.fromValue(id));
    }

    public static ID getIdRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)ID__GCNE);
    }

    public static void setIdRaw(Node node, ID id) {
        DotAttributes.checkAttributeRawValue(Context.NODE, ID__GCNE, id);
        node.attributesProperty().put((Object)ID__GCNE, (Object)id);
    }

    public static String getId(Node node) {
        ID idRaw = DotAttributes.getIdRaw(node);
        return idRaw != null ? idRaw.toValue() : null;
    }

    public static void setId(Node node, String id) {
        DotAttributes.setIdRaw(node, ID.fromValue(id));
    }

    public static ID getIdRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)ID__GCNE);
    }

    public static void setIdRaw(Edge edge, ID id) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, ID__GCNE, id);
        edge.attributesProperty().put((Object)ID__GCNE, (Object)id);
    }

    public static String getId(Edge edge) {
        ID idRaw = DotAttributes.getIdRaw(edge);
        return idRaw != null ? idRaw.toValue() : null;
    }

    public static void setId(Edge edge, String id) {
        DotAttributes.setIdRaw(edge, ID.fromValue(id));
    }

    public static ID getLabelRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)LABEL__GCNE);
    }

    public static void setLabelRaw(Graph graph, ID label) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, LABEL__GCNE, label);
        graph.attributesProperty().put((Object)LABEL__GCNE, (Object)label);
    }

    public static String getLabel(Graph graph) {
        ID labelRaw = DotAttributes.getLabelRaw(graph);
        return labelRaw != null ? labelRaw.toValue() : null;
    }

    public static void setLabel(Graph graph, String label) {
        DotAttributes.setLabelRaw(graph, ID.fromValue(label));
    }

    public static ID getLabelRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)LABEL__GCNE);
    }

    public static void setLabelRaw(Node node, ID label) {
        DotAttributes.checkAttributeRawValue(Context.NODE, LABEL__GCNE, label);
        node.attributesProperty().put((Object)LABEL__GCNE, (Object)label);
    }

    public static String getLabel(Node node) {
        ID labelRaw = DotAttributes.getLabelRaw(node);
        return labelRaw != null ? labelRaw.toValue() : null;
    }

    public static void setLabel(Node node, String label) {
        DotAttributes.setLabelRaw(node, ID.fromValue(label));
    }

    public static ID getLabelRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)LABEL__GCNE);
    }

    public static void setLabelRaw(Edge edge, ID label) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, LABEL__GCNE, label);
        edge.attributesProperty().put((Object)LABEL__GCNE, (Object)label);
    }

    public static String getLabel(Edge edge) {
        ID labelRaw = DotAttributes.getLabelRaw(edge);
        return labelRaw != null ? labelRaw.toValue() : null;
    }

    public static void setLabel(Edge edge, String label) {
        DotAttributes.setLabelRaw(edge, ID.fromValue(label));
    }

    public static ID getLabelfontcolorRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)LABELFONTCOLOR__E);
    }

    public static void setLabelfontcolorRaw(Edge edge, ID labelfontcolor) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, LABELFONTCOLOR__E, labelfontcolor);
        edge.attributesProperty().put((Object)LABELFONTCOLOR__E, (Object)labelfontcolor);
    }

    public static String getLabelfontcolor(Edge edge) {
        ID labelfontcolorRaw = DotAttributes.getLabelfontcolorRaw(edge);
        return labelfontcolorRaw != null ? labelfontcolorRaw.toValue() : null;
    }

    public static void setLabelfontcolor(Edge edge, String labelfontcolor) {
        DotAttributes.setLabelfontcolorRaw(edge, ID.fromValue(labelfontcolor));
    }

    public static Color getLabelfontcolorParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(COLOR_PARSER, DotAttributes.getLabelfontcolor(edge));
    }

    public static void setLabelfontcolorParsed(Edge edge, Color labelfontcolor) {
        DotAttributes.setLabelfontcolor(edge, DotAttributes.serializeAttributeValue(COLOR_SERIALIZER, labelfontcolor));
    }

    public static ID getLabelfontnameRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)LABELFONTNAME__E);
    }

    public static void setLabelfontnameRaw(Edge edge, ID labelfontname) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, LABELFONTNAME__E, labelfontname);
        edge.attributesProperty().put((Object)LABELFONTNAME__E, (Object)labelfontname);
    }

    public static String getLabelfontname(Edge edge) {
        ID labelfontnameRaw = DotAttributes.getLabelfontnameRaw(edge);
        return labelfontnameRaw != null ? labelfontnameRaw.toValue() : null;
    }

    public static void setLabelfontname(Edge edge, String labelfontname) {
        DotAttributes.setLabelfontnameRaw(edge, ID.fromValue(labelfontname));
    }

    public static FontName getLabelfontnameParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(FONTNAME_PARSER, DotAttributes.getLabelfontname(edge));
    }

    public static void setLabelfontnameParsed(Edge edge, FontName labelfontname) {
        DotAttributes.setLabelfontname(edge, DotAttributes.serializeAttributeValue(FONTNAME_SERIALIZER, labelfontname));
    }

    public static ID getLabelfontsizeRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)LABELFONTSIZE__E);
    }

    public static void setLabelfontsizeRaw(Edge edge, ID labelfontsize) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, LABELFONTSIZE__E, labelfontsize);
        edge.attributesProperty().put((Object)LABELFONTSIZE__E, (Object)labelfontsize);
    }

    public static String getLabelfontsize(Edge edge) {
        ID labelfontsizeRaw = DotAttributes.getLabelfontsizeRaw(edge);
        return labelfontsizeRaw != null ? labelfontsizeRaw.toValue() : null;
    }

    public static void setLabelfontsize(Edge edge, String labelfontsize) {
        DotAttributes.setLabelfontsizeRaw(edge, ID.fromValue(labelfontsize, ID.Type.NUMERAL));
    }

    public static Double getLabelfontsizeParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getLabelfontsize(edge));
    }

    public static void setLabelfontsizeParsed(Edge edge, Double labelfontsize) {
        DotAttributes.setLabelfontsize(edge, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, labelfontsize));
    }

    public static ID getLabeltooltipRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)LABELTOOLTIP__E);
    }

    public static void setLabeltooltipRaw(Edge edge, ID labeltooltip) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, LABELTOOLTIP__E, labeltooltip);
        edge.attributesProperty().put((Object)LABELTOOLTIP__E, (Object)labeltooltip);
    }

    public static String getLabeltooltip(Edge edge) {
        ID labeltooltipRaw = DotAttributes.getLabeltooltipRaw(edge);
        return labeltooltipRaw != null ? labeltooltipRaw.toValue() : null;
    }

    public static void setLabeltooltip(Edge edge, String labeltooltip) {
        DotAttributes.setLabeltooltipRaw(edge, ID.fromValue(labeltooltip));
    }

    public static EscString getLabeltooltipParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(ESCSTRING_PARSER, DotAttributes.getLabeltooltip(edge));
    }

    public static void setLabeltooltipParsed(Edge edge, EscString labeltooltip) {
        DotAttributes.setLabeltooltip(edge, DotAttributes.serializeAttributeValue(ESCSTRING_SERIALIZER, labeltooltip));
    }

    public static ID getLayoutRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)LAYOUT__G);
    }

    public static void setLayoutRaw(Graph graph, ID layout) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, LAYOUT__G, layout);
        graph.attributesProperty().put((Object)LAYOUT__G, (Object)layout);
    }

    public static String getLayout(Graph graph) {
        ID layoutRaw = DotAttributes.getLayoutRaw(graph);
        return layoutRaw != null ? layoutRaw.toValue() : null;
    }

    public static void setLayout(Graph graph, String layout) {
        DotAttributes.setLayoutRaw(graph, ID.fromValue(layout, ID.Type.STRING));
    }

    public static Layout getLayoutParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(LAYOUT_PARSER, DotAttributes.getLayout(graph));
    }

    public static void setLayoutParsed(Graph graph, Layout layout) {
        DotAttributes.setLayout(graph, DotAttributes.serializeAttributeValue(LAYOUT_SERIALIZER, layout));
    }

    public static ID getLpRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)LP__GCE);
    }

    public static void setLpRaw(Graph graph, ID lp) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, LP__GCE, lp);
        graph.attributesProperty().put((Object)LP__GCE, (Object)lp);
    }

    public static String getLp(Graph graph) {
        ID lpRaw = DotAttributes.getLpRaw(graph);
        return lpRaw != null ? lpRaw.toValue() : null;
    }

    public static void setLp(Graph graph, String lp) {
        DotAttributes.setLpRaw(graph, ID.fromValue(lp, ID.Type.QUOTED_STRING));
    }

    public static Point getLpParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(POINT_PARSER, DotAttributes.getLp(graph));
    }

    public static void setLpParsed(Graph graph, Point lp) {
        DotAttributes.setLp(graph, DotAttributes.serializeAttributeValue(POINT_SERIALIZER, lp));
    }

    public static ID getLpRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)LP__GCE);
    }

    public static void setLpRaw(Edge edge, ID lp) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, LP__GCE, lp);
        edge.attributesProperty().put((Object)LP__GCE, (Object)lp);
    }

    public static String getLp(Edge edge) {
        ID lpRaw = DotAttributes.getLpRaw(edge);
        return lpRaw != null ? lpRaw.toValue() : null;
    }

    public static void setLp(Edge edge, String lp) {
        DotAttributes.setLpRaw(edge, ID.fromValue(lp, ID.Type.QUOTED_STRING));
    }

    public static Point getLpParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(POINT_PARSER, DotAttributes.getLp(edge));
    }

    public static void setLpParsed(Edge edge, Point lp) {
        DotAttributes.setLp(edge, DotAttributes.serializeAttributeValue(POINT_SERIALIZER, lp));
    }

    public static ID getNodesepRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)NODESEP__G);
    }

    public static void setNodesepRaw(Graph graph, ID nodesep) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, NODESEP__G, nodesep);
        graph.attributesProperty().put((Object)NODESEP__G, (Object)nodesep);
    }

    public static String getNodesep(Graph graph) {
        ID nodesepRaw = DotAttributes.getNodesepRaw(graph);
        return nodesepRaw != null ? nodesepRaw.toValue() : null;
    }

    public static void setNodesep(Graph graph, String nodesep) {
        DotAttributes.setNodesepRaw(graph, ID.fromValue(nodesep, ID.Type.NUMERAL));
    }

    public static Double getNodesepParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getNodesep(graph));
    }

    public static void setNodesepParsed(Graph graph, Double nodesep) {
        DotAttributes.setNodesep(graph, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, nodesep));
    }

    public static ID getOutputorderRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)OUTPUTORDER__G);
    }

    public static void setOutputorderRaw(Graph graph, ID outputorder) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, OUTPUTORDER__G, outputorder);
        graph.attributesProperty().put((Object)OUTPUTORDER__G, (Object)outputorder);
    }

    public static String getOutputorder(Graph graph) {
        ID outputorderRaw = DotAttributes.getOutputorderRaw(graph);
        return outputorderRaw != null ? outputorderRaw.toValue() : null;
    }

    public static void setOutputorder(Graph graph, String outputorder) {
        DotAttributes.setOutputorderRaw(graph, ID.fromValue(outputorder, ID.Type.STRING));
    }

    public static OutputMode getOutputorderParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(OUTPUTMODE_PARSER, DotAttributes.getOutputorder(graph));
    }

    public static void setOutputorderParsed(Graph graph, OutputMode outputorder) {
        DotAttributes.setOutputorder(graph, DotAttributes.serializeAttributeValue(OUTPUTMODE_SERIALIZER, outputorder));
    }

    public static ID getPagedirRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)PAGEDIR__G);
    }

    public static void setPagedirRaw(Graph graph, ID pagedir) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, PAGEDIR__G, pagedir);
        graph.attributesProperty().put((Object)PAGEDIR__G, (Object)pagedir);
    }

    public static String getPagedir(Graph graph) {
        ID pagedirRaw = DotAttributes.getPagedirRaw(graph);
        return pagedirRaw != null ? pagedirRaw.toValue() : null;
    }

    public static void setPagedir(Graph graph, String pagedir) {
        DotAttributes.setPagedirRaw(graph, ID.fromValue(pagedir, ID.Type.STRING));
    }

    public static Pagedir getPagedirParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(PAGEDIR_PARSER, DotAttributes.getPagedir(graph));
    }

    public static void setPagedirParsed(Graph graph, Pagedir pagedir) {
        DotAttributes.setPagedir(graph, DotAttributes.serializeAttributeValue(PAGEDIR_SERIALIZER, pagedir));
    }

    public static ID getPenwidthRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)PENWIDTH__CNE);
    }

    public static void setPenwidthRaw(Graph graph, ID penwidth) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, PENWIDTH__CNE, penwidth);
        graph.attributesProperty().put((Object)PENWIDTH__CNE, (Object)penwidth);
    }

    public static String getPenwidth(Graph graph) {
        ID penwidthRaw = DotAttributes.getPenwidthRaw(graph);
        return penwidthRaw != null ? penwidthRaw.toValue() : null;
    }

    public static void setPenwidth(Graph graph, String penwidth) {
        DotAttributes.setPenwidthRaw(graph, ID.fromValue(penwidth, ID.Type.NUMERAL));
    }

    public static Double getPenwidthParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getPenwidth(graph));
    }

    public static void setPenwidthParsed(Graph graph, Double penwidth) {
        DotAttributes.setPenwidth(graph, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, penwidth));
    }

    public static ID getPenwidthRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)PENWIDTH__CNE);
    }

    public static void setPenwidthRaw(Node node, ID penwidth) {
        DotAttributes.checkAttributeRawValue(Context.NODE, PENWIDTH__CNE, penwidth);
        node.attributesProperty().put((Object)PENWIDTH__CNE, (Object)penwidth);
    }

    public static String getPenwidth(Node node) {
        ID penwidthRaw = DotAttributes.getPenwidthRaw(node);
        return penwidthRaw != null ? penwidthRaw.toValue() : null;
    }

    public static void setPenwidth(Node node, String penwidth) {
        DotAttributes.setPenwidthRaw(node, ID.fromValue(penwidth, ID.Type.NUMERAL));
    }

    public static Double getPenwidthParsed(Node node) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getPenwidth(node));
    }

    public static void setPenwidthParsed(Node node, Double penwidth) {
        DotAttributes.setPenwidth(node, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, penwidth));
    }

    public static ID getPenwidthRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)PENWIDTH__CNE);
    }

    public static void setPenwidthRaw(Edge edge, ID penwidth) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, PENWIDTH__CNE, penwidth);
        edge.attributesProperty().put((Object)PENWIDTH__CNE, (Object)penwidth);
    }

    public static String getPenwidth(Edge edge) {
        ID penwidthRaw = DotAttributes.getPenwidthRaw(edge);
        return penwidthRaw != null ? penwidthRaw.toValue() : null;
    }

    public static void setPenwidth(Edge edge, String penwidth) {
        DotAttributes.setPenwidthRaw(edge, ID.fromValue(penwidth, ID.Type.NUMERAL));
    }

    public static Double getPenwidthParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getPenwidth(edge));
    }

    public static void setPenwidthParsed(Edge edge, Double penwidth) {
        DotAttributes.setPenwidth(edge, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, penwidth));
    }

    public static ID getPosRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)POS__NE);
    }

    public static void setPosRaw(Node node, ID pos) {
        DotAttributes.checkAttributeRawValue(Context.NODE, POS__NE, pos);
        node.attributesProperty().put((Object)POS__NE, (Object)pos);
    }

    public static String getPos(Node node) {
        ID posRaw = DotAttributes.getPosRaw(node);
        return posRaw != null ? posRaw.toValue() : null;
    }

    public static void setPos(Node node, String pos) {
        DotAttributes.setPosRaw(node, ID.fromValue(pos, ID.Type.QUOTED_STRING));
    }

    public static Point getPosParsed(Node node) {
        return DotAttributes.parseAttributeValue(POINT_PARSER, DotAttributes.getPos(node));
    }

    public static void setPosParsed(Node node, Point pos) {
        DotAttributes.setPos(node, DotAttributes.serializeAttributeValue(POINT_SERIALIZER, pos));
    }

    public static ID getPosRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)POS__NE);
    }

    public static void setPosRaw(Edge edge, ID pos) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, POS__NE, pos);
        edge.attributesProperty().put((Object)POS__NE, (Object)pos);
    }

    public static String getPos(Edge edge) {
        ID posRaw = DotAttributes.getPosRaw(edge);
        return posRaw != null ? posRaw.toValue() : null;
    }

    public static void setPos(Edge edge, String pos) {
        DotAttributes.setPosRaw(edge, ID.fromValue(pos, ID.Type.QUOTED_STRING));
    }

    public static SplineType getPosParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(SPLINETYPE_PARSER, DotAttributes.getPos(edge));
    }

    public static void setPosParsed(Edge edge, SplineType pos) {
        DotAttributes.setPos(edge, DotAttributes.serializeAttributeValue(SPLINETYPE_SERIALIZER, pos));
    }

    public static ID getRankRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)RANK__S);
    }

    public static void setRankRaw(Graph graph, ID rank) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, RANK__S, rank);
        graph.attributesProperty().put((Object)RANK__S, (Object)rank);
    }

    public static String getRank(Graph graph) {
        ID rankRaw = DotAttributes.getRankRaw(graph);
        return rankRaw != null ? rankRaw.toValue() : null;
    }

    public static void setRank(Graph graph, String rank) {
        DotAttributes.setRankRaw(graph, ID.fromValue(rank, ID.Type.STRING));
    }

    public static RankType getRankParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(RANKTYPE_PARSER, DotAttributes.getRank(graph));
    }

    public static void setRankParsed(Graph graph, RankType rank) {
        DotAttributes.setRank(graph, DotAttributes.serializeAttributeValue(RANKTYPE_SERIALIZER, rank));
    }

    public static ID getRankdirRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)RANKDIR__G);
    }

    public static void setRankdirRaw(Graph graph, ID rankdir) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, RANKDIR__G, rankdir);
        graph.attributesProperty().put((Object)RANKDIR__G, (Object)rankdir);
    }

    public static String getRankdir(Graph graph) {
        ID rankdirRaw = DotAttributes.getRankdirRaw(graph);
        return rankdirRaw != null ? rankdirRaw.toValue() : null;
    }

    public static void setRankdir(Graph graph, String rankdir) {
        DotAttributes.setRankdirRaw(graph, ID.fromValue(rankdir, ID.Type.STRING));
    }

    public static Rankdir getRankdirParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(RANKDIR_PARSER, DotAttributes.getRankdir(graph));
    }

    public static void setRankdirParsed(Graph graph, Rankdir rankdir) {
        DotAttributes.setRankdir(graph, DotAttributes.serializeAttributeValue(RANKDIR_SERIALIZER, rankdir));
    }

    public static ID getShapeRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)SHAPE__N);
    }

    public static void setShapeRaw(Node node, ID shape) {
        DotAttributes.checkAttributeRawValue(Context.NODE, SHAPE__N, shape);
        node.attributesProperty().put((Object)SHAPE__N, (Object)shape);
    }

    public static String getShape(Node node) {
        ID shapeRaw = DotAttributes.getShapeRaw(node);
        return shapeRaw != null ? shapeRaw.toValue() : null;
    }

    public static void setShape(Node node, String shape) {
        DotAttributes.setShapeRaw(node, ID.fromValue(shape));
    }

    public static Shape getShapeParsed(Node node) {
        return DotAttributes.parseAttributeValue(SHAPE_PARSER, DotAttributes.getShape(node));
    }

    public static void setShapeParsed(Node node, Shape shape) {
        DotAttributes.setShape(node, DotAttributes.serializeAttributeValue(SHAPE_SERIALIZER, shape));
    }

    public static ID getSidesRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)SIDES__N);
    }

    public static void setSidesRaw(Node node, ID sides) {
        DotAttributes.checkAttributeRawValue(Context.NODE, SIDES__N, sides);
        node.attributesProperty().put((Object)SIDES__N, (Object)sides);
    }

    public static String getSides(Node node) {
        ID sidesRaw = DotAttributes.getSidesRaw(node);
        return sidesRaw != null ? sidesRaw.toValue() : null;
    }

    public static void setSides(Node node, String sides) {
        DotAttributes.setSidesRaw(node, ID.fromValue(sides, ID.Type.NUMERAL));
    }

    public static Integer getSidesParsed(Node node) {
        return DotAttributes.parseAttributeValue(INT_PARSER, DotAttributes.getSides(node));
    }

    public static void setSidesParsed(Node node, Integer sides) {
        DotAttributes.setSides(node, DotAttributes.serializeAttributeValue(INT_SERIALIZER, sides));
    }

    public static ID getSkewRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)SKEW__N);
    }

    public static void setSkewRaw(Node node, ID skew) {
        DotAttributes.checkAttributeRawValue(Context.NODE, SKEW__N, skew);
        node.attributesProperty().put((Object)SKEW__N, (Object)skew);
    }

    public static String getSkew(Node node) {
        ID skewRaw = DotAttributes.getSkewRaw(node);
        return skewRaw != null ? skewRaw.toValue() : null;
    }

    public static void setSkew(Node node, String skew) {
        DotAttributes.setSkewRaw(node, ID.fromValue(skew, ID.Type.NUMERAL));
    }

    public static Double getSkewParsed(Node node) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getSkew(node));
    }

    public static void setSkewParsed(Node node, Double skew) {
        DotAttributes.setSkew(node, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, skew));
    }

    public static ID getSplinesRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)SPLINES__G);
    }

    public static void setSplinesRaw(Graph graph, ID splines) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, SPLINES__G, splines);
        graph.attributesProperty().put((Object)SPLINES__G, (Object)splines);
    }

    public static String getSplines(Graph graph) {
        ID splinesRaw = DotAttributes.getSplinesRaw(graph);
        return splinesRaw != null ? splinesRaw.toValue() : null;
    }

    public static void setSplines(Graph graph, String splines) {
        DotAttributes.setSplinesRaw(graph, ID.fromValue(splines, ID.Type.QUOTED_STRING));
    }

    public static Splines getSplinesParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(SPLINES_PARSER, DotAttributes.getSplines(graph));
    }

    public static void setSplinesParsed(Graph graph, Splines splines) {
        DotAttributes.setSplines(graph, DotAttributes.serializeAttributeValue(SPLINES_SERIALIZER, splines));
    }

    public static ID getStyleRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)STYLE__GCNE);
    }

    public static void setStyleRaw(Graph graph, ID style) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, STYLE__GCNE, style);
        graph.attributesProperty().put((Object)STYLE__GCNE, (Object)style);
    }

    public static String getStyle(Graph graph) {
        ID styleRaw = DotAttributes.getStyleRaw(graph);
        return styleRaw != null ? styleRaw.toValue() : null;
    }

    public static void setStyle(Graph graph, String style) {
        DotAttributes.setStyleRaw(graph, ID.fromValue(style));
    }

    public static Style getStyleParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(STYLE_PARSER, DotAttributes.getStyle(graph));
    }

    public static void setStyleParsed(Graph graph, Style style) {
        DotAttributes.setStyle(graph, DotAttributes.serializeAttributeValue(STYLE_SERIALIZER, style));
    }

    public static ID getStyleRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)STYLE__GCNE);
    }

    public static void setStyleRaw(Node node, ID style) {
        DotAttributes.checkAttributeRawValue(Context.NODE, STYLE__GCNE, style);
        node.attributesProperty().put((Object)STYLE__GCNE, (Object)style);
    }

    public static String getStyle(Node node) {
        ID styleRaw = DotAttributes.getStyleRaw(node);
        return styleRaw != null ? styleRaw.toValue() : null;
    }

    public static void setStyle(Node node, String style) {
        DotAttributes.setStyleRaw(node, ID.fromValue(style));
    }

    public static Style getStyleParsed(Node node) {
        return DotAttributes.parseAttributeValue(STYLE_PARSER, DotAttributes.getStyle(node));
    }

    public static void setStyleParsed(Node node, Style style) {
        DotAttributes.setStyle(node, DotAttributes.serializeAttributeValue(STYLE_SERIALIZER, style));
    }

    public static ID getStyleRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)STYLE__GCNE);
    }

    public static void setStyleRaw(Edge edge, ID style) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, STYLE__GCNE, style);
        edge.attributesProperty().put((Object)STYLE__GCNE, (Object)style);
    }

    public static String getStyle(Edge edge) {
        ID styleRaw = DotAttributes.getStyleRaw(edge);
        return styleRaw != null ? styleRaw.toValue() : null;
    }

    public static void setStyle(Edge edge, String style) {
        DotAttributes.setStyleRaw(edge, ID.fromValue(style));
    }

    public static Style getStyleParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(STYLE_PARSER, DotAttributes.getStyle(edge));
    }

    public static void setStyleParsed(Edge edge, Style style) {
        DotAttributes.setStyle(edge, DotAttributes.serializeAttributeValue(STYLE_SERIALIZER, style));
    }

    public static ID getTailLpRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)TAIL_LP__E);
    }

    public static void setTailLpRaw(Edge edge, ID tailLp) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, TAIL_LP__E, tailLp);
        edge.attributesProperty().put((Object)TAIL_LP__E, (Object)tailLp);
    }

    public static String getTailLp(Edge edge) {
        ID tailLpRaw = DotAttributes.getTailLpRaw(edge);
        return tailLpRaw != null ? tailLpRaw.toValue() : null;
    }

    public static void setTailLp(Edge edge, String tailLp) {
        DotAttributes.setTailLpRaw(edge, ID.fromValue(tailLp, ID.Type.QUOTED_STRING));
    }

    public static Point getTailLpParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(POINT_PARSER, DotAttributes.getTailLp(edge));
    }

    public static void setTailLpParsed(Edge edge, Point tailLp) {
        DotAttributes.setTailLp(edge, DotAttributes.serializeAttributeValue(POINT_SERIALIZER, tailLp));
    }

    public static ID getTaillabelRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)TAILLABEL__E);
    }

    public static void setTaillabelRaw(Edge edge, ID taillabel) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, TAILLABEL__E, taillabel);
        edge.attributesProperty().put((Object)TAILLABEL__E, (Object)taillabel);
    }

    public static String getTaillabel(Edge edge) {
        ID taillabelRaw = DotAttributes.getTaillabelRaw(edge);
        return taillabelRaw != null ? taillabelRaw.toValue() : null;
    }

    public static void setTaillabel(Edge edge, String taillabel) {
        DotAttributes.setTaillabelRaw(edge, ID.fromValue(taillabel));
    }

    public static ID getTailportRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)TAILPORT__E);
    }

    public static void setTailportRaw(Edge edge, ID tailport) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, TAILPORT__E, tailport);
        edge.attributesProperty().put((Object)TAILPORT__E, (Object)tailport);
    }

    public static String getTailport(Edge edge) {
        ID tailportRaw = DotAttributes.getTailportRaw(edge);
        return tailportRaw != null ? tailportRaw.toValue() : null;
    }

    public static void setTailport(Edge edge, String tailport) {
        DotAttributes.setTailportRaw(edge, ID.fromValue(tailport));
    }

    public static PortPos getTailportParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(PORTPOS_PARSER, DotAttributes.getTailport(edge));
    }

    public static void setTailportParsed(Edge edge, PortPos tailport) {
        DotAttributes.setTailport(edge, DotAttributes.serializeAttributeValue(PORTPOS_SERIALIZER, tailport));
    }

    public static ID getTailtooltipRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)TAILTOOLTIP__E);
    }

    public static void setTailtooltipRaw(Edge edge, ID tailtooltip) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, TAILTOOLTIP__E, tailtooltip);
        edge.attributesProperty().put((Object)TAILTOOLTIP__E, (Object)tailtooltip);
    }

    public static String getTailtooltip(Edge edge) {
        ID tailtooltipRaw = DotAttributes.getTailtooltipRaw(edge);
        return tailtooltipRaw != null ? tailtooltipRaw.toValue() : null;
    }

    public static void setTailtooltip(Edge edge, String tailtooltip) {
        DotAttributes.setTailtooltipRaw(edge, ID.fromValue(tailtooltip));
    }

    public static EscString getTailtooltipParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(ESCSTRING_PARSER, DotAttributes.getTailtooltip(edge));
    }

    public static void setTailtooltipParsed(Edge edge, EscString tailtooltip) {
        DotAttributes.setTailtooltip(edge, DotAttributes.serializeAttributeValue(ESCSTRING_SERIALIZER, tailtooltip));
    }

    public static ID getTooltipRaw(Graph graph) {
        return (ID)graph.attributesProperty().get((Object)TOOLTIP__CNE);
    }

    public static void setTooltipRaw(Graph graph, ID tooltip) {
        DotAttributes.checkAttributeRawValue(Context.GRAPH, TOOLTIP__CNE, tooltip);
        graph.attributesProperty().put((Object)TOOLTIP__CNE, (Object)tooltip);
    }

    public static String getTooltip(Graph graph) {
        ID tooltipRaw = DotAttributes.getTooltipRaw(graph);
        return tooltipRaw != null ? tooltipRaw.toValue() : null;
    }

    public static void setTooltip(Graph graph, String tooltip) {
        DotAttributes.setTooltipRaw(graph, ID.fromValue(tooltip));
    }

    public static EscString getTooltipParsed(Graph graph) {
        return DotAttributes.parseAttributeValue(ESCSTRING_PARSER, DotAttributes.getTooltip(graph));
    }

    public static void setTooltipParsed(Graph graph, EscString tooltip) {
        DotAttributes.setTooltip(graph, DotAttributes.serializeAttributeValue(ESCSTRING_SERIALIZER, tooltip));
    }

    public static ID getTooltipRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)TOOLTIP__CNE);
    }

    public static void setTooltipRaw(Node node, ID tooltip) {
        DotAttributes.checkAttributeRawValue(Context.NODE, TOOLTIP__CNE, tooltip);
        node.attributesProperty().put((Object)TOOLTIP__CNE, (Object)tooltip);
    }

    public static String getTooltip(Node node) {
        ID tooltipRaw = DotAttributes.getTooltipRaw(node);
        return tooltipRaw != null ? tooltipRaw.toValue() : null;
    }

    public static void setTooltip(Node node, String tooltip) {
        DotAttributes.setTooltipRaw(node, ID.fromValue(tooltip));
    }

    public static EscString getTooltipParsed(Node node) {
        return DotAttributes.parseAttributeValue(ESCSTRING_PARSER, DotAttributes.getTooltip(node));
    }

    public static void setTooltipParsed(Node node, EscString tooltip) {
        DotAttributes.setTooltip(node, DotAttributes.serializeAttributeValue(ESCSTRING_SERIALIZER, tooltip));
    }

    public static ID getTooltipRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)TOOLTIP__CNE);
    }

    public static void setTooltipRaw(Edge edge, ID tooltip) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, TOOLTIP__CNE, tooltip);
        edge.attributesProperty().put((Object)TOOLTIP__CNE, (Object)tooltip);
    }

    public static String getTooltip(Edge edge) {
        ID tooltipRaw = DotAttributes.getTooltipRaw(edge);
        return tooltipRaw != null ? tooltipRaw.toValue() : null;
    }

    public static void setTooltip(Edge edge, String tooltip) {
        DotAttributes.setTooltipRaw(edge, ID.fromValue(tooltip));
    }

    public static EscString getTooltipParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(ESCSTRING_PARSER, DotAttributes.getTooltip(edge));
    }

    public static void setTooltipParsed(Edge edge, EscString tooltip) {
        DotAttributes.setTooltip(edge, DotAttributes.serializeAttributeValue(ESCSTRING_SERIALIZER, tooltip));
    }

    public static ID getWidthRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)WIDTH__N);
    }

    public static void setWidthRaw(Node node, ID width) {
        DotAttributes.checkAttributeRawValue(Context.NODE, WIDTH__N, width);
        node.attributesProperty().put((Object)WIDTH__N, (Object)width);
    }

    public static String getWidth(Node node) {
        ID widthRaw = DotAttributes.getWidthRaw(node);
        return widthRaw != null ? widthRaw.toValue() : null;
    }

    public static void setWidth(Node node, String width) {
        DotAttributes.setWidthRaw(node, ID.fromValue(width, ID.Type.NUMERAL));
    }

    public static Double getWidthParsed(Node node) {
        return DotAttributes.parseAttributeValue(DOUBLE_PARSER, DotAttributes.getWidth(node));
    }

    public static void setWidthParsed(Node node, Double width) {
        DotAttributes.setWidth(node, DotAttributes.serializeAttributeValue(DOUBLE_SERIALIZER, width));
    }

    public static ID getXlabelRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)XLABEL__NE);
    }

    public static void setXlabelRaw(Node node, ID xlabel) {
        DotAttributes.checkAttributeRawValue(Context.NODE, XLABEL__NE, xlabel);
        node.attributesProperty().put((Object)XLABEL__NE, (Object)xlabel);
    }

    public static String getXlabel(Node node) {
        ID xlabelRaw = DotAttributes.getXlabelRaw(node);
        return xlabelRaw != null ? xlabelRaw.toValue() : null;
    }

    public static void setXlabel(Node node, String xlabel) {
        DotAttributes.setXlabelRaw(node, ID.fromValue(xlabel));
    }

    public static ID getXlabelRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)XLABEL__NE);
    }

    public static void setXlabelRaw(Edge edge, ID xlabel) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, XLABEL__NE, xlabel);
        edge.attributesProperty().put((Object)XLABEL__NE, (Object)xlabel);
    }

    public static String getXlabel(Edge edge) {
        ID xlabelRaw = DotAttributes.getXlabelRaw(edge);
        return xlabelRaw != null ? xlabelRaw.toValue() : null;
    }

    public static void setXlabel(Edge edge, String xlabel) {
        DotAttributes.setXlabelRaw(edge, ID.fromValue(xlabel));
    }

    public static ID getXlpRaw(Node node) {
        return (ID)node.attributesProperty().get((Object)XLP__NE);
    }

    public static void setXlpRaw(Node node, ID xlp) {
        DotAttributes.checkAttributeRawValue(Context.NODE, XLP__NE, xlp);
        node.attributesProperty().put((Object)XLP__NE, (Object)xlp);
    }

    public static String getXlp(Node node) {
        ID xlpRaw = DotAttributes.getXlpRaw(node);
        return xlpRaw != null ? xlpRaw.toValue() : null;
    }

    public static void setXlp(Node node, String xlp) {
        DotAttributes.setXlpRaw(node, ID.fromValue(xlp, ID.Type.QUOTED_STRING));
    }

    public static Point getXlpParsed(Node node) {
        return DotAttributes.parseAttributeValue(POINT_PARSER, DotAttributes.getXlp(node));
    }

    public static void setXlpParsed(Node node, Point xlp) {
        DotAttributes.setXlp(node, DotAttributes.serializeAttributeValue(POINT_SERIALIZER, xlp));
    }

    public static ID getXlpRaw(Edge edge) {
        return (ID)edge.attributesProperty().get((Object)XLP__NE);
    }

    public static void setXlpRaw(Edge edge, ID xlp) {
        DotAttributes.checkAttributeRawValue(Context.EDGE, XLP__NE, xlp);
        edge.attributesProperty().put((Object)XLP__NE, (Object)xlp);
    }

    public static String getXlp(Edge edge) {
        ID xlpRaw = DotAttributes.getXlpRaw(edge);
        return xlpRaw != null ? xlpRaw.toValue() : null;
    }

    public static void setXlp(Edge edge, String xlp) {
        DotAttributes.setXlpRaw(edge, ID.fromValue(xlp, ID.Type.QUOTED_STRING));
    }

    public static Point getXlpParsed(Edge edge) {
        return DotAttributes.parseAttributeValue(POINT_PARSER, DotAttributes.getXlp(edge));
    }

    public static void setXlpParsed(Edge edge, Point xlp) {
        DotAttributes.setXlp(edge, DotAttributes.serializeAttributeValue(POINT_SERIALIZER, xlp));
    }

    public static enum Context {
        GRAPH,
        EDGE,
        NODE,
        SUBGRAPH,
        CLUSTER;

    }

    private static class DoubleValidator
    implements IAttributeValueValidator<Double> {
        private double minValue;

        public DoubleValidator(double minValue) {
            this.minValue = minValue;
        }

        @Override
        public List<Diagnostic> validate(Context attributeContext, Double attributeValue) {
            boolean _lessThan;
            List<Diagnostic> _xblockexpression = null;
            double _doubleValue = attributeValue;
            boolean bl = _lessThan = _doubleValue < this.minValue;
            if (_lessThan) {
                String _string = attributeValue.toString();
                BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, _string, -1, "Value may not be smaller than " + Double.valueOf(this.minValue) + ".", new Object[0]);
                return Collections.singletonList(_basicDiagnostic);
            }
            _xblockexpression = Collections.emptyList();
            return _xblockexpression;
        }
    }

    private static class EObjectParser<T extends EObject>
    implements IAttributeValueParser<T> {
        private final Injector injector;
        private IParser xtextParser;
        private Class<T> parsedType;

        public EObjectParser(Injector injector) {
            this.injector = injector;
        }

        @Override
        public IAttributeValueParser.ParseResult<T> parse(String attributeValue) {
            StringReader _stringReader;
            IParser _parser = this.getParser();
            IParseResult xtextParseResult = _parser.parse((Reader)(_stringReader = new StringReader(attributeValue)));
            boolean _hasSyntaxErrors = xtextParseResult.hasSyntaxErrors();
            if (_hasSyntaxErrors) {
                ArrayList syntaxProblems = CollectionLiterals.newArrayList((Object[])new Diagnostic[0]);
                Iterable _syntaxErrors = xtextParseResult.getSyntaxErrors();
                for (INode xtextSyntaxError : _syntaxErrors) {
                    SyntaxErrorMessage _syntaxErrorMessage = xtextSyntaxError.getSyntaxErrorMessage();
                    String _message = _syntaxErrorMessage.getMessage();
                    BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, attributeValue, -1, _message, new Object[0]);
                    syntaxProblems.add(_basicDiagnostic);
                }
                return new IAttributeValueParser.ParseResult(syntaxProblems);
            }
            EObject _rootASTElement = xtextParseResult.getRootASTElement();
            return new IAttributeValueParser.ParseResult(_rootASTElement);
        }

        protected IParser getParser() {
            boolean _tripleEquals;
            boolean bl = _tripleEquals = this.xtextParser == null;
            if (_tripleEquals) {
                IParser _instance;
                this.xtextParser = _instance = (IParser)this.injector.getInstance(IParser.class);
            }
            return this.xtextParser;
        }

        @Override
        public Class<T> getParsedType() {
            boolean _tripleEquals;
            Class<T> _xblockexpression = null;
            boolean bl = _tripleEquals = this.parsedType == null;
            if (_tripleEquals) {
                boolean _tripleEquals_1;
                Class _instanceClass;
                IGrammarAccess grammarAccess = (IGrammarAccess)this.injector.getInstance(IGrammarAccess.class);
                Grammar _grammar = grammarAccess.getGrammar();
                EList _rules = _grammar.getRules();
                AbstractRule _head = (AbstractRule)IterableExtensions.head((Iterable)_rules);
                TypeRef _type = _head.getType();
                EClassifier _classifier = _type.getClassifier();
                this.parsedType = _instanceClass = _classifier.getInstanceClass();
                boolean bl2 = _tripleEquals_1 = this.parsedType == null;
                if (_tripleEquals_1) {
                    Grammar _grammar_1 = grammarAccess.getGrammar();
                    String _name = _grammar_1.getName();
                    String _plus = "DotAttributes: parsedType cannot be determined for grammar: " + _name;
                    System.err.println(_plus);
                }
            }
            _xblockexpression = this.parsedType;
            return _xblockexpression;
        }
    }

    private static class EObjectSerializer<T extends EObject>
    implements IAttributeValueSerializer<T> {
        private final Injector injector;
        private ISerializer serializer;

        public EObjectSerializer(Injector injector) {
            this.injector = injector;
        }

        @Override
        public String serialize(T value) {
            String _xblockexpression = null;
            ISerializer serializer = this.getSerializer();
            _xblockexpression = serializer.serialize(value);
            return _xblockexpression;
        }

        protected ISerializer getSerializer() {
            boolean _tripleEquals;
            ISerializer _xblockexpression = null;
            boolean bl = _tripleEquals = this.serializer == null;
            if (_tripleEquals) {
                ISerializer _instance;
                this.serializer = _instance = (ISerializer)this.injector.getInstance(ISerializer.class);
            }
            _xblockexpression = this.serializer;
            return _xblockexpression;
        }
    }

    private static class EObjectValidator<T extends EObject>
    implements IAttributeValueValidator<T> {
        private final Injector injector;
        private Class<? extends AbstractDeclarativeValidator> validatorClass;
        private AbstractDeclarativeValidator validator;

        public EObjectValidator(Injector injector, Class<? extends AbstractDeclarativeValidator> validatorClass) {
            this.injector = injector;
            this.validatorClass = validatorClass;
        }

        protected AbstractDeclarativeValidator getValidator() {
            boolean _tripleEquals;
            AbstractDeclarativeValidator _xblockexpression = null;
            boolean bl = _tripleEquals = this.validator == null;
            if (_tripleEquals) {
                AbstractDeclarativeValidator _instance;
                this.validator = _instance = (AbstractDeclarativeValidator)this.injector.getInstance(this.validatorClass);
            }
            _xblockexpression = this.validator;
            return _xblockexpression;
        }

        @Override
        public List<Diagnostic> validate(Context attributeContext, T attributeValue) {
            boolean _tripleNotEquals;
            ArrayList _xblockexpression = null;
            AbstractDeclarativeValidator validator = this.getValidator();
            final ArrayList diagnostics = CollectionLiterals.newArrayList((Object[])new Diagnostic[0]);
            boolean bl = _tripleNotEquals = validator != null;
            if (_tripleNotEquals) {
                validator.setMessageAcceptor(new ValidationMessageAcceptor(){

                    public void acceptError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
                        BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, null, -1, message, new Object[0]);
                        diagnostics.add(_basicDiagnostic);
                    }

                    public void acceptError(String message, EObject object, int offset, int length, String code, String ... issueData) {
                        RangeBasedDiagnosticEx _rangeBasedDiagnosticEx = new RangeBasedDiagnosticEx(4, message, object, offset, length, CheckType.FAST, code, issueData);
                        diagnostics.add(_rangeBasedDiagnosticEx);
                    }

                    public void acceptInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
                        BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(1, null, -1, message, new Object[0]);
                        diagnostics.add(_basicDiagnostic);
                    }

                    public void acceptInfo(String message, EObject object, int offset, int length, String code, String ... issueData) {
                        RangeBasedDiagnosticEx _rangeBasedDiagnosticEx = new RangeBasedDiagnosticEx(1, message, object, offset, length, CheckType.FAST, code, issueData);
                        diagnostics.add(_rangeBasedDiagnosticEx);
                    }

                    public void acceptWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
                        BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(2, null, -1, message, new Object[0]);
                        diagnostics.add(_basicDiagnostic);
                    }

                    public void acceptWarning(String message, EObject object, int offset, int length, String code, String ... issueData) {
                        RangeBasedDiagnosticEx _rangeBasedDiagnosticEx = new RangeBasedDiagnosticEx(2, message, object, offset, length, CheckType.FAST, code, issueData);
                        diagnostics.add(_rangeBasedDiagnosticEx);
                    }
                });
                HashMap validationContext = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
                Object _privateFieldValue = ReflectionUtils.getPrivateFieldValue((Object)validator, (String)"languageName");
                validationContext.put(AbstractInjectableValidator.CURRENT_LANGUAGE_NAME, _privateFieldValue);
                String _name = Context.class.getName();
                validationContext.put(_name, attributeContext);
                validator.validate(attributeValue, null, (Map)validationContext);
                TreeIterator iterator = EcoreUtil.getAllProperContents(attributeValue, (boolean)true);
                while (iterator.hasNext()) {
                    EObject _next = (EObject)iterator.next();
                    validator.validate(_next, null, (Map)validationContext);
                }
            }
            _xblockexpression = diagnostics;
            return _xblockexpression;
        }
    }

    private static class EnumParser<E extends Enum<E>>
    implements IAttributeValueParser<E> {
        private Class<E> definition;

        public EnumParser(Class<E> attributeType) {
            this.definition = attributeType;
        }

        @Override
        public IAttributeValueParser.ParseResult<E> parse(String attributeValue) {
            Enum[] _enumConstants;
            boolean _tripleEquals;
            boolean bl = _tripleEquals = attributeValue == null;
            if (_tripleEquals) {
                return null;
            }
            Enum[] enumArray = _enumConstants = (Enum[])this.definition.getEnumConstants();
            int n = _enumConstants.length;
            int n2 = 0;
            while (n2 < n) {
                Enum value = enumArray[n2];
                String _string = value.toString();
                boolean _equals = _string.equals(attributeValue);
                if (_equals) {
                    return new IAttributeValueParser.ParseResult(value);
                }
                ++n2;
            }
            Object[] _enumConstants_1 = (Enum[])this.definition.getEnumConstants();
            String _formattedValues = EnumParser.getFormattedValues(_enumConstants_1);
            String _plus = "Value has to be one of " + _formattedValues;
            BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, attributeValue, -1, _plus, new Object[0]);
            List<BasicDiagnostic> _singletonList = Collections.singletonList(_basicDiagnostic);
            return new IAttributeValueParser.ParseResult(_singletonList);
        }

        private static String getFormattedValues(Object[] values) {
            Functions.Function1<Object, String> _function = new Functions.Function1<Object, String>(){

                public String apply(Object it) {
                    return "'" + it + "'";
                }
            };
            List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)values)), (Functions.Function1)_function);
            return IterableExtensions.join((Iterable)_map, (CharSequence)", ");
        }

        @Override
        public Class<E> getParsedType() {
            return this.definition;
        }
    }

    private static class EnumSerializer<E extends Enum<E>>
    implements IAttributeValueSerializer<E> {
        private Class<E> definition;

        public EnumSerializer(Class<E> definition) {
            this.definition = definition;
        }

        @Override
        public String serialize(E value) {
            boolean _not;
            String _xblockexpression = null;
            Class<?> _class = value.getClass();
            boolean _isAssignableFrom = this.definition.isAssignableFrom(_class);
            boolean bl = _not = !_isAssignableFrom;
            if (_not) {
                throw new IllegalArgumentException("Value does not comply to definition " + this.definition);
            }
            _xblockexpression = ((Enum)value).toString();
            return _xblockexpression;
        }
    }

    private static interface IAttributeValueParser<T> {
        public ParseResult<T> parse(String var1);

        public Class<T> getParsedType();

        public static class ParseResult<T> {
            private T parsedValue;
            private List<Diagnostic> syntaxErrors;

            private ParseResult(T parsedValue) {
                this(parsedValue, Collections.emptyList());
            }

            private ParseResult(List<Diagnostic> syntaxErrors) {
                this(null, syntaxErrors);
            }

            private ParseResult(T parsedValue, List<Diagnostic> syntaxErrors) {
                this.parsedValue = parsedValue;
                this.syntaxErrors = syntaxErrors;
            }

            public T getParsedValue() {
                return this.parsedValue;
            }

            public List<Diagnostic> getSyntaxErrors() {
                return this.syntaxErrors;
            }

            public boolean hasSyntaxErrors() {
                boolean _isEmpty = this.syntaxErrors.isEmpty();
                return !_isEmpty;
            }
        }
    }

    private static interface IAttributeValueSerializer<T> {
        public String serialize(T var1);
    }

    private static interface IAttributeValueValidator<T> {
        public List<Diagnostic> validate(Context var1, T var2);
    }

    private static class IntValidator
    implements IAttributeValueValidator<Integer> {
        private int minValue;

        public IntValidator(int minValue) {
            this.minValue = minValue;
        }

        @Override
        public List<Diagnostic> validate(Context attributeContext, Integer attributeValue) {
            boolean _lessThan;
            List<Diagnostic> _xblockexpression = null;
            double _doubleValue = attributeValue.doubleValue();
            boolean bl = _lessThan = _doubleValue < (double)this.minValue;
            if (_lessThan) {
                String _string = attributeValue.toString();
                BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, _string, -1, "Value may not be smaller than " + Integer.valueOf(this.minValue) + ".", new Object[0]);
                return Collections.singletonList(_basicDiagnostic);
            }
            _xblockexpression = Collections.emptyList();
            return _xblockexpression;
        }
    }

    private static class RangeBasedDiagnosticEx
    extends RangeBasedDiagnostic {
        public RangeBasedDiagnosticEx(int severity, String message, EObject source, int offset, int length, CheckType checkType, String issueCode, String[] issueData) {
            super(severity, message, source, offset, length, checkType, issueCode, issueData);
        }
    }

    private static class StringValidator
    implements IAttributeValueValidator<String> {
        private Object[] validValues;

        public StringValidator(Object[] validValues) {
            this.validValues = validValues;
        }

        @Override
        public List<Diagnostic> validate(Context attributeContext, String attributeValue) {
            Object[] objectArray = this.validValues;
            int n = this.validValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object validValue = objectArray[n2];
                String _string = validValue.toString();
                boolean _equals = _string.equals(attributeValue);
                if (_equals) {
                    return Collections.emptyList();
                }
                ++n2;
            }
            String _formattedValues = this.getFormattedValues(this.validValues);
            String _plus = "Value should be one of " + _formattedValues;
            String _plus_1 = String.valueOf(_plus) + ".";
            BasicDiagnostic _basicDiagnostic = new BasicDiagnostic(4, attributeValue, -1, _plus_1, new Object[0]);
            return Collections.singletonList(_basicDiagnostic);
        }

        private String getFormattedValues(Object[] values) {
            Functions.Function1<Object, String> _function = new Functions.Function1<Object, String>(){

                public String apply(Object it) {
                    return it.toString();
                }
            };
            List _sortBy = IterableExtensions.sortBy((Iterable)((Iterable)Conversions.doWrapArray((Object)values)), (Functions.Function1)_function);
            Functions.Function1<Object, String> _function_1 = new Functions.Function1<Object, String>(){

                public String apply(Object it) {
                    return "'" + it + "'";
                }
            };
            List _map = ListExtensions.map((List)_sortBy, (Functions.Function1)_function_1);
            return IterableExtensions.join((Iterable)_map, (CharSequence)", ");
        }
    }
}

