/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.server.mars;

import java.io.Closeable;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.logging.aeri.core.IProblemState;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;

import com.google.common.base.Optional;

public interface IProblemsHistory extends Closeable {

    Optional<IProblemState> seen(IStatus status);

    void sync(IO io, ISystemSettings systemSettings);
}
