/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.eresource.impl;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ObjectUtil;

public abstract class CDOResourceNodeImpl
extends CDOObjectImpl
implements CDOResourceNode {
    protected CDOResourceNodeImpl() {
    }

    protected EClass eStaticClass() {
        return EresourcePackage.Literals.CDO_RESOURCE_NODE;
    }

    protected int eStaticFeatureCount() {
        return 0;
    }

    public CDOResourceFolder getFolder() {
        return (CDOResourceFolder)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__FOLDER, true);
    }

    public void setFolderGen(CDOResourceFolder newFolder) {
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__FOLDER, newFolder);
    }

    public void setFolder(CDOResourceFolder newFolder) {
        this.basicSetFolder(newFolder, true);
    }

    public void basicSetFolder(CDOResourceFolder newFolder, boolean checkDuplicates) {
        CDOResourceFolder oldFolder = this.getFolder();
        if (!ObjectUtil.equals((Object)oldFolder, (Object)newFolder)) {
            String name;
            if (checkDuplicates && (name = this.getName()) != null) {
                String newPath = String.valueOf(newFolder == null ? "" : newFolder.getPath()) + CDOURIUtil.SEGMENT_SEPARATOR + name;
                this.checkDuplicates(newPath);
            }
            this.setFolderGen(newFolder);
        }
    }

    public void recacheURIs() {
    }

    public String getName() {
        return (String)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME, true);
    }

    public void setNameGen(String newName) {
        this.eSet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME, newName);
    }

    public void setName(String newName) {
        this.basicSetName(newName, true);
    }

    public void basicSetName(String newName, boolean checkDuplicates) {
        String oldName = this.getName();
        if (!ObjectUtil.equals((Object)oldName, (Object)newName)) {
            CDOResourceFolder parent;
            if (checkDuplicates && (parent = this.getFolder()) != null) {
                String newPath = String.valueOf(parent.getPath()) + CDOURIUtil.SEGMENT_SEPARATOR + this.getName();
                this.checkDuplicates(newPath);
            }
            this.setNameGen(newName);
        }
    }

    public String getPath() {
        if (this.isRoot()) {
            return "/";
        }
        CDOResourceFolder folder = this.getFolder();
        if (folder == null) {
            return "/" + this.getName();
        }
        return String.valueOf(folder.getPath()) + "/" + this.getName();
    }

    public void setPath(String newPath) {
        InternalCDOTransaction transaction = this.cdoView().toTransaction();
        if (newPath == null) {
            throw new CDOException(Messages.getString("CDOResourceNodeImpl.3"));
        }
        String oldPath = this.getPath();
        if (!ObjectUtil.equals((Object)oldPath, (Object)newPath)) {
            List<String> names = CDOURIUtil.analyzePath(newPath);
            if (names.isEmpty()) {
                throw new CDOException(Messages.getString("CDOResourceNodeImpl.4"));
            }
            String newName = names.remove(names.size() - 1);
            CDOResourceFolder newFolder = transaction.getOrCreateResourceFolder(names);
            if (newFolder == null) {
                transaction.getRootResource().getContents().add((Object)this);
            }
            this.basicSetFolder(newFolder, false);
            this.basicSetName(newName, false);
        }
    }

    public String getExtension() {
        String name = this.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            return name.substring(lastDot + 1);
        }
        return "";
    }

    public String trimExtension() {
        String name = this.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            return name.substring(0, lastDot);
        }
        return name;
    }

    public URI getURI() {
        String path;
        InternalCDOView view = this.cdoView();
        URI uri = CDOURIUtil.createResourceURI(view, path = this.getPath());
        if (uri != null) {
            URIConverter uriConverter = view.getResourceSet().getURIConverter();
            uri = uriConverter.normalize(uri);
        }
        return uri;
    }

    private void checkDuplicates(String newPath) {
        try {
            InternalCDOView view = this.cdoView();
            view.clearResourcePathCacheIfNecessary(null);
            view.getResourceNodeID(newPath);
        }
        catch (Exception ex) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOResourceNodeImpl.5"), newPath));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getPath();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setPath((String)newValue);
                break;
            }
            default: {
                super.eSet(featureID, newValue);
            }
        }
        if (featureID == 1) {
            this.recacheURIs();
        }
    }

    public String toString() {
        String string = super.toString();
        return this.toString(string);
    }

    protected String toString(String string) {
        InternalCDORevision revision = this.cdoRevision();
        if (revision != null) {
            String name = revision.getResourceNodeName();
            if (name == null) {
                name = "/";
            }
            string = String.valueOf(string) + "(\"" + name + "\")";
        }
        return string;
    }
}

