/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.mongodb;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import java.util.Map;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreFactory;
import org.eclipse.emf.cdo.server.mongodb.CDOMongoDBUtil;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBStoreFactory
implements IStoreFactory {
    public String getStoreType() {
        return "mongodb";
    }

    public IStore createStore(String repositoryName, Map<String, String> repositoryProperties, Element storeConfig) {
        Map properties = RepositoryConfigurator.getProperties((Element)storeConfig, (int)1);
        String uri = (String)properties.get("uri");
        if (StringUtil.isEmpty((String)uri)) {
            throw new IllegalArgumentException("Property 'uri' missing");
        }
        MongoURI mongoURI = new MongoURI(uri);
        String dbName = (String)properties.get("db");
        if (StringUtil.isEmpty((String)dbName)) {
            dbName = repositoryName;
        }
        String drop = (String)properties.get("drop");
        if (Boolean.toString(true).equals(drop)) {
            this.dropDatabase(mongoURI, dbName);
        }
        return CDOMongoDBUtil.createStore(uri, dbName);
    }

    protected void dropDatabase(MongoURI mongoURI, String dbName) {
        Mongo mongo = null;
        try {
            try {
                mongo = new Mongo(mongoURI);
                DB db = mongo.getDB(dbName);
                db.dropDatabase();
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        finally {
            if (mongo != null) {
                mongo.close();
            }
        }
    }
}

