/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.ObjectListController;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.explorer.checkouts.OfflineCDOCheckout;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.ui.handlers.AbstractBaseHandler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceRevertHandler
extends AbstractBaseHandler<OfflineCDOCheckout> {
    private List<CDOTransaction> dirtyTransactions;

    public WorkspaceRevertHandler() {
        super(OfflineCDOCheckout.class, null);
    }

    protected boolean updateSelection(ISelection selection) {
        OfflineCDOCheckout checkout;
        boolean result = super.updateSelection(selection);
        if (result && !(checkout = (OfflineCDOCheckout)this.elements.get(0)).isDirty()) {
            return false;
        }
        return result;
    }

    protected void preRun(ExecutionEvent event) throws Exception {
        this.dirtyTransactions = new ArrayList<CDOTransaction>();
        InternalCDOWorkspace workspace = this.getWorkspace();
        if (workspace != null) {
            CDOChangeSetData revertData;
            OfflineCDOCheckout checkout;
            RevertConfirmationDialog dialog;
            InternalCDOView[] internalCDOViewArray = workspace.getViews();
            int n = internalCDOViewArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOView view = internalCDOViewArray[n2];
                if (view.isDirty()) {
                    this.dirtyTransactions.add((CDOTransaction)view);
                }
                ++n2;
            }
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            int size = this.dirtyTransactions.size();
            if (size != 0) {
                String message;
                String plural = size == 1 ? "" : "s";
                String string = message = size == 1 ? "is 1" : "are " + size;
                if (!MessageDialog.openQuestion((Shell)shell, (String)("Uncommitted Transaction" + plural), (String)("There " + message + " uncommitted transaction" + plural + ".\n\n" + "Are you sure you want to rollback the transaction" + plural + ", too?"))) {
                    this.cancel();
                    return;
                }
            }
            if ((dialog = new RevertConfirmationDialog(shell, checkout = (OfflineCDOCheckout)this.elements.get(0), revertData = workspace.getLocalChanges(false))).open() == 0) {
                return;
            }
        }
        this.cancel();
    }

    protected void doExecute(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        try {
            for (CDOTransaction transaction : this.dirtyTransactions) {
                transaction.rollback();
            }
        }
        finally {
            this.dirtyTransactions = null;
        }
        InternalCDOWorkspace workspace = this.getWorkspace();
        if (workspace != null) {
            workspace.revert();
        }
    }

    private InternalCDOWorkspace getWorkspace() {
        OfflineCDOCheckout checkout = (OfflineCDOCheckout)this.elements.get(0);
        return checkout.getWorkspace();
    }

    private static class RevertConfirmationDialog
    extends TitleAreaDialog {
        private static final String TITLE = "Revert Local Changes";
        private final OfflineCDOCheckout checkout;
        private final CDOChangeSetData revertData;

        public RevertConfirmationDialog(Shell parentShell, OfflineCDOCheckout checkout, CDOChangeSetData revertData) {
            super(parentShell);
            this.checkout = checkout;
            this.revertData = revertData;
            this.setShellStyle(65648);
        }

        protected Control createDialogArea(Composite parent) {
            CDOObject object;
            Composite area = (Composite)super.createDialogArea(parent);
            this.getShell().setText(TITLE);
            this.setTitle(TITLE);
            this.setTitleImage(OM.getImage("icons/wiz/revert.gif"));
            this.setMessage("Are you sure you want to revert your local changes?");
            Composite container = new Composite(area, 0);
            container.setLayoutData((Object)new GridData(1808));
            GridLayout containerGridLayout = new GridLayout();
            containerGridLayout.marginWidth = 10;
            containerGridLayout.marginHeight = 10;
            container.setLayout((Layout)containerGridLayout);
            ObjectListController objectListController = new ObjectListController((CDOCheckout)this.checkout);
            CDOView view = this.checkout.getView();
            for (CDORevisionKey key : this.revertData.getChangedObjects()) {
                object = view.getObject(key.getID());
                objectListController.addObject((EObject)object, false);
            }
            for (CDORevisionKey key : this.revertData.getDetachedObjects()) {
                object = view.getObject(key.getID());
                objectListController.addObject((EObject)object, true);
            }
            TreeViewer treeViewer = new TreeViewer(container);
            treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
            objectListController.configure(treeViewer);
            return area;
        }

        protected Point getInitialSize() {
            return new Point(500, 400);
        }
    }
}

