/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.eclipse.datatools.enablement.ibm.catalog.util.ICatalogQuery;
import org.eclipse.datatools.enablement.ibm.util.PRSDebug;
import org.eclipse.datatools.enablement.ibm.util.PRSMetadata;
import org.eclipse.datatools.enablement.ibm.util.PRSSliceInfo;
import org.eclipse.datatools.enablement.ibm.util.PersistentQueryCache;
import org.eclipse.datatools.enablement.ibm.util.PersistentResultSetAdapter;
import org.eclipse.datatools.modelbase.sql.schema.Database;

public class PersistentResultSet
extends PersistentResultSetAdapter {
    public static final String ERR_MOVE = "Cannot move cursor to the specified position";
    public static final String ERR_RS_CLOSED = "ResultSet is closed";
    public static final String ERR_NO_ROW = "No current row";
    public static final String ERR_COL_NUM = "Column number %d is out of bounds";
    private Database database;
    private PersistentQueryCache cache;
    private PRSSliceInfo slice;
    private ICatalogQuery query;
    private Connection conn;
    private int currow;

    public PersistentResultSet(Database database, String context, Connection conn, ICatalogQuery query) {
        query.setContext(context);
        this.database = database;
        this.cache = PersistentQueryCache.getQueryCache(this.database);
        this.slice = null;
        this.query = query;
        this.conn = conn;
        this.currow = 0;
    }

    private void createSlice() {
        if (this.slice == null && this.query != null && this.conn != null) {
            this.slice = this.cache.getSlice(this.query, this.conn);
            this.query = null;
            this.conn = null;
        }
    }

    private void checkNotClosed() throws SQLException {
        if (this.slice != null && this.slice.getQueryInfo() != null && this.slice.getQueryInfo().getException() != null) {
            throw this.slice.getQueryInfo().getException();
        }
        if (this.isClosed()) {
            throw new SQLException(ERR_RS_CLOSED);
        }
    }

    private boolean safeIsClosed() {
        try {
            return this.isClosed();
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    public int getRowCount() {
        this.completeQueryProcessing();
        return this.slice.size();
    }

    public void completeQueryProcessing() {
        if (this.safeIsClosed()) {
            return;
        }
        this.slice.waitUntilComplete();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return ((PRSMetadata)this.getMetaData()).findColumn(columnName);
    }

    @Override
    protected Object getCurrentValue(int index) throws SQLException {
        this.checkNotClosed();
        return this.slice.getCurrentValue(this.currow, index);
    }

    @Override
    public int getType() throws SQLException {
        this.checkNotClosed();
        return 1003;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        return this.slice.getQueryInfo().getMetadata();
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.createSlice();
        return this.slice == null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.slice.unloadRowData();
        this.slice = null;
        this.database = null;
        this.currow = 0;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.isBeforeFirst() || this.isAfterLast()) {
            return 0;
        }
        return this.currow;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        while (true) {
            this.checkNotClosed();
            int size = this.slice.size();
            if (size > 0 && this.currow < size) {
                return false;
            }
            if (this.currow > size) {
                return true;
            }
            if (this.slice.isComplete()) {
                return false;
            }
            this.slice.waitForRow();
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkNotClosed();
        return this.currow == 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkNotClosed();
        return this.currow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        while (true) {
            this.checkNotClosed();
            if (this.slice.isComplete()) {
                return this.currow == this.slice.size();
            }
            this.slice.waitForRow();
        }
    }

    @Override
    public boolean last() throws SQLException {
        this.checkNotClosed();
        this.slice.waitUntilComplete();
        if (this.slice.isEmpty()) {
            return false;
        }
        this.currow = this.slice.size();
        return true;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkNotClosed();
        if (this.currow == row) {
            return row != 0 && !this.isAfterLast();
        }
        switch (this.getFetchDirection()) {
            case 1000: {
                if (row >= this.currow) break;
                throw new SQLException(ERR_MOVE);
            }
            case 1001: {
                if (row <= this.currow) break;
                throw new SQLException(ERR_MOVE);
            }
        }
        while (true) {
            this.checkNotClosed();
            int size = this.slice.size();
            if (size >= row) {
                this.currow = row;
                return true;
            }
            if (this.slice.isComplete()) {
                if (row > size) {
                    this.currow = size + 1;
                }
                return false;
            }
            if (PRSDebug.enableTracing) {
                PRSDebug.trace("PRS: abs(" + row + " sz=" + size + ") Waiting for slice " + this.slice.getSliceKey());
            }
            this.slice.waitForRow();
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.currow + rows);
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.isAfterLast()) {
            return;
        }
        this.absolute(this.slice.size() + 1);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }
}

