/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider.EmptyRowColumnProvider;
import org.eclipse.birt.report.item.crosstab.ui.views.attributes.widget.EmptyRowColumnDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class EmptyRowColumnSection
extends Section {
    private String oldValue;
    protected Label label;
    private int style = -1;
    private boolean fillLabel = false;
    private int width = -1;
    private EmptyRowColumnDescriptor emptyRowColumn;
    private int height = -1;
    EmptyRowColumnProvider provider;

    public EmptyRowColumnSection(Composite parent, boolean formStyle) {
        super(null, parent, formStyle);
    }

    public void createSection() {
        this.getEmptyRowColumnDescriptor(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public void layout() {
        GridData gd = (GridData)this.emptyRowColumn.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillLabel;
        }
        if (this.height > -1) {
            gd.heightHint = this.height;
            gd.grabExcessVerticalSpace = false;
            if (this.displayLabel != null) {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.verticalAlignment = 16;
            }
        } else {
            gd.grabExcessVerticalSpace = this.fillLabel;
            if (this.fillLabel) {
                gd.verticalAlignment = 4;
                if (this.displayLabel != null) {
                    gd = (GridData)this.displayLabel.getLayoutData();
                    gd.verticalAlignment = 16;
                }
            }
        }
    }

    public String getStringValue() {
        if (this.label != null) {
            return this.label.getText();
        }
        return null;
    }

    public EmptyRowColumnDescriptor getEmptyRowColumnDescriptor() {
        return this.emptyRowColumn;
    }

    protected EmptyRowColumnDescriptor getEmptyRowColumnDescriptor(Composite parent) {
        if (this.emptyRowColumn == null) {
            this.emptyRowColumn = new EmptyRowColumnDescriptor(true);
            if (this.getProvider() != null) {
                this.emptyRowColumn.setDescriptorProvider(this.getProvider());
            }
            this.emptyRowColumn.createControl(parent);
            this.emptyRowColumn.getControl().setLayoutData((Object)new GridData());
            this.emptyRowColumn.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    EmptyRowColumnSection.this.emptyRowColumn = null;
                }
            });
        } else {
            this.checkParent(this.emptyRowColumn.getControl(), parent);
        }
        return this.emptyRowColumn;
    }

    public void setFocus() {
        if (this.label != null) {
            this.label.setFocus();
        }
    }

    public void setStringValue(String value) {
        if (this.label != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.label.getText();
            if (!this.oldValue.equals(value)) {
                this.label.setText(value);
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isFillLabel() {
        return this.fillLabel;
    }

    public void setFillLabel(boolean fillLabel) {
        this.fillLabel = fillLabel;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.label != null) {
            WidgetUtil.setExcludeGridData((Control)this.label, (boolean)isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.label != null) {
            this.label.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setInput(Object input) {
        assert (input != null);
        this.emptyRowColumn.setInput(input);
    }

    public void load() {
        if (this.emptyRowColumn != null && !this.emptyRowColumn.getControl().isDisposed()) {
            this.emptyRowColumn.load();
        }
    }

    public EmptyRowColumnProvider getProvider() {
        return this.provider;
    }

    public void setProvider(EmptyRowColumnProvider provider) {
        this.provider = provider;
        if (this.emptyRowColumn != null) {
            this.emptyRowColumn.setDescriptorProvider(provider);
        }
    }
}

