/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ExceptionHandler;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class DataSetCapabilities
extends ExceptionHandler {
    private IDataSetMetaData m_dsMetaData;
    private static String sm_className = DataSetCapabilities.class.getName();

    DataSetCapabilities(IDataSetMetaData dsMetaData) {
        super(sm_className);
        DataSetCapabilities.getLogger().entering(sm_className, "DataSetCapabilities", dsMetaData);
        assert (dsMetaData != null);
        this.m_dsMetaData = dsMetaData;
        DataSetCapabilities.getLogger().exiting(sm_className, "DataSetCapabilities", this);
    }

    public int getSortMode() {
        return this.m_dsMetaData.getSortMode();
    }

    public boolean supportsMultipleOpenResults() throws DataException {
        try {
            return this.m_dsMetaData.supportsMultipleOpenResults();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotDetermineSupportForMultipleOpenResults", "supportsMultipleOpenResults");
        }
        catch (UnsupportedOperationException ex) {
            DataSetCapabilities.getLogger().logp(Level.INFO, sm_className, "supportsMultipleOpenResults", "Cannot determine support of multiple open result sets.  Default to false.", ex);
        }
        return false;
    }

    public boolean supportsMultipleResultSets() throws DataException {
        try {
            return this.m_dsMetaData.supportsMultipleResultSets();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotDetermineSupportForMultipleResultSets", "supportsMultipleResultSets");
        }
        catch (UnsupportedOperationException ex) {
            DataSetCapabilities.getLogger().logp(Level.INFO, sm_className, "supportsMultipleResultSets", "Cannot determine support of multiple result sets.  Default to false.", ex);
        }
        return false;
    }

    public boolean supportsNamedResultSets() throws DataException {
        try {
            return this.m_dsMetaData.supportsNamedResultSets();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotDetermineSupportForNamedResultSets", "supportsNamedResultSets");
        }
        catch (UnsupportedOperationException ex) {
            DataSetCapabilities.getLogger().logp(Level.INFO, sm_className, "supportsNamedResultSets", "Cannot determine support of named result sets.  Default to false.", ex);
        }
        return false;
    }

    public boolean supportsNamedParameters() throws DataException {
        try {
            return this.m_dsMetaData.supportsNamedParameters();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotDetermineSupportForNamedParameters", "supportsNamedParameters");
        }
        catch (UnsupportedOperationException ex) {
            DataSetCapabilities.getLogger().logp(Level.INFO, sm_className, "supportsNamedParameters", "Cannot determine support of named parameters. Default to false.", ex);
        }
        return false;
    }

    public boolean supportsInParameters() throws DataException {
        try {
            return this.m_dsMetaData.supportsInParameters();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotDetermineSupportForInParameters", "supportsInParameters");
        }
        catch (UnsupportedOperationException ex) {
            DataSetCapabilities.getLogger().logp(Level.INFO, sm_className, "supportsInParameters", "Cannot determine support of input parameters. Default to false.", ex);
        }
        return false;
    }

    public boolean supportsOutParameters() throws DataException {
        try {
            return this.m_dsMetaData.supportsOutParameters();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotDetermineSupportForOutParameters", "supportsOutParameters");
        }
        catch (UnsupportedOperationException ex) {
            DataSetCapabilities.getLogger().logp(Level.INFO, sm_className, "supportsOutParameters", "Cannot determine support of output parameters. Default to false.", ex);
        }
        return false;
    }
}

