/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import uk.co.spudsoft.birt.emitters.excel.AreaBorders;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.CellImage;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.NestedTableContainer;

public abstract class AbstractRealTableRowHandler
extends AbstractHandler {
    protected Row currentRow;
    protected int birtRowStartedAtPoiRow;
    protected int birtRowStartedAtPoiCol;
    protected int myRow;
    protected int startCol;
    private BirtStyle rowStyle;
    private AreaBorders borderDefn;

    public AbstractRealTableRowHandler(Logger log, IHandler parent, IRowContent row, int startCol) {
        super(log, parent, (IContent)row);
        this.startCol = startCol;
    }

    @Override
    public void startRow(HandlerState state, IRowContent row) throws BirtException {
        state.colNum = this.startCol;
        this.birtRowStartedAtPoiRow = state.rowNum;
        this.birtRowStartedAtPoiCol = state.colNum;
        this.resumeRow(state);
    }

    @Override
    public void endRow(HandlerState state, IRowContent row) throws BirtException {
        this.interruptRow(state);
        if (row.getBookmark() != null) {
            this.createName(state, AbstractRealTableRowHandler.prepareName(row.getBookmark()), this.birtRowStartedAtPoiRow, 0, state.rowNum - 1, this.currentRow.getLastCellNum() - 1);
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)row, "ExcelEmitter.InsertPrintBreakAfter", false)) {
            state.currentSheet.setRowBreak(state.rowNum - 1);
        }
        state.setHandler(this.parent);
    }

    protected abstract boolean isNested();

    public void resumeRow(HandlerState state) {
        this.log.debug("Resume row at ", state.rowNum);
        this.myRow = state.rowNum;
        if (state.currentSheet.getRow(state.rowNum) == null) {
            this.log.debug("Creating row ", state.rowNum);
            this.currentRow = state.currentSheet.createRow(state.rowNum);
        } else {
            this.currentRow = state.currentSheet.getRow(state.rowNum);
        }
        state.requiredRowHeightInPoints = 0.0f;
        this.rowStyle = new BirtStyle((IContent)((IRowContent)this.element));
        this.borderDefn = AreaBorders.create(this.myRow, 0, ((IRowContent)this.element).getTable().getColumnCount() - 1, this.myRow, this.rowStyle);
        if (this.borderDefn != null) {
            state.insertBorderOverload(this.borderDefn);
        }
    }

    public void interruptRow(HandlerState state) throws BirtException {
        this.log.debug("Interrupt row at ", state.rowNum);
        this.currentRow = state.currentSheet.getRow(state.rowNum);
        boolean blankRow = EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), this.element, "ExcelEmitter.RemoveBlankRows", true);
        this.log.debug("currentRow.getRowNum() == ", this.currentRow.getRowNum(), ", state.rowNum == ", state.rowNum);
        if (state.rowHasMergedCellsWithBorders(state.rowNum)) {
            for (AreaBorders areaBorder : state.areaBorders) {
                if (!areaBorder.isMergedCells || areaBorder.top > state.rowNum || areaBorder.bottom < state.rowNum) continue;
                int column = areaBorder.left;
                while (column <= areaBorder.right) {
                    if (this.currentRow.getCell(column) == null) {
                        BirtStyle birtCellStyle = new BirtStyle(state.getSm().getCssEngine());
                        this.log.debug("Creating cell[", state.rowNum, ",", column, "]");
                        Cell cell = state.currentSheet.getRow(state.rowNum).createCell(column);
                        state.getSmu().applyAreaBordersToCell(state.areaBorders, cell, birtCellStyle, state.rowNum, column);
                        CellStyle cellStyle = state.getSm().getStyle(birtCellStyle);
                        cell.setCellStyle(cellStyle);
                    }
                    ++column;
                }
            }
            blankRow = false;
        }
        if (blankRow) {
            Iterator iter = this.currentRow.cellIterator();
            while (iter.hasNext()) {
                Cell cell = (Cell)iter.next();
                if (StyleManagerUtils.cellIsEmpty(cell)) continue;
                blankRow = false;
                break;
            }
        }
        if (blankRow) {
            for (CellImage cellImage : state.images) {
                if (cellImage.location.getRow() != state.rowNum) continue;
                blankRow = false;
                break;
            }
        }
        if (blankRow && state.computeNumberSpanBefore(state.rowNum, state.colNum) > 0) {
            blankRow = false;
        }
        if (blankRow && ((IRowContent)this.element).getBookmark() != null) {
            blankRow = false;
        }
        boolean rowHasNestedTable = ((NestedTableContainer)this.parent).rowHasNestedTable(state.rowNum);
        if (blankRow && rowHasNestedTable) {
            blankRow = false;
        }
        if (blankRow && this.isNested()) {
            blankRow = false;
        }
        if (blankRow || !rowHasNestedTable && !this.isNested() && this.currentRow.getPhysicalNumberOfCells() == 0) {
            this.log.debug("Removing row ", this.currentRow.getRowNum());
            state.currentSheet.removeRow(this.currentRow);
        } else {
            DimensionType height = ((IRowContent)this.element).getHeight();
            if (height != null && DimensionUtil.isAbsoluteUnit((String)height.getUnits())) {
                double points = height.convertTo("pt");
                this.currentRow.setHeightInPoints((float)points);
            }
            if (state.requiredRowHeightInPoints > this.currentRow.getHeightInPoints()) {
                this.currentRow.setHeightInPoints(state.requiredRowHeightInPoints);
            }
            if (rowHasNestedTable) {
                int increase = ((NestedTableContainer)this.parent).extendRowBy(state.rowNum);
                this.log.debug("Incrementing rowNum from ", state.rowNum, " to ", state.rowNum + increase);
                state.rowNum += increase;
                state.getSmu().extendRows(state, this.birtRowStartedAtPoiRow, this.birtRowStartedAtPoiCol, state.rowNum, state.colNum);
            } else if (this.currentRow.getPhysicalNumberOfCells() > 0) {
                this.log.debug("Incrementing rowNum from ", state.rowNum);
                ++state.rowNum;
            } else {
                this.log.debug("Not incrementing rowNum from ", state.rowNum, " because there are no cells on row ", this.currentRow.getPhysicalNumberOfCells());
            }
        }
        if (this.borderDefn != null) {
            state.removeBorderOverload(this.borderDefn);
            this.borderDefn = null;
        }
    }
}

